/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.app.UiModeManager;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import androidx.core.util.Preconditions;

public final class DisplayCompat {
    private static final int DISPLAY_SIZE_4K_HEIGHT = 2160;
    private static final int DISPLAY_SIZE_4K_WIDTH = 3840;

    private DisplayCompat() {
    }

    static Point getCurrentDisplaySizeFromWorkarounds(Context context, Display display) {
        Point point = Build.VERSION.SDK_INT < 28 ? DisplayCompat.parsePhysicalDisplaySizeFromSystemProperties("sys.display-size", display) : DisplayCompat.parsePhysicalDisplaySizeFromSystemProperties("vendor.display-size", display);
        if (point != null) {
            return point;
        }
        boolean bl = DisplayCompat.isSonyBravia4kTv(context);
        point = null;
        context = point;
        if (bl) {
            context = point;
            if (DisplayCompat.isCurrentModeTheLargestMode(display)) {
                context = new Point(3840, 2160);
            }
        }
        return context;
    }

    private static Point getDisplaySize(Context context, Display display) {
        if ((context = DisplayCompat.getCurrentDisplaySizeFromWorkarounds(context, display)) != null) {
            return context;
        }
        context = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            Api17Impl.getRealSize(display, (Point)context);
        } else {
            display.getSize((Point)context);
        }
        return context;
    }

    public static ModeCompat getMode(Context context, Display display) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getMode(context, display);
        }
        return new ModeCompat(DisplayCompat.getDisplaySize(context, display));
    }

    public static ModeCompat[] getSupportedModes(Context context, Display display) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getSupportedModes(context, display);
        }
        return new ModeCompat[]{DisplayCompat.getMode(context, display)};
    }

    private static String getSystemProperty(String string2) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            string2 = (String)clazz.getMethod("get", String.class).invoke(clazz, string2);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean isCurrentModeTheLargestMode(Display display) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.isCurrentModeTheLargestMode(display);
        }
        return true;
    }

    private static boolean isSonyBravia4kTv(Context context) {
        boolean bl = DisplayCompat.isTv(context) && "Sony".equals(Build.MANUFACTURER) && Build.MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd");
        return bl;
    }

    private static boolean isTv(Context context) {
        boolean bl = (context = (UiModeManager)context.getSystemService("uimode")) != null && context.getCurrentModeType() == 4;
        return bl;
    }

    private static Point parseDisplaySize(String stringArray) throws NumberFormatException {
        if ((stringArray = stringArray.trim().split("x", -1)).length == 2) {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            if (n > 0 && n2 > 0) {
                return new Point(n, n2);
            }
        }
        throw new NumberFormatException();
    }

    private static Point parsePhysicalDisplaySizeFromSystemProperties(String string2, Display display) {
        if (display.getDisplayId() != 0) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = DisplayCompat.getSystemProperty(string2)))) {
            return null;
        }
        try {
            string2 = DisplayCompat.parseDisplaySize(string2);
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static class Api17Impl {
        private Api17Impl() {
        }

        static void getRealSize(Display display, Point point) {
            display.getRealSize(point);
        }
    }

    static class Api23Impl {
        private Api23Impl() {
        }

        static ModeCompat getMode(Context object, Display display) {
            Display.Mode mode = display.getMode();
            object = (object = DisplayCompat.getCurrentDisplaySizeFromWorkarounds(object, display)) != null && !Api23Impl.physicalSizeEquals(mode, (Point)object) ? new ModeCompat(mode, (Point)object) : new ModeCompat(mode, true);
            return object;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public static ModeCompat[] getSupportedModes(Context object, Display display) {
            int n;
            Point point;
            Display.Mode[] modeArray = point.getSupportedModes();
            ModeCompat[] modeCompatArray = new ModeCompat[modeArray.length];
            Display.Mode mode = point.getMode();
            point = DisplayCompat.getCurrentDisplaySizeFromWorkarounds(object, (Display)point);
            int n2 = n = 0;
            if (point != null) {
                if (Api23Impl.physicalSizeEquals(mode, point)) {
                    n2 = n;
                }
            } else {
                while (n2 < modeArray.length) {
                    boolean bl = Api23Impl.physicalSizeEquals(modeArray[n2], mode);
                    modeCompatArray[n2] = new ModeCompat(modeArray[n2], bl);
                    ++n2;
                }
                return modeCompatArray;
            }
            for (n2 = 0; n2 < modeArray.length; ++n2) {
                void var0_4;
                if (Api23Impl.physicalSizeEquals(modeArray[n2], mode)) {
                    ModeCompat modeCompat = new ModeCompat(modeArray[n2], point);
                } else {
                    ModeCompat modeCompat = new ModeCompat(modeArray[n2], false);
                }
                modeCompatArray[n2] = var0_4;
            }
            return modeCompatArray;
        }

        static boolean isCurrentModeTheLargestMode(Display modeArray) {
            Display.Mode mode = modeArray.getMode();
            modeArray = modeArray.getSupportedModes();
            for (int i = 0; i < modeArray.length; ++i) {
                if (mode.getPhysicalHeight() >= modeArray[i].getPhysicalHeight() && mode.getPhysicalWidth() >= modeArray[i].getPhysicalWidth()) {
                    continue;
                }
                return false;
            }
            return true;
        }

        static boolean physicalSizeEquals(Display.Mode mode, Point point) {
            boolean bl = mode.getPhysicalWidth() == point.x && mode.getPhysicalHeight() == point.y || mode.getPhysicalWidth() == point.y && mode.getPhysicalHeight() == point.x;
            return bl;
        }

        static boolean physicalSizeEquals(Display.Mode mode, Display.Mode mode2) {
            boolean bl = mode.getPhysicalWidth() == mode2.getPhysicalWidth() && mode.getPhysicalHeight() == mode2.getPhysicalHeight();
            return bl;
        }
    }

    public static final class ModeCompat {
        private final boolean mIsNative;
        private final Display.Mode mMode;
        private final Point mPhysicalSize;

        ModeCompat(Point point) {
            Preconditions.checkNotNull(point, "physicalSize == null");
            this.mPhysicalSize = point;
            this.mMode = null;
            this.mIsNative = true;
        }

        ModeCompat(Display.Mode mode, Point point) {
            Preconditions.checkNotNull(mode, "mode == null, can't wrap a null reference");
            Preconditions.checkNotNull(point, "physicalSize == null");
            this.mPhysicalSize = point;
            this.mMode = mode;
            this.mIsNative = true;
        }

        ModeCompat(Display.Mode mode, boolean bl) {
            Preconditions.checkNotNull(mode, "mode == null, can't wrap a null reference");
            this.mPhysicalSize = new Point(mode.getPhysicalWidth(), mode.getPhysicalHeight());
            this.mMode = mode;
            this.mIsNative = bl;
        }

        public int getPhysicalHeight() {
            return this.mPhysicalSize.y;
        }

        public int getPhysicalWidth() {
            return this.mPhysicalSize.x;
        }

        @Deprecated
        public boolean isNative() {
            return this.mIsNative;
        }

        public Display.Mode toMode() {
            return this.mMode;
        }
    }
}

