/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Rect;
import android.os.Build;
import android.view.DisplayCutout;
import androidx.core.graphics.Insets;
import androidx.core.os.BuildCompat;
import androidx.core.util.ObjectsCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DisplayCutoutCompat {
    private final Object mDisplayCutout;

    public DisplayCutoutCompat(Rect object, List<Rect> list) {
        object = Build.VERSION.SDK_INT >= 28 ? new DisplayCutout(object, list) : null;
        this(object);
    }

    public DisplayCutoutCompat(Insets insets, Rect rect, Rect rect2, Rect rect3, Rect rect4, Insets insets2) {
        this(DisplayCutoutCompat.constructDisplayCutout(insets, rect, rect2, rect3, rect4, insets2));
    }

    private DisplayCutoutCompat(Object object) {
        this.mDisplayCutout = object;
    }

    private static DisplayCutout constructDisplayCutout(Insets insets, Rect rect, Rect rect2, Rect rect3, Rect rect4, Insets object) {
        if (BuildCompat.isAtLeastR()) {
            return new DisplayCutout(insets.toPlatformInsets(), rect, rect2, rect3, rect4, ((Insets)object).toPlatformInsets());
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return new DisplayCutout(insets.toPlatformInsets(), rect, rect2, rect3, rect4);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            insets = new Rect(insets.left, insets.top, insets.right, insets.bottom);
            object = new ArrayList();
            if (rect != null) {
                ((ArrayList)object).add(rect);
            }
            if (rect2 != null) {
                ((ArrayList)object).add(rect2);
            }
            if (rect3 != null) {
                ((ArrayList)object).add(rect3);
            }
            if (rect4 != null) {
                ((ArrayList)object).add(rect4);
            }
            return new DisplayCutout((Rect)insets, (List)object);
        }
        return null;
    }

    static DisplayCutoutCompat wrap(Object object) {
        object = object == null ? null : new DisplayCutoutCompat(object);
        return object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (DisplayCutoutCompat)object;
            return ObjectsCompat.equals(this.mDisplayCutout, ((DisplayCutoutCompat)object).mDisplayCutout);
        }
        return false;
    }

    public List<Rect> getBoundingRects() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ((DisplayCutout)this.mDisplayCutout).getBoundingRects();
        }
        return Collections.emptyList();
    }

    public int getSafeInsetBottom() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ((DisplayCutout)this.mDisplayCutout).getSafeInsetBottom();
        }
        return 0;
    }

    public int getSafeInsetLeft() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ((DisplayCutout)this.mDisplayCutout).getSafeInsetLeft();
        }
        return 0;
    }

    public int getSafeInsetRight() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ((DisplayCutout)this.mDisplayCutout).getSafeInsetRight();
        }
        return 0;
    }

    public int getSafeInsetTop() {
        if (Build.VERSION.SDK_INT >= 28) {
            return ((DisplayCutout)this.mDisplayCutout).getSafeInsetTop();
        }
        return 0;
    }

    public Insets getWaterfallInsets() {
        if (BuildCompat.isAtLeastR()) {
            return Insets.toCompatInsets(((DisplayCutout)this.mDisplayCutout).getWaterfallInsets());
        }
        return Insets.NONE;
    }

    public int hashCode() {
        Object object = this.mDisplayCutout;
        int n = object == null ? 0 : object.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DisplayCutoutCompat{");
        stringBuilder.append(this.mDisplayCutout);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    DisplayCutout unwrap() {
        return (DisplayCutout)this.mDisplayCutout;
    }
}

