/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Point;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.view.MotionEventCompat;

public class DragStartHelper {
    private boolean mDragging;
    private int mLastTouchX;
    private int mLastTouchY;
    private final OnDragStartListener mListener;
    private final View.OnLongClickListener mLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View view) {
            return DragStartHelper.this.onLongClick(view);
        }
    };
    private final View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent motionEvent) {
            return DragStartHelper.this.onTouch(view, motionEvent);
        }
    };
    private final View mView;

    public DragStartHelper(View view, OnDragStartListener onDragStartListener) {
        this.mView = view;
        this.mListener = onDragStartListener;
    }

    public void attach() {
        this.mView.setOnLongClickListener(this.mLongClickListener);
        this.mView.setOnTouchListener(this.mTouchListener);
    }

    public void detach() {
        this.mView.setOnLongClickListener(null);
        this.mView.setOnTouchListener(null);
    }

    public void getTouchPosition(Point point) {
        point.set(this.mLastTouchX, this.mLastTouchY);
    }

    public boolean onLongClick(View view) {
        return this.mListener.onDragStart(view, this);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        block4: {
            int n;
            int n2;
            block1: {
                block2: {
                    block3: {
                        n2 = (int)motionEvent.getX();
                        n = (int)motionEvent.getY();
                        int n3 = motionEvent.getAction();
                        if (n3 == 0) break block1;
                        if (n3 == 1) break block2;
                        if (n3 == 2) break block3;
                        if (n3 == 3) break block2;
                        break block4;
                    }
                    if (MotionEventCompat.isFromSource(motionEvent, 8194) && (motionEvent.getButtonState() & 1) != 0 && !this.mDragging && (this.mLastTouchX != n2 || this.mLastTouchY != n)) {
                        boolean bl;
                        this.mLastTouchX = n2;
                        this.mLastTouchY = n;
                        this.mDragging = bl = this.mListener.onDragStart(view, this);
                        return bl;
                    }
                    break block4;
                }
                this.mDragging = false;
                break block4;
            }
            this.mLastTouchX = n2;
            this.mLastTouchY = n;
        }
        return false;
    }

    public static interface OnDragStartListener {
        public boolean onDragStart(View var1, DragStartHelper var2);
    }
}

