/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.app.ActionBar;
import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import androidx.core.view.ViewCompat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class KeyEventDispatcher {
    private static boolean sActionBarFieldsFetched = false;
    private static Method sActionBarOnMenuKeyMethod;
    private static boolean sDialogFieldsFetched = false;
    private static Field sDialogKeyListenerField;

    private KeyEventDispatcher() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean actionBarOnMenuKeyEventPre28(ActionBar actionBar, KeyEvent keyEvent) {
        Method method;
        if (!sActionBarFieldsFetched) {
            try {
                sActionBarOnMenuKeyMethod = actionBar.getClass().getMethod("onMenuKeyEvent", KeyEvent.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            sActionBarFieldsFetched = true;
        }
        if ((method = sActionBarOnMenuKeyMethod) == null) return false;
        try {
            return (Boolean)method.invoke((Object)actionBar, keyEvent);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    private static boolean activitySuperDispatchKeyEventPre28(Activity activity, KeyEvent keyEvent) {
        activity.onUserInteraction();
        Object object = activity.getWindow();
        if (object.hasFeature(8)) {
            ActionBar actionBar = activity.getActionBar();
            if (keyEvent.getKeyCode() == 82 && actionBar != null && KeyEventDispatcher.actionBarOnMenuKeyEventPre28(actionBar, keyEvent)) {
                return true;
            }
        }
        if (object.superDispatchKeyEvent(keyEvent)) {
            return true;
        }
        if (ViewCompat.dispatchUnhandledKeyEventBeforeCallback((View)(object = object.getDecorView()), keyEvent)) {
            return true;
        }
        object = object != null ? object.getKeyDispatcherState() : null;
        return keyEvent.dispatch((KeyEvent.Callback)activity, (KeyEvent.DispatcherState)object, (Object)activity);
    }

    private static boolean dialogSuperDispatchKeyEventPre28(Dialog dialog, KeyEvent keyEvent) {
        Object object = KeyEventDispatcher.getDialogKeyListenerPre28(dialog);
        if (object != null && object.onKey((DialogInterface)dialog, keyEvent.getKeyCode(), keyEvent)) {
            return true;
        }
        object = dialog.getWindow();
        if (object.superDispatchKeyEvent(keyEvent)) {
            return true;
        }
        if (ViewCompat.dispatchUnhandledKeyEventBeforeCallback((View)(object = object.getDecorView()), keyEvent)) {
            return true;
        }
        object = object != null ? object.getKeyDispatcherState() : null;
        return keyEvent.dispatch((KeyEvent.Callback)dialog, (KeyEvent.DispatcherState)object, (Object)dialog);
    }

    public static boolean dispatchBeforeHierarchy(View view, KeyEvent keyEvent) {
        return ViewCompat.dispatchUnhandledKeyEventBeforeHierarchy(view, keyEvent);
    }

    public static boolean dispatchKeyEvent(Component component, View view, Window.Callback callback, KeyEvent keyEvent) {
        boolean bl = false;
        if (component == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return component.superDispatchKeyEvent(keyEvent);
        }
        if (callback instanceof Activity) {
            return KeyEventDispatcher.activitySuperDispatchKeyEventPre28((Activity)callback, keyEvent);
        }
        if (callback instanceof Dialog) {
            return KeyEventDispatcher.dialogSuperDispatchKeyEventPre28((Dialog)callback, keyEvent);
        }
        if (view != null && ViewCompat.dispatchUnhandledKeyEventBeforeCallback(view, keyEvent) || component.superDispatchKeyEvent(keyEvent)) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DialogInterface.OnKeyListener getDialogKeyListenerPre28(Dialog dialog) {
        Field field;
        if (!sDialogFieldsFetched) {
            try {
                sDialogKeyListenerField = field = Dialog.class.getDeclaredField("mOnKeyListener");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            sDialogFieldsFetched = true;
        }
        if ((field = sDialogKeyListenerField) == null) return null;
        try {
            return (DialogInterface.OnKeyListener)field.get(dialog);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static interface Component {
        public boolean superDispatchKeyEvent(KeyEvent var1);
    }
}

