/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsetsController;
import androidx.core.view.WindowInsetsControllerCompat;

public final class WindowCompat {
    public static final int FEATURE_ACTION_BAR = 8;
    public static final int FEATURE_ACTION_BAR_OVERLAY = 9;
    public static final int FEATURE_ACTION_MODE_OVERLAY = 10;

    private WindowCompat() {
    }

    public static WindowInsetsControllerCompat getInsetsController(Window window, View view) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Impl30.getInsetsController(window);
        }
        return new WindowInsetsControllerCompat(window, view);
    }

    public static <T extends View> T requireViewById(Window window, int n) {
        if (Build.VERSION.SDK_INT >= 28) {
            return (T)window.requireViewById(n);
        }
        if ((window = window.findViewById(n)) != null) {
            return (T)window;
        }
        throw new IllegalArgumentException("ID does not reference a View inside this Window");
    }

    public static void setDecorFitsSystemWindows(Window window, boolean bl) {
        if (Build.VERSION.SDK_INT >= 30) {
            Impl30.setDecorFitsSystemWindows(window, bl);
        } else if (Build.VERSION.SDK_INT >= 16) {
            Impl16.setDecorFitsSystemWindows(window, bl);
        }
    }

    private static class Impl16 {
        private Impl16() {
        }

        static void setDecorFitsSystemWindows(Window window, boolean bl) {
            window = window.getDecorView();
            int n = window.getSystemUiVisibility();
            n = bl ? (n &= 0xFFFFF8FF) : (n |= 0x700);
            window.setSystemUiVisibility(n);
        }
    }

    private static class Impl30 {
        private Impl30() {
        }

        static WindowInsetsControllerCompat getInsetsController(Window window) {
            if ((window = window.getInsetsController()) != null) {
                return WindowInsetsControllerCompat.toWindowInsetsControllerCompat((WindowInsetsController)window);
            }
            return null;
        }

        static void setDecorFitsSystemWindows(Window window, boolean bl) {
            window.setDecorFitsSystemWindows(bl);
        }
    }
}

