/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.core.R;
import androidx.core.graphics.Insets;
import androidx.core.view.OneShotPreDrawListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class WindowInsetsAnimationCompat {
    private static final boolean DEBUG = false;
    private static final String TAG = "WindowInsetsAnimCompat";
    private Impl mImpl;

    public WindowInsetsAnimationCompat(int n, Interpolator interpolator2, long l) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(n, interpolator2, l) : (Build.VERSION.SDK_INT >= 21 ? new Impl21(n, interpolator2, l) : new Impl(0, interpolator2, l));
    }

    private WindowInsetsAnimationCompat(WindowInsetsAnimation windowInsetsAnimation) {
        this(0, null, 0L);
        if (Build.VERSION.SDK_INT >= 30) {
            this.mImpl = new Impl30(windowInsetsAnimation);
        }
    }

    static void setCallback(View view, Callback callback) {
        if (Build.VERSION.SDK_INT >= 30) {
            Impl30.setCallback(view, callback);
        } else if (Build.VERSION.SDK_INT >= 21) {
            Impl21.setCallback(view, callback);
        }
    }

    static WindowInsetsAnimationCompat toWindowInsetsAnimationCompat(WindowInsetsAnimation windowInsetsAnimation) {
        return new WindowInsetsAnimationCompat(windowInsetsAnimation);
    }

    public float getAlpha() {
        return this.mImpl.getAlpha();
    }

    public long getDurationMillis() {
        return this.mImpl.getDurationMillis();
    }

    public float getFraction() {
        return this.mImpl.getFraction();
    }

    public float getInterpolatedFraction() {
        return this.mImpl.getInterpolatedFraction();
    }

    public Interpolator getInterpolator() {
        return this.mImpl.getInterpolator();
    }

    public int getTypeMask() {
        return this.mImpl.getTypeMask();
    }

    public void setAlpha(float f) {
        this.mImpl.setAlpha(f);
    }

    public void setFraction(float f) {
        this.mImpl.setFraction(f);
    }

    public static final class BoundsCompat {
        private final Insets mLowerBound;
        private final Insets mUpperBound;

        private BoundsCompat(WindowInsetsAnimation.Bounds bounds) {
            this.mLowerBound = Impl30.getLowerBounds(bounds);
            this.mUpperBound = Impl30.getHigherBounds(bounds);
        }

        public BoundsCompat(Insets insets, Insets insets2) {
            this.mLowerBound = insets;
            this.mUpperBound = insets2;
        }

        public static BoundsCompat toBoundsCompat(WindowInsetsAnimation.Bounds bounds) {
            return new BoundsCompat(bounds);
        }

        public Insets getLowerBound() {
            return this.mLowerBound;
        }

        public Insets getUpperBound() {
            return this.mUpperBound;
        }

        public BoundsCompat inset(Insets insets) {
            return new BoundsCompat(WindowInsetsCompat.insetInsets(this.mLowerBound, insets.left, insets.top, insets.right, insets.bottom), WindowInsetsCompat.insetInsets(this.mUpperBound, insets.left, insets.top, insets.right, insets.bottom));
        }

        public WindowInsetsAnimation.Bounds toBounds() {
            return Impl30.createPlatformBounds(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Bounds{lower=");
            stringBuilder.append(this.mLowerBound);
            stringBuilder.append(" upper=");
            stringBuilder.append(this.mUpperBound);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static abstract class Callback {
        public static final int DISPATCH_MODE_CONTINUE_ON_SUBTREE = 1;
        public static final int DISPATCH_MODE_STOP = 0;
        WindowInsets mDispachedInsets;
        private final int mDispatchMode;

        public Callback(int n) {
            this.mDispatchMode = n;
        }

        public final int getDispatchMode() {
            return this.mDispatchMode;
        }

        public void onEnd(WindowInsetsAnimationCompat windowInsetsAnimationCompat) {
        }

        public void onPrepare(WindowInsetsAnimationCompat windowInsetsAnimationCompat) {
        }

        public abstract WindowInsetsCompat onProgress(WindowInsetsCompat var1, List<WindowInsetsAnimationCompat> var2);

        public BoundsCompat onStart(WindowInsetsAnimationCompat windowInsetsAnimationCompat, BoundsCompat boundsCompat) {
            return boundsCompat;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DispatchMode {
        }
    }

    private static class Impl {
        private float mAlpha;
        private final long mDurationMillis;
        private float mFraction;
        private final Interpolator mInterpolator;
        private final int mTypeMask;

        Impl(int n, Interpolator interpolator2, long l) {
            this.mTypeMask = n;
            this.mInterpolator = interpolator2;
            this.mDurationMillis = l;
        }

        public float getAlpha() {
            return this.mAlpha;
        }

        public long getDurationMillis() {
            return this.mDurationMillis;
        }

        public float getFraction() {
            return this.mFraction;
        }

        public float getInterpolatedFraction() {
            Interpolator interpolator2 = this.mInterpolator;
            if (interpolator2 != null) {
                return interpolator2.getInterpolation(this.mFraction);
            }
            return this.mFraction;
        }

        public Interpolator getInterpolator() {
            return this.mInterpolator;
        }

        public int getTypeMask() {
            return this.mTypeMask;
        }

        public void setAlpha(float f) {
            this.mAlpha = f;
        }

        public void setFraction(float f) {
            this.mFraction = f;
        }
    }

    private static class Impl21
    extends Impl {
        Impl21(int n, Interpolator interpolator2, long l) {
            super(n, interpolator2, l);
        }

        static int buildAnimationMask(WindowInsetsCompat windowInsetsCompat, WindowInsetsCompat windowInsetsCompat2) {
            int n = 0;
            for (int i = 1; i <= 256; i <<= 1) {
                int n2 = n;
                if (!windowInsetsCompat.getInsets(i).equals(windowInsetsCompat2.getInsets(i))) {
                    n2 = n | i;
                }
                n = n2;
            }
            return n;
        }

        static BoundsCompat computeAnimationBounds(WindowInsetsCompat object, WindowInsetsCompat object2, int n) {
            object = ((WindowInsetsCompat)object).getInsets(n);
            object2 = ((WindowInsetsCompat)object2).getInsets(n);
            return new BoundsCompat(Insets.of(Math.min(((Insets)object).left, ((Insets)object2).left), Math.min(((Insets)object).top, ((Insets)object2).top), Math.min(((Insets)object).right, ((Insets)object2).right), Math.min(((Insets)object).bottom, ((Insets)object2).bottom)), Insets.of(Math.max(((Insets)object).left, ((Insets)object2).left), Math.max(((Insets)object).top, ((Insets)object2).top), Math.max(((Insets)object).right, ((Insets)object2).right), Math.max(((Insets)object).bottom, ((Insets)object2).bottom)));
        }

        private static View.OnApplyWindowInsetsListener createProxyListener(View view, Callback callback) {
            return new Impl21OnApplyWindowInsetsListener(view, callback);
        }

        static void dispatchOnEnd(View view, WindowInsetsAnimationCompat windowInsetsAnimationCompat) {
            Callback callback = Impl21.getCallback(view);
            if (callback != null) {
                callback.onEnd(windowInsetsAnimationCompat);
                if (callback.getDispatchMode() == 0) {
                    return;
                }
            }
            if (view instanceof ViewGroup) {
                view = (ViewGroup)view;
                for (int i = 0; i < view.getChildCount(); ++i) {
                    Impl21.dispatchOnEnd(view.getChildAt(i), windowInsetsAnimationCompat);
                }
            }
        }

        static void dispatchOnPrepare(View view, WindowInsetsAnimationCompat windowInsetsAnimationCompat, WindowInsets windowInsets, boolean bl) {
            Callback callback = Impl21.getCallback(view);
            int n = 0;
            boolean bl2 = bl;
            if (callback != null) {
                callback.mDispachedInsets = windowInsets;
                bl2 = bl;
                if (!bl) {
                    callback.onPrepare(windowInsetsAnimationCompat);
                    bl2 = callback.getDispatchMode() == 0;
                }
            }
            if (view instanceof ViewGroup) {
                view = (ViewGroup)view;
                while (n < view.getChildCount()) {
                    Impl21.dispatchOnPrepare(view.getChildAt(n), windowInsetsAnimationCompat, windowInsets, bl2);
                    ++n;
                }
            }
        }

        static void dispatchOnProgress(View view, WindowInsetsCompat windowInsetsCompat, List<WindowInsetsAnimationCompat> list) {
            Callback callback = Impl21.getCallback(view);
            WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
            if (callback != null) {
                windowInsetsCompat2 = callback.onProgress(windowInsetsCompat, list);
                if (callback.getDispatchMode() == 0) {
                    return;
                }
            }
            if (view instanceof ViewGroup) {
                view = (ViewGroup)view;
                for (int i = 0; i < view.getChildCount(); ++i) {
                    Impl21.dispatchOnProgress(view.getChildAt(i), windowInsetsCompat2, list);
                }
            }
        }

        static void dispatchOnStart(View view, WindowInsetsAnimationCompat windowInsetsAnimationCompat, BoundsCompat boundsCompat) {
            Callback callback = Impl21.getCallback(view);
            if (callback != null) {
                callback.onStart(windowInsetsAnimationCompat, boundsCompat);
                if (callback.getDispatchMode() == 0) {
                    return;
                }
            }
            if (view instanceof ViewGroup) {
                view = (ViewGroup)view;
                for (int i = 0; i < view.getChildCount(); ++i) {
                    Impl21.dispatchOnStart(view.getChildAt(i), windowInsetsAnimationCompat, boundsCompat);
                }
            }
        }

        static WindowInsets forwardToViewIfNeeded(View view, WindowInsets windowInsets) {
            if (view.getTag(R.id.tag_on_apply_window_listener) != null) {
                return windowInsets;
            }
            return view.onApplyWindowInsets(windowInsets);
        }

        static Callback getCallback(View object) {
            object = (object = object.getTag(R.id.tag_window_insets_animation_callback)) instanceof Impl21OnApplyWindowInsetsListener ? ((Impl21OnApplyWindowInsetsListener)object).mCallback : null;
            return object;
        }

        static WindowInsetsCompat interpolateInsets(WindowInsetsCompat windowInsetsCompat, WindowInsetsCompat windowInsetsCompat2, float f, int n) {
            WindowInsetsCompat.Builder builder = new WindowInsetsCompat.Builder(windowInsetsCompat);
            for (int i = 1; i <= 256; i <<= 1) {
                if ((n & i) == 0) {
                    builder.setInsets(i, windowInsetsCompat.getInsets(i));
                    continue;
                }
                Insets insets = windowInsetsCompat.getInsets(i);
                Insets insets2 = windowInsetsCompat2.getInsets(i);
                float f2 = insets.left - insets2.left;
                float f3 = 1.0f - f;
                builder.setInsets(i, WindowInsetsCompat.insetInsets(insets, (int)((double)(f2 * f3) + 0.5), (int)((double)((float)(insets.top - insets2.top) * f3) + 0.5), (int)((double)((float)(insets.right - insets2.right) * f3) + 0.5), (int)((double)((float)(insets.bottom - insets2.bottom) * f3) + 0.5)));
            }
            return builder.build();
        }

        static void setCallback(View view, Callback callback) {
            Object object = view.getTag(R.id.tag_on_apply_window_listener);
            if (callback == null) {
                view.setTag(R.id.tag_window_insets_animation_callback, null);
                if (object == null) {
                    view.setOnApplyWindowInsetsListener(null);
                }
            } else {
                callback = Impl21.createProxyListener(view, callback);
                view.setTag(R.id.tag_window_insets_animation_callback, (Object)callback);
                if (object == null) {
                    view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)callback);
                }
            }
        }

        private static class Impl21OnApplyWindowInsetsListener
        implements View.OnApplyWindowInsetsListener {
            private static final int COMPAT_ANIMATION_DURATION = 160;
            final Callback mCallback;
            private WindowInsetsCompat mLastInsets;

            Impl21OnApplyWindowInsetsListener(View object, Callback callback) {
                this.mCallback = callback;
                object = ViewCompat.getRootWindowInsets(object);
                object = object != null ? new WindowInsetsCompat.Builder((WindowInsetsCompat)object).build() : null;
                this.mLastInsets = object;
            }

            public WindowInsets onApplyWindowInsets(final View view, WindowInsets windowInsets) {
                if (!view.isLaidOut()) {
                    this.mLastInsets = WindowInsetsCompat.toWindowInsetsCompat(windowInsets, view);
                    return Impl21.forwardToViewIfNeeded(view, windowInsets);
                }
                WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat(windowInsets, view);
                if (this.mLastInsets == null) {
                    this.mLastInsets = ViewCompat.getRootWindowInsets(view);
                }
                if (this.mLastInsets == null) {
                    this.mLastInsets = windowInsetsCompat;
                    return Impl21.forwardToViewIfNeeded(view, windowInsets);
                }
                Object object = Impl21.getCallback(view);
                if (object != null && Objects.equals(((Callback)object).mDispachedInsets, windowInsets)) {
                    return Impl21.forwardToViewIfNeeded(view, windowInsets);
                }
                int n = Impl21.buildAnimationMask(windowInsetsCompat, this.mLastInsets);
                if (n == 0) {
                    return Impl21.forwardToViewIfNeeded(view, windowInsets);
                }
                WindowInsetsCompat windowInsetsCompat2 = this.mLastInsets;
                object = new WindowInsetsAnimationCompat(n, (Interpolator)new DecelerateInterpolator(), 160L);
                ((WindowInsetsAnimationCompat)object).setFraction(0.0f);
                ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(((WindowInsetsAnimationCompat)object).getDurationMillis());
                BoundsCompat boundsCompat = Impl21.computeAnimationBounds(windowInsetsCompat, windowInsetsCompat2, n);
                Impl21.dispatchOnPrepare(view, (WindowInsetsAnimationCompat)object, windowInsets, false);
                valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((WindowInsetsAnimationCompat)object, windowInsetsCompat, windowInsetsCompat2, n, view){
                    final /* synthetic */ WindowInsetsAnimationCompat val$anim;
                    final /* synthetic */ int val$animationMask;
                    final /* synthetic */ WindowInsetsCompat val$startingInsets;
                    final /* synthetic */ WindowInsetsCompat val$targetInsets;
                    final /* synthetic */ View val$v;
                    {
                        this.val$anim = windowInsetsAnimationCompat;
                        this.val$targetInsets = windowInsetsCompat;
                        this.val$startingInsets = windowInsetsCompat2;
                        this.val$animationMask = n;
                        this.val$v = view;
                    }

                    public void onAnimationUpdate(ValueAnimator object) {
                        this.val$anim.setFraction(object.getAnimatedFraction());
                        object = Impl21.interpolateInsets(this.val$targetInsets, this.val$startingInsets, this.val$anim.getInterpolatedFraction(), this.val$animationMask);
                        List<WindowInsetsAnimationCompat> list = Collections.singletonList(this.val$anim);
                        Impl21.dispatchOnProgress(this.val$v, (WindowInsetsCompat)object, list);
                    }
                });
                valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((WindowInsetsAnimationCompat)object, view){
                    final /* synthetic */ WindowInsetsAnimationCompat val$anim;
                    final /* synthetic */ View val$v;
                    {
                        this.val$anim = windowInsetsAnimationCompat;
                        this.val$v = view;
                    }

                    public void onAnimationEnd(Animator animator2) {
                        this.val$anim.setFraction(1.0f);
                        Impl21.dispatchOnEnd(this.val$v, this.val$anim);
                    }
                });
                OneShotPreDrawListener.add(view, new Runnable((WindowInsetsAnimationCompat)object, boundsCompat, valueAnimator){
                    final /* synthetic */ WindowInsetsAnimationCompat val$anim;
                    final /* synthetic */ BoundsCompat val$animationBounds;
                    final /* synthetic */ ValueAnimator val$animator;
                    {
                        this.val$anim = windowInsetsAnimationCompat;
                        this.val$animationBounds = boundsCompat;
                        this.val$animator = valueAnimator;
                    }

                    @Override
                    public void run() {
                        Impl21.dispatchOnStart(view, this.val$anim, this.val$animationBounds);
                        this.val$animator.start();
                    }
                });
                this.mLastInsets = windowInsetsCompat;
                return Impl21.forwardToViewIfNeeded(view, windowInsets);
            }
        }
    }

    private static class Impl30
    extends Impl {
        private final WindowInsetsAnimation mWrapped;

        Impl30(int n, Interpolator interpolator2, long l) {
            this(new WindowInsetsAnimation(n, interpolator2, l));
        }

        Impl30(WindowInsetsAnimation windowInsetsAnimation) {
            super(0, null, 0L);
            this.mWrapped = windowInsetsAnimation;
        }

        public static WindowInsetsAnimation.Bounds createPlatformBounds(BoundsCompat boundsCompat) {
            return new WindowInsetsAnimation.Bounds(boundsCompat.getLowerBound().toPlatformInsets(), boundsCompat.getUpperBound().toPlatformInsets());
        }

        public static Insets getHigherBounds(WindowInsetsAnimation.Bounds bounds) {
            return Insets.toCompatInsets(bounds.getUpperBound());
        }

        public static Insets getLowerBounds(WindowInsetsAnimation.Bounds bounds) {
            return Insets.toCompatInsets(bounds.getLowerBound());
        }

        public static void setCallback(View view, Callback object) {
            object = object != null ? new ProxyCallback((Callback)object) : null;
            view.setWindowInsetsAnimationCallback((WindowInsetsAnimation.Callback)object);
        }

        @Override
        public long getDurationMillis() {
            return this.mWrapped.getDurationMillis();
        }

        @Override
        public float getFraction() {
            return this.mWrapped.getFraction();
        }

        @Override
        public float getInterpolatedFraction() {
            return this.mWrapped.getInterpolatedFraction();
        }

        @Override
        public Interpolator getInterpolator() {
            return this.mWrapped.getInterpolator();
        }

        @Override
        public int getTypeMask() {
            return this.mWrapped.getTypeMask();
        }

        @Override
        public void setFraction(float f) {
            this.mWrapped.setFraction(f);
        }

        private static class ProxyCallback
        extends WindowInsetsAnimation.Callback {
            private final HashMap<WindowInsetsAnimation, WindowInsetsAnimationCompat> mAnimations = new HashMap();
            private final Callback mCompat;
            private List<WindowInsetsAnimationCompat> mRORunningAnimations;
            private ArrayList<WindowInsetsAnimationCompat> mTmpRunningAnimations;

            ProxyCallback(Callback callback) {
                super(callback.getDispatchMode());
                this.mCompat = callback;
            }

            private WindowInsetsAnimationCompat getWindowInsetsAnimationCompat(WindowInsetsAnimation windowInsetsAnimation) {
                WindowInsetsAnimationCompat windowInsetsAnimationCompat;
                WindowInsetsAnimationCompat windowInsetsAnimationCompat2 = windowInsetsAnimationCompat = this.mAnimations.get(windowInsetsAnimation);
                if (windowInsetsAnimationCompat == null) {
                    windowInsetsAnimationCompat2 = WindowInsetsAnimationCompat.toWindowInsetsAnimationCompat(windowInsetsAnimation);
                    this.mAnimations.put(windowInsetsAnimation, windowInsetsAnimationCompat2);
                }
                return windowInsetsAnimationCompat2;
            }

            public void onEnd(WindowInsetsAnimation windowInsetsAnimation) {
                this.mCompat.onEnd(this.getWindowInsetsAnimationCompat(windowInsetsAnimation));
                this.mAnimations.remove(windowInsetsAnimation);
            }

            public void onPrepare(WindowInsetsAnimation windowInsetsAnimation) {
                this.mCompat.onPrepare(this.getWindowInsetsAnimationCompat(windowInsetsAnimation));
            }

            public WindowInsets onProgress(WindowInsets windowInsets, List<WindowInsetsAnimation> list) {
                ArrayList<WindowInsetsAnimationCompat> arrayList = this.mTmpRunningAnimations;
                if (arrayList == null) {
                    arrayList = new ArrayList(list.size());
                    this.mTmpRunningAnimations = arrayList;
                    this.mRORunningAnimations = Collections.unmodifiableList(arrayList);
                } else {
                    arrayList.clear();
                }
                for (int i = list.size() - 1; i >= 0; --i) {
                    WindowInsetsAnimation windowInsetsAnimation = list.get(i);
                    arrayList = this.getWindowInsetsAnimationCompat(windowInsetsAnimation);
                    ((WindowInsetsAnimationCompat)((Object)arrayList)).setFraction(windowInsetsAnimation.getFraction());
                    this.mTmpRunningAnimations.add((WindowInsetsAnimationCompat)((Object)arrayList));
                }
                return this.mCompat.onProgress(WindowInsetsCompat.toWindowInsetsCompat(windowInsets), this.mRORunningAnimations).toWindowInsets();
            }

            public WindowInsetsAnimation.Bounds onStart(WindowInsetsAnimation windowInsetsAnimation, WindowInsetsAnimation.Bounds bounds) {
                return this.mCompat.onStart(this.getWindowInsetsAnimationCompat(windowInsetsAnimation), BoundsCompat.toBoundsCompat(bounds)).toBounds();
            }
        }
    }
}

