/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.os.CancellationSignal;
import android.view.View;
import android.view.Window;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputMethodManager;
import androidx.collection.SimpleArrayMap;
import androidx.core.view.WindowInsetsAnimationControlListenerCompat;
import androidx.core.view.WindowInsetsAnimationControllerCompat;

public final class WindowInsetsControllerCompat {
    public static final int BEHAVIOR_SHOW_BARS_BY_SWIPE = 1;
    public static final int BEHAVIOR_SHOW_BARS_BY_TOUCH = 0;
    public static final int BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE = 2;
    private final Impl mImpl;

    public WindowInsetsControllerCompat(Window window, View view) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(window, this) : (Build.VERSION.SDK_INT >= 26 ? new Impl26(window, view) : (Build.VERSION.SDK_INT >= 23 ? new Impl23(window, view) : (Build.VERSION.SDK_INT >= 20 ? new Impl20(window, view) : new Impl())));
    }

    private WindowInsetsControllerCompat(WindowInsetsController windowInsetsController) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(windowInsetsController, this) : new Impl();
    }

    public static WindowInsetsControllerCompat toWindowInsetsControllerCompat(WindowInsetsController windowInsetsController) {
        return new WindowInsetsControllerCompat(windowInsetsController);
    }

    public void addOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
        this.mImpl.addOnControllableInsetsChangedListener(onControllableInsetsChangedListener);
    }

    public void controlWindowInsetsAnimation(int n, long l, Interpolator interpolator2, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListenerCompat windowInsetsAnimationControlListenerCompat) {
        this.mImpl.controlWindowInsetsAnimation(n, l, interpolator2, cancellationSignal, windowInsetsAnimationControlListenerCompat);
    }

    public int getSystemBarsBehavior() {
        return this.mImpl.getSystemBarsBehavior();
    }

    public void hide(int n) {
        this.mImpl.hide(n);
    }

    public boolean isAppearanceLightNavigationBars() {
        return this.mImpl.isAppearanceLightNavigationBars();
    }

    public boolean isAppearanceLightStatusBars() {
        return this.mImpl.isAppearanceLightStatusBars();
    }

    public void removeOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
        this.mImpl.removeOnControllableInsetsChangedListener(onControllableInsetsChangedListener);
    }

    public void setAppearanceLightNavigationBars(boolean bl) {
        this.mImpl.setAppearanceLightNavigationBars(bl);
    }

    public void setAppearanceLightStatusBars(boolean bl) {
        this.mImpl.setAppearanceLightStatusBars(bl);
    }

    public void setSystemBarsBehavior(int n) {
        this.mImpl.setSystemBarsBehavior(n);
    }

    public void show(int n) {
        this.mImpl.show(n);
    }

    private static class Impl {
        Impl() {
        }

        void addOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
        }

        void controlWindowInsetsAnimation(int n, long l, Interpolator interpolator2, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListenerCompat windowInsetsAnimationControlListenerCompat) {
        }

        int getSystemBarsBehavior() {
            return 0;
        }

        void hide(int n) {
        }

        public boolean isAppearanceLightNavigationBars() {
            return false;
        }

        public boolean isAppearanceLightStatusBars() {
            return false;
        }

        void removeOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
        }

        public void setAppearanceLightNavigationBars(boolean bl) {
        }

        public void setAppearanceLightStatusBars(boolean bl) {
        }

        void setSystemBarsBehavior(int n) {
        }

        void show(int n) {
        }
    }

    private static class Impl20
    extends Impl {
        private final View mView;
        protected final Window mWindow;

        Impl20(Window window, View view) {
            this.mWindow = window;
            this.mView = view;
        }

        private void hideForType(int n) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 8) {
                        ((InputMethodManager)this.mWindow.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.mWindow.getDecorView().getWindowToken(), 0);
                    }
                    return;
                }
                this.setSystemUiFlag(2);
                return;
            }
            this.setSystemUiFlag(4);
        }

        private void showForType(int n) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 8) {
                        View view = this.mView;
                        if (view != null && (view.isInEditMode() || view.onCheckIsTextEditor())) {
                            view.requestFocus();
                        } else {
                            view = this.mWindow.getCurrentFocus();
                        }
                        final View view2 = view;
                        if (view == null) {
                            view2 = this.mWindow.findViewById(0x1020002);
                        }
                        if (view2 != null && view2.hasWindowFocus()) {
                            view2.post(new Runnable(){

                                @Override
                                public void run() {
                                    ((InputMethodManager)view2.getContext().getSystemService("input_method")).showSoftInput(view2, 0);
                                }
                            });
                        }
                    }
                    return;
                }
                this.unsetSystemUiFlag(2);
                return;
            }
            this.unsetSystemUiFlag(4);
            this.unsetWindowFlag(1024);
        }

        @Override
        void addOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
        }

        @Override
        void controlWindowInsetsAnimation(int n, long l, Interpolator interpolator2, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListenerCompat windowInsetsAnimationControlListenerCompat) {
        }

        @Override
        int getSystemBarsBehavior() {
            return 0;
        }

        @Override
        void hide(int n) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((n & i) == 0) continue;
                this.hideForType(i);
            }
        }

        @Override
        void removeOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
        }

        @Override
        void setSystemBarsBehavior(int n) {
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        this.unsetSystemUiFlag(2048);
                        this.setSystemUiFlag(4096);
                    }
                } else {
                    this.unsetSystemUiFlag(4096);
                    this.setSystemUiFlag(2048);
                }
            } else {
                this.unsetSystemUiFlag(6144);
            }
        }

        protected void setSystemUiFlag(int n) {
            View view = this.mWindow.getDecorView();
            view.setSystemUiVisibility(n | view.getSystemUiVisibility());
        }

        protected void setWindowFlag(int n) {
            this.mWindow.addFlags(n);
        }

        @Override
        void show(int n) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((n & i) == 0) continue;
                this.showForType(i);
            }
        }

        protected void unsetSystemUiFlag(int n) {
            View view = this.mWindow.getDecorView();
            view.setSystemUiVisibility(n & view.getSystemUiVisibility());
        }

        protected void unsetWindowFlag(int n) {
            this.mWindow.clearFlags(n);
        }
    }

    private static class Impl23
    extends Impl20 {
        Impl23(Window window, View view) {
            super(window, view);
        }

        @Override
        public boolean isAppearanceLightStatusBars() {
            boolean bl = (this.mWindow.getDecorView().getSystemUiVisibility() & 0x2000) != 0;
            return bl;
        }

        @Override
        public void setAppearanceLightStatusBars(boolean bl) {
            if (bl) {
                this.unsetWindowFlag(0x4000000);
                this.setWindowFlag(Integer.MIN_VALUE);
                this.setSystemUiFlag(8192);
            } else {
                this.unsetSystemUiFlag(8192);
            }
        }
    }

    private static class Impl26
    extends Impl23 {
        Impl26(Window window, View view) {
            super(window, view);
        }

        @Override
        public boolean isAppearanceLightNavigationBars() {
            boolean bl = (this.mWindow.getDecorView().getSystemUiVisibility() & 0x10) != 0;
            return bl;
        }

        @Override
        public void setAppearanceLightNavigationBars(boolean bl) {
            if (bl) {
                this.unsetWindowFlag(0x8000000);
                this.setWindowFlag(Integer.MIN_VALUE);
                this.setSystemUiFlag(16);
            } else {
                this.unsetSystemUiFlag(16);
            }
        }
    }

    private static class Impl30
    extends Impl {
        final WindowInsetsControllerCompat mCompatController;
        final WindowInsetsController mInsetsController;
        private final SimpleArrayMap<OnControllableInsetsChangedListener, WindowInsetsController.OnControllableInsetsChangedListener> mListeners = new SimpleArrayMap();
        protected Window mWindow;

        Impl30(Window window, WindowInsetsControllerCompat windowInsetsControllerCompat) {
            this(window.getInsetsController(), windowInsetsControllerCompat);
            this.mWindow = window;
        }

        Impl30(WindowInsetsController windowInsetsController, WindowInsetsControllerCompat windowInsetsControllerCompat) {
            this.mInsetsController = windowInsetsController;
            this.mCompatController = windowInsetsControllerCompat;
        }

        @Override
        void addOnControllableInsetsChangedListener(final OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
            if (this.mListeners.containsKey(onControllableInsetsChangedListener)) {
                return;
            }
            WindowInsetsController.OnControllableInsetsChangedListener onControllableInsetsChangedListener2 = new WindowInsetsController.OnControllableInsetsChangedListener(){

                public void onControllableInsetsChanged(WindowInsetsController windowInsetsController, int n) {
                    if (Impl30.this.mInsetsController == windowInsetsController) {
                        onControllableInsetsChangedListener.onControllableInsetsChanged(Impl30.this.mCompatController, n);
                    }
                }
            };
            this.mListeners.put(onControllableInsetsChangedListener, onControllableInsetsChangedListener2);
            this.mInsetsController.addOnControllableInsetsChangedListener(onControllableInsetsChangedListener2);
        }

        @Override
        void controlWindowInsetsAnimation(int n, long l, Interpolator interpolator2, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListenerCompat object) {
            object = new WindowInsetsAnimationControlListener((WindowInsetsAnimationControlListenerCompat)object){
                private WindowInsetsAnimationControllerCompat mCompatAnimController = null;
                final /* synthetic */ WindowInsetsAnimationControlListenerCompat val$listener;
                {
                    this.val$listener = windowInsetsAnimationControlListenerCompat;
                }

                public void onCancelled(WindowInsetsAnimationController object) {
                    WindowInsetsAnimationControlListenerCompat windowInsetsAnimationControlListenerCompat = this.val$listener;
                    object = object == null ? null : this.mCompatAnimController;
                    windowInsetsAnimationControlListenerCompat.onCancelled((WindowInsetsAnimationControllerCompat)object);
                }

                public void onFinished(WindowInsetsAnimationController windowInsetsAnimationController) {
                    this.val$listener.onFinished(this.mCompatAnimController);
                }

                public void onReady(WindowInsetsAnimationController object, int n) {
                    object = new WindowInsetsAnimationControllerCompat((WindowInsetsAnimationController)object);
                    this.mCompatAnimController = object;
                    this.val$listener.onReady((WindowInsetsAnimationControllerCompat)object, n);
                }
            };
            this.mInsetsController.controlWindowInsetsAnimation(n, l, interpolator2, cancellationSignal, (WindowInsetsAnimationControlListener)object);
        }

        @Override
        int getSystemBarsBehavior() {
            return this.mInsetsController.getSystemBarsBehavior();
        }

        @Override
        void hide(int n) {
            this.mInsetsController.hide(n);
        }

        @Override
        public boolean isAppearanceLightNavigationBars() {
            boolean bl = (this.mInsetsController.getSystemBarsAppearance() & 0x10) != 0;
            return bl;
        }

        @Override
        public boolean isAppearanceLightStatusBars() {
            boolean bl = (this.mInsetsController.getSystemBarsAppearance() & 8) != 0;
            return bl;
        }

        @Override
        void removeOnControllableInsetsChangedListener(OnControllableInsetsChangedListener onControllableInsetsChangedListener) {
            if ((onControllableInsetsChangedListener = this.mListeners.remove(onControllableInsetsChangedListener)) != null) {
                this.mInsetsController.removeOnControllableInsetsChangedListener((WindowInsetsController.OnControllableInsetsChangedListener)onControllableInsetsChangedListener);
            }
        }

        @Override
        public void setAppearanceLightNavigationBars(boolean bl) {
            if (bl) {
                this.mInsetsController.setSystemBarsAppearance(16, 16);
            } else {
                this.mInsetsController.setSystemBarsAppearance(0, 16);
            }
        }

        @Override
        public void setAppearanceLightStatusBars(boolean bl) {
            if (bl) {
                if (this.mWindow != null) {
                    this.unsetSystemUiFlag(8192);
                }
                this.mInsetsController.setSystemBarsAppearance(8, 8);
            } else {
                this.mInsetsController.setSystemBarsAppearance(0, 8);
            }
        }

        @Override
        void setSystemBarsBehavior(int n) {
            this.mInsetsController.setSystemBarsBehavior(n);
        }

        @Override
        void show(int n) {
            this.mInsetsController.show(n);
        }

        protected void unsetSystemUiFlag(int n) {
            View view = this.mWindow.getDecorView();
            view.setSystemUiVisibility(n & view.getSystemUiVisibility());
        }
    }

    public static interface OnControllableInsetsChangedListener {
        public void onControllableInsetsChanged(WindowInsetsControllerCompat var1, int var2);
    }
}

