/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view.accessibility;

import android.os.Build;
import android.os.Parcelable;
import android.view.View;
import android.view.accessibility.AccessibilityRecord;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import java.util.List;

public class AccessibilityRecordCompat {
    private final AccessibilityRecord mRecord;

    @Deprecated
    public AccessibilityRecordCompat(Object object) {
        this.mRecord = (AccessibilityRecord)object;
    }

    public static int getMaxScrollX(AccessibilityRecord accessibilityRecord) {
        if (Build.VERSION.SDK_INT >= 15) {
            return accessibilityRecord.getMaxScrollX();
        }
        return 0;
    }

    public static int getMaxScrollY(AccessibilityRecord accessibilityRecord) {
        if (Build.VERSION.SDK_INT >= 15) {
            return accessibilityRecord.getMaxScrollY();
        }
        return 0;
    }

    @Deprecated
    public static AccessibilityRecordCompat obtain() {
        return new AccessibilityRecordCompat(AccessibilityRecord.obtain());
    }

    @Deprecated
    public static AccessibilityRecordCompat obtain(AccessibilityRecordCompat accessibilityRecordCompat) {
        return new AccessibilityRecordCompat(AccessibilityRecord.obtain((AccessibilityRecord)accessibilityRecordCompat.mRecord));
    }

    public static void setMaxScrollX(AccessibilityRecord accessibilityRecord, int n) {
        if (Build.VERSION.SDK_INT >= 15) {
            accessibilityRecord.setMaxScrollX(n);
        }
    }

    public static void setMaxScrollY(AccessibilityRecord accessibilityRecord, int n) {
        if (Build.VERSION.SDK_INT >= 15) {
            accessibilityRecord.setMaxScrollY(n);
        }
    }

    public static void setSource(AccessibilityRecord accessibilityRecord, View view, int n) {
        if (Build.VERSION.SDK_INT >= 16) {
            accessibilityRecord.setSource(view, n);
        }
    }

    @Deprecated
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessibilityRecordCompat)) {
            return false;
        }
        object = (AccessibilityRecordCompat)object;
        AccessibilityRecord accessibilityRecord = this.mRecord;
        return !(accessibilityRecord == null ? ((AccessibilityRecordCompat)object).mRecord != null : !accessibilityRecord.equals(((AccessibilityRecordCompat)object).mRecord));
    }

    @Deprecated
    public int getAddedCount() {
        return this.mRecord.getAddedCount();
    }

    @Deprecated
    public CharSequence getBeforeText() {
        return this.mRecord.getBeforeText();
    }

    @Deprecated
    public CharSequence getClassName() {
        return this.mRecord.getClassName();
    }

    @Deprecated
    public CharSequence getContentDescription() {
        return this.mRecord.getContentDescription();
    }

    @Deprecated
    public int getCurrentItemIndex() {
        return this.mRecord.getCurrentItemIndex();
    }

    @Deprecated
    public int getFromIndex() {
        return this.mRecord.getFromIndex();
    }

    @Deprecated
    public Object getImpl() {
        return this.mRecord;
    }

    @Deprecated
    public int getItemCount() {
        return this.mRecord.getItemCount();
    }

    @Deprecated
    public int getMaxScrollX() {
        return AccessibilityRecordCompat.getMaxScrollX(this.mRecord);
    }

    @Deprecated
    public int getMaxScrollY() {
        return AccessibilityRecordCompat.getMaxScrollY(this.mRecord);
    }

    @Deprecated
    public Parcelable getParcelableData() {
        return this.mRecord.getParcelableData();
    }

    @Deprecated
    public int getRemovedCount() {
        return this.mRecord.getRemovedCount();
    }

    @Deprecated
    public int getScrollX() {
        return this.mRecord.getScrollX();
    }

    @Deprecated
    public int getScrollY() {
        return this.mRecord.getScrollY();
    }

    @Deprecated
    public AccessibilityNodeInfoCompat getSource() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(this.mRecord.getSource());
    }

    @Deprecated
    public List<CharSequence> getText() {
        return this.mRecord.getText();
    }

    @Deprecated
    public int getToIndex() {
        return this.mRecord.getToIndex();
    }

    @Deprecated
    public int getWindowId() {
        return this.mRecord.getWindowId();
    }

    @Deprecated
    public int hashCode() {
        AccessibilityRecord accessibilityRecord = this.mRecord;
        int n = accessibilityRecord == null ? 0 : accessibilityRecord.hashCode();
        return n;
    }

    @Deprecated
    public boolean isChecked() {
        return this.mRecord.isChecked();
    }

    @Deprecated
    public boolean isEnabled() {
        return this.mRecord.isEnabled();
    }

    @Deprecated
    public boolean isFullScreen() {
        return this.mRecord.isFullScreen();
    }

    @Deprecated
    public boolean isPassword() {
        return this.mRecord.isPassword();
    }

    @Deprecated
    public boolean isScrollable() {
        return this.mRecord.isScrollable();
    }

    @Deprecated
    public void recycle() {
        this.mRecord.recycle();
    }

    @Deprecated
    public void setAddedCount(int n) {
        this.mRecord.setAddedCount(n);
    }

    @Deprecated
    public void setBeforeText(CharSequence charSequence) {
        this.mRecord.setBeforeText(charSequence);
    }

    @Deprecated
    public void setChecked(boolean bl) {
        this.mRecord.setChecked(bl);
    }

    @Deprecated
    public void setClassName(CharSequence charSequence) {
        this.mRecord.setClassName(charSequence);
    }

    @Deprecated
    public void setContentDescription(CharSequence charSequence) {
        this.mRecord.setContentDescription(charSequence);
    }

    @Deprecated
    public void setCurrentItemIndex(int n) {
        this.mRecord.setCurrentItemIndex(n);
    }

    @Deprecated
    public void setEnabled(boolean bl) {
        this.mRecord.setEnabled(bl);
    }

    @Deprecated
    public void setFromIndex(int n) {
        this.mRecord.setFromIndex(n);
    }

    @Deprecated
    public void setFullScreen(boolean bl) {
        this.mRecord.setFullScreen(bl);
    }

    @Deprecated
    public void setItemCount(int n) {
        this.mRecord.setItemCount(n);
    }

    @Deprecated
    public void setMaxScrollX(int n) {
        AccessibilityRecordCompat.setMaxScrollX(this.mRecord, n);
    }

    @Deprecated
    public void setMaxScrollY(int n) {
        AccessibilityRecordCompat.setMaxScrollY(this.mRecord, n);
    }

    @Deprecated
    public void setParcelableData(Parcelable parcelable) {
        this.mRecord.setParcelableData(parcelable);
    }

    @Deprecated
    public void setPassword(boolean bl) {
        this.mRecord.setPassword(bl);
    }

    @Deprecated
    public void setRemovedCount(int n) {
        this.mRecord.setRemovedCount(n);
    }

    @Deprecated
    public void setScrollX(int n) {
        this.mRecord.setScrollX(n);
    }

    @Deprecated
    public void setScrollY(int n) {
        this.mRecord.setScrollY(n);
    }

    @Deprecated
    public void setScrollable(boolean bl) {
        this.mRecord.setScrollable(bl);
    }

    @Deprecated
    public void setSource(View view) {
        this.mRecord.setSource(view);
    }

    @Deprecated
    public void setSource(View view, int n) {
        AccessibilityRecordCompat.setSource(this.mRecord, view, n);
    }

    @Deprecated
    public void setToIndex(int n) {
        this.mRecord.setToIndex(n);
    }
}

