/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view.inputmethod;

import android.content.ClipData;
import android.content.ClipDescription;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputContentInfo;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.ContentInfoCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.inputmethod.EditorInfoCompat;
import androidx.core.view.inputmethod.InputContentInfoCompat;

public final class InputConnectionCompat {
    private static final String COMMIT_CONTENT_ACTION = "androidx.core.view.inputmethod.InputConnectionCompat.COMMIT_CONTENT";
    private static final String COMMIT_CONTENT_CONTENT_URI_INTEROP_KEY = "android.support.v13.view.inputmethod.InputConnectionCompat.CONTENT_URI";
    private static final String COMMIT_CONTENT_CONTENT_URI_KEY = "androidx.core.view.inputmethod.InputConnectionCompat.CONTENT_URI";
    private static final String COMMIT_CONTENT_DESCRIPTION_INTEROP_KEY = "android.support.v13.view.inputmethod.InputConnectionCompat.CONTENT_DESCRIPTION";
    private static final String COMMIT_CONTENT_DESCRIPTION_KEY = "androidx.core.view.inputmethod.InputConnectionCompat.CONTENT_DESCRIPTION";
    private static final String COMMIT_CONTENT_FLAGS_INTEROP_KEY = "android.support.v13.view.inputmethod.InputConnectionCompat.CONTENT_FLAGS";
    private static final String COMMIT_CONTENT_FLAGS_KEY = "androidx.core.view.inputmethod.InputConnectionCompat.CONTENT_FLAGS";
    private static final String COMMIT_CONTENT_INTEROP_ACTION = "android.support.v13.view.inputmethod.InputConnectionCompat.COMMIT_CONTENT";
    private static final String COMMIT_CONTENT_LINK_URI_INTEROP_KEY = "android.support.v13.view.inputmethod.InputConnectionCompat.CONTENT_LINK_URI";
    private static final String COMMIT_CONTENT_LINK_URI_KEY = "androidx.core.view.inputmethod.InputConnectionCompat.CONTENT_LINK_URI";
    private static final String COMMIT_CONTENT_OPTS_INTEROP_KEY = "android.support.v13.view.inputmethod.InputConnectionCompat.CONTENT_OPTS";
    private static final String COMMIT_CONTENT_OPTS_KEY = "androidx.core.view.inputmethod.InputConnectionCompat.CONTENT_OPTS";
    private static final String COMMIT_CONTENT_RESULT_INTEROP_RECEIVER_KEY = "android.support.v13.view.inputmethod.InputConnectionCompat.CONTENT_RESULT_RECEIVER";
    private static final String COMMIT_CONTENT_RESULT_RECEIVER_KEY = "androidx.core.view.inputmethod.InputConnectionCompat.CONTENT_RESULT_RECEIVER";
    private static final String EXTRA_INPUT_CONTENT_INFO = "androidx.core.view.extra.INPUT_CONTENT_INFO";
    public static final int INPUT_CONTENT_GRANT_READ_URI_PERMISSION = 1;
    private static final String LOG_TAG = "InputConnectionCompat";

    @Deprecated
    public InputConnectionCompat() {
    }

    public static boolean commitContent(InputConnection inputConnection, EditorInfo object, InputContentInfoCompat inputContentInfoCompat, int n, Bundle bundle) {
        int n2;
        int n3;
        int n4;
        Bundle bundle2;
        block7: {
            ClipDescription clipDescription = inputContentInfoCompat.getDescription();
            bundle2 = EditorInfoCompat.getContentMimeTypes(object);
            n4 = ((String[])bundle2).length;
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (!clipDescription.hasMimeType(bundle2[n2])) continue;
                n2 = 1;
                break block7;
            }
            n2 = 0;
        }
        if (n2 == 0) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 25) {
            return inputConnection.commitContent((InputContentInfo)inputContentInfoCompat.unwrap(), n, bundle);
        }
        n4 = EditorInfoCompat.getProtocol(object);
        if (n4 != 2) {
            n2 = n3;
            if (n4 != 3) {
                n2 = n3;
                if (n4 != 4) {
                    return false;
                }
            }
        } else {
            n2 = 1;
        }
        bundle2 = new Bundle();
        object = n2 != 0 ? COMMIT_CONTENT_CONTENT_URI_INTEROP_KEY : COMMIT_CONTENT_CONTENT_URI_KEY;
        bundle2.putParcelable((String)object, (Parcelable)inputContentInfoCompat.getContentUri());
        object = n2 != 0 ? COMMIT_CONTENT_DESCRIPTION_INTEROP_KEY : COMMIT_CONTENT_DESCRIPTION_KEY;
        bundle2.putParcelable((String)object, (Parcelable)inputContentInfoCompat.getDescription());
        object = n2 != 0 ? COMMIT_CONTENT_LINK_URI_INTEROP_KEY : COMMIT_CONTENT_LINK_URI_KEY;
        bundle2.putParcelable((String)object, (Parcelable)inputContentInfoCompat.getLinkUri());
        object = n2 != 0 ? COMMIT_CONTENT_FLAGS_INTEROP_KEY : COMMIT_CONTENT_FLAGS_KEY;
        bundle2.putInt((String)object, n);
        object = n2 != 0 ? COMMIT_CONTENT_OPTS_INTEROP_KEY : COMMIT_CONTENT_OPTS_KEY;
        bundle2.putParcelable((String)object, (Parcelable)bundle);
        object = n2 != 0 ? COMMIT_CONTENT_INTEROP_ACTION : COMMIT_CONTENT_ACTION;
        return inputConnection.performPrivateCommand((String)object, bundle2);
    }

    private static OnCommitContentListener createOnCommitContentListenerUsingPerformReceiveContent(final View view) {
        Preconditions.checkNotNull(view);
        return new OnCommitContentListener(){

            @Override
            public boolean onCommitContent(InputContentInfoCompat object, int n, Bundle bundle) {
                int n2 = Build.VERSION.SDK_INT;
                boolean bl = false;
                Bundle bundle2 = bundle;
                if (n2 >= 25) {
                    bundle2 = bundle;
                    if ((n & 1) != 0) {
                        try {
                            ((InputContentInfoCompat)object).requestPermission();
                        }
                        catch (Exception exception) {
                            Log.w((String)InputConnectionCompat.LOG_TAG, (String)"Can't insert content from IME; requestPermission() failed", (Throwable)exception);
                            return false;
                        }
                        bundle2 = (InputContentInfo)((InputContentInfoCompat)object).unwrap();
                        bundle = bundle == null ? new Bundle() : new Bundle(bundle);
                        bundle.putParcelable(InputConnectionCompat.EXTRA_INPUT_CONTENT_INFO, (Parcelable)bundle2);
                        bundle2 = bundle;
                    }
                }
                if (ViewCompat.performReceiveContent(view, (ContentInfoCompat)(object = new ContentInfoCompat.Builder(new ClipData(((InputContentInfoCompat)object).getDescription(), new ClipData.Item(((InputContentInfoCompat)object).getContentUri())), 2).setLinkUri(((InputContentInfoCompat)object).getLinkUri()).setExtras(bundle2).build())) == null) {
                    bl = true;
                }
                return bl;
            }
        };
    }

    public static InputConnection createWrapper(View view, InputConnection inputConnection, EditorInfo editorInfo) {
        return InputConnectionCompat.createWrapper(inputConnection, editorInfo, InputConnectionCompat.createOnCommitContentListenerUsingPerformReceiveContent(view));
    }

    @Deprecated
    public static InputConnection createWrapper(InputConnection inputConnection, EditorInfo editorInfo, final OnCommitContentListener onCommitContentListener) {
        ObjectsCompat.requireNonNull(inputConnection, "inputConnection must be non-null");
        ObjectsCompat.requireNonNull(editorInfo, "editorInfo must be non-null");
        ObjectsCompat.requireNonNull(onCommitContentListener, "onCommitContentListener must be non-null");
        if (Build.VERSION.SDK_INT >= 25) {
            return new InputConnectionWrapper(inputConnection, false){

                public boolean commitContent(InputContentInfo inputContentInfo, int n, Bundle bundle) {
                    if (onCommitContentListener.onCommitContent(InputContentInfoCompat.wrap(inputContentInfo), n, bundle)) {
                        return true;
                    }
                    return super.commitContent(inputContentInfo, n, bundle);
                }
            };
        }
        if (EditorInfoCompat.getContentMimeTypes(editorInfo).length == 0) {
            return inputConnection;
        }
        return new InputConnectionWrapper(inputConnection, false){

            public boolean performPrivateCommand(String string2, Bundle bundle) {
                if (InputConnectionCompat.handlePerformPrivateCommand(string2, bundle, onCommitContentListener)) {
                    return true;
                }
                return super.performPrivateCommand(string2, bundle);
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean handlePerformPrivateCommand(String string2, Bundle object, OnCommitContentListener onCommitContentListener) {
        void var0_3;
        block11: {
            int n;
            block12: {
                ResultReceiver resultReceiver;
                int n2 = 0;
                if (object == null) {
                    return false;
                }
                if (TextUtils.equals((CharSequence)COMMIT_CONTENT_ACTION, (CharSequence)string2)) {
                    n = 0;
                } else {
                    if (!TextUtils.equals((CharSequence)COMMIT_CONTENT_INTEROP_ACTION, (CharSequence)string2)) {
                        return false;
                    }
                    n = 1;
                }
                string2 = n != 0 ? COMMIT_CONTENT_RESULT_INTEROP_RECEIVER_KEY : COMMIT_CONTENT_RESULT_RECEIVER_KEY;
                try {
                    resultReceiver = (ResultReceiver)object.getParcelable(string2);
                    string2 = n != 0 ? COMMIT_CONTENT_CONTENT_URI_INTEROP_KEY : COMMIT_CONTENT_CONTENT_URI_KEY;
                }
                catch (Throwable throwable) {
                    object = null;
                    break block11;
                }
                try {
                    Uri uri = (Uri)object.getParcelable(string2);
                    string2 = n != 0 ? COMMIT_CONTENT_DESCRIPTION_INTEROP_KEY : COMMIT_CONTENT_DESCRIPTION_KEY;
                    ClipDescription clipDescription = (ClipDescription)object.getParcelable(string2);
                    string2 = n != 0 ? COMMIT_CONTENT_LINK_URI_INTEROP_KEY : COMMIT_CONTENT_LINK_URI_KEY;
                    Uri uri2 = (Uri)object.getParcelable(string2);
                    string2 = n != 0 ? COMMIT_CONTENT_FLAGS_INTEROP_KEY : COMMIT_CONTENT_FLAGS_KEY;
                    int n3 = object.getInt(string2);
                    string2 = n != 0 ? COMMIT_CONTENT_OPTS_INTEROP_KEY : COMMIT_CONTENT_OPTS_KEY;
                    string2 = (Bundle)object.getParcelable(string2);
                    n = n2;
                    if (uri != null) {
                        n = n2;
                        if (clipDescription != null) {
                            object = new InputContentInfoCompat(uri, clipDescription, uri2);
                            n = onCommitContentListener.onCommitContent((InputContentInfoCompat)object, n3, (Bundle)string2) ? 1 : 0;
                        }
                    }
                    if (resultReceiver == null) break block12;
                }
                catch (Throwable throwable) {
                    object = resultReceiver;
                    break block11;
                }
                resultReceiver.send(n, null);
            }
            return n != 0;
        }
        if (object != null) {
            object.send(0, null);
        }
        throw var0_3;
    }

    public static interface OnCommitContentListener {
        public boolean onCommitContent(InputContentInfoCompat var1, int var2, Bundle var3);
    }
}

