/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class PopupWindowCompat {
    private static final String TAG = "PopupWindowCompatApi21";
    private static Method sGetWindowLayoutTypeMethod;
    private static boolean sGetWindowLayoutTypeMethodAttempted;
    private static Field sOverlapAnchorField;
    private static boolean sOverlapAnchorFieldAttempted;
    private static Method sSetWindowLayoutTypeMethod;
    private static boolean sSetWindowLayoutTypeMethodAttempted;

    private PopupWindowCompat() {
    }

    public static boolean getOverlapAnchor(PopupWindow popupWindow) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getOverlapAnchor(popupWindow);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Field field;
            if (!sOverlapAnchorFieldAttempted) {
                try {
                    sOverlapAnchorField = field = PopupWindow.class.getDeclaredField("mOverlapAnchor");
                    field.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Log.i((String)TAG, (String)"Could not fetch mOverlapAnchor field from PopupWindow", (Throwable)noSuchFieldException);
                }
                sOverlapAnchorFieldAttempted = true;
            }
            if ((field = sOverlapAnchorField) != null) {
                try {
                    boolean bl = (Boolean)field.get(popupWindow);
                    return bl;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.i((String)TAG, (String)"Could not get overlap anchor field in PopupWindow", (Throwable)illegalAccessException);
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getWindowLayoutType(PopupWindow popupWindow) {
        Method method;
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getWindowLayoutType(popupWindow);
        }
        if (!sGetWindowLayoutTypeMethodAttempted) {
            try {
                sGetWindowLayoutTypeMethod = method = PopupWindow.class.getDeclaredMethod("getWindowLayoutType", new Class[0]);
                method.setAccessible(true);
            }
            catch (Exception exception) {}
            sGetWindowLayoutTypeMethodAttempted = true;
        }
        if ((method = sGetWindowLayoutTypeMethod) == null) return 0;
        try {
            return (Integer)method.invoke((Object)popupWindow, new Object[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void setOverlapAnchor(PopupWindow popupWindow, boolean bl) {
        if (Build.VERSION.SDK_INT >= 23) {
            Api23Impl.setOverlapAnchor(popupWindow, bl);
        } else if (Build.VERSION.SDK_INT >= 21) {
            Field field;
            if (!sOverlapAnchorFieldAttempted) {
                try {
                    sOverlapAnchorField = field = PopupWindow.class.getDeclaredField("mOverlapAnchor");
                    field.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Log.i((String)TAG, (String)"Could not fetch mOverlapAnchor field from PopupWindow", (Throwable)noSuchFieldException);
                }
                sOverlapAnchorFieldAttempted = true;
            }
            if ((field = sOverlapAnchorField) != null) {
                try {
                    field.set(popupWindow, bl);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.i((String)TAG, (String)"Could not set overlap anchor field in PopupWindow", (Throwable)illegalAccessException);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setWindowLayoutType(PopupWindow popupWindow, int n) {
        Method method;
        if (Build.VERSION.SDK_INT >= 23) {
            Api23Impl.setWindowLayoutType(popupWindow, n);
            return;
        }
        if (!sSetWindowLayoutTypeMethodAttempted) {
            try {
                sSetWindowLayoutTypeMethod = method = PopupWindow.class.getDeclaredMethod("setWindowLayoutType", Integer.TYPE);
                method.setAccessible(true);
            }
            catch (Exception exception) {}
            sSetWindowLayoutTypeMethodAttempted = true;
        }
        if ((method = sSetWindowLayoutTypeMethod) == null) return;
        try {
            method.invoke((Object)popupWindow, n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void showAsDropDown(PopupWindow popupWindow, View view, int n, int n2, int n3) {
        if (Build.VERSION.SDK_INT >= 19) {
            Api19Impl.showAsDropDown(popupWindow, view, n, n2, n3);
        } else {
            int n4 = n;
            if ((GravityCompat.getAbsoluteGravity(n3, ViewCompat.getLayoutDirection(view)) & 7) == 5) {
                n4 = n - (popupWindow.getWidth() - view.getWidth());
            }
            popupWindow.showAsDropDown(view, n4, n2);
        }
    }

    static class Api19Impl {
        private Api19Impl() {
        }

        static void showAsDropDown(PopupWindow popupWindow, View view, int n, int n2, int n3) {
            popupWindow.showAsDropDown(view, n, n2, n3);
        }
    }

    static class Api23Impl {
        private Api23Impl() {
        }

        static boolean getOverlapAnchor(PopupWindow popupWindow) {
            return popupWindow.getOverlapAnchor();
        }

        static int getWindowLayoutType(PopupWindow popupWindow) {
            return popupWindow.getWindowLayoutType();
        }

        static void setOverlapAnchor(PopupWindow popupWindow, boolean bl) {
            popupWindow.setOverlapAnchor(bl);
        }

        static void setWindowLayoutType(PopupWindow popupWindow, int n) {
            popupWindow.setWindowLayoutType(n);
        }
    }
}

