/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.ClipData;
import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.core.view.ContentInfoCompat;
import androidx.core.view.OnReceiveContentListener;

public final class TextViewOnReceiveContentListener
implements OnReceiveContentListener {
    private static final String LOG_TAG = "ReceiveContent";

    private static CharSequence coerceToText(Context context, ClipData.Item item, int n) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.coerce(context, item, n);
        }
        return ApiImpl.coerce(context, item, n);
    }

    private static void replaceSelection(Editable editable, CharSequence charSequence) {
        int n = Selection.getSelectionStart((CharSequence)editable);
        int n2 = Selection.getSelectionEnd((CharSequence)editable);
        int n3 = Math.max(0, Math.min(n, n2));
        n = Math.max(0, Math.max(n, n2));
        Selection.setSelection((Spannable)editable, (int)n);
        editable.replace(n3, n, charSequence);
    }

    @Override
    public ContentInfoCompat onReceiveContent(View view, ContentInfoCompat contentInfoCompat) {
        StringBuilder stringBuilder;
        if (Log.isLoggable((String)LOG_TAG, (int)3)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("onReceive: ");
            stringBuilder.append(contentInfoCompat);
            Log.d((String)LOG_TAG, (String)stringBuilder.toString());
        }
        if (contentInfoCompat.getSource() == 2) {
            return contentInfoCompat;
        }
        stringBuilder = contentInfoCompat.getClip();
        int n = contentInfoCompat.getFlags();
        contentInfoCompat = (TextView)view;
        view = (Editable)contentInfoCompat.getText();
        contentInfoCompat = contentInfoCompat.getContext();
        boolean bl = false;
        for (int i = 0; i < stringBuilder.getItemCount(); ++i) {
            CharSequence charSequence = TextViewOnReceiveContentListener.coerceToText((Context)contentInfoCompat, stringBuilder.getItemAt(i), n);
            boolean bl2 = bl;
            if (charSequence != null) {
                if (!bl) {
                    TextViewOnReceiveContentListener.replaceSelection((Editable)view, charSequence);
                    bl2 = true;
                } else {
                    view.insert(Selection.getSelectionEnd((CharSequence)view), (CharSequence)"\n");
                    view.insert(Selection.getSelectionEnd((CharSequence)view), charSequence);
                    bl2 = bl;
                }
            }
            bl = bl2;
        }
        return null;
    }

    private static final class Api16Impl {
        private Api16Impl() {
        }

        static CharSequence coerce(Context object, ClipData.Item object2, int n) {
            if ((n & 1) != 0) {
                object2 = object2.coerceToText(object);
                object = object2;
                if (object2 instanceof Spanned) {
                    object = object2.toString();
                }
                return object;
            }
            return object2.coerceToStyledText(object);
        }
    }

    private static final class ApiImpl {
        private ApiImpl() {
        }

        static CharSequence coerce(Context object, ClipData.Item object2, int n) {
            object2 = object2.coerceToText(object);
            object = object2;
            if ((n & 1) != 0) {
                object = object2;
                if (object2 instanceof Spanned) {
                    object = object2.toString();
                }
            }
            return object;
        }
    }
}

