/*
 * Decompiled with CFR 0.152.
 */
package androidx.dynamicanimation.animation;

import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.Force;

public final class SpringForce
implements Force {
    public static final float DAMPING_RATIO_HIGH_BOUNCY = 0.2f;
    public static final float DAMPING_RATIO_LOW_BOUNCY = 0.75f;
    public static final float DAMPING_RATIO_MEDIUM_BOUNCY = 0.5f;
    public static final float DAMPING_RATIO_NO_BOUNCY = 1.0f;
    public static final float STIFFNESS_HIGH = 10000.0f;
    public static final float STIFFNESS_LOW = 200.0f;
    public static final float STIFFNESS_MEDIUM = 1500.0f;
    public static final float STIFFNESS_VERY_LOW = 50.0f;
    private static final double UNSET = Double.MAX_VALUE;
    private static final double VELOCITY_THRESHOLD_MULTIPLIER = 62.5;
    private double mDampedFreq;
    double mDampingRatio = 0.5;
    private double mFinalPosition;
    private double mGammaMinus;
    private double mGammaPlus;
    private boolean mInitialized = false;
    private final DynamicAnimation.MassState mMassState;
    double mNaturalFreq = Math.sqrt(1500.0);
    private double mValueThreshold;
    private double mVelocityThreshold;

    public SpringForce() {
        this.mFinalPosition = Double.MAX_VALUE;
        this.mMassState = new DynamicAnimation.MassState();
    }

    public SpringForce(float f) {
        this.mFinalPosition = Double.MAX_VALUE;
        this.mMassState = new DynamicAnimation.MassState();
        this.mFinalPosition = f;
    }

    private void init() {
        if (this.mInitialized) {
            return;
        }
        if (this.mFinalPosition != Double.MAX_VALUE) {
            double d = this.mDampingRatio;
            if (d > 1.0) {
                double d2 = -d;
                double d3 = this.mNaturalFreq;
                this.mGammaPlus = d2 * d3 + d3 * Math.sqrt(d * d - 1.0);
                d3 = this.mDampingRatio;
                d = -d3;
                d2 = this.mNaturalFreq;
                this.mGammaMinus = d * d2 - d2 * Math.sqrt(d3 * d3 - 1.0);
            } else if (d >= 0.0 && d < 1.0) {
                this.mDampedFreq = this.mNaturalFreq * Math.sqrt(1.0 - d * d);
            }
            this.mInitialized = true;
            return;
        }
        throw new IllegalStateException("Error: Final position of the spring must be set before the animation starts");
    }

    @Override
    public float getAcceleration(float f, float f2) {
        float f3 = this.getFinalPosition();
        double d = this.mNaturalFreq;
        double d2 = this.mDampingRatio;
        return (float)(-(d * d) * (double)(f - f3) - d * 2.0 * d2 * (double)f2);
    }

    public float getDampingRatio() {
        return (float)this.mDampingRatio;
    }

    public float getFinalPosition() {
        return (float)this.mFinalPosition;
    }

    public float getStiffness() {
        double d = this.mNaturalFreq;
        return (float)(d * d);
    }

    @Override
    public boolean isAtEquilibrium(float f, float f2) {
        return (double)Math.abs(f2) < this.mVelocityThreshold && (double)Math.abs(f - this.getFinalPosition()) < this.mValueThreshold;
    }

    public SpringForce setDampingRatio(float f) {
        if (!(f < 0.0f)) {
            this.mDampingRatio = f;
            this.mInitialized = false;
            return this;
        }
        throw new IllegalArgumentException("Damping ratio must be non-negative");
    }

    public SpringForce setFinalPosition(float f) {
        this.mFinalPosition = f;
        return this;
    }

    public SpringForce setStiffness(float f) {
        if (!(f <= 0.0f)) {
            this.mNaturalFreq = Math.sqrt(f);
            this.mInitialized = false;
            return this;
        }
        throw new IllegalArgumentException("Spring stiffness constant must be positive.");
    }

    void setValueThreshold(double d) {
        this.mValueThreshold = d = Math.abs(d);
        this.mVelocityThreshold = d * 62.5;
    }

    DynamicAnimation.MassState updateValues(double d, double d2, long l) {
        this.init();
        double d3 = (double)l / 1000.0;
        double d4 = d - this.mFinalPosition;
        d = this.mDampingRatio;
        if (d > 1.0) {
            d = this.mGammaMinus;
            double d5 = this.mGammaPlus;
            double d6 = d4 - (d * d4 - d2) / (d - d5);
            d2 = (d4 * d - d2) / (d - d5);
            d = Math.pow(Math.E, d * d3) * d6 + Math.pow(Math.E, this.mGammaPlus * d3) * d2;
            d5 = this.mGammaMinus;
            double d7 = Math.pow(Math.E, d5 * d3);
            d4 = this.mGammaPlus;
            d2 = d6 * d5 * d7 + d2 * d4 * Math.pow(Math.E, d4 * d3);
        } else if (d == 1.0) {
            d = this.mNaturalFreq;
            d2 += d * d4;
            d = Math.pow(Math.E, -d * d3) * (d4 += d2 * d3);
            double d8 = Math.pow(Math.E, -this.mNaturalFreq * d3);
            double d9 = this.mNaturalFreq;
            double d10 = -d9;
            d2 = d2 * Math.pow(Math.E, -d9 * d3) + d4 * d8 * d10;
        } else {
            double d11 = 1.0 / this.mDampedFreq;
            double d12 = this.mNaturalFreq;
            d2 = d11 * (d * d12 * d4 + d2);
            d = Math.pow(Math.E, -d * d12 * d3) * (Math.cos(this.mDampedFreq * d3) * d4 + Math.sin(this.mDampedFreq * d3) * d2);
            double d13 = this.mNaturalFreq;
            d11 = -d13;
            d12 = this.mDampingRatio;
            double d14 = Math.pow(Math.E, -d12 * d13 * d3);
            double d15 = this.mDampedFreq;
            d13 = -d15;
            double d16 = Math.sin(d15 * d3);
            d15 = this.mDampedFreq;
            d2 = d11 * d * d12 + d14 * (d13 * d4 * d16 + d2 * d15 * Math.cos(d15 * d3));
        }
        this.mMassState.mValue = (float)(d + this.mFinalPosition);
        this.mMassState.mVelocity = (float)d2;
        return this.mMassState;
    }
}

