/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.collection.ArraySet;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.DefaultEmojiCompatConfig;
import androidx.emoji2.text.EmojiMetadata;
import androidx.emoji2.text.EmojiProcessor;
import androidx.emoji2.text.EmojiSpan;
import androidx.emoji2.text.MetadataRepo;
import androidx.emoji2.text.TypefaceEmojiSpan;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EmojiCompat {
    private static final Object CONFIG_LOCK;
    public static final String EDITOR_INFO_METAVERSION_KEY = "android.support.text.emoji.emojiCompat_metadataVersion";
    public static final String EDITOR_INFO_REPLACE_ALL_KEY = "android.support.text.emoji.emojiCompat_replaceAll";
    static final int EMOJI_COUNT_UNLIMITED = Integer.MAX_VALUE;
    private static final Object INSTANCE_LOCK;
    public static final int LOAD_STATE_DEFAULT = 3;
    public static final int LOAD_STATE_FAILED = 2;
    public static final int LOAD_STATE_LOADING = 0;
    public static final int LOAD_STATE_SUCCEEDED = 1;
    public static final int LOAD_STRATEGY_DEFAULT = 0;
    public static final int LOAD_STRATEGY_MANUAL = 1;
    private static final String NOT_INITIALIZED_ERROR_TEXT = "EmojiCompat is not initialized.\n\nYou must initialize EmojiCompat prior to referencing the EmojiCompat instance.\n\nThe most likely cause of this error is disabling the EmojiCompatInitializer\neither explicitly in AndroidManifest.xml, or by including\nandroidx.emoji2:emoji2-bundled.\n\nAutomatic initialization is typically performed by EmojiCompatInitializer. If\nyou are not expecting to initialize EmojiCompat manually in your application,\nplease check to ensure it has not been removed from your APK's manifest. You can\ndo this in Android Studio using Build > Analyze APK.\n\nIn the APK Analyzer, ensure that the startup entry for\nEmojiCompatInitializer and InitializationProvider is present in\n AndroidManifest.xml. If it is missing or contains tools:node=\"remove\", and you\nintend to use automatic configuration, verify:\n\n  1. Your application does not include emoji2-bundled\n  2. All modules do not contain an exclusion manifest rule for\n     EmojiCompatInitializer or InitializationProvider. For more information\n     about manifest exclusions see the documentation for the androidx startup\n     library.\n\nIf you intend to use emoji2-bundled, please call EmojiCompat.init. You can\nlearn more in the documentation for BundledEmojiCompatConfig.\n\nIf you intended to perform manual configuration, it is recommended that you call\nEmojiCompat.init immediately on application startup.\n\nIf you still cannot resolve this issue, please open a bug with your specific\nconfiguration to help improve error message.";
    public static final int REPLACE_STRATEGY_ALL = 1;
    public static final int REPLACE_STRATEGY_DEFAULT = 0;
    public static final int REPLACE_STRATEGY_NON_EXISTENT = 2;
    private static volatile boolean sHasDoneDefaultConfigLookup;
    private static volatile EmojiCompat sInstance;
    final int[] mEmojiAsDefaultStyleExceptions;
    private final int mEmojiSpanIndicatorColor;
    private final boolean mEmojiSpanIndicatorEnabled;
    private final GlyphChecker mGlyphChecker;
    private final CompatInternal mHelper;
    private final Set<InitCallback> mInitCallbacks;
    private final ReadWriteLock mInitLock = new ReentrantReadWriteLock();
    private volatile int mLoadState = 3;
    private final Handler mMainHandler;
    private final int mMetadataLoadStrategy;
    final MetadataRepoLoader mMetadataLoader;
    final boolean mReplaceAll;
    final boolean mUseEmojiAsDefaultStyle;

    static {
        INSTANCE_LOCK = new Object();
        CONFIG_LOCK = new Object();
    }

    private EmojiCompat(Config object) {
        this.mReplaceAll = ((Config)object).mReplaceAll;
        this.mUseEmojiAsDefaultStyle = ((Config)object).mUseEmojiAsDefaultStyle;
        this.mEmojiAsDefaultStyleExceptions = ((Config)object).mEmojiAsDefaultStyleExceptions;
        this.mEmojiSpanIndicatorEnabled = ((Config)object).mEmojiSpanIndicatorEnabled;
        this.mEmojiSpanIndicatorColor = ((Config)object).mEmojiSpanIndicatorColor;
        this.mMetadataLoader = ((Config)object).mMetadataLoader;
        this.mMetadataLoadStrategy = ((Config)object).mMetadataLoadStrategy;
        this.mGlyphChecker = ((Config)object).mGlyphChecker;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        ArraySet<InitCallback> arraySet = new ArraySet<InitCallback>();
        this.mInitCallbacks = arraySet;
        if (((Config)object).mInitCallbacks != null && !((Config)object).mInitCallbacks.isEmpty()) {
            arraySet.addAll(((Config)object).mInitCallbacks);
        }
        object = Build.VERSION.SDK_INT < 19 ? new CompatInternal(this) : new CompatInternal19(this);
        this.mHelper = object;
        this.loadMetadata();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmojiCompat get() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            EmojiCompat emojiCompat = sInstance;
            boolean bl = emojiCompat != null;
            Preconditions.checkState(bl, NOT_INITIALIZED_ERROR_TEXT);
            return emojiCompat;
        }
    }

    public static boolean handleDeleteSurroundingText(InputConnection inputConnection, Editable editable, int n, int n2, boolean bl) {
        if (Build.VERSION.SDK_INT >= 19) {
            return EmojiProcessor.handleDeleteSurroundingText(inputConnection, editable, n, n2, bl);
        }
        return false;
    }

    public static boolean handleOnKeyDown(Editable editable, int n, KeyEvent keyEvent) {
        if (Build.VERSION.SDK_INT >= 19) {
            return EmojiProcessor.handleOnKeyDown(editable, n, keyEvent);
        }
        return false;
    }

    public static EmojiCompat init(Context context) {
        return EmojiCompat.init(context, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmojiCompat init(Context object, DefaultEmojiCompatConfig.DefaultEmojiCompatConfigFactory object2) {
        if (sHasDoneDefaultConfigLookup) {
            return sInstance;
        }
        if (object2 == null) {
            object2 = new DefaultEmojiCompatConfig.DefaultEmojiCompatConfigFactory(null);
        }
        object2 = ((DefaultEmojiCompatConfig.DefaultEmojiCompatConfigFactory)object2).create((Context)object);
        object = CONFIG_LOCK;
        synchronized (object) {
            if (sHasDoneDefaultConfigLookup) return sInstance;
            if (object2 != null) {
                EmojiCompat.init((Config)object2);
            }
            sHasDoneDefaultConfigLookup = true;
            return sInstance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmojiCompat init(Config config) {
        EmojiCompat emojiCompat;
        EmojiCompat emojiCompat2 = emojiCompat = sInstance;
        if (emojiCompat != null) return emojiCompat2;
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            emojiCompat2 = emojiCompat = sInstance;
            if (emojiCompat != null) return emojiCompat2;
            sInstance = emojiCompat2 = new EmojiCompat(config);
            return emojiCompat2;
        }
    }

    public static boolean isConfigured() {
        boolean bl = sInstance != null;
        return bl;
    }

    private boolean isInitialized() {
        int n = this.getLoadState();
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    private void loadMetadata() {
        this.mInitLock.writeLock().lock();
        try {
            if (this.mMetadataLoadStrategy == 0) {
                this.mLoadState = 0;
            }
            if (this.getLoadState() == 0) {
                this.mHelper.loadMetadata();
            }
            return;
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmojiCompat reset(Config config) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            EmojiCompat emojiCompat;
            sInstance = emojiCompat = new EmojiCompat(config);
            return emojiCompat;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmojiCompat reset(EmojiCompat emojiCompat) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            sInstance = emojiCompat;
            return sInstance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void skipDefaultConfigurationLookup(boolean bl) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            sHasDoneDefaultConfigLookup = bl;
            return;
        }
    }

    public String getAssetSignature() {
        Preconditions.checkState(this.isInitialized(), "Not initialized yet");
        return this.mHelper.getAssetSignature();
    }

    public int getEmojiSpanIndicatorColor() {
        return this.mEmojiSpanIndicatorColor;
    }

    public int getLoadState() {
        this.mInitLock.readLock().lock();
        try {
            int n = this.mLoadState;
            return n;
        }
        finally {
            this.mInitLock.readLock().unlock();
        }
    }

    public boolean hasEmojiGlyph(CharSequence charSequence) {
        Preconditions.checkState(this.isInitialized(), "Not initialized yet");
        Preconditions.checkNotNull(charSequence, "sequence cannot be null");
        return this.mHelper.hasEmojiGlyph(charSequence);
    }

    public boolean hasEmojiGlyph(CharSequence charSequence, int n) {
        Preconditions.checkState(this.isInitialized(), "Not initialized yet");
        Preconditions.checkNotNull(charSequence, "sequence cannot be null");
        return this.mHelper.hasEmojiGlyph(charSequence, n);
    }

    public boolean isEmojiSpanIndicatorEnabled() {
        return this.mEmojiSpanIndicatorEnabled;
    }

    public void load() {
        block6: {
            int n = this.mMetadataLoadStrategy;
            boolean bl = true;
            if (n != 1) {
                bl = false;
            }
            Preconditions.checkState(bl, "Set metadataLoadStrategy to LOAD_STRATEGY_MANUAL to execute manual loading");
            if (this.isInitialized()) {
                return;
            }
            this.mInitLock.writeLock().lock();
            n = this.mLoadState;
            if (n != 0) break block6;
            this.mInitLock.writeLock().unlock();
            return;
        }
        try {
            this.mLoadState = 0;
            this.mHelper.loadMetadata();
            return;
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    void onMetadataLoadFailed(Throwable throwable) {
        ArrayList<InitCallback> arrayList = new ArrayList<InitCallback>();
        this.mInitLock.writeLock().lock();
        this.mLoadState = 2;
        arrayList.addAll(this.mInitCallbacks);
        this.mInitCallbacks.clear();
        this.mMainHandler.post((Runnable)new ListenerDispatcher(arrayList, this.mLoadState, throwable));
        return;
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    void onMetadataLoadSuccess() {
        ArrayList<InitCallback> arrayList = new ArrayList<InitCallback>();
        this.mInitLock.writeLock().lock();
        this.mLoadState = 1;
        arrayList.addAll(this.mInitCallbacks);
        this.mInitCallbacks.clear();
        this.mMainHandler.post((Runnable)new ListenerDispatcher(arrayList, this.mLoadState));
        return;
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    public CharSequence process(CharSequence charSequence) {
        int n = charSequence == null ? 0 : charSequence.length();
        return this.process(charSequence, 0, n);
    }

    public CharSequence process(CharSequence charSequence, int n, int n2) {
        return this.process(charSequence, n, n2, Integer.MAX_VALUE);
    }

    public CharSequence process(CharSequence charSequence, int n, int n2, int n3) {
        return this.process(charSequence, n, n2, n3, 0);
    }

    public CharSequence process(CharSequence charSequence, int n, int n2, int n3, int n4) {
        Preconditions.checkState(this.isInitialized(), "Not initialized yet");
        Preconditions.checkArgumentNonnegative(n, "start cannot be negative");
        Preconditions.checkArgumentNonnegative(n2, "end cannot be negative");
        Preconditions.checkArgumentNonnegative(n3, "maxEmojiCount cannot be negative");
        boolean bl = n <= n2;
        Preconditions.checkArgument(bl, "start should be <= than end");
        if (charSequence == null) {
            return null;
        }
        bl = n <= charSequence.length();
        Preconditions.checkArgument(bl, "start should be < than charSequence length");
        bl = n2 <= charSequence.length();
        Preconditions.checkArgument(bl, "end should be < than charSequence length");
        CharSequence charSequence2 = charSequence;
        if (charSequence.length() != 0) {
            if (n == n2) {
                charSequence2 = charSequence;
            } else {
                bl = n4 != 1 ? (n4 != 2 ? this.mReplaceAll : false) : true;
                charSequence2 = this.mHelper.process(charSequence, n, n2, n3, bl);
            }
        }
        return charSequence2;
    }

    public void registerInitCallback(InitCallback initCallback) {
        Preconditions.checkNotNull(initCallback, "initCallback cannot be null");
        this.mInitLock.writeLock().lock();
        try {
            if (this.mLoadState != 1 && this.mLoadState != 2) {
                this.mInitCallbacks.add(initCallback);
            } else {
                Handler handler = this.mMainHandler;
                ListenerDispatcher listenerDispatcher = new ListenerDispatcher(initCallback, this.mLoadState);
                handler.post((Runnable)listenerDispatcher);
            }
            return;
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    public void unregisterInitCallback(InitCallback initCallback) {
        Preconditions.checkNotNull(initCallback, "initCallback cannot be null");
        this.mInitLock.writeLock().lock();
        try {
            this.mInitCallbacks.remove(initCallback);
            return;
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    public void updateEditorInfo(EditorInfo editorInfo) {
        if (this.isInitialized() && editorInfo != null) {
            if (editorInfo.extras == null) {
                editorInfo.extras = new Bundle();
            }
            this.mHelper.updateEditorInfoAttrs(editorInfo);
        }
    }

    private static class CompatInternal {
        final EmojiCompat mEmojiCompat;

        CompatInternal(EmojiCompat emojiCompat) {
            this.mEmojiCompat = emojiCompat;
        }

        String getAssetSignature() {
            return "";
        }

        boolean hasEmojiGlyph(CharSequence charSequence) {
            return false;
        }

        boolean hasEmojiGlyph(CharSequence charSequence, int n) {
            return false;
        }

        void loadMetadata() {
            this.mEmojiCompat.onMetadataLoadSuccess();
        }

        CharSequence process(CharSequence charSequence, int n, int n2, int n3, boolean bl) {
            return charSequence;
        }

        void updateEditorInfoAttrs(EditorInfo editorInfo) {
        }
    }

    private static final class CompatInternal19
    extends CompatInternal {
        private volatile MetadataRepo mMetadataRepo;
        private volatile EmojiProcessor mProcessor;

        CompatInternal19(EmojiCompat emojiCompat) {
            super(emojiCompat);
        }

        @Override
        String getAssetSignature() {
            String string2;
            String string3 = string2 = this.mMetadataRepo.getMetadataList().sourceSha();
            if (string2 == null) {
                string3 = "";
            }
            return string3;
        }

        @Override
        boolean hasEmojiGlyph(CharSequence charSequence) {
            boolean bl = this.mProcessor.getEmojiMetadata(charSequence) != null;
            return bl;
        }

        @Override
        boolean hasEmojiGlyph(CharSequence object, int n) {
            boolean bl = (object = this.mProcessor.getEmojiMetadata((CharSequence)object)) != null && ((EmojiMetadata)object).getCompatAdded() <= n;
            return bl;
        }

        @Override
        void loadMetadata() {
            try {
                MetadataRepoLoaderCallback metadataRepoLoaderCallback = new MetadataRepoLoaderCallback(){

                    @Override
                    public void onFailed(Throwable throwable) {
                        CompatInternal19.this.mEmojiCompat.onMetadataLoadFailed(throwable);
                    }

                    @Override
                    public void onLoaded(MetadataRepo metadataRepo) {
                        CompatInternal19.this.onMetadataLoadSuccess(metadataRepo);
                    }
                };
                this.mEmojiCompat.mMetadataLoader.load(metadataRepoLoaderCallback);
            }
            catch (Throwable throwable) {
                this.mEmojiCompat.onMetadataLoadFailed(throwable);
            }
        }

        void onMetadataLoadSuccess(MetadataRepo metadataRepo) {
            if (metadataRepo == null) {
                this.mEmojiCompat.onMetadataLoadFailed(new IllegalArgumentException("metadataRepo cannot be null"));
                return;
            }
            this.mMetadataRepo = metadataRepo;
            this.mProcessor = new EmojiProcessor(this.mMetadataRepo, new SpanFactory(), this.mEmojiCompat.mGlyphChecker, this.mEmojiCompat.mUseEmojiAsDefaultStyle, this.mEmojiCompat.mEmojiAsDefaultStyleExceptions);
            this.mEmojiCompat.onMetadataLoadSuccess();
        }

        @Override
        CharSequence process(CharSequence charSequence, int n, int n2, int n3, boolean bl) {
            return this.mProcessor.process(charSequence, n, n2, n3, bl);
        }

        @Override
        void updateEditorInfoAttrs(EditorInfo editorInfo) {
            editorInfo.extras.putInt(EmojiCompat.EDITOR_INFO_METAVERSION_KEY, this.mMetadataRepo.getMetadataVersion());
            editorInfo.extras.putBoolean(EmojiCompat.EDITOR_INFO_REPLACE_ALL_KEY, this.mEmojiCompat.mReplaceAll);
        }
    }

    public static abstract class Config {
        int[] mEmojiAsDefaultStyleExceptions;
        int mEmojiSpanIndicatorColor = -16711936;
        boolean mEmojiSpanIndicatorEnabled;
        GlyphChecker mGlyphChecker = new EmojiProcessor.DefaultGlyphChecker();
        Set<InitCallback> mInitCallbacks;
        int mMetadataLoadStrategy = 0;
        final MetadataRepoLoader mMetadataLoader;
        boolean mReplaceAll;
        boolean mUseEmojiAsDefaultStyle;

        protected Config(MetadataRepoLoader metadataRepoLoader) {
            Preconditions.checkNotNull(metadataRepoLoader, "metadataLoader cannot be null.");
            this.mMetadataLoader = metadataRepoLoader;
        }

        protected final MetadataRepoLoader getMetadataRepoLoader() {
            return this.mMetadataLoader;
        }

        public Config registerInitCallback(InitCallback initCallback) {
            Preconditions.checkNotNull(initCallback, "initCallback cannot be null");
            if (this.mInitCallbacks == null) {
                this.mInitCallbacks = new ArraySet<InitCallback>();
            }
            this.mInitCallbacks.add(initCallback);
            return this;
        }

        public Config setEmojiSpanIndicatorColor(int n) {
            this.mEmojiSpanIndicatorColor = n;
            return this;
        }

        public Config setEmojiSpanIndicatorEnabled(boolean bl) {
            this.mEmojiSpanIndicatorEnabled = bl;
            return this;
        }

        public Config setGlyphChecker(GlyphChecker glyphChecker) {
            Preconditions.checkNotNull(glyphChecker, "GlyphChecker cannot be null");
            this.mGlyphChecker = glyphChecker;
            return this;
        }

        public Config setMetadataLoadStrategy(int n) {
            this.mMetadataLoadStrategy = n;
            return this;
        }

        public Config setReplaceAll(boolean bl) {
            this.mReplaceAll = bl;
            return this;
        }

        public Config setUseEmojiAsDefaultStyle(boolean bl) {
            return this.setUseEmojiAsDefaultStyle(bl, null);
        }

        public Config setUseEmojiAsDefaultStyle(boolean bl, List<Integer> object) {
            this.mUseEmojiAsDefaultStyle = bl;
            if (bl && object != null) {
                this.mEmojiAsDefaultStyleExceptions = new int[object.size()];
                int n = 0;
                object = object.iterator();
                while (object.hasNext()) {
                    Integer n2 = (Integer)object.next();
                    this.mEmojiAsDefaultStyleExceptions[n] = n2;
                    ++n;
                }
                Arrays.sort(this.mEmojiAsDefaultStyleExceptions);
            } else {
                this.mEmojiAsDefaultStyleExceptions = null;
            }
            return this;
        }

        public Config unregisterInitCallback(InitCallback initCallback) {
            Preconditions.checkNotNull(initCallback, "initCallback cannot be null");
            Set<InitCallback> set = this.mInitCallbacks;
            if (set != null) {
                set.remove(initCallback);
            }
            return this;
        }
    }

    public static interface GlyphChecker {
        public boolean hasGlyph(CharSequence var1, int var2, int var3, int var4);
    }

    public static abstract class InitCallback {
        public void onFailed(Throwable throwable) {
        }

        public void onInitialized() {
        }
    }

    private static class ListenerDispatcher
    implements Runnable {
        private final List<InitCallback> mInitCallbacks;
        private final int mLoadState;
        private final Throwable mThrowable;

        ListenerDispatcher(InitCallback initCallback, int n) {
            this(Arrays.asList(Preconditions.checkNotNull(initCallback, "initCallback cannot be null")), n, null);
        }

        ListenerDispatcher(Collection<InitCallback> collection, int n) {
            this(collection, n, null);
        }

        ListenerDispatcher(Collection<InitCallback> collection, int n, Throwable throwable) {
            Preconditions.checkNotNull(collection, "initCallbacks cannot be null");
            this.mInitCallbacks = new ArrayList<InitCallback>(collection);
            this.mLoadState = n;
            this.mThrowable = throwable;
        }

        @Override
        public void run() {
            int n;
            int n2 = this.mInitCallbacks.size();
            int n3 = this.mLoadState;
            int n4 = 0;
            if (n3 != 1) {
                for (n = n4; n < n2; ++n) {
                    this.mInitCallbacks.get(n).onFailed(this.mThrowable);
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    this.mInitCallbacks.get(n).onInitialized();
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoadStrategy {
    }

    public static interface MetadataRepoLoader {
        public void load(MetadataRepoLoaderCallback var1);
    }

    public static abstract class MetadataRepoLoaderCallback {
        public abstract void onFailed(Throwable var1);

        public abstract void onLoaded(MetadataRepo var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReplaceStrategy {
    }

    static class SpanFactory {
        SpanFactory() {
        }

        EmojiSpan createSpan(EmojiMetadata emojiMetadata) {
            return new TypefaceEmojiSpan(emojiMetadata);
        }
    }
}

