/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.Context;
import android.os.Build;
import androidx.core.os.TraceCompat;
import androidx.emoji2.text.ConcurrencyHelpers;
import androidx.emoji2.text.DefaultEmojiCompatConfig;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.EmojiCompatInitializer$BackgroundDefaultLoader$$ExternalSyntheticLambda0;
import androidx.emoji2.text.FontRequestEmojiCompatConfig;
import androidx.emoji2.text.MetadataRepo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.DefaultLifecycleObserver$_CC;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleInitializer;
import androidx.startup.AppInitializer;
import androidx.startup.Initializer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class EmojiCompatInitializer
implements Initializer<Boolean> {
    private static final long STARTUP_THREAD_CREATION_DELAY_MS = 500L;
    private static final String S_INITIALIZER_THREAD_NAME = "EmojiCompatInitializer";

    @Override
    public Boolean create(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            EmojiCompat.init(new BackgroundDefaultConfig(context));
            this.delayUntilFirstResume(context);
            return true;
        }
        return false;
    }

    void delayUntilFirstResume(Context object) {
        object = ((LifecycleOwner)AppInitializer.getInstance((Context)object).initializeComponent(ProcessLifecycleInitializer.class)).getLifecycle();
        ((Lifecycle)object).addObserver(new DefaultLifecycleObserver((Lifecycle)object){
            final /* synthetic */ Lifecycle val$lifecycle;
            {
                this.val$lifecycle = lifecycle;
            }

            @Override
            public /* synthetic */ void onCreate(LifecycleOwner lifecycleOwner) {
                DefaultLifecycleObserver$_CC.$default$onCreate(this, lifecycleOwner);
            }

            @Override
            public /* synthetic */ void onDestroy(LifecycleOwner lifecycleOwner) {
                DefaultLifecycleObserver$_CC.$default$onDestroy(this, lifecycleOwner);
            }

            @Override
            public /* synthetic */ void onPause(LifecycleOwner lifecycleOwner) {
                DefaultLifecycleObserver$_CC.$default$onPause(this, lifecycleOwner);
            }

            @Override
            public void onResume(LifecycleOwner lifecycleOwner) {
                EmojiCompatInitializer.this.loadEmojiCompatAfterDelay();
                this.val$lifecycle.removeObserver(this);
            }

            @Override
            public /* synthetic */ void onStart(LifecycleOwner lifecycleOwner) {
                DefaultLifecycleObserver$_CC.$default$onStart(this, lifecycleOwner);
            }

            @Override
            public /* synthetic */ void onStop(LifecycleOwner lifecycleOwner) {
                DefaultLifecycleObserver$_CC.$default$onStop(this, lifecycleOwner);
            }
        });
    }

    @Override
    public List<Class<? extends Initializer<?>>> dependencies() {
        return Collections.singletonList(ProcessLifecycleInitializer.class);
    }

    void loadEmojiCompatAfterDelay() {
        ConcurrencyHelpers.mainHandlerAsync().postDelayed((Runnable)new LoadEmojiCompatRunnable(), 500L);
    }

    static class BackgroundDefaultConfig
    extends EmojiCompat.Config {
        protected BackgroundDefaultConfig(Context context) {
            super(new BackgroundDefaultLoader(context));
            this.setMetadataLoadStrategy(1);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BackgroundDefaultLoader
    implements EmojiCompat.MetadataRepoLoader {
        private final Context mContext;

        BackgroundDefaultLoader(Context context) {
            this.mContext = context.getApplicationContext();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doLoad(final EmojiCompat.MetadataRepoLoaderCallback metadataRepoLoaderCallback, final ThreadPoolExecutor threadPoolExecutor) {
            try {
                EmojiCompat.MetadataRepoLoaderCallback metadataRepoLoaderCallback2 = DefaultEmojiCompatConfig.create(this.mContext);
                if (metadataRepoLoaderCallback2 != null) {
                    ((FontRequestEmojiCompatConfig)((Object)metadataRepoLoaderCallback2)).setLoadingExecutor(threadPoolExecutor);
                    EmojiCompat.MetadataRepoLoader metadataRepoLoader = ((EmojiCompat.Config)((Object)metadataRepoLoaderCallback2)).getMetadataRepoLoader();
                    metadataRepoLoaderCallback2 = new EmojiCompat.MetadataRepoLoaderCallback(){

                        @Override
                        public void onFailed(Throwable throwable) {
                            try {
                                metadataRepoLoaderCallback.onFailed(throwable);
                                return;
                            }
                            finally {
                                threadPoolExecutor.shutdown();
                            }
                        }

                        @Override
                        public void onLoaded(MetadataRepo metadataRepo) {
                            try {
                                metadataRepoLoaderCallback.onLoaded(metadataRepo);
                                return;
                            }
                            finally {
                                threadPoolExecutor.shutdown();
                            }
                        }
                    };
                    metadataRepoLoader.load(metadataRepoLoaderCallback2);
                    return;
                }
                metadataRepoLoaderCallback2 = new RuntimeException("EmojiCompat font provider not available on this device.");
                throw metadataRepoLoaderCallback2;
            }
            catch (Throwable throwable) {
                metadataRepoLoaderCallback.onFailed(throwable);
                threadPoolExecutor.shutdown();
            }
        }

        public /* synthetic */ void lambda$load$0$androidx-emoji2-text-EmojiCompatInitializer$BackgroundDefaultLoader(EmojiCompat.MetadataRepoLoaderCallback metadataRepoLoaderCallback, ThreadPoolExecutor threadPoolExecutor) {
            this.doLoad(metadataRepoLoaderCallback, threadPoolExecutor);
        }

        @Override
        public void load(EmojiCompat.MetadataRepoLoaderCallback metadataRepoLoaderCallback) {
            ThreadPoolExecutor threadPoolExecutor = ConcurrencyHelpers.createBackgroundPriorityExecutor(EmojiCompatInitializer.S_INITIALIZER_THREAD_NAME);
            threadPoolExecutor.execute(new EmojiCompatInitializer$BackgroundDefaultLoader$$ExternalSyntheticLambda0(this, metadataRepoLoaderCallback, threadPoolExecutor));
        }
    }

    static class LoadEmojiCompatRunnable
    implements Runnable {
        LoadEmojiCompatRunnable() {
        }

        @Override
        public void run() {
            try {
                TraceCompat.beginSection("EmojiCompat.EmojiCompatInitializer.run");
                if (EmojiCompat.isConfigured()) {
                    EmojiCompat.get().load();
                }
                return;
            }
            finally {
                TraceCompat.endSection();
            }
        }
    }
}

