/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.graphics.Paint;
import android.os.Build;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyEvent;
import android.view.inputmethod.InputConnection;
import androidx.core.graphics.PaintCompat;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.EmojiMetadata;
import androidx.emoji2.text.EmojiSpan;
import androidx.emoji2.text.MetadataRepo;
import androidx.emoji2.text.SpannableBuilder;
import java.util.Arrays;

final class EmojiProcessor {
    private static final int ACTION_ADVANCE_BOTH = 1;
    private static final int ACTION_ADVANCE_END = 2;
    private static final int ACTION_FLUSH = 3;
    private final int[] mEmojiAsDefaultStyleExceptions;
    private EmojiCompat.GlyphChecker mGlyphChecker;
    private final MetadataRepo mMetadataRepo;
    private final EmojiCompat.SpanFactory mSpanFactory;
    private final boolean mUseEmojiAsDefaultStyle;

    EmojiProcessor(MetadataRepo metadataRepo, EmojiCompat.SpanFactory spanFactory, EmojiCompat.GlyphChecker glyphChecker, boolean bl, int[] nArray) {
        this.mSpanFactory = spanFactory;
        this.mMetadataRepo = metadataRepo;
        this.mGlyphChecker = glyphChecker;
        this.mUseEmojiAsDefaultStyle = bl;
        this.mEmojiAsDefaultStyleExceptions = nArray;
    }

    private void addEmoji(Spannable spannable, EmojiMetadata emojiMetadata, int n, int n2) {
        spannable.setSpan((Object)this.mSpanFactory.createSpan(emojiMetadata), n, n2, 33);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean delete(Editable editable, KeyEvent object2, boolean bl) {
        int n;
        if (EmojiProcessor.hasModifiers((KeyEvent)object2)) {
            return false;
        }
        int n2 = Selection.getSelectionStart((CharSequence)editable);
        if (EmojiProcessor.hasInvalidSelection(n2, n = Selection.getSelectionEnd((CharSequence)editable))) {
            return false;
        }
        EmojiSpan[] emojiSpanArray = (EmojiSpan[])editable.getSpans(n2, n, EmojiSpan.class);
        if (emojiSpanArray != null && emojiSpanArray.length > 0) {
            for (EmojiSpan emojiSpan : emojiSpanArray) {
                void var2_4;
                int n3 = editable.getSpanStart((Object)emojiSpan);
                int n4 = editable.getSpanEnd((Object)emojiSpan);
                if (!(var2_4 != false && n3 == n2 || var2_4 == false && n4 == n2) && (n2 <= n3 || n2 >= n4)) continue;
                editable.delete(n3, n4);
                return true;
            }
        }
        return false;
    }

    static boolean handleDeleteSurroundingText(InputConnection inputConnection, Editable editable, int n, int n2, boolean bl) {
        block5: {
            EmojiSpan[] emojiSpanArray;
            int n3;
            int n4;
            block8: {
                block6: {
                    block7: {
                        if (editable == null || inputConnection == null || n < 0 || n2 < 0) break block5;
                        n4 = Selection.getSelectionStart((CharSequence)editable);
                        if (EmojiProcessor.hasInvalidSelection(n4, n3 = Selection.getSelectionEnd((CharSequence)editable))) {
                            return false;
                        }
                        if (!bl) break block6;
                        n = CodepointIndexFinder.findIndexBackward((CharSequence)editable, n4, Math.max(n, 0));
                        n3 = CodepointIndexFinder.findIndexForward((CharSequence)editable, n3, Math.max(n2, 0));
                        if (n == -1) break block7;
                        n2 = n3;
                        if (n3 != -1) break block8;
                    }
                    return false;
                }
                n = Math.max(n4 - n, 0);
                n2 = Math.min(n3 + n2, editable.length());
            }
            if ((emojiSpanArray = (EmojiSpan[])editable.getSpans(n, n2, EmojiSpan.class)) != null && emojiSpanArray.length > 0) {
                int n5 = emojiSpanArray.length;
                n4 = 0;
                n3 = n;
                for (n = n4; n < n5; ++n) {
                    EmojiSpan emojiSpan = emojiSpanArray[n];
                    int n6 = editable.getSpanStart((Object)emojiSpan);
                    n4 = editable.getSpanEnd((Object)emojiSpan);
                    n3 = Math.min(n6, n3);
                    n2 = Math.max(n4, n2);
                }
                n = Math.max(n3, 0);
                n2 = Math.min(n2, editable.length());
                inputConnection.beginBatchEdit();
                editable.delete(n, n2);
                inputConnection.endBatchEdit();
                return true;
            }
        }
        return false;
    }

    static boolean handleOnKeyDown(Editable editable, int n, KeyEvent keyEvent) {
        boolean bl = n != 67 ? (n != 112 ? false : EmojiProcessor.delete(editable, keyEvent, true)) : EmojiProcessor.delete(editable, keyEvent, false);
        if (bl) {
            MetaKeyKeyListener.adjustMetaAfterKeypress((Spannable)editable);
            return true;
        }
        return false;
    }

    private boolean hasGlyph(CharSequence charSequence, int n, int n2, EmojiMetadata emojiMetadata) {
        if (emojiMetadata.getHasGlyph() == 0) {
            emojiMetadata.setHasGlyph(this.mGlyphChecker.hasGlyph(charSequence, n, n2, emojiMetadata.getSdkAdded()));
        }
        boolean bl = emojiMetadata.getHasGlyph() == 2;
        return bl;
    }

    private static boolean hasInvalidSelection(int n, int n2) {
        boolean bl = n == -1 || n2 == -1 || n != n2;
        return bl;
    }

    private static boolean hasModifiers(KeyEvent keyEvent) {
        return KeyEvent.metaStateHasNoModifiers((int)keyEvent.getMetaState()) ^ true;
    }

    EmojiMetadata getEmojiMetadata(CharSequence charSequence) {
        int n;
        ProcessorSm processorSm = new ProcessorSm(this.mMetadataRepo.getRootNode(), this.mUseEmojiAsDefaultStyle, this.mEmojiAsDefaultStyleExceptions);
        int n2 = charSequence.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            if (processorSm.check(n) == 2) continue;
            return null;
        }
        if (processorSm.isInFlushableState()) {
            return processorSm.getCurrentMetadata();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    CharSequence process(CharSequence var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block31: {
            block36: {
                block37: {
                    block30: {
                        block29: {
                            var6_6 = var1_1 instanceof SpannableBuilder;
                            if (var6_6) {
                                ((SpannableBuilder)var1_1).beginBatchEdit();
                            }
                            var7_7 = null;
                            if (var6_6) ** GOTO lbl16
                            if (var1_1 instanceof Spannable) ** GOTO lbl16
                            var8_8 /* !! */  = var7_7;
                            if (!(var1_1 instanceof Spanned)) break block29;
                            var8_8 /* !! */  = var7_7;
                            if (((Spanned)var1_1).nextSpanTransition(var2_2 - 1, var3_3 + 1, EmojiSpan.class) <= var3_3) {
                                var8_8 /* !! */  = new SpannableString(var1_1);
                            }
                            break block29;
lbl16:
                            // 2 sources

                            var8_8 /* !! */  = (Spannable)var1_1;
                        }
                        var9_10 = var2_2;
                        var10_11 = var3_3;
                        if (var8_8 /* !! */  == null) break block30;
                        var11_12 = (EmojiSpan[])var8_8 /* !! */ .getSpans(var2_2, var3_3, EmojiSpan.class);
                        var9_10 = var2_2;
                        var10_11 = var3_3;
                        if (var11_12 == null) break block30;
                        var9_10 = var2_2;
                        var10_11 = var3_3;
                        if (((EmojiSpan[])var11_12).length <= 0) break block30;
                        var12_13 = ((EmojiSpan[])var11_12).length;
                        var13_14 = 0;
                        while (true) {
                            var9_10 = var2_2;
                            var10_11 = var3_3;
                            if (var13_14 >= var12_13) break;
                            var7_7 = var11_12[var13_14];
                            var10_11 = var8_8 /* !! */ .getSpanStart((Object)var7_7);
                            var9_10 = var8_8 /* !! */ .getSpanEnd((Object)var7_7);
                            if (var10_11 == var3_3) ** GOTO lbl43
                            var8_8 /* !! */ .removeSpan((Object)var7_7);
lbl43:
                            // 2 sources

                            var2_2 = Math.min(var10_11, var2_2);
                            var3_3 = Math.max(var9_10, var3_3);
                            ++var13_14;
                            continue;
                            break;
                        }
                    }
                    if (var9_10 == var10_11) break block31;
                    if (var9_10 >= var1_1.length()) break block31;
                    var13_14 = var4_4;
                    if (var4_4 == 0x7FFFFFFF) ** GOTO lbl57
                    var13_14 = var4_4;
                    if (var8_8 /* !! */  == null) ** GOTO lbl57
                    var13_14 = var4_4 - ((EmojiSpan[])var8_8 /* !! */ .getSpans(0, var8_8 /* !! */ .length(), EmojiSpan.class)).length;
lbl57:
                    // 3 sources

                    var11_12 = new ProcessorSm(this.mMetadataRepo.getRootNode(), this.mUseEmojiAsDefaultStyle, this.mEmojiAsDefaultStyleExceptions);
                    var14_15 = Character.codePointAt(var1_1, var9_10);
                    var4_4 = 0;
                    block21: while (true) {
                        var12_13 = var9_10;
                        var3_3 = var9_10;
                        var2_2 = var14_15;
                        while (var3_3 < var10_11 && var4_4 < var13_14) {
                            block35: {
                                block32: {
                                    block33: {
                                        block34: {
                                            var9_10 = var11_12.check(var2_2);
                                            if (var9_10 == 1) break block32;
                                            if (var9_10 == 2) break block33;
                                            if (var9_10 != 3) continue;
                                            if (var5_5) break block34;
                                            var14_15 = var2_2;
                                            var9_10 = var3_3;
                                            if (this.hasGlyph(var1_1, var12_13, var3_3, var11_12.getFlushMetadata())) continue block21;
                                        }
                                        var7_7 = var8_8 /* !! */ ;
                                        if (var8_8 /* !! */  != null) ** GOTO lbl80
                                        var7_7 = new SpannableString(var1_1);
lbl80:
                                        // 2 sources

                                        this.addEmoji((Spannable)var7_7, var11_12.getFlushMetadata(), var12_13, var3_3);
                                        ++var4_4;
                                        var8_8 /* !! */  = var7_7;
                                        var14_15 = var2_2;
                                        var9_10 = var3_3;
                                        continue block21;
                                    }
                                    var3_3 = var9_10 = var3_3 + Character.charCount(var2_2);
                                    if (var9_10 >= var10_11) continue;
                                    var2_2 = Character.codePointAt(var1_1, var9_10);
                                    var3_3 = var9_10;
                                    continue;
                                }
                                var12_13 += Character.charCount(Character.codePointAt(var1_1, var12_13));
                                if (var12_13 >= var10_11) break block35;
                                var2_2 = Character.codePointAt(var1_1, var12_13);
                            }
                            var3_3 = var12_13;
                        }
                        break;
                    }
                    var7_7 = var8_8 /* !! */ ;
                    try {
                        if (!var11_12.isInFlushableState()) break block36;
                        var7_7 = var8_8 /* !! */ ;
                        if (var4_4 >= var13_14) break block36;
                        if (var5_5) break block37;
                        var7_7 = var8_8 /* !! */ ;
                    }
                    catch (Throwable var8_9) {
                        if (var6_6) {
                            ((SpannableBuilder)var1_1).endBatchEdit();
                        }
                        throw var8_9;
                    }
                    if (this.hasGlyph(var1_1, var12_13, var3_3, var11_12.getCurrentMetadata())) break block36;
                }
                var7_7 = var8_8 /* !! */ ;
                if (var8_8 /* !! */  != null) ** GOTO lbl121
                var7_7 = new SpannableString(var1_1);
lbl121:
                // 2 sources

                this.addEmoji((Spannable)var7_7, var11_12.getCurrentMetadata(), var12_13, var3_3);
            }
            var8_8 /* !! */  = var7_7;
            if (var7_7 == null) {
                var8_8 /* !! */  = var1_1;
            }
            if (var6_6) {
                ((SpannableBuilder)var1_1).endBatchEdit();
            }
            return var8_8 /* !! */ ;
        }
        if (var6_6) {
            ((SpannableBuilder)var1_1).endBatchEdit();
        }
        return var1_1;
    }

    private static final class CodepointIndexFinder {
        private static final int INVALID_INDEX = -1;

        private CodepointIndexFinder() {
        }

        static int findIndexBackward(CharSequence charSequence, int n, int n2) {
            int n3 = charSequence.length();
            if (n >= 0 && n3 >= n) {
                if (n2 < 0) {
                    return -1;
                }
                block0: while (true) {
                    n3 = 0;
                    while (true) {
                        if (n2 == 0) {
                            return n;
                        }
                        if (--n < 0) {
                            if (n3 != 0) {
                                return -1;
                            }
                            return 0;
                        }
                        char c = charSequence.charAt(n);
                        if (n3 != 0) {
                            if (!Character.isHighSurrogate(c)) {
                                return -1;
                            }
                            --n2;
                            continue block0;
                        }
                        if (!Character.isSurrogate(c)) {
                            --n2;
                            continue;
                        }
                        if (Character.isHighSurrogate(c)) {
                            return -1;
                        }
                        n3 = 1;
                    }
                    break;
                }
            }
            return -1;
        }

        static int findIndexForward(CharSequence charSequence, int n, int n2) {
            int n3 = charSequence.length();
            if (n >= 0 && n3 >= n) {
                if (n2 < 0) {
                    return -1;
                }
                block0: while (true) {
                    boolean bl = false;
                    while (true) {
                        if (n2 == 0) {
                            return n;
                        }
                        if (n >= n3) {
                            if (bl) {
                                return -1;
                            }
                            return n3;
                        }
                        char c = charSequence.charAt(n);
                        if (bl) {
                            if (!Character.isLowSurrogate(c)) {
                                return -1;
                            }
                            --n2;
                            ++n;
                            continue block0;
                        }
                        if (!Character.isSurrogate(c)) {
                            --n2;
                            ++n;
                            continue;
                        }
                        if (Character.isLowSurrogate(c)) {
                            return -1;
                        }
                        ++n;
                        bl = true;
                    }
                    break;
                }
            }
            return -1;
        }
    }

    public static class DefaultGlyphChecker
    implements EmojiCompat.GlyphChecker {
        private static final int PAINT_TEXT_SIZE = 10;
        private static final ThreadLocal<StringBuilder> sStringBuilder = new ThreadLocal();
        private final TextPaint mTextPaint;

        DefaultGlyphChecker() {
            TextPaint textPaint;
            this.mTextPaint = textPaint = new TextPaint();
            textPaint.setTextSize(10.0f);
        }

        private static StringBuilder getStringBuilder() {
            ThreadLocal<StringBuilder> threadLocal = sStringBuilder;
            if (threadLocal.get() == null) {
                threadLocal.set(new StringBuilder());
            }
            return threadLocal.get();
        }

        @Override
        public boolean hasGlyph(CharSequence charSequence, int n, int n2, int n3) {
            if (Build.VERSION.SDK_INT < 23 && n3 > Build.VERSION.SDK_INT) {
                return false;
            }
            StringBuilder stringBuilder = DefaultGlyphChecker.getStringBuilder();
            stringBuilder.setLength(0);
            while (n < n2) {
                stringBuilder.append(charSequence.charAt(n));
                ++n;
            }
            return PaintCompat.hasGlyph((Paint)this.mTextPaint, stringBuilder.toString());
        }
    }

    static final class ProcessorSm {
        private static final int STATE_DEFAULT = 1;
        private static final int STATE_WALKING = 2;
        private int mCurrentDepth;
        private MetadataRepo.Node mCurrentNode;
        private final int[] mEmojiAsDefaultStyleExceptions;
        private MetadataRepo.Node mFlushNode;
        private int mLastCodepoint;
        private final MetadataRepo.Node mRootNode;
        private int mState = 1;
        private final boolean mUseEmojiAsDefaultStyle;

        ProcessorSm(MetadataRepo.Node node, boolean bl, int[] nArray) {
            this.mRootNode = node;
            this.mCurrentNode = node;
            this.mUseEmojiAsDefaultStyle = bl;
            this.mEmojiAsDefaultStyleExceptions = nArray;
        }

        private static boolean isEmojiStyle(int n) {
            boolean bl = n == 65039;
            return bl;
        }

        private static boolean isTextStyle(int n) {
            boolean bl = n == 65038;
            return bl;
        }

        private int reset() {
            this.mState = 1;
            this.mCurrentNode = this.mRootNode;
            this.mCurrentDepth = 0;
            return 1;
        }

        private boolean shouldUseEmojiPresentationStyleForSingleCodepoint() {
            if (this.mCurrentNode.getData().isDefaultEmoji()) {
                return true;
            }
            if (ProcessorSm.isEmojiStyle(this.mLastCodepoint)) {
                return true;
            }
            if (this.mUseEmojiAsDefaultStyle) {
                if (this.mEmojiAsDefaultStyleExceptions == null) {
                    return true;
                }
                int n = this.mCurrentNode.getData().getCodepointAt(0);
                if (Arrays.binarySearch(this.mEmojiAsDefaultStyleExceptions, n) < 0) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        int check(int n) {
            int n2;
            block4: {
                block11: {
                    block10: {
                        block7: {
                            block9: {
                                block8: {
                                    MetadataRepo.Node node;
                                    block5: {
                                        block6: {
                                            node = this.mCurrentNode.get(n);
                                            int n3 = this.mState;
                                            n2 = 3;
                                            if (n3 == 2) break block5;
                                            if (node != null) break block6;
                                            n2 = this.reset();
                                            break block4;
                                        }
                                        this.mState = 2;
                                        this.mCurrentNode = node;
                                        this.mCurrentDepth = 1;
                                        break block7;
                                    }
                                    if (node == null) break block8;
                                    this.mCurrentNode = node;
                                    ++this.mCurrentDepth;
                                    break block7;
                                }
                                if (!ProcessorSm.isTextStyle(n)) break block9;
                                n2 = this.reset();
                                break block4;
                            }
                            if (!ProcessorSm.isEmojiStyle(n)) break block10;
                        }
                        n2 = 2;
                        break block4;
                    }
                    if (this.mCurrentNode.getData() == null) break block11;
                    if (this.mCurrentDepth == 1) {
                        if (this.shouldUseEmojiPresentationStyleForSingleCodepoint()) {
                            this.mFlushNode = this.mCurrentNode;
                            this.reset();
                            break block4;
                        } else {
                            n2 = this.reset();
                        }
                        break block4;
                    } else {
                        this.mFlushNode = this.mCurrentNode;
                        this.reset();
                    }
                    break block4;
                }
                n2 = this.reset();
            }
            this.mLastCodepoint = n;
            return n2;
        }

        EmojiMetadata getCurrentMetadata() {
            return this.mCurrentNode.getData();
        }

        EmojiMetadata getFlushMetadata() {
            return this.mFlushNode.getData();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isInFlushableState() {
            int n = this.mState;
            boolean bl = true;
            if (n != 2) return false;
            if (this.mCurrentNode.getData() == null) return false;
            boolean bl2 = bl;
            if (this.mCurrentDepth > 1) return bl2;
            if (!this.shouldUseEmojiPresentationStyleForSingleCodepoint()) return false;
            return bl;
        }
    }
}

