/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text.flatbuffer;

import androidx.emoji2.text.flatbuffer.Utf8;
import java.nio.ByteBuffer;

public final class Utf8Safe
extends Utf8 {
    private static int computeEncodedLength(CharSequence charSequence) {
        int n;
        int n2;
        block3: {
            int n3;
            n2 = charSequence.length();
            for (n3 = 0; n3 < n2 && charSequence.charAt(n3) < '\u0080'; ++n3) {
            }
            int n4 = n2;
            while (true) {
                n = n4;
                if (n3 >= n2) break block3;
                n = charSequence.charAt(n3);
                if (n >= 2048) break;
                n4 += 127 - n >>> 31;
                ++n3;
            }
            n = n4 + Utf8Safe.encodedLengthGeneral(charSequence, n3);
        }
        if (n >= n2) {
            return n;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("UTF-8 length does not fit in int: ");
        ((StringBuilder)charSequence).append((long)n + 0x100000000L);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    public static String decodeUtf8Array(byte[] byArray, int n, int n2) {
        if ((n | n2 | byArray.length - n - n2) >= 0) {
            byte by;
            int n3 = n + n2;
            char[] cArray = new char[n2];
            n2 = 0;
            while (n < n3 && Utf8.DecodeUtil.isOneByte(by = byArray[n])) {
                ++n;
                Utf8.DecodeUtil.handleOneByte(by, cArray, n2);
                ++n2;
            }
            int n4 = n2;
            n2 = n;
            n = n4;
            while (n2 < n3) {
                n4 = n2 + 1;
                byte by2 = byArray[n2];
                if (Utf8.DecodeUtil.isOneByte(by2)) {
                    n2 = n + 1;
                    Utf8.DecodeUtil.handleOneByte(by2, cArray, n);
                    n = n2;
                    n2 = n4;
                    while (n2 < n3 && Utf8.DecodeUtil.isOneByte(by = byArray[n2])) {
                        ++n2;
                        Utf8.DecodeUtil.handleOneByte(by, cArray, n);
                        ++n;
                    }
                    continue;
                }
                if (Utf8.DecodeUtil.isTwoBytes(by2)) {
                    if (n4 < n3) {
                        Utf8.DecodeUtil.handleTwoBytes(by2, byArray[n4], cArray, n);
                        n2 = n4 + 1;
                        ++n;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                if (Utf8.DecodeUtil.isThreeBytes(by2)) {
                    if (n4 < n3 - 1) {
                        n2 = n4 + 1;
                        Utf8.DecodeUtil.handleThreeBytes(by2, byArray[n4], byArray[n2], cArray, n);
                        ++n2;
                        ++n;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                if (n4 < n3 - 2) {
                    n2 = n4 + 1;
                    by = byArray[n4];
                    n4 = n2 + 1;
                    Utf8.DecodeUtil.handleFourBytes(by2, by, byArray[n2], byArray[n4], cArray, n);
                    n2 = n4 + 1;
                    n = n + 1 + 1;
                    continue;
                }
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            return new String(cArray, 0, n);
        }
        throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n, n2));
    }

    public static String decodeUtf8Buffer(ByteBuffer byteBuffer, int n, int n2) {
        if ((n | n2 | byteBuffer.limit() - n - n2) >= 0) {
            byte by;
            int n3 = n + n2;
            char[] cArray = new char[n2];
            n2 = 0;
            while (n < n3 && Utf8.DecodeUtil.isOneByte(by = byteBuffer.get(n))) {
                ++n;
                Utf8.DecodeUtil.handleOneByte(by, cArray, n2);
                ++n2;
            }
            int n4 = n2;
            n2 = n;
            n = n4;
            while (n2 < n3) {
                n4 = n2 + 1;
                by = byteBuffer.get(n2);
                if (Utf8.DecodeUtil.isOneByte(by)) {
                    n2 = n + 1;
                    Utf8.DecodeUtil.handleOneByte(by, cArray, n);
                    n = n2;
                    n2 = n4;
                    while (n2 < n3 && Utf8.DecodeUtil.isOneByte(by = byteBuffer.get(n2))) {
                        ++n2;
                        Utf8.DecodeUtil.handleOneByte(by, cArray, n);
                        ++n;
                    }
                    continue;
                }
                if (Utf8.DecodeUtil.isTwoBytes(by)) {
                    if (n4 < n3) {
                        Utf8.DecodeUtil.handleTwoBytes(by, byteBuffer.get(n4), cArray, n);
                        n2 = n4 + 1;
                        ++n;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                if (Utf8.DecodeUtil.isThreeBytes(by)) {
                    if (n4 < n3 - 1) {
                        n2 = n4 + 1;
                        Utf8.DecodeUtil.handleThreeBytes(by, byteBuffer.get(n4), byteBuffer.get(n2), cArray, n);
                        ++n2;
                        ++n;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid UTF-8");
                }
                if (n4 < n3 - 2) {
                    n2 = n4 + 1;
                    byte by2 = byteBuffer.get(n4);
                    n4 = n2 + 1;
                    Utf8.DecodeUtil.handleFourBytes(by, by2, byteBuffer.get(n2), byteBuffer.get(n4), cArray, n);
                    n2 = n4 + 1;
                    n = n + 1 + 1;
                    continue;
                }
                throw new IllegalArgumentException("Invalid UTF-8");
            }
            return new String(cArray, 0, n);
        }
        throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n, n2));
    }

    private static int encodeUtf8Array(CharSequence charSequence, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = charSequence.length();
        int n6 = n2 + n;
        for (n2 = 0; n2 < n5 && (n4 = n2 + n) < n6 && (n3 = charSequence.charAt(n2)) < 128; ++n2) {
            byArray[n4] = (byte)n3;
        }
        if (n2 == n5) {
            return n + n5;
        }
        n4 = n + n2;
        for (n = n2; n < n5; ++n) {
            char c;
            block11: {
                block12: {
                    block13: {
                        block8: {
                            block10: {
                                block9: {
                                    block7: {
                                        c = charSequence.charAt(n);
                                        if (c >= '\u0080' || n4 >= n6) break block7;
                                        n2 = n4 + 1;
                                        byArray[n4] = (byte)c;
                                        break block8;
                                    }
                                    if (c >= '\u0800' || n4 > n6 - 2) break block9;
                                    n3 = n4 + 1;
                                    byArray[n4] = (byte)(c >>> 6 | 0x3C0);
                                    n2 = n3 + 1;
                                    byArray[n3] = (byte)(c & 0x3F | 0x80);
                                    break block8;
                                }
                                if (c >= '\ud800' && '\udfff' >= c || n4 > n6 - 3) break block10;
                                n2 = n4 + 1;
                                byArray[n4] = (byte)(c >>> 12 | 0x1E0);
                                n4 = n2 + 1;
                                byArray[n2] = (byte)(c >>> 6 & 0x3F | 0x80);
                                n2 = n4 + 1;
                                byArray[n4] = (byte)(c & 0x3F | 0x80);
                                break block8;
                            }
                            if (n4 > n6 - 4) break block11;
                            n2 = n + 1;
                            if (n2 == charSequence.length()) break block12;
                            char c2 = charSequence.charAt(n2);
                            if (!Character.isSurrogatePair(c, c2)) break block13;
                            n = Character.toCodePoint(c, c2);
                            n3 = n4 + 1;
                            byArray[n4] = (byte)(n >>> 18 | 0xF0);
                            n4 = n3 + 1;
                            byArray[n3] = (byte)(n >>> 12 & 0x3F | 0x80);
                            n3 = n4 + 1;
                            byArray[n4] = (byte)(n >>> 6 & 0x3F | 0x80);
                            n4 = n3 + 1;
                            byArray[n3] = (byte)(n & 0x3F | 0x80);
                            n = n2;
                            n2 = n4;
                        }
                        n4 = n2;
                        continue;
                    }
                    n = n2;
                }
                throw new UnpairedSurrogateException(n - 1, n5);
            }
            if (!('\ud800' > c || c > '\udfff' || (n2 = n + 1) != charSequence.length() && Character.isSurrogatePair(c, charSequence.charAt(n2)))) {
                throw new UnpairedSurrogateException(n, n5);
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Failed writing ");
            ((StringBuilder)charSequence).append(c);
            ((StringBuilder)charSequence).append(" at index ");
            ((StringBuilder)charSequence).append(n4);
            throw new ArrayIndexOutOfBoundsException(((StringBuilder)charSequence).toString());
        }
        return n4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void encodeUtf8Buffer(CharSequence var0, ByteBuffer var1_1) {
        block21: {
            block23: {
                block24: {
                    block25: {
                        var2_2 = var0.length();
                        var3_3 = var1_1.position();
                        for (var4_4 = 0; var4_4 < var2_2; ++var4_4) {
                            var5_5 = var3_3;
                            var6_6 = var4_4;
                            var7_7 = var0.charAt(var4_4);
                            if (var7_7 >= 128) break;
                            var5_5 = var3_3;
                            var6_6 = var4_4;
                            var1_1.put(var3_3 + var4_4, (byte)var7_7);
                            continue;
                        }
                        if (var4_4 != var2_2) ** GOTO lbl21
                        var5_5 = var3_3;
                        var6_6 = var4_4;
                        try {
                            var1_1.position(var3_3 + var4_4);
                            return;
lbl21:
                            // 1 sources

                            var3_3 += var4_4;
lbl22:
                            // 2 sources

                            while (var4_4 < var2_2) {
                                var5_5 = var3_3;
                                var6_6 = var4_4;
                                var8_8 = var0.charAt(var4_4);
                                if (var8_8 < '\u0080') {
                                    var5_5 = var3_3;
                                    var6_6 = var4_4;
                                    var1_1.put(var3_3, (byte)var8_8);
                                    break block21;
                                }
                                if (var8_8 >= '\u0800') break block22;
                                var5_5 = var3_3 + 1;
                            }
                        }
                        catch (IndexOutOfBoundsException var10_15) {
                            var4_4 = var6_6;
                            ** continue;
                        }
                        {
                            block22: {
                                var9_9 = (byte)(var8_8 >>> 6 | 192);
                                var6_6 = var5_5;
                                try {
                                    var1_1.put(var3_3, var9_9);
                                    var6_6 = var5_5;
                                    var1_1.put(var5_5, (byte)(var8_8 & 63 | 128));
                                    var3_3 = var5_5;
                                    break block21;
                                }
                                catch (IndexOutOfBoundsException var10_12) {
                                    var5_5 = var6_6;
                                }
lbl47:
                                // 3 sources

                                while (true) {
                                    var3_3 = var1_1.position();
                                    var6_6 = Math.max(var4_4, var5_5 - var1_1.position() + 1);
                                    var1_1 = new StringBuilder();
                                    var1_1.append("Failed writing ");
                                    var1_1.append(var0.charAt(var4_4));
                                    var1_1.append(" at index ");
                                    var1_1.append(var3_3 + var6_6);
                                    throw new ArrayIndexOutOfBoundsException(var1_1.toString());
                                }
                            }
                            if (var8_8 < '\ud800' || '\udfff' < var8_8) break block23;
                            var6_6 = var4_4 + 1;
                            if (var6_6 == var2_2) break block24;
                            var4_4 = var3_3;
                            try {}
                            catch (IndexOutOfBoundsException var10_16) {}
                            break block25;
lbl68:
                            // 2 sources

                            while (true) {
                                var5_5 = var4_4;
                                var4_4 = var6_6;
                                ** GOTO lbl47
                                break;
                            }
                            break;
                        }
                    }
                    var11_10 = var0.charAt(var6_6);
                    var4_4 = var3_3;
                    if (Character.isSurrogatePair(var8_8, var11_10)) {
                        var4_4 = var3_3;
                        var12_11 = Character.toCodePoint(var8_8, var11_10);
                        var7_7 = var3_3 + 1;
                        var9_9 = (byte)(var12_11 >>> 18 | 240);
                        var4_4 = var7_7;
                        try {
                            var1_1.put(var3_3, var9_9);
                            var5_5 = var7_7 + 1;
                        }
                        catch (IndexOutOfBoundsException var10_13) {
                            ** continue;
                        }
                        var9_9 = (byte)(var12_11 >>> 12 & 63 | 128);
                        var4_4 = var5_5;
                        {
                            var1_1.put(var7_7, var9_9);
                            var3_3 = var5_5 + 1;
                        }
                        var9_9 = (byte)(var12_11 >>> 6 & 63 | 128);
                        var4_4 = var3_3;
                        {
                            var1_1.put(var5_5, var9_9);
                            var4_4 = var3_3;
                            var1_1.put(var3_3, (byte)(var12_11 & 63 | 128));
                            var4_4 = var6_6;
                            break block21;
                        }
                    }
                    var4_4 = var6_6;
                }
                var5_5 = var3_3;
                var6_6 = var4_4;
                {
                    var5_5 = var3_3;
                    var6_6 = var4_4;
                    var10_14 = new UnpairedSurrogateException(var4_4, var2_2);
                    var5_5 = var3_3;
                    var6_6 = var4_4;
                    throw var10_14;
                }
            }
            var7_7 = var3_3 + 1;
            var9_9 = (byte)(var8_8 >>> 12 | 224);
            var6_6 = var7_7;
            {
                var1_1.put(var3_3, var9_9);
                var3_3 = var7_7 + 1;
            }
            var9_9 = (byte)(var8_8 >>> 6 & 63 | 128);
            var5_5 = var3_3;
            var6_6 = var4_4;
            {
                var1_1.put(var7_7, var9_9);
                var5_5 = var3_3;
                var6_6 = var4_4;
                var1_1.put(var3_3, (byte)(var8_8 & 63 | 128));
            }
        }
        ++var4_4;
        ++var3_3;
        ** GOTO lbl22
        var5_5 = var3_3;
        var6_6 = var4_4;
        {
            var1_1.position(var3_3);
            return;
        }
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n < n2) {
            int n4;
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                n4 = n;
            } else {
                int n5;
                n3 = n5 = n3 + 2;
                n4 = n;
                if ('\ud800' <= c) {
                    n3 = n5;
                    n4 = n;
                    if (c <= '\udfff') {
                        if (Character.codePointAt(charSequence, n) >= 65536) {
                            n4 = n + 1;
                            n3 = n5;
                        } else {
                            throw new UnpairedSurrogateException(n, n2);
                        }
                    }
                }
            }
            n = n4 + 1;
        }
        return n3;
    }

    @Override
    public String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) throws IllegalArgumentException {
        if (byteBuffer.hasArray()) {
            return Utf8Safe.decodeUtf8Array(byteBuffer.array(), byteBuffer.arrayOffset() + n, n2);
        }
        return Utf8Safe.decodeUtf8Buffer(byteBuffer, n, n2);
    }

    @Override
    public void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset();
            byteBuffer.position(Utf8Safe.encodeUtf8Array(charSequence, byteBuffer.array(), byteBuffer.position() + n, byteBuffer.remaining()) - n);
        } else {
            Utf8Safe.encodeUtf8Buffer(charSequence, byteBuffer);
        }
    }

    @Override
    public int encodedLength(CharSequence charSequence) {
        return Utf8Safe.computeEncodedLength(charSequence);
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unpaired surrogate at index ");
            stringBuilder.append(n);
            stringBuilder.append(" of ");
            stringBuilder.append(n2);
            super(stringBuilder.toString());
        }
    }
}

