/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.text.Editable;
import androidx.emoji2.text.SpannableBuilder;

final class EmojiEditableFactory
extends Editable.Factory {
    private static final Object INSTANCE_LOCK = new Object();
    private static volatile Editable.Factory sInstance;
    private static Class<?> sWatcherClass;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EmojiEditableFactory() {
        try {
            sWatcherClass = Class.forName("android.text.DynamicLayout$ChangeWatcher", false, ((Object)((Object)this)).getClass().getClassLoader());
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Editable.Factory getInstance() {
        if (sInstance != null) return sInstance;
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (sInstance != null) return sInstance;
            EmojiEditableFactory emojiEditableFactory = new EmojiEditableFactory();
            sInstance = emojiEditableFactory;
            return sInstance;
        }
    }

    public Editable newEditable(CharSequence charSequence) {
        Class<?> clazz = sWatcherClass;
        if (clazz != null) {
            return SpannableBuilder.create(clazz, charSequence);
        }
        return super.newEditable(charSequence);
    }
}

