/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.emoji2.text.EmojiCompat;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

final class EmojiInputFilter
implements InputFilter {
    private EmojiCompat.InitCallback mInitCallback;
    private final TextView mTextView;

    EmojiInputFilter(TextView textView) {
        this.mTextView = textView;
    }

    private EmojiCompat.InitCallback getInitCallback() {
        if (this.mInitCallback == null) {
            this.mInitCallback = new InitCallbackImpl(this.mTextView, this);
        }
        return this.mInitCallback;
    }

    static void updateSelection(Spannable spannable, int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            Selection.setSelection((Spannable)spannable, (int)n, (int)n2);
        } else if (n >= 0) {
            Selection.setSelection((Spannable)spannable, (int)n);
        } else if (n2 >= 0) {
            Selection.setSelection((Spannable)spannable, (int)n2);
        }
    }

    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned object, int n3, int n4) {
        if (this.mTextView.isInEditMode()) {
            return charSequence;
        }
        int n5 = EmojiCompat.get().getLoadState();
        if (n5 != 0) {
            int n6 = 1;
            if (n5 != 1) {
                if (n5 != 3) {
                    return charSequence;
                }
            } else {
                n5 = n6;
                if (n4 == 0) {
                    n5 = n6;
                    if (n3 == 0) {
                        n5 = n6;
                        if (object.length() == 0) {
                            n5 = n6;
                            if (charSequence == this.mTextView.getText()) {
                                n5 = 0;
                            }
                        }
                    }
                }
                object = charSequence;
                if (n5 != 0) {
                    object = charSequence;
                    if (charSequence != null) {
                        if (n != 0 || n2 != charSequence.length()) {
                            charSequence = charSequence.subSequence(n, n2);
                        }
                        object = EmojiCompat.get().process(charSequence, 0, charSequence.length());
                    }
                }
                return object;
            }
        }
        EmojiCompat.get().registerInitCallback(this.getInitCallback());
        return charSequence;
    }

    private static class InitCallbackImpl
    extends EmojiCompat.InitCallback {
        private final Reference<EmojiInputFilter> mEmojiInputFilterReference;
        private final Reference<TextView> mViewRef;

        InitCallbackImpl(TextView textView, EmojiInputFilter emojiInputFilter) {
            this.mViewRef = new WeakReference<TextView>(textView);
            this.mEmojiInputFilterReference = new WeakReference<EmojiInputFilter>(emojiInputFilter);
        }

        private boolean isInputFilterCurrentlyRegisteredOnTextView(TextView inputFilterArray, InputFilter inputFilter) {
            if (inputFilter != null && inputFilterArray != null) {
                if ((inputFilterArray = inputFilterArray.getFilters()) == null) {
                    return false;
                }
                for (int i = 0; i < inputFilterArray.length; ++i) {
                    if (inputFilterArray[i] != inputFilter) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onInitialized() {
            super.onInitialized();
            TextView textView = this.mViewRef.get();
            if (!this.isInputFilterCurrentlyRegisteredOnTextView(textView, this.mEmojiInputFilterReference.get())) {
                return;
            }
            if (textView.isAttachedToWindow()) {
                CharSequence charSequence = EmojiCompat.get().process(textView.getText());
                int n = Selection.getSelectionStart((CharSequence)charSequence);
                int n2 = Selection.getSelectionEnd((CharSequence)charSequence);
                textView.setText(charSequence);
                if (charSequence instanceof Spannable) {
                    EmojiInputFilter.updateSelection((Spannable)charSequence, n, n2);
                }
            }
        }
    }
}

