/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.widget.EditText;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.viewsintegration.EmojiInputFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

final class EmojiTextWatcher
implements TextWatcher {
    private final EditText mEditText;
    private int mEmojiReplaceStrategy = 0;
    private boolean mEnabled;
    private final boolean mExpectInitializedEmojiCompat;
    private EmojiCompat.InitCallback mInitCallback;
    private int mMaxEmojiCount = Integer.MAX_VALUE;

    EmojiTextWatcher(EditText editText, boolean bl) {
        this.mEditText = editText;
        this.mExpectInitializedEmojiCompat = bl;
        this.mEnabled = true;
    }

    private EmojiCompat.InitCallback getInitCallback() {
        if (this.mInitCallback == null) {
            this.mInitCallback = new InitCallbackImpl(this.mEditText);
        }
        return this.mInitCallback;
    }

    static void processTextOnEnablingEvent(EditText editText, int n) {
        if (n == 1 && editText != null && editText.isAttachedToWindow()) {
            editText = editText.getEditableText();
            int n2 = Selection.getSelectionStart((CharSequence)editText);
            n = Selection.getSelectionEnd((CharSequence)editText);
            EmojiCompat.get().process((CharSequence)editText);
            EmojiInputFilter.updateSelection((Spannable)editText, n2, n);
        }
    }

    private boolean shouldSkipForDisabledOrNotConfigured() {
        boolean bl = !this.mEnabled || !this.mExpectInitializedEmojiCompat && !EmojiCompat.isConfigured();
        return bl;
    }

    public void afterTextChanged(Editable editable) {
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    int getEmojiReplaceStrategy() {
        return this.mEmojiReplaceStrategy;
    }

    int getMaxEmojiCount() {
        return this.mMaxEmojiCount;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        block0: {
            block1: {
                block2: {
                    if (this.mEditText.isInEditMode() || this.shouldSkipForDisabledOrNotConfigured() || n2 > n3 || !(charSequence instanceof Spannable)) break block0;
                    n2 = EmojiCompat.get().getLoadState();
                    if (n2 == 0) break block1;
                    if (n2 == 1) break block2;
                    if (n2 == 3) break block1;
                    break block0;
                }
                charSequence = (Spannable)charSequence;
                EmojiCompat.get().process(charSequence, n, n + n3, this.mMaxEmojiCount, this.mEmojiReplaceStrategy);
                break block0;
            }
            EmojiCompat.get().registerInitCallback(this.getInitCallback());
        }
    }

    void setEmojiReplaceStrategy(int n) {
        this.mEmojiReplaceStrategy = n;
    }

    public void setEnabled(boolean bl) {
        if (this.mEnabled != bl) {
            if (this.mInitCallback != null) {
                EmojiCompat.get().unregisterInitCallback(this.mInitCallback);
            }
            this.mEnabled = bl;
            if (bl) {
                EmojiTextWatcher.processTextOnEnablingEvent(this.mEditText, EmojiCompat.get().getLoadState());
            }
        }
    }

    void setMaxEmojiCount(int n) {
        this.mMaxEmojiCount = n;
    }

    private static class InitCallbackImpl
    extends EmojiCompat.InitCallback {
        private final Reference<EditText> mViewRef;

        InitCallbackImpl(EditText editText) {
            this.mViewRef = new WeakReference<EditText>(editText);
        }

        @Override
        public void onInitialized() {
            super.onInitialized();
            EmojiTextWatcher.processTextOnEnablingEvent(this.mViewRef.get(), 1);
        }
    }
}

