/*
 * Decompiled with CFR 0.152.
 */
package androidx.exifinterface.media;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.util.Log;
import android.util.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class ExifInterface {
    public static final short ALTITUDE_ABOVE_SEA_LEVEL = 0;
    public static final short ALTITUDE_BELOW_SEA_LEVEL = 1;
    static final Charset ASCII;
    public static final int[] BITS_PER_SAMPLE_GREYSCALE_1;
    public static final int[] BITS_PER_SAMPLE_GREYSCALE_2;
    public static final int[] BITS_PER_SAMPLE_RGB;
    static final short BYTE_ALIGN_II = 18761;
    static final short BYTE_ALIGN_MM = 19789;
    public static final int COLOR_SPACE_S_RGB = 1;
    public static final int COLOR_SPACE_UNCALIBRATED = 65535;
    public static final short CONTRAST_HARD = 2;
    public static final short CONTRAST_NORMAL = 0;
    public static final short CONTRAST_SOFT = 1;
    public static final int DATA_DEFLATE_ZIP = 8;
    public static final int DATA_HUFFMAN_COMPRESSED = 2;
    public static final int DATA_JPEG = 6;
    public static final int DATA_JPEG_COMPRESSED = 7;
    public static final int DATA_LOSSY_JPEG = 34892;
    public static final int DATA_PACK_BITS_COMPRESSED = 32773;
    public static final int DATA_UNCOMPRESSED = 1;
    private static final boolean DEBUG = false;
    static final byte[] EXIF_ASCII_PREFIX;
    private static final ExifTag[] EXIF_POINTER_TAGS;
    static final ExifTag[][] EXIF_TAGS;
    public static final short EXPOSURE_MODE_AUTO = 0;
    public static final short EXPOSURE_MODE_AUTO_BRACKET = 2;
    public static final short EXPOSURE_MODE_MANUAL = 1;
    public static final short EXPOSURE_PROGRAM_ACTION = 6;
    public static final short EXPOSURE_PROGRAM_APERTURE_PRIORITY = 3;
    public static final short EXPOSURE_PROGRAM_CREATIVE = 5;
    public static final short EXPOSURE_PROGRAM_LANDSCAPE_MODE = 8;
    public static final short EXPOSURE_PROGRAM_MANUAL = 1;
    public static final short EXPOSURE_PROGRAM_NORMAL = 2;
    public static final short EXPOSURE_PROGRAM_NOT_DEFINED = 0;
    public static final short EXPOSURE_PROGRAM_PORTRAIT_MODE = 7;
    public static final short EXPOSURE_PROGRAM_SHUTTER_PRIORITY = 4;
    public static final short FILE_SOURCE_DSC = 3;
    public static final short FILE_SOURCE_OTHER = 0;
    public static final short FILE_SOURCE_REFLEX_SCANNER = 2;
    public static final short FILE_SOURCE_TRANSPARENT_SCANNER = 1;
    public static final short FLAG_FLASH_FIRED = 1;
    public static final short FLAG_FLASH_MODE_AUTO = 24;
    public static final short FLAG_FLASH_MODE_COMPULSORY_FIRING = 8;
    public static final short FLAG_FLASH_MODE_COMPULSORY_SUPPRESSION = 16;
    public static final short FLAG_FLASH_NO_FLASH_FUNCTION = 32;
    public static final short FLAG_FLASH_RED_EYE_SUPPORTED = 64;
    public static final short FLAG_FLASH_RETURN_LIGHT_DETECTED = 6;
    public static final short FLAG_FLASH_RETURN_LIGHT_NOT_DETECTED = 4;
    private static final List<Integer> FLIPPED_ROTATION_ORDER;
    public static final short FORMAT_CHUNKY = 1;
    public static final short FORMAT_PLANAR = 2;
    public static final short GAIN_CONTROL_HIGH_GAIN_DOWN = 4;
    public static final short GAIN_CONTROL_HIGH_GAIN_UP = 2;
    public static final short GAIN_CONTROL_LOW_GAIN_DOWN = 3;
    public static final short GAIN_CONTROL_LOW_GAIN_UP = 1;
    public static final short GAIN_CONTROL_NONE = 0;
    public static final String GPS_DIRECTION_MAGNETIC = "M";
    public static final String GPS_DIRECTION_TRUE = "T";
    public static final String GPS_DISTANCE_KILOMETERS = "K";
    public static final String GPS_DISTANCE_MILES = "M";
    public static final String GPS_DISTANCE_NAUTICAL_MILES = "N";
    public static final String GPS_MEASUREMENT_2D = "2";
    public static final String GPS_MEASUREMENT_3D = "3";
    public static final short GPS_MEASUREMENT_DIFFERENTIAL_CORRECTED = 1;
    public static final String GPS_MEASUREMENT_INTERRUPTED = "V";
    public static final String GPS_MEASUREMENT_IN_PROGRESS = "A";
    public static final short GPS_MEASUREMENT_NO_DIFFERENTIAL = 0;
    public static final String GPS_SPEED_KILOMETERS_PER_HOUR = "K";
    public static final String GPS_SPEED_KNOTS = "N";
    public static final String GPS_SPEED_MILES_PER_HOUR = "M";
    static final byte[] IDENTIFIER_EXIF_APP1;
    private static final ExifTag[] IFD_EXIF_TAGS;
    private static final int IFD_FORMAT_BYTE = 1;
    static final int[] IFD_FORMAT_BYTES_PER_FORMAT;
    private static final int IFD_FORMAT_DOUBLE = 12;
    private static final int IFD_FORMAT_IFD = 13;
    static final String[] IFD_FORMAT_NAMES;
    private static final int IFD_FORMAT_SBYTE = 6;
    private static final int IFD_FORMAT_SINGLE = 11;
    private static final int IFD_FORMAT_SLONG = 9;
    private static final int IFD_FORMAT_SRATIONAL = 10;
    private static final int IFD_FORMAT_SSHORT = 8;
    private static final int IFD_FORMAT_STRING = 2;
    private static final int IFD_FORMAT_ULONG = 4;
    private static final int IFD_FORMAT_UNDEFINED = 7;
    private static final int IFD_FORMAT_URATIONAL = 5;
    private static final int IFD_FORMAT_USHORT = 3;
    private static final ExifTag[] IFD_GPS_TAGS;
    private static final ExifTag[] IFD_INTEROPERABILITY_TAGS;
    private static final int IFD_OFFSET = 8;
    private static final ExifTag[] IFD_THUMBNAIL_TAGS;
    private static final ExifTag[] IFD_TIFF_TAGS;
    private static final int IFD_TYPE_EXIF = 1;
    private static final int IFD_TYPE_GPS = 2;
    private static final int IFD_TYPE_INTEROPERABILITY = 3;
    private static final int IFD_TYPE_ORF_CAMERA_SETTINGS = 7;
    private static final int IFD_TYPE_ORF_IMAGE_PROCESSING = 8;
    private static final int IFD_TYPE_ORF_MAKER_NOTE = 6;
    private static final int IFD_TYPE_PEF = 9;
    static final int IFD_TYPE_PREVIEW = 5;
    static final int IFD_TYPE_PRIMARY = 0;
    static final int IFD_TYPE_THUMBNAIL = 4;
    private static final int IMAGE_TYPE_ARW = 1;
    private static final int IMAGE_TYPE_CR2 = 2;
    private static final int IMAGE_TYPE_DNG = 3;
    private static final int IMAGE_TYPE_JPEG = 4;
    private static final int IMAGE_TYPE_NEF = 5;
    private static final int IMAGE_TYPE_NRW = 6;
    private static final int IMAGE_TYPE_ORF = 7;
    private static final int IMAGE_TYPE_PEF = 8;
    private static final int IMAGE_TYPE_RAF = 9;
    private static final int IMAGE_TYPE_RW2 = 10;
    private static final int IMAGE_TYPE_SRW = 11;
    private static final int IMAGE_TYPE_UNKNOWN = 0;
    private static final ExifTag JPEG_INTERCHANGE_FORMAT_LENGTH_TAG;
    private static final ExifTag JPEG_INTERCHANGE_FORMAT_TAG;
    static final byte[] JPEG_SIGNATURE;
    public static final String LATITUDE_NORTH = "N";
    public static final String LATITUDE_SOUTH = "S";
    public static final short LIGHT_SOURCE_CLOUDY_WEATHER = 10;
    public static final short LIGHT_SOURCE_COOL_WHITE_FLUORESCENT = 14;
    public static final short LIGHT_SOURCE_D50 = 23;
    public static final short LIGHT_SOURCE_D55 = 20;
    public static final short LIGHT_SOURCE_D65 = 21;
    public static final short LIGHT_SOURCE_D75 = 22;
    public static final short LIGHT_SOURCE_DAYLIGHT = 1;
    public static final short LIGHT_SOURCE_DAYLIGHT_FLUORESCENT = 12;
    public static final short LIGHT_SOURCE_DAY_WHITE_FLUORESCENT = 13;
    public static final short LIGHT_SOURCE_FINE_WEATHER = 9;
    public static final short LIGHT_SOURCE_FLASH = 4;
    public static final short LIGHT_SOURCE_FLUORESCENT = 2;
    public static final short LIGHT_SOURCE_ISO_STUDIO_TUNGSTEN = 24;
    public static final short LIGHT_SOURCE_OTHER = 255;
    public static final short LIGHT_SOURCE_SHADE = 11;
    public static final short LIGHT_SOURCE_STANDARD_LIGHT_A = 17;
    public static final short LIGHT_SOURCE_STANDARD_LIGHT_B = 18;
    public static final short LIGHT_SOURCE_STANDARD_LIGHT_C = 19;
    public static final short LIGHT_SOURCE_TUNGSTEN = 3;
    public static final short LIGHT_SOURCE_UNKNOWN = 0;
    public static final short LIGHT_SOURCE_WARM_WHITE_FLUORESCENT = 16;
    public static final short LIGHT_SOURCE_WHITE_FLUORESCENT = 15;
    public static final String LONGITUDE_EAST = "E";
    public static final String LONGITUDE_WEST = "W";
    static final byte MARKER = -1;
    static final byte MARKER_APP1 = -31;
    private static final byte MARKER_COM = -2;
    static final byte MARKER_EOI = -39;
    private static final byte MARKER_SOF0 = -64;
    private static final byte MARKER_SOF1 = -63;
    private static final byte MARKER_SOF10 = -54;
    private static final byte MARKER_SOF11 = -53;
    private static final byte MARKER_SOF13 = -51;
    private static final byte MARKER_SOF14 = -50;
    private static final byte MARKER_SOF15 = -49;
    private static final byte MARKER_SOF2 = -62;
    private static final byte MARKER_SOF3 = -61;
    private static final byte MARKER_SOF5 = -59;
    private static final byte MARKER_SOF6 = -58;
    private static final byte MARKER_SOF7 = -57;
    private static final byte MARKER_SOF9 = -55;
    private static final byte MARKER_SOI = -40;
    private static final byte MARKER_SOS = -38;
    private static final int MAX_THUMBNAIL_SIZE = 512;
    public static final short METERING_MODE_AVERAGE = 1;
    public static final short METERING_MODE_CENTER_WEIGHT_AVERAGE = 2;
    public static final short METERING_MODE_MULTI_SPOT = 4;
    public static final short METERING_MODE_OTHER = 255;
    public static final short METERING_MODE_PARTIAL = 6;
    public static final short METERING_MODE_PATTERN = 5;
    public static final short METERING_MODE_SPOT = 3;
    public static final short METERING_MODE_UNKNOWN = 0;
    private static final ExifTag[] ORF_CAMERA_SETTINGS_TAGS;
    private static final ExifTag[] ORF_IMAGE_PROCESSING_TAGS;
    private static final byte[] ORF_MAKER_NOTE_HEADER_1;
    private static final int ORF_MAKER_NOTE_HEADER_1_SIZE = 8;
    private static final byte[] ORF_MAKER_NOTE_HEADER_2;
    private static final int ORF_MAKER_NOTE_HEADER_2_SIZE = 12;
    private static final ExifTag[] ORF_MAKER_NOTE_TAGS;
    private static final short ORF_SIGNATURE_1 = 20306;
    private static final short ORF_SIGNATURE_2 = 21330;
    public static final int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static final int ORIENTATION_FLIP_VERTICAL = 4;
    public static final int ORIENTATION_NORMAL = 1;
    public static final int ORIENTATION_ROTATE_180 = 3;
    public static final int ORIENTATION_ROTATE_270 = 8;
    public static final int ORIENTATION_ROTATE_90 = 6;
    public static final int ORIENTATION_TRANSPOSE = 5;
    public static final int ORIENTATION_TRANSVERSE = 7;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIGINAL_RESOLUTION_IMAGE = 0;
    private static final int PEF_MAKER_NOTE_SKIP_SIZE = 6;
    private static final String PEF_SIGNATURE = "PENTAX";
    private static final ExifTag[] PEF_TAGS;
    public static final int PHOTOMETRIC_INTERPRETATION_BLACK_IS_ZERO = 1;
    public static final int PHOTOMETRIC_INTERPRETATION_RGB = 2;
    public static final int PHOTOMETRIC_INTERPRETATION_WHITE_IS_ZERO = 0;
    public static final int PHOTOMETRIC_INTERPRETATION_YCBCR = 6;
    private static final int RAF_INFO_SIZE = 160;
    private static final int RAF_JPEG_LENGTH_VALUE_SIZE = 4;
    private static final int RAF_OFFSET_TO_JPEG_IMAGE_OFFSET = 84;
    private static final String RAF_SIGNATURE = "FUJIFILMCCD-RAW";
    public static final int REDUCED_RESOLUTION_IMAGE = 1;
    public static final short RENDERED_PROCESS_CUSTOM = 1;
    public static final short RENDERED_PROCESS_NORMAL = 0;
    public static final short RESOLUTION_UNIT_CENTIMETERS = 3;
    public static final short RESOLUTION_UNIT_INCHES = 2;
    private static final List<Integer> ROTATION_ORDER;
    private static final short RW2_SIGNATURE = 85;
    public static final short SATURATION_HIGH = 0;
    public static final short SATURATION_LOW = 0;
    public static final short SATURATION_NORMAL = 0;
    public static final short SCENE_CAPTURE_TYPE_LANDSCAPE = 1;
    public static final short SCENE_CAPTURE_TYPE_NIGHT = 3;
    public static final short SCENE_CAPTURE_TYPE_PORTRAIT = 2;
    public static final short SCENE_CAPTURE_TYPE_STANDARD = 0;
    public static final short SCENE_TYPE_DIRECTLY_PHOTOGRAPHED = 1;
    public static final short SENSITIVITY_TYPE_ISO_SPEED = 3;
    public static final short SENSITIVITY_TYPE_REI = 2;
    public static final short SENSITIVITY_TYPE_REI_AND_ISO = 6;
    public static final short SENSITIVITY_TYPE_SOS = 1;
    public static final short SENSITIVITY_TYPE_SOS_AND_ISO = 5;
    public static final short SENSITIVITY_TYPE_SOS_AND_REI = 4;
    public static final short SENSITIVITY_TYPE_SOS_AND_REI_AND_ISO = 7;
    public static final short SENSITIVITY_TYPE_UNKNOWN = 0;
    public static final short SENSOR_TYPE_COLOR_SEQUENTIAL = 5;
    public static final short SENSOR_TYPE_COLOR_SEQUENTIAL_LINEAR = 8;
    public static final short SENSOR_TYPE_NOT_DEFINED = 1;
    public static final short SENSOR_TYPE_ONE_CHIP = 2;
    public static final short SENSOR_TYPE_THREE_CHIP = 4;
    public static final short SENSOR_TYPE_TRILINEAR = 7;
    public static final short SENSOR_TYPE_TWO_CHIP = 3;
    public static final short SHARPNESS_HARD = 2;
    public static final short SHARPNESS_NORMAL = 0;
    public static final short SHARPNESS_SOFT = 1;
    private static final int SIGNATURE_CHECK_SIZE = 5000;
    static final byte START_CODE = 42;
    public static final short SUBJECT_DISTANCE_RANGE_CLOSE_VIEW = 2;
    public static final short SUBJECT_DISTANCE_RANGE_DISTANT_VIEW = 3;
    public static final short SUBJECT_DISTANCE_RANGE_MACRO = 1;
    public static final short SUBJECT_DISTANCE_RANGE_UNKNOWN = 0;
    private static final String TAG = "ExifInterface";
    public static final String TAG_APERTURE_VALUE = "ApertureValue";
    public static final String TAG_ARTIST = "Artist";
    public static final String TAG_BITS_PER_SAMPLE = "BitsPerSample";
    public static final String TAG_BODY_SERIAL_NUMBER = "BodySerialNumber";
    public static final String TAG_BRIGHTNESS_VALUE = "BrightnessValue";
    public static final String TAG_CAMARA_OWNER_NAME = "CameraOwnerName";
    public static final String TAG_CFA_PATTERN = "CFAPattern";
    public static final String TAG_COLOR_SPACE = "ColorSpace";
    public static final String TAG_COMPONENTS_CONFIGURATION = "ComponentsConfiguration";
    public static final String TAG_COMPRESSED_BITS_PER_PIXEL = "CompressedBitsPerPixel";
    public static final String TAG_COMPRESSION = "Compression";
    public static final String TAG_CONTRAST = "Contrast";
    public static final String TAG_COPYRIGHT = "Copyright";
    public static final String TAG_CUSTOM_RENDERED = "CustomRendered";
    public static final String TAG_DATETIME = "DateTime";
    public static final String TAG_DATETIME_DIGITIZED = "DateTimeDigitized";
    public static final String TAG_DATETIME_ORIGINAL = "DateTimeOriginal";
    public static final String TAG_DEFAULT_CROP_SIZE = "DefaultCropSize";
    public static final String TAG_DEVICE_SETTING_DESCRIPTION = "DeviceSettingDescription";
    public static final String TAG_DIGITAL_ZOOM_RATIO = "DigitalZoomRatio";
    public static final String TAG_DNG_VERSION = "DNGVersion";
    private static final String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    public static final String TAG_EXIF_VERSION = "ExifVersion";
    public static final String TAG_EXPOSURE_BIAS_VALUE = "ExposureBiasValue";
    public static final String TAG_EXPOSURE_INDEX = "ExposureIndex";
    public static final String TAG_EXPOSURE_MODE = "ExposureMode";
    public static final String TAG_EXPOSURE_PROGRAM = "ExposureProgram";
    public static final String TAG_EXPOSURE_TIME = "ExposureTime";
    public static final String TAG_FILE_SOURCE = "FileSource";
    public static final String TAG_FLASH = "Flash";
    public static final String TAG_FLASHPIX_VERSION = "FlashpixVersion";
    public static final String TAG_FLASH_ENERGY = "FlashEnergy";
    public static final String TAG_FOCAL_LENGTH = "FocalLength";
    public static final String TAG_FOCAL_LENGTH_IN_35MM_FILM = "FocalLengthIn35mmFilm";
    public static final String TAG_FOCAL_PLANE_RESOLUTION_UNIT = "FocalPlaneResolutionUnit";
    public static final String TAG_FOCAL_PLANE_X_RESOLUTION = "FocalPlaneXResolution";
    public static final String TAG_FOCAL_PLANE_Y_RESOLUTION = "FocalPlaneYResolution";
    public static final String TAG_F_NUMBER = "FNumber";
    public static final String TAG_GAIN_CONTROL = "GainControl";
    public static final String TAG_GAMMA = "Gamma";
    public static final String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static final String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static final String TAG_GPS_AREA_INFORMATION = "GPSAreaInformation";
    public static final String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static final String TAG_GPS_DEST_BEARING = "GPSDestBearing";
    public static final String TAG_GPS_DEST_BEARING_REF = "GPSDestBearingRef";
    public static final String TAG_GPS_DEST_DISTANCE = "GPSDestDistance";
    public static final String TAG_GPS_DEST_DISTANCE_REF = "GPSDestDistanceRef";
    public static final String TAG_GPS_DEST_LATITUDE = "GPSDestLatitude";
    public static final String TAG_GPS_DEST_LATITUDE_REF = "GPSDestLatitudeRef";
    public static final String TAG_GPS_DEST_LONGITUDE = "GPSDestLongitude";
    public static final String TAG_GPS_DEST_LONGITUDE_REF = "GPSDestLongitudeRef";
    public static final String TAG_GPS_DIFFERENTIAL = "GPSDifferential";
    public static final String TAG_GPS_DOP = "GPSDOP";
    public static final String TAG_GPS_H_POSITIONING_ERROR = "GPSHPositioningError";
    public static final String TAG_GPS_IMG_DIRECTION = "GPSImgDirection";
    public static final String TAG_GPS_IMG_DIRECTION_REF = "GPSImgDirectionRef";
    private static final String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    public static final String TAG_GPS_LATITUDE = "GPSLatitude";
    public static final String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static final String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static final String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static final String TAG_GPS_MAP_DATUM = "GPSMapDatum";
    public static final String TAG_GPS_MEASURE_MODE = "GPSMeasureMode";
    public static final String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static final String TAG_GPS_SATELLITES = "GPSSatellites";
    public static final String TAG_GPS_SPEED = "GPSSpeed";
    public static final String TAG_GPS_SPEED_REF = "GPSSpeedRef";
    public static final String TAG_GPS_STATUS = "GPSStatus";
    public static final String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static final String TAG_GPS_TRACK = "GPSTrack";
    public static final String TAG_GPS_TRACK_REF = "GPSTrackRef";
    public static final String TAG_GPS_VERSION_ID = "GPSVersionID";
    private static final String TAG_HAS_THUMBNAIL = "HasThumbnail";
    public static final String TAG_IMAGE_DESCRIPTION = "ImageDescription";
    public static final String TAG_IMAGE_LENGTH = "ImageLength";
    public static final String TAG_IMAGE_UNIQUE_ID = "ImageUniqueID";
    public static final String TAG_IMAGE_WIDTH = "ImageWidth";
    private static final String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    public static final String TAG_INTEROPERABILITY_INDEX = "InteroperabilityIndex";
    public static final String TAG_ISO_SPEED = "ISOSpeed";
    public static final String TAG_ISO_SPEED_LATITUDE_YYY = "ISOSpeedLatitudeyyy";
    public static final String TAG_ISO_SPEED_LATITUDE_ZZZ = "ISOSpeedLatitudezzz";
    @Deprecated
    public static final String TAG_ISO_SPEED_RATINGS = "ISOSpeedRatings";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT = "JPEGInterchangeFormat";
    public static final String TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = "JPEGInterchangeFormatLength";
    public static final String TAG_LENS_MAKE = "LensMake";
    public static final String TAG_LENS_MODEL = "LensModel";
    public static final String TAG_LENS_SERIAL_NUMBER = "LensSerialNumber";
    public static final String TAG_LENS_SPECIFICATION = "LensSpecification";
    public static final String TAG_LIGHT_SOURCE = "LightSource";
    public static final String TAG_MAKE = "Make";
    public static final String TAG_MAKER_NOTE = "MakerNote";
    public static final String TAG_MAX_APERTURE_VALUE = "MaxApertureValue";
    public static final String TAG_METERING_MODE = "MeteringMode";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_NEW_SUBFILE_TYPE = "NewSubfileType";
    public static final String TAG_OECF = "OECF";
    public static final String TAG_ORF_ASPECT_FRAME = "AspectFrame";
    private static final String TAG_ORF_CAMERA_SETTINGS_IFD_POINTER = "CameraSettingsIFDPointer";
    private static final String TAG_ORF_IMAGE_PROCESSING_IFD_POINTER = "ImageProcessingIFDPointer";
    public static final String TAG_ORF_PREVIEW_IMAGE_LENGTH = "PreviewImageLength";
    public static final String TAG_ORF_PREVIEW_IMAGE_START = "PreviewImageStart";
    public static final String TAG_ORF_THUMBNAIL_IMAGE = "ThumbnailImage";
    public static final String TAG_ORIENTATION = "Orientation";
    public static final String TAG_PHOTOGRAPHIC_SENSITIVITY = "PhotographicSensitivity";
    public static final String TAG_PHOTOMETRIC_INTERPRETATION = "PhotometricInterpretation";
    public static final String TAG_PIXEL_X_DIMENSION = "PixelXDimension";
    public static final String TAG_PIXEL_Y_DIMENSION = "PixelYDimension";
    public static final String TAG_PLANAR_CONFIGURATION = "PlanarConfiguration";
    public static final String TAG_PRIMARY_CHROMATICITIES = "PrimaryChromaticities";
    private static final ExifTag TAG_RAF_IMAGE_SIZE;
    public static final String TAG_RECOMMENDED_EXPOSURE_INDEX = "RecommendedExposureIndex";
    public static final String TAG_REFERENCE_BLACK_WHITE = "ReferenceBlackWhite";
    public static final String TAG_RELATED_SOUND_FILE = "RelatedSoundFile";
    public static final String TAG_RESOLUTION_UNIT = "ResolutionUnit";
    public static final String TAG_ROWS_PER_STRIP = "RowsPerStrip";
    public static final String TAG_RW2_ISO = "ISO";
    public static final String TAG_RW2_JPG_FROM_RAW = "JpgFromRaw";
    public static final String TAG_RW2_SENSOR_BOTTOM_BORDER = "SensorBottomBorder";
    public static final String TAG_RW2_SENSOR_LEFT_BORDER = "SensorLeftBorder";
    public static final String TAG_RW2_SENSOR_RIGHT_BORDER = "SensorRightBorder";
    public static final String TAG_RW2_SENSOR_TOP_BORDER = "SensorTopBorder";
    public static final String TAG_SAMPLES_PER_PIXEL = "SamplesPerPixel";
    public static final String TAG_SATURATION = "Saturation";
    public static final String TAG_SCENE_CAPTURE_TYPE = "SceneCaptureType";
    public static final String TAG_SCENE_TYPE = "SceneType";
    public static final String TAG_SENSING_METHOD = "SensingMethod";
    public static final String TAG_SENSITIVITY_TYPE = "SensitivityType";
    public static final String TAG_SHARPNESS = "Sharpness";
    public static final String TAG_SHUTTER_SPEED_VALUE = "ShutterSpeedValue";
    public static final String TAG_SOFTWARE = "Software";
    public static final String TAG_SPATIAL_FREQUENCY_RESPONSE = "SpatialFrequencyResponse";
    public static final String TAG_SPECTRAL_SENSITIVITY = "SpectralSensitivity";
    public static final String TAG_STANDARD_OUTPUT_SENSITIVITY = "StandardOutputSensitivity";
    public static final String TAG_STRIP_BYTE_COUNTS = "StripByteCounts";
    public static final String TAG_STRIP_OFFSETS = "StripOffsets";
    public static final String TAG_SUBFILE_TYPE = "SubfileType";
    public static final String TAG_SUBJECT_AREA = "SubjectArea";
    public static final String TAG_SUBJECT_DISTANCE = "SubjectDistance";
    public static final String TAG_SUBJECT_DISTANCE_RANGE = "SubjectDistanceRange";
    public static final String TAG_SUBJECT_LOCATION = "SubjectLocation";
    public static final String TAG_SUBSEC_TIME = "SubSecTime";
    public static final String TAG_SUBSEC_TIME_DIGITIZED = "SubSecTimeDigitized";
    public static final String TAG_SUBSEC_TIME_ORIGINAL = "SubSecTimeOriginal";
    private static final String TAG_SUB_IFD_POINTER = "SubIFDPointer";
    private static final String TAG_THUMBNAIL_DATA = "ThumbnailData";
    public static final String TAG_THUMBNAIL_IMAGE_LENGTH = "ThumbnailImageLength";
    public static final String TAG_THUMBNAIL_IMAGE_WIDTH = "ThumbnailImageWidth";
    private static final String TAG_THUMBNAIL_LENGTH = "ThumbnailLength";
    private static final String TAG_THUMBNAIL_OFFSET = "ThumbnailOffset";
    public static final String TAG_TRANSFER_FUNCTION = "TransferFunction";
    public static final String TAG_USER_COMMENT = "UserComment";
    public static final String TAG_WHITE_BALANCE = "WhiteBalance";
    public static final String TAG_WHITE_POINT = "WhitePoint";
    public static final String TAG_X_RESOLUTION = "XResolution";
    public static final String TAG_Y_CB_CR_COEFFICIENTS = "YCbCrCoefficients";
    public static final String TAG_Y_CB_CR_POSITIONING = "YCbCrPositioning";
    public static final String TAG_Y_CB_CR_SUB_SAMPLING = "YCbCrSubSampling";
    public static final String TAG_Y_RESOLUTION = "YResolution";
    @Deprecated
    public static final int WHITEBALANCE_AUTO = 0;
    @Deprecated
    public static final int WHITEBALANCE_MANUAL = 1;
    public static final short WHITE_BALANCE_AUTO = 0;
    public static final short WHITE_BALANCE_MANUAL = 1;
    public static final short Y_CB_CR_POSITIONING_CENTERED = 1;
    public static final short Y_CB_CR_POSITIONING_CO_SITED = 2;
    private static final HashMap<Integer, Integer> sExifPointerTagMap;
    private static final HashMap<Integer, ExifTag>[] sExifTagMapsForReading;
    private static final HashMap<String, ExifTag>[] sExifTagMapsForWriting;
    private static SimpleDateFormat sFormatter;
    private static final Pattern sGpsTimestampPattern;
    private static final Pattern sNonZeroTimePattern;
    private static final HashSet<String> sTagSetForCompatibility;
    private final AssetManager.AssetInputStream mAssetInputStream;
    private final HashMap<String, ExifAttribute>[] mAttributes;
    private Set<Integer> mAttributesOffsets;
    private ByteOrder mExifByteOrder;
    private int mExifOffset;
    private final String mFilename;
    private boolean mHasThumbnail;
    private boolean mIsSupportedFile;
    private int mMimeType;
    private int mOrfMakerNoteOffset;
    private int mOrfThumbnailLength;
    private int mOrfThumbnailOffset;
    private int mRw2JpgFromRawOffset;
    private byte[] mThumbnailBytes;
    private int mThumbnailCompression;
    private int mThumbnailLength;
    private int mThumbnailOffset;

    static {
        Integer n = 1;
        Integer n2 = 3;
        Integer n3 = 2;
        Integer n4 = 8;
        ROTATION_ORDER = Arrays.asList(n, 6, n2, n4);
        Integer n5 = 7;
        Integer n6 = 5;
        FLIPPED_ROTATION_ORDER = Arrays.asList(n3, n5, 4, n6);
        BITS_PER_SAMPLE_RGB = new int[]{8, 8, 8};
        BITS_PER_SAMPLE_GREYSCALE_1 = new int[]{4};
        BITS_PER_SAMPLE_GREYSCALE_2 = new int[]{8};
        JPEG_SIGNATURE = new byte[]{-1, -40, -1};
        ORF_MAKER_NOTE_HEADER_1 = new byte[]{79, 76, 89, 77, 80, 0};
        ORF_MAKER_NOTE_HEADER_2 = new byte[]{79, 76, 89, 77, 80, 85, 83, 0, 73, 73};
        IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE"};
        IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 1};
        EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
        ExifTag[] exifTagArray = new ExifTag[]{new ExifTag(TAG_NEW_SUBFILE_TYPE, 254, 4), new ExifTag(TAG_SUBFILE_TYPE, 255, 4), new ExifTag(TAG_IMAGE_WIDTH, 256, 3, 4), new ExifTag(TAG_IMAGE_LENGTH, 257, 3, 4), new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3), new ExifTag(TAG_COMPRESSION, 259, 3), new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3), new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2), new ExifTag(TAG_MAKE, 271, 2), new ExifTag(TAG_MODEL, 272, 2), new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4), new ExifTag(TAG_ORIENTATION, 274, 3), new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3), new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4), new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4), new ExifTag(TAG_X_RESOLUTION, 282, 5), new ExifTag(TAG_Y_RESOLUTION, 283, 5), new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3), new ExifTag(TAG_RESOLUTION_UNIT, 296, 3), new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3), new ExifTag(TAG_SOFTWARE, 305, 2), new ExifTag(TAG_DATETIME, 306, 2), new ExifTag(TAG_ARTIST, 315, 2), new ExifTag(TAG_WHITE_POINT, 318, 5), new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5), new ExifTag(TAG_SUB_IFD_POINTER, 330, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4), new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5), new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3), new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3), new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5), new ExifTag(TAG_COPYRIGHT, 33432, 2), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_RW2_SENSOR_TOP_BORDER, 4, 4), new ExifTag(TAG_RW2_SENSOR_LEFT_BORDER, 5, 4), new ExifTag(TAG_RW2_SENSOR_BOTTOM_BORDER, 6, 4), new ExifTag(TAG_RW2_SENSOR_RIGHT_BORDER, 7, 4), new ExifTag(TAG_RW2_ISO, 23, 3), new ExifTag(TAG_RW2_JPG_FROM_RAW, 46, 7)};
        IFD_TIFF_TAGS = exifTagArray;
        ExifTag[] exifTagArray2 = new ExifTag[]{new ExifTag(TAG_EXPOSURE_TIME, 33434, 5), new ExifTag(TAG_F_NUMBER, 33437, 5), new ExifTag(TAG_EXPOSURE_PROGRAM, 34850, 3), new ExifTag(TAG_SPECTRAL_SENSITIVITY, 34852, 2), new ExifTag(TAG_PHOTOGRAPHIC_SENSITIVITY, 34855, 3), new ExifTag(TAG_OECF, 34856, 7), new ExifTag(TAG_EXIF_VERSION, 36864, 2), new ExifTag(TAG_DATETIME_ORIGINAL, 36867, 2), new ExifTag(TAG_DATETIME_DIGITIZED, 36868, 2), new ExifTag(TAG_COMPONENTS_CONFIGURATION, 37121, 7), new ExifTag(TAG_COMPRESSED_BITS_PER_PIXEL, 37122, 5), new ExifTag(TAG_SHUTTER_SPEED_VALUE, 37377, 10), new ExifTag(TAG_APERTURE_VALUE, 37378, 5), new ExifTag(TAG_BRIGHTNESS_VALUE, 37379, 10), new ExifTag(TAG_EXPOSURE_BIAS_VALUE, 37380, 10), new ExifTag(TAG_MAX_APERTURE_VALUE, 37381, 5), new ExifTag(TAG_SUBJECT_DISTANCE, 37382, 5), new ExifTag(TAG_METERING_MODE, 37383, 3), new ExifTag(TAG_LIGHT_SOURCE, 37384, 3), new ExifTag(TAG_FLASH, 37385, 3), new ExifTag(TAG_FOCAL_LENGTH, 37386, 5), new ExifTag(TAG_SUBJECT_AREA, 37396, 3), new ExifTag(TAG_MAKER_NOTE, 37500, 7), new ExifTag(TAG_USER_COMMENT, 37510, 7), new ExifTag(TAG_SUBSEC_TIME, 37520, 2), new ExifTag(TAG_SUBSEC_TIME_ORIGINAL, 37521, 2), new ExifTag(TAG_SUBSEC_TIME_DIGITIZED, 37522, 2), new ExifTag(TAG_FLASHPIX_VERSION, 40960, 7), new ExifTag(TAG_COLOR_SPACE, 40961, 3), new ExifTag(TAG_PIXEL_X_DIMENSION, 40962, 3, 4), new ExifTag(TAG_PIXEL_Y_DIMENSION, 40963, 3, 4), new ExifTag(TAG_RELATED_SOUND_FILE, 40964, 2), new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4), new ExifTag(TAG_FLASH_ENERGY, 41483, 5), new ExifTag(TAG_SPATIAL_FREQUENCY_RESPONSE, 41484, 7), new ExifTag(TAG_FOCAL_PLANE_X_RESOLUTION, 41486, 5), new ExifTag(TAG_FOCAL_PLANE_Y_RESOLUTION, 41487, 5), new ExifTag(TAG_FOCAL_PLANE_RESOLUTION_UNIT, 41488, 3), new ExifTag(TAG_SUBJECT_LOCATION, 41492, 3), new ExifTag(TAG_EXPOSURE_INDEX, 41493, 5), new ExifTag(TAG_SENSING_METHOD, 41495, 3), new ExifTag(TAG_FILE_SOURCE, 41728, 7), new ExifTag(TAG_SCENE_TYPE, 41729, 7), new ExifTag(TAG_CFA_PATTERN, 41730, 7), new ExifTag(TAG_CUSTOM_RENDERED, 41985, 3), new ExifTag(TAG_EXPOSURE_MODE, 41986, 3), new ExifTag(TAG_WHITE_BALANCE, 41987, 3), new ExifTag(TAG_DIGITAL_ZOOM_RATIO, 41988, 5), new ExifTag(TAG_FOCAL_LENGTH_IN_35MM_FILM, 41989, 3), new ExifTag(TAG_SCENE_CAPTURE_TYPE, 41990, 3), new ExifTag(TAG_GAIN_CONTROL, 41991, 3), new ExifTag(TAG_CONTRAST, 41992, 3), new ExifTag(TAG_SATURATION, 41993, 3), new ExifTag(TAG_SHARPNESS, 41994, 3), new ExifTag(TAG_DEVICE_SETTING_DESCRIPTION, 41995, 7), new ExifTag(TAG_SUBJECT_DISTANCE_RANGE, 41996, 3), new ExifTag(TAG_IMAGE_UNIQUE_ID, 42016, 2), new ExifTag(TAG_DNG_VERSION, 50706, 1), new ExifTag(TAG_DEFAULT_CROP_SIZE, 50720, 3, 4)};
        IFD_EXIF_TAGS = exifTagArray2;
        ExifTag[] exifTagArray3 = new ExifTag[]{new ExifTag(TAG_GPS_VERSION_ID, 0, 1), new ExifTag(TAG_GPS_LATITUDE_REF, 1, 2), new ExifTag(TAG_GPS_LATITUDE, 2, 5), new ExifTag(TAG_GPS_LONGITUDE_REF, 3, 2), new ExifTag(TAG_GPS_LONGITUDE, 4, 5), new ExifTag(TAG_GPS_ALTITUDE_REF, 5, 1), new ExifTag(TAG_GPS_ALTITUDE, 6, 5), new ExifTag(TAG_GPS_TIMESTAMP, 7, 5), new ExifTag(TAG_GPS_SATELLITES, 8, 2), new ExifTag(TAG_GPS_STATUS, 9, 2), new ExifTag(TAG_GPS_MEASURE_MODE, 10, 2), new ExifTag(TAG_GPS_DOP, 11, 5), new ExifTag(TAG_GPS_SPEED_REF, 12, 2), new ExifTag(TAG_GPS_SPEED, 13, 5), new ExifTag(TAG_GPS_TRACK_REF, 14, 2), new ExifTag(TAG_GPS_TRACK, 15, 5), new ExifTag(TAG_GPS_IMG_DIRECTION_REF, 16, 2), new ExifTag(TAG_GPS_IMG_DIRECTION, 17, 5), new ExifTag(TAG_GPS_MAP_DATUM, 18, 2), new ExifTag(TAG_GPS_DEST_LATITUDE_REF, 19, 2), new ExifTag(TAG_GPS_DEST_LATITUDE, 20, 5), new ExifTag(TAG_GPS_DEST_LONGITUDE_REF, 21, 2), new ExifTag(TAG_GPS_DEST_LONGITUDE, 22, 5), new ExifTag(TAG_GPS_DEST_BEARING_REF, 23, 2), new ExifTag(TAG_GPS_DEST_BEARING, 24, 5), new ExifTag(TAG_GPS_DEST_DISTANCE_REF, 25, 2), new ExifTag(TAG_GPS_DEST_DISTANCE, 26, 5), new ExifTag(TAG_GPS_PROCESSING_METHOD, 27, 7), new ExifTag(TAG_GPS_AREA_INFORMATION, 28, 7), new ExifTag(TAG_GPS_DATESTAMP, 29, 2), new ExifTag(TAG_GPS_DIFFERENTIAL, 30, 3)};
        IFD_GPS_TAGS = exifTagArray3;
        ExifTag[] exifTagArray4 = new ExifTag[]{new ExifTag(TAG_INTEROPERABILITY_INDEX, 1, 2)};
        IFD_INTEROPERABILITY_TAGS = exifTagArray4;
        ExifTag[] exifTagArray5 = new ExifTag[]{new ExifTag(TAG_NEW_SUBFILE_TYPE, 254, 4), new ExifTag(TAG_SUBFILE_TYPE, 255, 4), new ExifTag(TAG_THUMBNAIL_IMAGE_WIDTH, 256, 3, 4), new ExifTag(TAG_THUMBNAIL_IMAGE_LENGTH, 257, 3, 4), new ExifTag(TAG_BITS_PER_SAMPLE, 258, 3), new ExifTag(TAG_COMPRESSION, 259, 3), new ExifTag(TAG_PHOTOMETRIC_INTERPRETATION, 262, 3), new ExifTag(TAG_IMAGE_DESCRIPTION, 270, 2), new ExifTag(TAG_MAKE, 271, 2), new ExifTag(TAG_MODEL, 272, 2), new ExifTag(TAG_STRIP_OFFSETS, 273, 3, 4), new ExifTag(TAG_ORIENTATION, 274, 3), new ExifTag(TAG_SAMPLES_PER_PIXEL, 277, 3), new ExifTag(TAG_ROWS_PER_STRIP, 278, 3, 4), new ExifTag(TAG_STRIP_BYTE_COUNTS, 279, 3, 4), new ExifTag(TAG_X_RESOLUTION, 282, 5), new ExifTag(TAG_Y_RESOLUTION, 283, 5), new ExifTag(TAG_PLANAR_CONFIGURATION, 284, 3), new ExifTag(TAG_RESOLUTION_UNIT, 296, 3), new ExifTag(TAG_TRANSFER_FUNCTION, 301, 3), new ExifTag(TAG_SOFTWARE, 305, 2), new ExifTag(TAG_DATETIME, 306, 2), new ExifTag(TAG_ARTIST, 315, 2), new ExifTag(TAG_WHITE_POINT, 318, 5), new ExifTag(TAG_PRIMARY_CHROMATICITIES, 319, 5), new ExifTag(TAG_SUB_IFD_POINTER, 330, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4), new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4), new ExifTag(TAG_Y_CB_CR_COEFFICIENTS, 529, 5), new ExifTag(TAG_Y_CB_CR_SUB_SAMPLING, 530, 3), new ExifTag(TAG_Y_CB_CR_POSITIONING, 531, 3), new ExifTag(TAG_REFERENCE_BLACK_WHITE, 532, 5), new ExifTag(TAG_COPYRIGHT, 33432, 2), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_DNG_VERSION, 50706, 1), new ExifTag(TAG_DEFAULT_CROP_SIZE, 50720, 3, 4)};
        IFD_THUMBNAIL_TAGS = exifTagArray5;
        TAG_RAF_IMAGE_SIZE = new ExifTag(TAG_STRIP_OFFSETS, 273, 3);
        ExifTag[] exifTagArray6 = new ExifTag[]{new ExifTag(TAG_ORF_THUMBNAIL_IMAGE, 256, 7), new ExifTag(TAG_ORF_CAMERA_SETTINGS_IFD_POINTER, 8224, 4), new ExifTag(TAG_ORF_IMAGE_PROCESSING_IFD_POINTER, 8256, 4)};
        ORF_MAKER_NOTE_TAGS = exifTagArray6;
        Object object = new ExifTag[]{new ExifTag(TAG_ORF_PREVIEW_IMAGE_START, 257, 4), new ExifTag(TAG_ORF_PREVIEW_IMAGE_LENGTH, 258, 4)};
        ORF_CAMERA_SETTINGS_TAGS = object;
        Object object2 = new ExifTag[]{new ExifTag(TAG_ORF_ASPECT_FRAME, 4371, 3)};
        ORF_IMAGE_PROCESSING_TAGS = object2;
        ExifTag[] exifTagArray7 = new ExifTag[]{new ExifTag(TAG_COLOR_SPACE, 55, 3)};
        PEF_TAGS = exifTagArray7;
        ExifTag[][] exifTagArrayArray = new ExifTag[][]{exifTagArray, exifTagArray2, exifTagArray3, exifTagArray4, exifTagArray5, exifTagArray, exifTagArray6, object, object2, exifTagArray7};
        EXIF_TAGS = exifTagArrayArray;
        EXIF_POINTER_TAGS = new ExifTag[]{new ExifTag(TAG_SUB_IFD_POINTER, 330, 4), new ExifTag(TAG_EXIF_IFD_POINTER, 34665, 4), new ExifTag(TAG_GPS_INFO_IFD_POINTER, 34853, 4), new ExifTag(TAG_INTEROPERABILITY_IFD_POINTER, 40965, 4), new ExifTag(TAG_ORF_CAMERA_SETTINGS_IFD_POINTER, 8224, 1), new ExifTag(TAG_ORF_IMAGE_PROCESSING_IFD_POINTER, 8256, 1)};
        JPEG_INTERCHANGE_FORMAT_TAG = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT, 513, 4);
        JPEG_INTERCHANGE_FORMAT_LENGTH_TAG = new ExifTag(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, 514, 4);
        sExifTagMapsForReading = new HashMap[exifTagArrayArray.length];
        sExifTagMapsForWriting = new HashMap[exifTagArrayArray.length];
        sTagSetForCompatibility = new HashSet<String>(Arrays.asList(TAG_F_NUMBER, TAG_DIGITAL_ZOOM_RATIO, TAG_EXPOSURE_TIME, TAG_SUBJECT_DISTANCE, TAG_GPS_TIMESTAMP));
        sExifPointerTagMap = new HashMap();
        object = Charset.forName("US-ASCII");
        ASCII = object;
        IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes((Charset)object);
        sFormatter = object = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
        for (int i = 0; i < ((Object)(object = EXIF_TAGS)).length; ++i) {
            ExifInterface.sExifTagMapsForReading[i] = new HashMap();
            ExifInterface.sExifTagMapsForWriting[i] = new HashMap();
            object = object[i];
            int n7 = ((Object)object).length;
            for (int j = 0; j < n7; ++j) {
                object2 = object[j];
                sExifTagMapsForReading[i].put(object2.number, (ExifTag)object2);
                sExifTagMapsForWriting[i].put(object2.name, (ExifTag)object2);
            }
        }
        object = sExifPointerTagMap;
        object2 = EXIF_POINTER_TAGS;
        ((HashMap)object).put(object2[0].number, n6);
        ((HashMap)object).put(object2[1].number, n);
        ((HashMap)object).put(object2[2].number, n3);
        ((HashMap)object).put(object2[3].number, n2);
        ((HashMap)object).put(object2[4].number, n5);
        ((HashMap)object).put(object2[5].number, n4);
        sNonZeroTimePattern = Pattern.compile(".*[1-9].*");
        sGpsTimestampPattern = Pattern.compile("^([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
    }

    public ExifInterface(InputStream inputStream) throws IOException {
        ExifTag[][] exifTagArray = EXIF_TAGS;
        this.mAttributes = new HashMap[exifTagArray.length];
        this.mAttributesOffsets = new HashSet<Integer>(exifTagArray.length);
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (inputStream != null) {
            this.mFilename = null;
            this.mAssetInputStream = inputStream instanceof AssetManager.AssetInputStream ? (AssetManager.AssetInputStream)inputStream : null;
            this.loadAttributes(inputStream);
            return;
        }
        throw new IllegalArgumentException("inputStream cannot be null");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExifInterface(String string2) throws IOException {
        void var1_4;
        Object object;
        block5: {
            FileInputStream fileInputStream;
            object = EXIF_TAGS;
            this.mAttributes = new HashMap[((ExifTag[][])object).length];
            this.mAttributesOffsets = new HashSet<Integer>(((ExifTag[][])object).length);
            this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
            if (string2 == null) {
                throw new IllegalArgumentException("filename cannot be null");
            }
            object = null;
            this.mAssetInputStream = null;
            this.mFilename = string2;
            try {
                fileInputStream = new FileInputStream(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
                break block5;
            }
            try {
                this.loadAttributes(fileInputStream);
            }
            catch (Throwable throwable) {
                object = fileInputStream;
                break block5;
            }
            ExifInterface.closeQuietly(fileInputStream);
            return;
        }
        ExifInterface.closeQuietly((Closeable)object);
        throw var1_4;
    }

    private void addDefaultValuesForCompatibility() {
        String string2 = this.getAttribute(TAG_DATETIME_ORIGINAL);
        if (string2 != null && this.getAttribute(TAG_DATETIME) == null) {
            this.mAttributes[0].put(TAG_DATETIME, ExifAttribute.createString(string2));
        }
        if (this.getAttribute(TAG_IMAGE_WIDTH) == null) {
            this.mAttributes[0].put(TAG_IMAGE_WIDTH, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_IMAGE_LENGTH) == null) {
            this.mAttributes[0].put(TAG_IMAGE_LENGTH, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_ORIENTATION) == null) {
            this.mAttributes[0].put(TAG_ORIENTATION, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute(TAG_LIGHT_SOURCE) == null) {
            this.mAttributes[1].put(TAG_LIGHT_SOURCE, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    private String convertDecimalDegree(double d) {
        long l = (long)d;
        long l2 = (long)((d -= (double)l) * 60.0);
        long l3 = Math.round((d - (double)l2 / 60.0) * 3600.0 * 1.0E7);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l);
        stringBuilder.append("/1,");
        stringBuilder.append(l2);
        stringBuilder.append("/1,");
        stringBuilder.append(l3);
        stringBuilder.append("/10000000");
        return stringBuilder.toString();
    }

    private static double convertRationalLatLonToDouble(String object, String string2) {
        double d;
        block4: {
            object = object.split(",", -1);
            String[] stringArray = object[0].split("/", -1);
            double d2 = Double.parseDouble(stringArray[0].trim()) / Double.parseDouble(stringArray[1].trim());
            stringArray = object[1].split("/", -1);
            double d3 = Double.parseDouble(stringArray[0].trim()) / Double.parseDouble(stringArray[1].trim());
            object = object[2].split("/", -1);
            d = Double.parseDouble(object[0].trim()) / Double.parseDouble(object[1].trim());
            d = d2 + d3 / 60.0 + d / 3600.0;
            try {
                if (string2.equals(LATITUDE_SOUTH) || string2.equals(LONGITUDE_WEST)) break block4;
                if (!string2.equals("N") && !string2.equals(LONGITUDE_EAST)) {
                    object = new IllegalArgumentException();
                    throw object;
                }
                return d;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                throw new IllegalArgumentException();
            }
        }
        return -d;
    }

    private static long[] convertToLongArray(Object object) {
        if (object instanceof int[]) {
            object = (int[])object;
            long[] lArray = new long[((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                lArray[i] = (long)object[i];
            }
            return lArray;
        }
        if (object instanceof long[]) {
            return (long[])object;
        }
        return null;
    }

    private static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            n2 += n;
            outputStream.write(byArray, 0, n);
        }
        return n2;
    }

    private ExifAttribute getExifAttribute(String object) {
        String string2 = object;
        if (TAG_ISO_SPEED_RATINGS.equals(object)) {
            string2 = TAG_PHOTOGRAPHIC_SENSITIVITY;
        }
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            object = this.mAttributes[i].get(string2);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void getJpegAttributes(ByteOrderedDataInputStream var1_1, int var2_2, int var3_3) throws IOException {
        var1_1.setByteOrder(ByteOrder.BIG_ENDIAN);
        var1_1.seek(var2_2);
        var4_4 = var1_1.readByte();
        if (var4_4 != -1) {
            var1_1 = new StringBuilder();
            var1_1.append("Invalid marker: ");
            var1_1.append(Integer.toHexString(var4_4 & 255));
            throw new IOException(var1_1.toString());
        }
        if (var1_1.readByte() != -40) {
            var1_1 = new StringBuilder();
            var1_1.append("Invalid marker: ");
            var1_1.append(Integer.toHexString(var4_4 & 255));
            throw new IOException(var1_1.toString());
        }
        var2_2 = var2_2 + 1 + 1;
        while (true) {
            block31: {
                block29: {
                    block30: {
                        if ((var4_4 = var1_1.readByte()) != -1) {
                            var1_1 = new StringBuilder();
                            var1_1.append("Invalid marker:");
                            var1_1.append(Integer.toHexString(var4_4 & 255));
                            throw new IOException(var1_1.toString());
                        }
                        var5_5 = var1_1.readByte();
                        if (var5_5 == -39 || var5_5 == -38) break;
                        var4_4 = var1_1.readUnsignedShort() - 2;
                        var6_6 = var2_2 + 1 + 1 + 2;
                        if (var4_4 < 0) {
                            throw new IOException("Invalid length");
                        }
                        if (var5_5 == -31) break block29;
                        if (var5_5 == -2) break block30;
                        block0 : switch (var5_5) {
                            default: {
                                switch (var5_5) {
                                    default: {
                                        switch (var5_5) {
                                            default: {
                                                switch (var5_5) {
                                                    default: {
                                                        var2_2 = var4_4;
                                                        var4_4 = var6_6;
                                                        break block0;
                                                    }
                                                    case -51: 
                                                    case -50: 
                                                    case -49: 
                                                }
                                            }
                                            case -55: 
                                            case -54: 
                                            case -53: 
                                        }
                                    }
                                    case -59: 
                                    case -58: 
                                    case -57: 
                                }
                            }
                            case -64: 
                            case -63: 
                            case -62: 
                            case -61: {
                                if (var1_1.skipBytes(1) != 1) {
                                    throw new IOException("Invalid SOFx");
                                }
                                this.mAttributes[var3_3].put("ImageLength", ExifAttribute.createULong(var1_1.readUnsignedShort(), this.mExifByteOrder));
                                this.mAttributes[var3_3].put("ImageWidth", ExifAttribute.createULong(var1_1.readUnsignedShort(), this.mExifByteOrder));
                                var2_2 = var4_4 - 5;
                                var4_4 = var6_6;
                                break;
                            }
                        }
                        break block31;
                    }
                    var7_7 = new byte[var4_4];
                    if (var1_1.read(var7_7) != var4_4) {
                        throw new IOException("Invalid exif");
                    }
                    var4_4 = var6_6;
                    if (this.getAttribute("UserComment") == null) {
                        this.mAttributes[1].put("UserComment", ExifAttribute.createString(new String(var7_7, ExifInterface.ASCII)));
                        var4_4 = var6_6;
                    }
                    ** GOTO lbl91
                }
                if (var4_4 < 6) {
                    var2_2 = var4_4;
                    var4_4 = var6_6;
                } else {
                    var7_7 = new byte[6];
                    if (var1_1.read(var7_7) != 6) {
                        throw new IOException("Invalid exif");
                    }
                    var6_6 += 6;
                    var2_2 = var4_4 - 6;
                    if (!Arrays.equals(var7_7, ExifInterface.IDENTIFIER_EXIF_APP1)) {
                        var4_4 = var6_6;
                    } else {
                        if (var2_2 <= 0) {
                            throw new IOException("Invalid exif");
                        }
                        this.mExifOffset = var6_6;
                        var7_7 = new byte[var2_2];
                        if (var1_1.read(var7_7) != var2_2) {
                            throw new IOException("Invalid exif");
                        }
                        var4_4 = var6_6 + var2_2;
                        this.readExifSegment(var7_7, var3_3);
lbl91:
                        // 2 sources

                        var2_2 = 0;
                    }
                }
            }
            if (var2_2 < 0) {
                throw new IOException("Invalid length");
            }
            if (var1_1.skipBytes(var2_2) != var2_2) {
                throw new IOException("Invalid JPEG segment");
            }
            var2_2 = var4_4 + var2_2;
        }
        var1_1.setByteOrder(this.mExifByteOrder);
    }

    private int getMimeType(BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.mark(5000);
        byte[] byArray = new byte[5000];
        bufferedInputStream.read(byArray);
        bufferedInputStream.reset();
        if (ExifInterface.isJpegFormat(byArray)) {
            return 4;
        }
        if (this.isRafFormat(byArray)) {
            return 9;
        }
        if (this.isOrfFormat(byArray)) {
            return 7;
        }
        if (this.isRw2Format(byArray)) {
            return 10;
        }
        return 0;
    }

    private void getOrfAttributes(ByteOrderedDataInputStream object) throws IOException {
        this.getRawAttributes((ByteOrderedDataInputStream)object);
        object = this.mAttributes[1].get(TAG_MAKER_NOTE);
        if (object != null) {
            ByteOrderedDataInputStream byteOrderedDataInputStream = new ByteOrderedDataInputStream(((ExifAttribute)object).bytes);
            byteOrderedDataInputStream.setByteOrder(this.mExifByteOrder);
            Object object2 = ORF_MAKER_NOTE_HEADER_1;
            byte[] byArray = new byte[((byte[])object2).length];
            byteOrderedDataInputStream.readFully(byArray);
            byteOrderedDataInputStream.seek(0L);
            object = ORF_MAKER_NOTE_HEADER_2;
            byte[] byArray2 = new byte[((Object)object).length];
            byteOrderedDataInputStream.readFully(byArray2);
            if (Arrays.equals(byArray, object2)) {
                byteOrderedDataInputStream.seek(8L);
            } else if (Arrays.equals(byArray2, (byte[])object)) {
                byteOrderedDataInputStream.seek(12L);
            }
            this.readImageFileDirectory(byteOrderedDataInputStream, 6);
            object = this.mAttributes[7].get(TAG_ORF_PREVIEW_IMAGE_START);
            object2 = this.mAttributes[7].get(TAG_ORF_PREVIEW_IMAGE_LENGTH);
            if (object != null && object2 != null) {
                this.mAttributes[5].put(TAG_JPEG_INTERCHANGE_FORMAT, (ExifAttribute)object);
                this.mAttributes[5].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, (ExifAttribute)object2);
            }
            if ((object = this.mAttributes[8].get(TAG_ORF_ASPECT_FRAME)) != null) {
                object2 = (int[])((ExifAttribute)object).getValue(this.mExifByteOrder);
                if (object2 != null && ((byte[])object2).length == 4) {
                    if (object2[2] > object2[0] && object2[3] > object2[1]) {
                        int n = object2[2] - object2[0] + 1;
                        int n2 = object2[3] - object2[1] + 1;
                        int n3 = n;
                        int n4 = n2;
                        if (n < n2) {
                            n3 = n + n2;
                            n4 = n3 - n2;
                            n3 -= n4;
                        }
                        object2 = ExifAttribute.createUShort(n3, this.mExifByteOrder);
                        object = ExifAttribute.createUShort(n4, this.mExifByteOrder);
                        this.mAttributes[0].put(TAG_IMAGE_WIDTH, (ExifAttribute)object2);
                        this.mAttributes[0].put(TAG_IMAGE_LENGTH, (ExifAttribute)object);
                    }
                } else {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid aspect frame values. frame=");
                    ((StringBuilder)object).append(Arrays.toString((int[])object2));
                    Log.w((String)TAG, (String)((StringBuilder)object).toString());
                }
            }
        }
    }

    private void getRafAttributes(ByteOrderedDataInputStream object) throws IOException {
        ((ByteOrderedDataInputStream)object).skipBytes(84);
        Object object2 = new byte[4];
        byte[] byArray = new byte[4];
        ((InputStream)object).read((byte[])object2);
        ((ByteOrderedDataInputStream)object).skipBytes(4);
        ((InputStream)object).read(byArray);
        int n = ByteBuffer.wrap(object2).getInt();
        int n2 = ByteBuffer.wrap(byArray).getInt();
        this.getJpegAttributes((ByteOrderedDataInputStream)object, n, 5);
        ((ByteOrderedDataInputStream)object).seek(n2);
        ((ByteOrderedDataInputStream)object).setByteOrder(ByteOrder.BIG_ENDIAN);
        n = ((ByteOrderedDataInputStream)object).readInt();
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = ((ByteOrderedDataInputStream)object).readUnsignedShort();
            int n4 = ((ByteOrderedDataInputStream)object).readUnsignedShort();
            if (n3 == ExifInterface.TAG_RAF_IMAGE_SIZE.number) {
                n = ((ByteOrderedDataInputStream)object).readShort();
                n2 = ((ByteOrderedDataInputStream)object).readShort();
                object2 = ExifAttribute.createUShort(n, this.mExifByteOrder);
                object = ExifAttribute.createUShort(n2, this.mExifByteOrder);
                this.mAttributes[0].put(TAG_IMAGE_LENGTH, (ExifAttribute)object2);
                this.mAttributes[0].put(TAG_IMAGE_WIDTH, (ExifAttribute)object);
                return;
            }
            ((ByteOrderedDataInputStream)object).skipBytes(n4);
        }
    }

    private void getRawAttributes(ByteOrderedDataInputStream object) throws IOException {
        this.parseTiffHeaders((ByteOrderedDataInputStream)object, ((ByteOrderedDataInputStream)object).available());
        this.readImageFileDirectory((ByteOrderedDataInputStream)object, 0);
        this.updateImageSizeValues((ByteOrderedDataInputStream)object, 0);
        this.updateImageSizeValues((ByteOrderedDataInputStream)object, 5);
        this.updateImageSizeValues((ByteOrderedDataInputStream)object, 4);
        this.validateImages((InputStream)object);
        if (this.mMimeType == 8 && (object = this.mAttributes[1].get(TAG_MAKER_NOTE)) != null) {
            object = new ByteOrderedDataInputStream(((ExifAttribute)object).bytes);
            ((ByteOrderedDataInputStream)object).setByteOrder(this.mExifByteOrder);
            ((ByteOrderedDataInputStream)object).seek(6L);
            this.readImageFileDirectory((ByteOrderedDataInputStream)object, 9);
            object = this.mAttributes[9].get(TAG_COLOR_SPACE);
            if (object != null) {
                this.mAttributes[1].put(TAG_COLOR_SPACE, (ExifAttribute)object);
            }
        }
    }

    private void getRw2Attributes(ByteOrderedDataInputStream object) throws IOException {
        this.getRawAttributes((ByteOrderedDataInputStream)object);
        if (this.mAttributes[0].get(TAG_RW2_JPG_FROM_RAW) != null) {
            this.getJpegAttributes((ByteOrderedDataInputStream)object, this.mRw2JpgFromRawOffset, 5);
        }
        object = this.mAttributes[0].get(TAG_RW2_ISO);
        ExifAttribute exifAttribute = this.mAttributes[1].get(TAG_PHOTOGRAPHIC_SENSITIVITY);
        if (object != null && exifAttribute == null) {
            this.mAttributes[1].put(TAG_PHOTOGRAPHIC_SENSITIVITY, (ExifAttribute)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Integer, Integer> guessDataFormat(String pair) {
        boolean bl = pair.contains(",");
        int n = 1;
        Integer n2 = 2;
        Integer n3 = -1;
        if (bl) {
            Pair pair2;
            String[] stringArray = pair.split(",", -1);
            pair = pair2 = ExifInterface.guessDataFormat(stringArray[0]);
            if ((Integer)pair2.first == 2) {
                return pair2;
            }
            while (n < stringArray.length) {
                pair2 = ExifInterface.guessDataFormat(stringArray[n]);
                int n4 = !((Integer)pair2.first).equals(pair.first) && !((Integer)pair2.second).equals(pair.first) ? -1 : (Integer)pair.first;
                int n5 = (Integer)pair.second != -1 && (((Integer)pair2.first).equals(pair.second) || ((Integer)pair2.second).equals(pair.second)) ? (Integer)pair.second : -1;
                if (n4 == -1 && n5 == -1) {
                    return new Pair((Object)n2, (Object)n3);
                }
                if (n4 == -1) {
                    pair = new Pair((Object)n5, (Object)n3);
                } else if (n5 == -1) {
                    pair = new Pair((Object)n4, (Object)n3);
                }
                ++n;
            }
            return pair;
        }
        if (pair.contains("/")) {
            if (((String[])(pair = pair.split("/", -1))).length != 2) return new Pair((Object)n2, (Object)n3);
            try {
                long l = (long)Double.parseDouble(pair[0]);
                long l2 = (long)Double.parseDouble((String)pair[1]);
                if (l < 0L) return new Pair((Object)10, (Object)n3);
                if (l2 < 0L) return new Pair((Object)10, (Object)n3);
                if (l > Integer.MAX_VALUE) return new Pair((Object)5, (Object)n3);
                if (l2 <= Integer.MAX_VALUE) return new Pair((Object)10, (Object)5);
                return new Pair((Object)5, (Object)n3);
            }
            catch (NumberFormatException numberFormatException) {
                return new Pair((Object)n2, (Object)n3);
            }
        }
        try {
            Long l = Long.parseLong((String)pair);
            if (l >= 0L && l <= 65535L) {
                return new Pair((Object)3, (Object)4);
            }
            if (l >= 0L) return new Pair((Object)4, (Object)n3);
            return new Pair((Object)9, (Object)n3);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble((String)pair);
                return new Pair((Object)12, (Object)n3);
            }
            catch (NumberFormatException numberFormatException2) {
                return new Pair((Object)n2, (Object)n3);
            }
        }
    }

    private void handleThumbnailFromJfif(ByteOrderedDataInputStream byteOrderedDataInputStream, HashMap object) throws IOException {
        block2: {
            int n;
            int n2;
            block4: {
                int n3;
                block5: {
                    block3: {
                        ExifAttribute exifAttribute = (ExifAttribute)((HashMap)object).get(TAG_JPEG_INTERCHANGE_FORMAT);
                        object = (ExifAttribute)((HashMap)object).get(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
                        if (exifAttribute == null || object == null) break block2;
                        n3 = exifAttribute.getIntValue(this.mExifByteOrder);
                        n2 = Math.min(((ExifAttribute)object).getIntValue(this.mExifByteOrder), byteOrderedDataInputStream.available() - n3);
                        int n4 = this.mMimeType;
                        if (n4 == 4 || n4 == 9 || n4 == 10) break block3;
                        n = n3;
                        if (n4 != 7) break block4;
                        n = this.mOrfMakerNoteOffset;
                        break block5;
                    }
                    n = this.mExifOffset;
                }
                n = n3 + n;
            }
            if (n > 0 && n2 > 0) {
                this.mHasThumbnail = true;
                this.mThumbnailOffset = n;
                this.mThumbnailLength = n2;
                if (this.mFilename == null && this.mAssetInputStream == null) {
                    object = new byte[n2];
                    byteOrderedDataInputStream.seek(n);
                    byteOrderedDataInputStream.readFully((byte[])object);
                    this.mThumbnailBytes = (byte[])object;
                }
            }
        }
    }

    private void handleThumbnailFromStrips(ByteOrderedDataInputStream byteOrderedDataInputStream, HashMap object) throws IOException {
        Object object2 = (ExifAttribute)((HashMap)object).get(TAG_STRIP_OFFSETS);
        Object object3 = (ExifAttribute)((HashMap)object).get(TAG_STRIP_BYTE_COUNTS);
        if (object2 != null && object3 != null) {
            int n;
            object = ExifInterface.convertToLongArray(((ExifAttribute)object2).getValue(this.mExifByteOrder));
            object2 = ExifInterface.convertToLongArray(((ExifAttribute)object3).getValue(this.mExifByteOrder));
            if (object == null) {
                Log.w((String)TAG, (String)"stripOffsets should not be null.");
                return;
            }
            if (object2 == null) {
                Log.w((String)TAG, (String)"stripByteCounts should not be null.");
                return;
            }
            long l = 0L;
            int n2 = ((Object)object2).length;
            for (n = 0; n < n2; ++n) {
                l += object2[n];
            }
            int n3 = (int)l;
            object3 = new byte[n3];
            int n4 = 0;
            n = 0;
            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                int n5 = (int)object[n2];
                int n6 = (int)object2[n2];
                if ((n5 -= n4) < 0) {
                    Log.d((String)TAG, (String)"Invalid strip offset value");
                }
                byteOrderedDataInputStream.seek(n5);
                byte[] byArray = new byte[n6];
                byteOrderedDataInputStream.read(byArray);
                n4 = n4 + n5 + n6;
                System.arraycopy(byArray, 0, object3, n, n6);
                n += n6;
            }
            this.mHasThumbnail = true;
            this.mThumbnailBytes = (byte[])object3;
            this.mThumbnailLength = n3;
        }
    }

    private static boolean isJpegFormat(byte[] byArray) throws IOException {
        byte[] byArray2;
        for (int i = 0; i < (byArray2 = JPEG_SIGNATURE).length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isOrfFormat(byte[] object) throws IOException {
        ByteOrderedDataInputStream byteOrderedDataInputStream = new ByteOrderedDataInputStream((byte[])object);
        object = this.readByteOrder(byteOrderedDataInputStream);
        this.mExifByteOrder = object;
        byteOrderedDataInputStream.setByteOrder((ByteOrder)object);
        short s = byteOrderedDataInputStream.readShort();
        byteOrderedDataInputStream.close();
        boolean bl = s == 20306 || s == 21330;
        return bl;
    }

    private boolean isRafFormat(byte[] byArray) throws IOException {
        byte[] byArray2 = RAF_SIGNATURE.getBytes(Charset.defaultCharset());
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isRw2Format(byte[] object) throws IOException {
        ByteOrder byteOrder;
        object = new ByteOrderedDataInputStream((byte[])object);
        this.mExifByteOrder = byteOrder = this.readByteOrder((ByteOrderedDataInputStream)object);
        ((ByteOrderedDataInputStream)object).setByteOrder(byteOrder);
        short s = ((ByteOrderedDataInputStream)object).readShort();
        ((InputStream)object).close();
        boolean bl = s == 85;
        return bl;
    }

    private boolean isSupportedDataType(HashMap object) throws IOException {
        Object object2 = (ExifAttribute)((HashMap)object).get(TAG_BITS_PER_SAMPLE);
        if (object2 != null) {
            int n;
            int[] nArray = BITS_PER_SAMPLE_RGB;
            if (Arrays.equals(nArray, (int[])(object2 = (Object)((int[])((ExifAttribute)object2).getValue(this.mExifByteOrder))))) {
                return true;
            }
            if (this.mMimeType == 3 && (object = (ExifAttribute)((HashMap)object).get(TAG_PHOTOMETRIC_INTERPRETATION)) != null && ((n = ((ExifAttribute)object).getIntValue(this.mExifByteOrder)) == 1 && Arrays.equals((int[])object2, BITS_PER_SAMPLE_GREYSCALE_2) || n == 6 && Arrays.equals((int[])object2, nArray))) {
                return true;
            }
        }
        return false;
    }

    private boolean isThumbnail(HashMap object) throws IOException {
        ExifAttribute exifAttribute = (ExifAttribute)((HashMap)object).get(TAG_IMAGE_LENGTH);
        object = (ExifAttribute)((HashMap)object).get(TAG_IMAGE_WIDTH);
        if (exifAttribute != null && object != null) {
            int n = exifAttribute.getIntValue(this.mExifByteOrder);
            int n2 = ((ExifAttribute)object).getIntValue(this.mExifByteOrder);
            if (n <= 512 && n2 <= 512) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAttributes(InputStream inputStream) throws IOException {
        Throwable throwable22;
        block14: {
            try {
                for (int i = 0; i < EXIF_TAGS.length; ++i) {
                    this.mAttributes[i] = new HashMap();
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 5000);
                inputStream = bufferedInputStream;
                this.mMimeType = this.getMimeType(bufferedInputStream);
                inputStream = new ByteOrderedDataInputStream(bufferedInputStream);
                switch (this.mMimeType) {
                    default: {
                        break;
                    }
                    case 10: {
                        this.getRw2Attributes((ByteOrderedDataInputStream)inputStream);
                        break;
                    }
                    case 9: {
                        this.getRafAttributes((ByteOrderedDataInputStream)inputStream);
                        break;
                    }
                    case 7: {
                        this.getOrfAttributes((ByteOrderedDataInputStream)inputStream);
                        break;
                    }
                    case 4: {
                        this.getJpegAttributes((ByteOrderedDataInputStream)inputStream, 0, 0);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 11: {
                        this.getRawAttributes((ByteOrderedDataInputStream)inputStream);
                    }
                }
                this.setThumbnailData((ByteOrderedDataInputStream)inputStream);
                this.mIsSupportedFile = true;
            }
            catch (Throwable throwable22) {
                break block14;
            }
            catch (IOException iOException) {
                this.mIsSupportedFile = false;
            }
            this.addDefaultValuesForCompatibility();
            return;
        }
        this.addDefaultValuesForCompatibility();
        throw throwable22;
    }

    private void parseTiffHeaders(ByteOrderedDataInputStream object, int n) throws IOException {
        ByteOrder byteOrder;
        this.mExifByteOrder = byteOrder = this.readByteOrder((ByteOrderedDataInputStream)object);
        ((ByteOrderedDataInputStream)object).setByteOrder(byteOrder);
        int n2 = ((ByteOrderedDataInputStream)object).readUnsignedShort();
        int n3 = this.mMimeType;
        if (n3 != 7 && n3 != 10 && n2 != 42) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid start code: ");
            ((StringBuilder)object).append(Integer.toHexString(n2));
            throw new IOException(((StringBuilder)object).toString());
        }
        n2 = ((ByteOrderedDataInputStream)object).readInt();
        if (n2 >= 8 && n2 < n) {
            n = n2 - 8;
            if (n > 0 && ((ByteOrderedDataInputStream)object).skipBytes(n) != n) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Couldn't jump to first Ifd: ");
                ((StringBuilder)object).append(n);
                throw new IOException(((StringBuilder)object).toString());
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid first Ifd offset: ");
        ((StringBuilder)object).append(n2);
        throw new IOException(((StringBuilder)object).toString());
    }

    private void printAttributes() {
        for (int i = 0; i < this.mAttributes.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The size of tag group[");
            stringBuilder.append(i);
            stringBuilder.append("]: ");
            stringBuilder.append(this.mAttributes[i].size());
            Log.d((String)TAG, (String)stringBuilder.toString());
            for (Map.Entry<String, ExifAttribute> entry : this.mAttributes[i].entrySet()) {
                ExifAttribute exifAttribute = entry.getValue();
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("tagName: ");
                stringBuilder2.append(entry.getKey());
                stringBuilder2.append(", tagType: ");
                stringBuilder2.append(exifAttribute.toString());
                stringBuilder2.append(", tagValue: '");
                stringBuilder2.append(exifAttribute.getStringValue(this.mExifByteOrder));
                stringBuilder2.append("'");
                Log.d((String)TAG, (String)stringBuilder2.toString());
            }
        }
    }

    private ByteOrder readByteOrder(ByteOrderedDataInputStream object) throws IOException {
        short s = ((ByteOrderedDataInputStream)object).readShort();
        if (s != 18761) {
            if (s == 19789) {
                return ByteOrder.BIG_ENDIAN;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid byte order: ");
            ((StringBuilder)object).append(Integer.toHexString(s));
            throw new IOException(((StringBuilder)object).toString());
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    private void readExifSegment(byte[] byArray, int n) throws IOException {
        ByteOrderedDataInputStream byteOrderedDataInputStream = new ByteOrderedDataInputStream(byArray);
        this.parseTiffHeaders(byteOrderedDataInputStream, byArray.length);
        this.readImageFileDirectory(byteOrderedDataInputStream, n);
    }

    private void readImageFileDirectory(ByteOrderedDataInputStream object, int n) throws IOException {
        block27: {
            long l;
            this.mAttributesOffsets.add(((ByteOrderedDataInputStream)object).mPosition);
            if (((ByteOrderedDataInputStream)object).mPosition + 2 > ((ByteOrderedDataInputStream)object).mLength) {
                return;
            }
            short s = ((ByteOrderedDataInputStream)object).readShort();
            if (((ByteOrderedDataInputStream)object).mPosition + s * 12 > ((ByteOrderedDataInputStream)object).mLength || s <= 0) break block27;
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                int n2;
                Object object2;
                Object object3;
                long l2;
                int n3;
                block35: {
                    block39: {
                        block40: {
                            block36: {
                                block37: {
                                    block38: {
                                        int n4;
                                        int n5;
                                        block33: {
                                            block34: {
                                                block29: {
                                                    block30: {
                                                        block32: {
                                                            block31: {
                                                                block28: {
                                                                    n5 = ((ByteOrderedDataInputStream)object).readUnsignedShort();
                                                                    n4 = ((ByteOrderedDataInputStream)object).readUnsignedShort();
                                                                    n3 = ((ByteOrderedDataInputStream)object).readInt();
                                                                    l2 = (long)((ByteOrderedDataInputStream)object).peek() + 4L;
                                                                    object3 = sExifTagMapsForReading[n].get(n5);
                                                                    if (object3 != null) break block28;
                                                                    object2 = new StringBuilder();
                                                                    ((StringBuilder)object2).append("Skip the tag entry since tag number is not defined: ");
                                                                    ((StringBuilder)object2).append(n5);
                                                                    Log.w((String)TAG, (String)((StringBuilder)object2).toString());
                                                                    break block29;
                                                                }
                                                                if (n4 <= 0 || n4 >= ((Object)(object2 = (Object)IFD_FORMAT_BYTES_PER_FORMAT)).length) break block30;
                                                                if (((ExifTag)object3).isFormatCompatible(n4)) break block31;
                                                                object2 = new StringBuilder();
                                                                ((StringBuilder)object2).append("Skip the tag entry since data format (");
                                                                ((StringBuilder)object2).append(IFD_FORMAT_NAMES[n4]);
                                                                ((StringBuilder)object2).append(") is unexpected for tag: ");
                                                                ((StringBuilder)object2).append(((ExifTag)object3).name);
                                                                Log.w((String)TAG, (String)((StringBuilder)object2).toString());
                                                                break block29;
                                                            }
                                                            n2 = n4;
                                                            if (n4 == 7) {
                                                                n2 = ((ExifTag)object3).primaryFormat;
                                                            }
                                                            l = n3;
                                                            if ((l = (long)object2[n2] * l) < 0L || l > Integer.MAX_VALUE) break block32;
                                                            n4 = 1;
                                                            break block33;
                                                        }
                                                        object2 = new StringBuilder();
                                                        ((StringBuilder)object2).append("Skip the tag entry since the number of components is invalid: ");
                                                        ((StringBuilder)object2).append(n3);
                                                        Log.w((String)TAG, (String)((StringBuilder)object2).toString());
                                                        break block34;
                                                    }
                                                    object2 = new StringBuilder();
                                                    ((StringBuilder)object2).append("Skip the tag entry since data format is invalid: ");
                                                    ((StringBuilder)object2).append(n4);
                                                    Log.w((String)TAG, (String)((StringBuilder)object2).toString());
                                                }
                                                l = 0L;
                                                n2 = n4;
                                            }
                                            n4 = 0;
                                        }
                                        if (n4 == 0) {
                                            ((ByteOrderedDataInputStream)object).seek(l2);
                                            continue;
                                        }
                                        if (l > 4L) {
                                            int n6 = ((ByteOrderedDataInputStream)object).readInt();
                                            n4 = this.mMimeType;
                                            if (n4 == 7) {
                                                if (TAG_MAKER_NOTE.equals(((ExifTag)object3).name)) {
                                                    this.mOrfMakerNoteOffset = n6;
                                                } else if (n == 6 && TAG_ORF_THUMBNAIL_IMAGE.equals(((ExifTag)object3).name)) {
                                                    this.mOrfThumbnailOffset = n6;
                                                    this.mOrfThumbnailLength = n3;
                                                    ExifAttribute exifAttribute = ExifAttribute.createUShort(6, this.mExifByteOrder);
                                                    object2 = ExifAttribute.createULong(this.mOrfThumbnailOffset, this.mExifByteOrder);
                                                    ExifAttribute exifAttribute2 = ExifAttribute.createULong(this.mOrfThumbnailLength, this.mExifByteOrder);
                                                    this.mAttributes[4].put(TAG_COMPRESSION, exifAttribute);
                                                    this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT, (ExifAttribute)object2);
                                                    this.mAttributes[4].put(TAG_JPEG_INTERCHANGE_FORMAT_LENGTH, exifAttribute2);
                                                }
                                            } else if (n4 == 10 && TAG_RW2_JPG_FROM_RAW.equals(((ExifTag)object3).name)) {
                                                this.mRw2JpgFromRawOffset = n6;
                                            }
                                            long l3 = n6;
                                            if (l3 + l <= (long)((ByteOrderedDataInputStream)object).mLength) {
                                                ((ByteOrderedDataInputStream)object).seek(l3);
                                            } else {
                                                object3 = new StringBuilder();
                                                ((StringBuilder)object3).append("Skip the tag entry since data offset is invalid: ");
                                                ((StringBuilder)object3).append(n6);
                                                Log.w((String)TAG, (String)((StringBuilder)object3).toString());
                                                ((ByteOrderedDataInputStream)object).seek(l2);
                                                continue;
                                            }
                                        }
                                        if ((object2 = sExifPointerTagMap.get(n5)) == null) break block35;
                                        l = -1L;
                                        if (n2 == 3) break block36;
                                        if (n2 == 4) break block37;
                                        if (n2 == 8) break block38;
                                        if (n2 != 9 && n2 != 13) break block39;
                                        n2 = ((ByteOrderedDataInputStream)object).readInt();
                                        break block40;
                                    }
                                    n2 = ((ByteOrderedDataInputStream)object).readShort();
                                    break block40;
                                }
                                l = ((ByteOrderedDataInputStream)object).readUnsignedInt();
                                break block39;
                            }
                            n2 = ((ByteOrderedDataInputStream)object).readUnsignedShort();
                        }
                        l = n2;
                    }
                    if (l > 0L && l < (long)((ByteOrderedDataInputStream)object).mLength) {
                        if (!this.mAttributesOffsets.contains((int)l)) {
                            ((ByteOrderedDataInputStream)object).seek(l);
                            this.readImageFileDirectory((ByteOrderedDataInputStream)object, (Integer)object2);
                        } else {
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("Skip jump into the IFD since it has already been read: IfdType ");
                            ((StringBuilder)object3).append(object2);
                            ((StringBuilder)object3).append(" (at ");
                            ((StringBuilder)object3).append(l);
                            ((StringBuilder)object3).append(")");
                            Log.w((String)TAG, (String)((StringBuilder)object3).toString());
                        }
                    } else {
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("Skip jump into the IFD since its offset is invalid: ");
                        ((StringBuilder)object3).append(l);
                        Log.w((String)TAG, (String)((StringBuilder)object3).toString());
                    }
                    ((ByteOrderedDataInputStream)object).seek(l2);
                    continue;
                }
                object2 = new byte[(int)l];
                ((ByteOrderedDataInputStream)object).readFully((byte[])object2);
                object2 = new ExifAttribute(n2, n3, (byte[])object2);
                this.mAttributes[n].put(((ExifTag)object3).name, (ExifAttribute)object2);
                if (TAG_DNG_VERSION.equals(((ExifTag)object3).name)) {
                    this.mMimeType = 3;
                }
                if ((TAG_MAKE.equals(((ExifTag)object3).name) || TAG_MODEL.equals(((ExifTag)object3).name)) && ((ExifAttribute)object2).getStringValue(this.mExifByteOrder).contains(PEF_SIGNATURE) || TAG_COMPRESSION.equals(((ExifTag)object3).name) && ((ExifAttribute)object2).getIntValue(this.mExifByteOrder) == 65535) {
                    this.mMimeType = 8;
                }
                if ((long)((ByteOrderedDataInputStream)object).peek() == l2) continue;
                ((ByteOrderedDataInputStream)object).seek(l2);
            }
            if (((ByteOrderedDataInputStream)object).peek() + 4 <= ((ByteOrderedDataInputStream)object).mLength) {
                n = ((ByteOrderedDataInputStream)object).readInt();
                l = n;
                if (l > 0L && n < ((ByteOrderedDataInputStream)object).mLength) {
                    if (!this.mAttributesOffsets.contains(n)) {
                        ((ByteOrderedDataInputStream)object).seek(l);
                        if (this.mAttributes[4].isEmpty()) {
                            this.readImageFileDirectory((ByteOrderedDataInputStream)object, 4);
                        } else if (this.mAttributes[5].isEmpty()) {
                            this.readImageFileDirectory((ByteOrderedDataInputStream)object, 5);
                        }
                    } else {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Stop reading file since re-reading an IFD may cause an infinite loop: ");
                        ((StringBuilder)object).append(n);
                        Log.w((String)TAG, (String)((StringBuilder)object).toString());
                    }
                } else {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Stop reading file since a wrong offset may cause an infinite loop: ");
                    ((StringBuilder)object).append(n);
                    Log.w((String)TAG, (String)((StringBuilder)object).toString());
                }
            }
        }
    }

    private void removeAttribute(String string2) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            this.mAttributes[i].remove(string2);
        }
    }

    private void retrieveJpegImageSize(ByteOrderedDataInputStream byteOrderedDataInputStream, int n) throws IOException {
        ExifAttribute exifAttribute = this.mAttributes[n].get(TAG_IMAGE_LENGTH);
        ExifAttribute exifAttribute2 = this.mAttributes[n].get(TAG_IMAGE_WIDTH);
        if ((exifAttribute == null || exifAttribute2 == null) && (exifAttribute2 = this.mAttributes[n].get(TAG_JPEG_INTERCHANGE_FORMAT)) != null) {
            this.getJpegAttributes(byteOrderedDataInputStream, exifAttribute2.getIntValue(this.mExifByteOrder), n);
        }
    }

    private void saveJpegAttributes(InputStream inputStream, OutputStream object) throws IOException {
        inputStream = new DataInputStream(inputStream);
        ByteOrderedDataOutputStream byteOrderedDataOutputStream = new ByteOrderedDataOutputStream((OutputStream)object, ByteOrder.BIG_ENDIAN);
        if (((DataInputStream)inputStream).readByte() == -1) {
            byteOrderedDataOutputStream.writeByte(-1);
            if (((DataInputStream)inputStream).readByte() == -40) {
                byteOrderedDataOutputStream.writeByte(-40);
                byteOrderedDataOutputStream.writeByte(-1);
                byteOrderedDataOutputStream.writeByte(-31);
                this.writeExifSegment(byteOrderedDataOutputStream, 6);
                byte[] byArray = new byte[4096];
                while (((DataInputStream)inputStream).readByte() == -1) {
                    int n = ((DataInputStream)inputStream).readByte();
                    if (n != -39 && n != -38) {
                        int n2;
                        if (n != -31) {
                            byteOrderedDataOutputStream.writeByte(-1);
                            byteOrderedDataOutputStream.writeByte(n);
                            n = ((DataInputStream)inputStream).readUnsignedShort();
                            byteOrderedDataOutputStream.writeUnsignedShort(n);
                            if ((n -= 2) >= 0) {
                                while (n > 0 && (n2 = ((DataInputStream)inputStream).read(byArray, 0, Math.min(n, 4096))) >= 0) {
                                    byteOrderedDataOutputStream.write(byArray, 0, n2);
                                    n -= n2;
                                }
                                continue;
                            }
                            throw new IOException("Invalid length");
                        }
                        n2 = ((DataInputStream)inputStream).readUnsignedShort() - 2;
                        if (n2 >= 0) {
                            object = new byte[6];
                            if (n2 >= 6) {
                                if (((DataInputStream)inputStream).read((byte[])object) == 6) {
                                    if (Arrays.equals((byte[])object, IDENTIFIER_EXIF_APP1)) {
                                        n = n2 - 6;
                                        if (((DataInputStream)inputStream).skipBytes(n) == n) continue;
                                        throw new IOException("Invalid length");
                                    }
                                } else {
                                    throw new IOException("Invalid exif");
                                }
                            }
                            byteOrderedDataOutputStream.writeByte(-1);
                            byteOrderedDataOutputStream.writeByte(n);
                            byteOrderedDataOutputStream.writeUnsignedShort(n2 + 2);
                            n = n2;
                            if (n2 >= 6) {
                                n = n2 - 6;
                                byteOrderedDataOutputStream.write((byte[])object);
                            }
                            while (n > 0 && (n2 = ((DataInputStream)inputStream).read(byArray, 0, Math.min(n, 4096))) >= 0) {
                                byteOrderedDataOutputStream.write(byArray, 0, n2);
                                n -= n2;
                            }
                            continue;
                        }
                        throw new IOException("Invalid length");
                    }
                    byteOrderedDataOutputStream.writeByte(-1);
                    byteOrderedDataOutputStream.writeByte(n);
                    ExifInterface.copy(inputStream, byteOrderedDataOutputStream);
                    return;
                }
                throw new IOException("Invalid marker");
            }
            throw new IOException("Invalid marker");
        }
        throw new IOException("Invalid marker");
    }

    private void setThumbnailData(ByteOrderedDataInputStream byteOrderedDataInputStream) throws IOException {
        block4: {
            HashMap<String, ExifAttribute> hashMap;
            block1: {
                block2: {
                    block3: {
                        int n;
                        hashMap = this.mAttributes[4];
                        ExifAttribute exifAttribute = hashMap.get(TAG_COMPRESSION);
                        if (exifAttribute == null) break block1;
                        this.mThumbnailCompression = n = exifAttribute.getIntValue(this.mExifByteOrder);
                        if (n == 1) break block2;
                        if (n == 6) break block3;
                        if (n == 7) break block2;
                        break block4;
                    }
                    this.handleThumbnailFromJfif(byteOrderedDataInputStream, hashMap);
                    break block4;
                }
                if (this.isSupportedDataType(hashMap)) {
                    this.handleThumbnailFromStrips(byteOrderedDataInputStream, hashMap);
                }
                break block4;
            }
            this.mThumbnailCompression = 6;
            this.handleThumbnailFromJfif(byteOrderedDataInputStream, hashMap);
        }
    }

    private void swapBasedOnImageSize(int n, int n2) throws IOException {
        if (!this.mAttributes[n].isEmpty() && !this.mAttributes[n2].isEmpty()) {
            HashMap<String, ExifAttribute>[] hashMapArray = this.mAttributes[n].get(TAG_IMAGE_LENGTH);
            ExifAttribute exifAttribute = this.mAttributes[n].get(TAG_IMAGE_WIDTH);
            Object object = this.mAttributes[n2].get(TAG_IMAGE_LENGTH);
            ExifAttribute exifAttribute2 = this.mAttributes[n2].get(TAG_IMAGE_WIDTH);
            if (hashMapArray != null && exifAttribute != null && object != null && exifAttribute2 != null) {
                int n3 = hashMapArray.getIntValue(this.mExifByteOrder);
                int n4 = exifAttribute.getIntValue(this.mExifByteOrder);
                int n5 = ((ExifAttribute)object).getIntValue(this.mExifByteOrder);
                int n6 = exifAttribute2.getIntValue(this.mExifByteOrder);
                if (n3 < n5 && n4 < n6) {
                    hashMapArray = this.mAttributes;
                    object = hashMapArray[n];
                    hashMapArray[n] = hashMapArray[n2];
                    hashMapArray[n2] = object;
                }
            }
        }
    }

    private boolean updateAttribute(String string2, ExifAttribute exifAttribute) {
        boolean bl = false;
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            if (!this.mAttributes[i].containsKey(string2)) continue;
            this.mAttributes[i].put(string2, exifAttribute);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void updateImageSizeValues(ByteOrderedDataInputStream object, int n) throws IOException {
        ExifAttribute exifAttribute;
        ExifAttribute exifAttribute2;
        ExifAttribute exifAttribute3;
        ExifAttribute exifAttribute4;
        block9: {
            int[] nArray;
            block10: {
                void var3_8;
                block8: {
                    ExifAttribute exifAttribute5 = this.mAttributes[n].get(TAG_DEFAULT_CROP_SIZE);
                    exifAttribute4 = this.mAttributes[n].get(TAG_RW2_SENSOR_TOP_BORDER);
                    exifAttribute3 = this.mAttributes[n].get(TAG_RW2_SENSOR_LEFT_BORDER);
                    exifAttribute2 = this.mAttributes[n].get(TAG_RW2_SENSOR_BOTTOM_BORDER);
                    exifAttribute = this.mAttributes[n].get(TAG_RW2_SENSOR_RIGHT_BORDER);
                    if (exifAttribute5 == null) break block9;
                    if (exifAttribute5.format == 5) {
                        Object[] objectArray = (Rational[])exifAttribute5.getValue(this.mExifByteOrder);
                        if (objectArray != null && objectArray.length == 2) {
                            object = ExifAttribute.createURational(objectArray[0], this.mExifByteOrder);
                            ExifAttribute exifAttribute6 = ExifAttribute.createURational((Rational)objectArray[1], this.mExifByteOrder);
                            break block8;
                        } else {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Invalid crop size values. cropSize=");
                            ((StringBuilder)object).append(Arrays.toString(objectArray));
                            Log.w((String)TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                    }
                    nArray = (int[])exifAttribute5.getValue(this.mExifByteOrder);
                    if (nArray == null || nArray.length != 2) break block10;
                    object = ExifAttribute.createUShort(nArray[0], this.mExifByteOrder);
                    ExifAttribute exifAttribute7 = ExifAttribute.createUShort(nArray[1], this.mExifByteOrder);
                }
                this.mAttributes[n].put(TAG_IMAGE_WIDTH, (ExifAttribute)object);
                this.mAttributes[n].put(TAG_IMAGE_LENGTH, (ExifAttribute)var3_8);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid crop size values. cropSize=");
            ((StringBuilder)object).append(Arrays.toString(nArray));
            Log.w((String)TAG, (String)((StringBuilder)object).toString());
            return;
        }
        if (exifAttribute4 != null && exifAttribute3 != null && exifAttribute2 != null && exifAttribute != null) {
            int n2 = exifAttribute4.getIntValue(this.mExifByteOrder);
            int n3 = exifAttribute2.getIntValue(this.mExifByteOrder);
            int n4 = exifAttribute.getIntValue(this.mExifByteOrder);
            int n5 = exifAttribute3.getIntValue(this.mExifByteOrder);
            if (n3 <= n2) return;
            if (n4 <= n5) return;
            object = ExifAttribute.createUShort(n3 - n2, this.mExifByteOrder);
            ExifAttribute exifAttribute8 = ExifAttribute.createUShort(n4 - n5, this.mExifByteOrder);
            this.mAttributes[n].put(TAG_IMAGE_LENGTH, (ExifAttribute)object);
            this.mAttributes[n].put(TAG_IMAGE_WIDTH, exifAttribute8);
            return;
        }
        this.retrieveJpegImageSize((ByteOrderedDataInputStream)object, n);
    }

    private void validateImages(InputStream hashMapArray) throws IOException {
        this.swapBasedOnImageSize(0, 5);
        this.swapBasedOnImageSize(0, 4);
        this.swapBasedOnImageSize(5, 4);
        hashMapArray = this.mAttributes[1].get(TAG_PIXEL_X_DIMENSION);
        ExifAttribute exifAttribute = this.mAttributes[1].get(TAG_PIXEL_Y_DIMENSION);
        if (hashMapArray != null && exifAttribute != null) {
            this.mAttributes[0].put(TAG_IMAGE_WIDTH, (ExifAttribute)hashMapArray);
            this.mAttributes[0].put(TAG_IMAGE_LENGTH, exifAttribute);
        }
        if (this.mAttributes[4].isEmpty() && this.isThumbnail(this.mAttributes[5])) {
            hashMapArray = this.mAttributes;
            hashMapArray[4] = hashMapArray[5];
            hashMapArray[5] = new HashMap();
        }
        if (!this.isThumbnail(this.mAttributes[4])) {
            Log.d((String)TAG, (String)"No image meets the size requirements of a thumbnail image.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int writeExifSegment(ByteOrderedDataOutputStream byteOrderedDataOutputStream, int n) throws IOException {
        void var10_21;
        int n2;
        int n3;
        Object object = EXIF_TAGS;
        int[] nArray = new int[((ExifTag[][])object).length];
        object = new int[((ExifTag[][])object).length];
        ExifTag[] object22 = EXIF_POINTER_TAGS;
        int n4 = object22.length;
        for (n3 = 0; n3 < n4; ++n3) {
            this.removeAttribute(object22[n3].name);
        }
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        for (n3 = 0; n3 < EXIF_TAGS.length; ++n3) {
            Object[] objectArray = this.mAttributes[n3].entrySet().toArray();
            n2 = objectArray.length;
            for (n4 = 0; n4 < n2; ++n4) {
                Map.Entry entry = (Map.Entry)objectArray[n4];
                if (entry.getValue() != null) continue;
                this.mAttributes[n3].remove(entry.getKey());
            }
        }
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.mHasThumbnail) {
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(0L, this.mExifByteOrder));
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name, ExifAttribute.createULong(this.mThumbnailLength, this.mExifByteOrder));
        }
        for (n3 = 0; n3 < EXIF_TAGS.length; ++n3) {
            Iterator<Map.Entry<String, ExifAttribute>> iterator = this.mAttributes[n3].entrySet().iterator();
            n4 = 0;
            while (iterator.hasNext()) {
                n2 = iterator.next().getValue().size();
                if (n2 <= 4) continue;
                n4 += n2;
            }
            object[n3] = object[n3] + n4;
        }
        n3 = 8;
        for (n4 = 0; n4 < EXIF_TAGS.length; ++n4) {
            n2 = n3;
            if (!this.mAttributes[n4].isEmpty()) {
                nArray[n4] = n3;
                n2 = n3 + (this.mAttributes[n4].size() * 12 + 2 + 4 + object[n4]);
            }
            n3 = n2;
        }
        n4 = n3;
        if (this.mHasThumbnail) {
            this.mAttributes[4].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(n3, this.mExifByteOrder));
            this.mThumbnailOffset = n + n3;
            n4 = n3 + this.mThumbnailLength;
        }
        n2 = n4 + 8;
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[1].name, ExifAttribute.createULong(nArray[1], this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.EXIF_POINTER_TAGS[2].name, ExifAttribute.createULong(nArray[2], this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.EXIF_POINTER_TAGS[3].name, ExifAttribute.createULong(nArray[3], this.mExifByteOrder));
        }
        byteOrderedDataOutputStream.writeUnsignedShort(n2);
        byteOrderedDataOutputStream.write(IDENTIFIER_EXIF_APP1);
        if (this.mExifByteOrder == ByteOrder.BIG_ENDIAN) {
            int n5 = n = 19789;
        } else {
            int n6 = n = 18761;
        }
        byteOrderedDataOutputStream.writeShort((short)var10_21);
        byteOrderedDataOutputStream.setByteOrder(this.mExifByteOrder);
        byteOrderedDataOutputStream.writeUnsignedShort(42);
        byteOrderedDataOutputStream.writeUnsignedInt(8L);
        for (n = 0; n < EXIF_TAGS.length; ++n) {
            if (this.mAttributes[n].isEmpty()) continue;
            byteOrderedDataOutputStream.writeUnsignedShort(this.mAttributes[n].size());
            n3 = nArray[n] + 2 + this.mAttributes[n].size() * 12 + 4;
            for (Map.Entry entry : this.mAttributes[n].entrySet()) {
                int n7 = ExifInterface.sExifTagMapsForWriting[n].get(entry.getKey()).number;
                ExifAttribute exifAttribute = (ExifAttribute)entry.getValue();
                byteOrderedDataOutputStream.writeUnsignedShort(n7);
                byteOrderedDataOutputStream.writeUnsignedShort(exifAttribute.format);
                byteOrderedDataOutputStream.writeInt(exifAttribute.numberOfComponents);
                if (n4 > 4) {
                    byteOrderedDataOutputStream.writeUnsignedInt(n3);
                    n3 += n4;
                    continue;
                }
                byteOrderedDataOutputStream.write(exifAttribute.bytes);
                if (n4 >= 4) continue;
                for (n4 = exifAttribute.size(); n4 < 4; ++n4) {
                    byteOrderedDataOutputStream.writeByte(0);
                }
            }
            if (n == 0 && !this.mAttributes[4].isEmpty()) {
                byteOrderedDataOutputStream.writeUnsignedInt(nArray[4]);
            } else {
                byteOrderedDataOutputStream.writeUnsignedInt(0L);
            }
            Iterator<Map.Entry<String, ExifAttribute>> iterator = this.mAttributes[n].entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next().getValue();
                if (((ExifAttribute)object).bytes.length <= 4) continue;
                byteOrderedDataOutputStream.write(((ExifAttribute)object).bytes, 0, ((ExifAttribute)object).bytes.length);
            }
        }
        if (this.mHasThumbnail) {
            byteOrderedDataOutputStream.write(this.getThumbnailBytes());
        }
        byteOrderedDataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return n2;
    }

    public void flipHorizontally() {
        int n = 1;
        switch (this.getAttributeInt(TAG_ORIENTATION, 1)) {
            default: {
                n = 0;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            case 7: {
                n = 8;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 1: {
                n = 2;
            }
            case 2: 
        }
        this.setAttribute(TAG_ORIENTATION, Integer.toString(n));
    }

    public void flipVertically() {
        int n = 1;
        switch (this.getAttributeInt(TAG_ORIENTATION, 1)) {
            default: {
                n = 0;
                break;
            }
            case 8: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 6: {
                n = 7;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
            }
            case 4: 
        }
        this.setAttribute(TAG_ORIENTATION, Integer.toString(n));
    }

    public double getAltitude(double d) {
        double d2 = this.getAttributeDouble(TAG_GPS_ALTITUDE, -1.0);
        int n = -1;
        int n2 = this.getAttributeInt(TAG_GPS_ALTITUDE_REF, -1);
        if (d2 >= 0.0 && n2 >= 0) {
            if (n2 != 1) {
                n = 1;
            }
            return d2 * (double)n;
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAttribute(String object) {
        Object object2 = this.getExifAttribute((String)object);
        if (object2 == null) return null;
        if (!sTagSetForCompatibility.contains(object)) {
            return ((ExifAttribute)object2).getStringValue(this.mExifByteOrder);
        }
        if (((String)object).equals(TAG_GPS_TIMESTAMP)) {
            if (((ExifAttribute)object2).format != 5 && ((ExifAttribute)object2).format != 10) {
                object = new StringBuilder();
                ((StringBuilder)object).append("GPS Timestamp format is not rational. format=");
                ((StringBuilder)object).append(((ExifAttribute)object2).format);
                Log.w((String)TAG, (String)((StringBuilder)object).toString());
                return null;
            }
            object = (Rational[])((ExifAttribute)object2).getValue(this.mExifByteOrder);
            if (object != null && ((Object)object).length == 3) {
                return String.format("%02d:%02d:%02d", (int)((float)((Rational)object[0]).numerator / (float)((Rational)object[0]).denominator), (int)((float)((Rational)object[1]).numerator / (float)((Rational)object[1]).denominator), (int)((float)((Rational)object[2]).numerator / (float)((Rational)object[2]).denominator));
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Invalid GPS Timestamp array. array=");
            ((StringBuilder)object2).append(Arrays.toString((Object[])object));
            Log.w((String)TAG, (String)((StringBuilder)object2).toString());
            return null;
        }
        try {
            return Double.toString(((ExifAttribute)object2).getDoubleValue(this.mExifByteOrder));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public double getAttributeDouble(String object, double d) {
        if ((object = this.getExifAttribute((String)object)) == null) {
            return d;
        }
        try {
            double d2 = ((ExifAttribute)object).getDoubleValue(this.mExifByteOrder);
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public int getAttributeInt(String object, int n) {
        if ((object = this.getExifAttribute((String)object)) == null) {
            return n;
        }
        try {
            int n2 = ((ExifAttribute)object).getIntValue(this.mExifByteOrder);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDateTime() {
        Object object = this.getAttribute(TAG_DATETIME);
        if (object == null) return -1L;
        if (!sNonZeroTimePattern.matcher((CharSequence)object).matches()) {
            return -1L;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            object = sFormatter.parse((String)object, parsePosition);
            if (object == null) {
                return -1L;
            }
            long l = ((Date)object).getTime();
            object = this.getAttribute(TAG_SUBSEC_TIME);
            long l2 = l;
            if (object == null) return l2;
            try {
                l2 = Long.parseLong((String)object);
                while (l2 > 1000L) {
                    l2 /= 10L;
                }
                return l + l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getGpsDateTime() {
        String string2 = this.getAttribute(TAG_GPS_DATESTAMP);
        Object object = this.getAttribute(TAG_GPS_TIMESTAMP);
        if (string2 == null) return -1L;
        if (object == null) return -1L;
        Serializable serializable = sNonZeroTimePattern;
        if (!((Pattern)serializable).matcher(string2).matches() && !((Pattern)serializable).matcher((CharSequence)object).matches()) {
            return -1L;
        }
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(string2);
        ((StringBuilder)serializable).append(' ');
        ((StringBuilder)serializable).append((String)object);
        string2 = ((StringBuilder)serializable).toString();
        object = new ParsePosition(0);
        try {
            object = sFormatter.parse(string2, (ParsePosition)object);
            if (object != null) return ((Date)object).getTime();
            return -1L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1L;
        }
    }

    @Deprecated
    public boolean getLatLong(float[] fArray) {
        double[] dArray = this.getLatLong();
        if (dArray == null) {
            return false;
        }
        fArray[0] = (float)dArray[0];
        fArray[1] = (float)dArray[1];
        return true;
    }

    public double[] getLatLong() {
        String string2 = this.getAttribute(TAG_GPS_LATITUDE);
        String string3 = this.getAttribute(TAG_GPS_LATITUDE_REF);
        String string4 = this.getAttribute(TAG_GPS_LONGITUDE);
        String string5 = this.getAttribute(TAG_GPS_LONGITUDE_REF);
        if (string2 != null && string3 != null && string4 != null && string5 != null) {
            double d;
            double d2;
            try {
                d2 = ExifInterface.convertRationalLatLonToDouble(string2, string3);
                d = ExifInterface.convertRationalLatLonToDouble(string4, string5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Latitude/longitude values are not parseable. ");
                stringBuilder.append(String.format("latValue=%s, latRef=%s, lngValue=%s, lngRef=%s", string2, string3, string4, string5));
                Log.w((String)TAG, (String)stringBuilder.toString());
            }
            return new double[]{d2, d};
        }
        return null;
    }

    public int getRotationDegrees() {
        switch (this.getAttributeInt(TAG_ORIENTATION, 1)) {
            default: {
                return 0;
            }
            case 6: 
            case 7: {
                return 90;
            }
            case 5: 
            case 8: {
                return 270;
            }
            case 3: 
            case 4: 
        }
        return 180;
    }

    public byte[] getThumbnail() {
        int n = this.mThumbnailCompression;
        if (n != 6 && n != 7) {
            return null;
        }
        return this.getThumbnailBytes();
    }

    public Bitmap getThumbnailBitmap() {
        int n;
        if (!this.mHasThumbnail) {
            return null;
        }
        if (this.mThumbnailBytes == null) {
            this.mThumbnailBytes = this.getThumbnailBytes();
        }
        if ((n = this.mThumbnailCompression) != 6 && n != 7) {
            if (n == 1) {
                Object object;
                int n2 = this.mThumbnailBytes.length / 3;
                int[] nArray = new int[n2];
                for (n = 0; n < n2; ++n) {
                    object = this.mThumbnailBytes;
                    int n3 = n * 3;
                    nArray[n] = (object[n3] << 16) + 0 + (object[n3 + 1] << 8) + object[n3 + 2];
                }
                ExifAttribute exifAttribute = this.mAttributes[4].get(TAG_IMAGE_LENGTH);
                object = this.mAttributes[4].get(TAG_IMAGE_WIDTH);
                if (exifAttribute != null && object != null) {
                    n = exifAttribute.getIntValue(this.mExifByteOrder);
                    return Bitmap.createBitmap((int[])nArray, (int)((ExifAttribute)object).getIntValue(this.mExifByteOrder), (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
            }
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])this.mThumbnailBytes, (int)0, (int)this.mThumbnailLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getThumbnailBytes() {
        block14: {
            var1_1 = this.mHasThumbnail;
            var2_2 = null;
            if (!var1_1) {
                return null;
            }
            var3_3 /* !! */  = this.mThumbnailBytes;
            if (var3_3 /* !! */  != null) {
                return var3_3 /* !! */ ;
            }
            var3_3 /* !! */  = (byte[])this.mAssetInputStream;
            if (var3_3 /* !! */  == null) ** GOTO lbl-1000
            var4_10 = var3_3 /* !! */ ;
            var2_2 = var3_3 /* !! */ ;
            ** try [egrp 1[TRYBLOCK] [2, 3 : 38->72)] { 
lbl14:
            // 1 sources

            ** GOTO lbl23
lbl15:
            // 1 sources

            catch (Throwable var3_8) {
                // empty catch block
                break block14;
            }
            {
                block15: {
                    block17: {
                        block16: {
                            catch (Throwable var3_5) {
                                break block14;
                            }
                            catch (IOException var3_6) {
                                var4_10 = null;
                                break block15;
                            }
lbl23:
                            // 1 sources

                            if (var3_3 /* !! */ .markSupported()) {
                                var4_10 = var3_3 /* !! */ ;
                                var2_2 = var3_3 /* !! */ ;
                                var3_3 /* !! */ .reset();
                                break block16;
                            } else {
                                var4_10 = var3_3 /* !! */ ;
                                var2_2 = var3_3 /* !! */ ;
                                Log.d((String)"ExifInterface", (String)"Cannot read thumbnail from inputstream without mark/reset support");
                                ExifInterface.closeQuietly((Closeable)var3_3 /* !! */ );
                                return null;
                            }
lbl34:
                            // 1 sources

                            catch (IOException var3_4) {
                                break block15;
                            }
lbl-1000:
                            // 1 sources

                            {
                                var3_3 /* !! */  = this.mFilename != null ? new FileInputStream(this.mFilename) : null;
                            }
                        }
                        if (var3_3 /* !! */  == null) ** GOTO lbl75
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        {
                            var5_11 = var3_3 /* !! */ .skip(this.mThumbnailOffset);
                            var4_10 = var3_3 /* !! */ ;
                            var2_2 = var3_3 /* !! */ ;
                            var7_12 = this.mThumbnailOffset;
                            if (var5_11 != (long)var7_12) ** GOTO lbl67
                            var4_10 = var3_3 /* !! */ ;
                            var2_2 = var3_3 /* !! */ ;
                            var8_13 /* !! */  = new byte[this.mThumbnailLength];
                            var4_10 = var3_3 /* !! */ ;
                            var2_2 = var3_3 /* !! */ ;
                            if (var3_3 /* !! */ .read(var8_13 /* !! */ ) != this.mThumbnailLength) break block17;
                            var4_10 = var3_3 /* !! */ ;
                            var2_2 = var3_3 /* !! */ ;
                            this.mThumbnailBytes = var8_13 /* !! */ ;
                        }
                        ExifInterface.closeQuietly((Closeable)var3_3 /* !! */ );
                        return var8_13 /* !! */ ;
                    }
                    var4_10 = var3_3 /* !! */ ;
                    var2_2 = var3_3 /* !! */ ;
                    {
                        var8_13 /* !! */  = (byte[])new IOException;
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        var8_13 /* !! */ ("Corrupted image");
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        throw var8_13 /* !! */ ;
lbl67:
                        // 1 sources

                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        var8_14 = new IOException("Corrupted image");
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        throw var8_14;
lbl75:
                        // 1 sources

                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        var8_15 = new FileNotFoundException();
                        var4_10 = var3_3 /* !! */ ;
                        var2_2 = var3_3 /* !! */ ;
                        throw var8_15;
                    }
                }
                var2_2 = var4_10;
                Log.d((String)"ExifInterface", (String)"Encountered exception while getting thumbnail", (Throwable)var3_7);
            }
            ExifInterface.closeQuietly((Closeable)var4_10);
            return null;
        }
        ExifInterface.closeQuietly(var2_2);
        throw var3_9;
    }

    public long[] getThumbnailRange() {
        if (!this.mHasThumbnail) {
            return null;
        }
        return new long[]{this.mThumbnailOffset, this.mThumbnailLength};
    }

    public boolean hasThumbnail() {
        return this.mHasThumbnail;
    }

    public boolean isFlipped() {
        int n = this.getAttributeInt(TAG_ORIENTATION, 1);
        return n == 2 || n == 7 || n == 4 || n == 5;
    }

    public boolean isThumbnailCompressed() {
        int n = this.mThumbnailCompression;
        boolean bl = n == 6 || n == 7;
        return bl;
    }

    public void resetOrientation() {
        this.setAttribute(TAG_ORIENTATION, Integer.toString(1));
    }

    public void rotate(int n) {
        if (n % 90 == 0) {
            int n2 = this.getAttributeInt(TAG_ORIENTATION, 1);
            List<Integer> list = ROTATION_ORDER;
            boolean bl = list.contains(n2);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (bl) {
                n3 = (list.indexOf(n2) + n / 90) % 4;
                n = n5;
                if (n3 < 0) {
                    n = 4;
                }
                n5 = list.get(n3 + n);
            } else {
                list = FLIPPED_ROTATION_ORDER;
                n5 = n4;
                if (list.contains(n2)) {
                    n5 = (list.indexOf(n2) + n / 90) % 4;
                    n = n3;
                    if (n5 < 0) {
                        n = 4;
                    }
                    n5 = list.get(n5 + n);
                }
            }
            this.setAttribute(TAG_ORIENTATION, Integer.toString(n5));
            return;
        }
        throw new IllegalArgumentException("degree should be a multiple of 90");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveAttributes() throws IOException {
        if (this.mIsSupportedFile && this.mMimeType == 4) {
            void var1_5;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file;
            block9: {
                if (this.mFilename == null) {
                    throw new IOException("ExifInterface does not support saving attributes for the current input.");
                }
                this.mThumbnailBytes = this.getThumbnail();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.mFilename);
                stringBuilder.append(".tmp");
                file = new File(stringBuilder.toString());
                if (!new File(this.mFilename).renameTo(file)) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Could not rename to ");
                    stringBuilder.append(file.getAbsolutePath());
                    throw new IOException(stringBuilder.toString());
                }
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (Throwable throwable) {
                    fileOutputStream = null;
                    fileInputStream = fileOutputStream;
                    break block9;
                }
                try {
                    fileOutputStream = new FileOutputStream(this.mFilename);
                }
                catch (Throwable throwable) {
                    fileOutputStream = null;
                    break block9;
                }
                try {
                    this.saveJpegAttributes(fileInputStream, fileOutputStream);
                }
                catch (Throwable throwable) {
                    break block9;
                }
                ExifInterface.closeQuietly(fileInputStream);
                ExifInterface.closeQuietly(fileOutputStream);
                file.delete();
                this.mThumbnailBytes = null;
                return;
            }
            ExifInterface.closeQuietly(fileInputStream);
            ExifInterface.closeQuietly(fileOutputStream);
            file.delete();
            throw var1_5;
        }
        throw new IOException("ExifInterface only supports saving attributes on JPEG formats.");
    }

    public void setAltitude(double d) {
        String string2 = d >= 0.0 ? "0" : "1";
        this.setAttribute(TAG_GPS_ALTITUDE, new Rational(Math.abs(d)).toString());
        this.setAttribute(TAG_GPS_ALTITUDE_REF, string2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setAttribute(String var1_1, String var2_4) {
        var3_5 /* !! */  = var2_4;
        var4_6 = "ISOSpeedRatings".equals(var1_1) != false ? "PhotographicSensitivity" : var1_1;
        var1_1 = "ExifInterface";
        var5_7 = var3_5 /* !! */ ;
        if (var3_5 /* !! */  != null) {
            var5_7 = var3_5 /* !! */ ;
            if (ExifInterface.sTagSetForCompatibility.contains(var4_6)) {
                if (var4_6.equals("GPSTimeStamp")) {
                    var2_4 = ExifInterface.sGpsTimestampPattern.matcher((CharSequence)var3_5 /* !! */ );
                    if (!var2_4.find()) {
                        var1_1 = new StringBuilder();
                        var1_1.append("Invalid value for ");
                        var1_1.append((String)var4_6);
                        var1_1.append(" : ");
                        var1_1.append((String)var3_5 /* !! */ );
                        Log.w((String)"ExifInterface", (String)var1_1.toString());
                        return;
                    }
                    var5_7 = new StringBuilder();
                    var5_7.append(Integer.parseInt(var2_4.group(1)));
                    var5_7.append("/1,");
                    var5_7.append(Integer.parseInt(var2_4.group(2)));
                    var5_7.append("/1,");
                    var5_7.append(Integer.parseInt(var2_4.group(3)));
                    var5_7.append("/1");
                    var5_7 = var5_7.toString();
                } else {
                    try {
                        var6_8 = Double.parseDouble((String)var2_4);
                        var2_4 = new Rational(var6_8);
                        var5_7 = var2_4.toString();
                    }
                    catch (NumberFormatException var1_2) {
                        var1_3 = new StringBuilder();
                        var1_3.append("Invalid value for ");
                        var1_3.append((String)var4_6);
                        var1_3.append(" : ");
                        var1_3.append((String)var3_5 /* !! */ );
                        Log.w((String)"ExifInterface", (String)var1_3.toString());
                        return;
                    }
                }
            }
        }
        block12: for (var8_9 = 0; var8_9 < ExifInterface.EXIF_TAGS.length; ++var8_9) {
            block29: {
                block33: {
                    block31: {
                        block34: {
                            block32: {
                                block30: {
                                    block28: {
                                        if (var8_9 != 4 || this.mHasThumbnail) break block28;
                                        var2_4 = var1_1;
                                        break block29;
                                    }
                                    var9_10 = ExifInterface.sExifTagMapsForWriting[var8_9].get(var4_6);
                                    var2_4 = var1_1;
                                    if (var9_10 == null) break block29;
                                    if (var5_7 != null) break block30;
                                    this.mAttributes[var8_9].remove(var4_6);
                                    var2_4 = var1_1;
                                    break block29;
                                }
                                var10_11 = ExifInterface.guessDataFormat((String)var5_7);
                                if (var9_10.primaryFormat == (Integer)var10_11.first || var9_10.primaryFormat == (Integer)var10_11.second) break block31;
                                if (var9_10.secondaryFormat == -1 || var9_10.secondaryFormat != (Integer)var10_11.first && var9_10.secondaryFormat != (Integer)var10_11.second) break block32;
                                var11_12 = var9_10.secondaryFormat;
                                break block33;
                            }
                            if (var9_10.primaryFormat == 1 || var9_10.primaryFormat == 7 || var9_10.primaryFormat == 2) break block34;
                            var12_13 = new StringBuilder();
                            var12_13.append("Given tag (");
                            var12_13.append((String)var4_6);
                            var12_13.append(") value didn't match with one of expected ");
                            var12_13.append("formats: ");
                            var13_14 = ExifInterface.IFD_FORMAT_NAMES;
                            var12_13.append(var13_14[var9_10.primaryFormat]);
                            var11_12 = var9_10.secondaryFormat;
                            var3_5 /* !! */  = "";
                            if (var11_12 == -1) {
                                var2_4 = "";
                            } else {
                                var2_4 = new StringBuilder();
                                var2_4.append(", ");
                                var2_4.append(var13_14[var9_10.secondaryFormat]);
                                var2_4 = var2_4.toString();
                            }
                            var12_13.append((String)var2_4);
                            var12_13.append(" (guess: ");
                            var12_13.append(var13_14[(Integer)var10_11.first]);
                            if ((Integer)var10_11.second == -1) {
                                var2_4 = var3_5 /* !! */ ;
                            } else {
                                var2_4 = new StringBuilder();
                                var2_4.append(", ");
                                var2_4.append(var13_14[(Integer)var10_11.second]);
                                var2_4 = var2_4.toString();
                            }
                            var12_13.append((String)var2_4);
                            var12_13.append(")");
                            Log.w((String)var1_1, (String)var12_13.toString());
                            var2_4 = var1_1;
                            break block29;
                        }
                        var11_12 = var9_10.primaryFormat;
                        break block33;
                    }
                    var11_12 = var9_10.primaryFormat;
                }
                switch (var11_12) {
                    default: {
                        var2_4 = new StringBuilder();
                        var2_4.append("Data format isn't one of expected formats: ");
                        var2_4.append(var11_12);
                        var2_4 = var2_4.toString();
                        Log.w((String)var1_1, (String)var2_4);
                        continue block12;
                    }
                    case 12: {
                        var3_5 /* !! */  = var5_7.split(",", -1);
                        var2_4 = new double[var3_5 /* !! */ .length];
                        for (var11_12 = 0; var11_12 < var3_5 /* !! */ .length; ++var11_12) {
                            var2_4[var11_12] = (String)Double.parseDouble(var3_5 /* !! */ [var11_12]);
                        }
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createDouble((double[])var2_4, this.mExifByteOrder));
                        var2_4 = var1_1;
                        break block29;
                    }
                    case 10: {
                        var3_5 /* !! */  = var5_7.split(",", -1);
                        var2_4 = new Rational[var3_5 /* !! */ .length];
                        for (var11_12 = 0; var11_12 < var3_5 /* !! */ .length; ++var11_12) {
                            var12_13 = var3_5 /* !! */ [var11_12].split("/", -1);
                            var2_4[var11_12] = new Rational((long)Double.parseDouble((String)var12_13[0]), (long)Double.parseDouble((String)var12_13[1]));
                        }
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createSRational((Rational[])var2_4, this.mExifByteOrder));
                        ** GOTO lbl168
                    }
                    case 9: {
                        var3_5 /* !! */  = var5_7.split(",", -1);
                        var2_4 = new int[var3_5 /* !! */ .length];
                        for (var11_12 = 0; var11_12 < var3_5 /* !! */ .length; ++var11_12) {
                            var2_4[var11_12] = (String)Integer.parseInt(var3_5 /* !! */ [var11_12]);
                        }
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createSLong((int[])var2_4, this.mExifByteOrder));
lbl168:
                        // 2 sources

                        var2_4 = var1_1;
                        break block29;
                    }
                    case 5: {
                        var2_4 = var5_7.split(",", -1);
                        var12_13 = new Rational[((String[])var2_4).length];
                        for (var11_12 = 0; var11_12 < ((Object[])var2_4).length; ++var11_12) {
                            var3_5 /* !! */  = var2_4[var11_12].split("/", -1);
                            var12_13[var11_12] = new Rational((long)Double.parseDouble(var3_5 /* !! */ [0]), (long)Double.parseDouble(var3_5 /* !! */ [1]));
                        }
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createURational((Rational[])var12_13, this.mExifByteOrder));
                        continue block12;
                    }
                    case 4: {
                        var2_4 = var5_7.split(",", -1);
                        var3_5 /* !! */  = (String[])new long[((String[])var2_4).length];
                        for (var11_12 = 0; var11_12 < ((Object[])var2_4).length; ++var11_12) {
                            var3_5 /* !! */ [var11_12] = (String)Long.parseLong(var2_4[var11_12]);
                        }
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createULong((long[])var3_5 /* !! */ , this.mExifByteOrder));
                        continue block12;
                    }
                    case 3: {
                        var2_4 = var5_7.split(",", -1);
                        var3_5 /* !! */  = (String[])new int[((String[])var2_4).length];
                        for (var11_12 = 0; var11_12 < ((Object[])var2_4).length; ++var11_12) {
                            var3_5 /* !! */ [var11_12] = (String)Integer.parseInt(var2_4[var11_12]);
                        }
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createUShort((int[])var3_5 /* !! */ , this.mExifByteOrder));
                        continue block12;
                    }
                    case 2: 
                    case 7: {
                        this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createString((String)var5_7));
                        continue block12;
                    }
                    case 1: 
                }
                this.mAttributes[var8_9].put((String)var4_6, ExifAttribute.createByte((String)var5_7));
                continue;
            }
            var1_1 = var2_4;
        }
    }

    public void setDateTime(long l) {
        this.setAttribute(TAG_DATETIME, sFormatter.format(new Date(l)));
        this.setAttribute(TAG_SUBSEC_TIME, Long.toString(l % 1000L));
    }

    public void setGpsInfo(Location stringArray) {
        if (stringArray == null) {
            return;
        }
        this.setAttribute(TAG_GPS_PROCESSING_METHOD, stringArray.getProvider());
        this.setLatLong(stringArray.getLatitude(), stringArray.getLongitude());
        this.setAltitude(stringArray.getAltitude());
        this.setAttribute(TAG_GPS_SPEED_REF, "K");
        this.setAttribute(TAG_GPS_SPEED, new Rational(stringArray.getSpeed() * (float)TimeUnit.HOURS.toSeconds(1L) / 1000.0f).toString());
        stringArray = sFormatter.format(new Date(stringArray.getTime())).split("\\s+", -1);
        this.setAttribute(TAG_GPS_DATESTAMP, stringArray[0]);
        this.setAttribute(TAG_GPS_TIMESTAMP, stringArray[1]);
    }

    public void setLatLong(double d, double d2) {
        if (!(d < -90.0 || d > 90.0 || Double.isNaN(d))) {
            if (!(d2 < -180.0 || d2 > 180.0 || Double.isNaN(d2))) {
                String string2 = d >= 0.0 ? "N" : LATITUDE_SOUTH;
                this.setAttribute(TAG_GPS_LATITUDE_REF, string2);
                this.setAttribute(TAG_GPS_LATITUDE, this.convertDecimalDegree(Math.abs(d)));
                string2 = d2 >= 0.0 ? LONGITUDE_EAST : LONGITUDE_WEST;
                this.setAttribute(TAG_GPS_LONGITUDE_REF, string2);
                this.setAttribute(TAG_GPS_LONGITUDE, this.convertDecimalDegree(Math.abs(d2)));
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Longitude value ");
            stringBuilder.append(d2);
            stringBuilder.append(" is not valid.");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Latitude value ");
        stringBuilder.append(d);
        stringBuilder.append(" is not valid.");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private static class ByteOrderedDataInputStream
    extends InputStream
    implements DataInput {
        private static final ByteOrder BIG_ENDIAN;
        private static final ByteOrder LITTLE_ENDIAN;
        private ByteOrder mByteOrder = ByteOrder.BIG_ENDIAN;
        private DataInputStream mDataInputStream;
        final int mLength;
        int mPosition;

        static {
            LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
            BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
        }

        public ByteOrderedDataInputStream(InputStream inputStream) throws IOException {
            int n;
            inputStream = new DataInputStream(inputStream);
            this.mDataInputStream = inputStream;
            this.mLength = n = ((FilterInputStream)inputStream).available();
            this.mPosition = 0;
            this.mDataInputStream.mark(n);
        }

        public ByteOrderedDataInputStream(byte[] byArray) throws IOException {
            this(new ByteArrayInputStream(byArray));
        }

        @Override
        public int available() throws IOException {
            return this.mDataInputStream.available();
        }

        public int peek() {
            return this.mPosition;
        }

        @Override
        public int read() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            n = this.mDataInputStream.read(byArray, n, n2);
            this.mPosition += n;
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            int n;
            this.mPosition = n = this.mPosition + 1;
            if (n <= this.mLength) {
                n = this.mDataInputStream.read();
                if (n >= 0) {
                    return (byte)n;
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public char readChar() throws IOException {
            this.mPosition += 2;
            return this.mDataInputStream.readChar();
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            int n;
            this.mPosition = n = this.mPosition + byArray.length;
            if (n <= this.mLength) {
                if (this.mDataInputStream.read(byArray, 0, byArray.length) == byArray.length) {
                    return;
                }
                throw new IOException("Couldn't read up to the length of buffer");
            }
            throw new EOFException();
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.mPosition = n3 = this.mPosition + n2;
            if (n3 <= this.mLength) {
                if (this.mDataInputStream.read(byArray, n, n2) == n2) {
                    return;
                }
                throw new IOException("Couldn't read up to the length of buffer");
            }
            throw new EOFException();
        }

        @Override
        public int readInt() throws IOException {
            int n;
            this.mPosition = n = this.mPosition + 4;
            if (n <= this.mLength) {
                int n2;
                int n3;
                int n4;
                n = this.mDataInputStream.read();
                if ((n | (n4 = this.mDataInputStream.read()) | (n3 = this.mDataInputStream.read()) | (n2 = this.mDataInputStream.read())) >= 0) {
                    Object object = this.mByteOrder;
                    if (object == LITTLE_ENDIAN) {
                        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n;
                    }
                    if (object == BIG_ENDIAN) {
                        return (n << 24) + (n4 << 16) + (n3 << 8) + n2;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid byte order: ");
                    ((StringBuilder)object).append(this.mByteOrder);
                    throw new IOException(((StringBuilder)object).toString());
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public String readLine() throws IOException {
            Log.d((String)ExifInterface.TAG, (String)"Currently unsupported");
            return null;
        }

        @Override
        public long readLong() throws IOException {
            int n;
            this.mPosition = n = this.mPosition + 8;
            if (n <= this.mLength) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = this.mDataInputStream.read();
                if ((n8 | (n = this.mDataInputStream.read()) | (n7 = this.mDataInputStream.read()) | (n6 = this.mDataInputStream.read()) | (n5 = this.mDataInputStream.read()) | (n4 = this.mDataInputStream.read()) | (n3 = this.mDataInputStream.read()) | (n2 = this.mDataInputStream.read())) >= 0) {
                    Object object = this.mByteOrder;
                    if (object == LITTLE_ENDIAN) {
                        return ((long)n2 << 56) + ((long)n3 << 48) + ((long)n4 << 40) + ((long)n5 << 32) + ((long)n6 << 24) + ((long)n7 << 16) + ((long)n << 8) + (long)n8;
                    }
                    if (object == BIG_ENDIAN) {
                        return ((long)n8 << 56) + ((long)n << 48) + ((long)n7 << 40) + ((long)n6 << 32) + ((long)n5 << 24) + ((long)n4 << 16) + ((long)n3 << 8) + (long)n2;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid byte order: ");
                    ((StringBuilder)object).append(this.mByteOrder);
                    throw new IOException(((StringBuilder)object).toString());
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public short readShort() throws IOException {
            int n;
            this.mPosition = n = this.mPosition + 2;
            if (n <= this.mLength) {
                int n2 = this.mDataInputStream.read();
                if ((n2 | (n = this.mDataInputStream.read())) >= 0) {
                    Object object = this.mByteOrder;
                    if (object == LITTLE_ENDIAN) {
                        return (short)((n << 8) + n2);
                    }
                    if (object == BIG_ENDIAN) {
                        return (short)((n2 << 8) + n);
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid byte order: ");
                    ((StringBuilder)object).append(this.mByteOrder);
                    throw new IOException(((StringBuilder)object).toString());
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        @Override
        public String readUTF() throws IOException {
            this.mPosition += 2;
            return this.mDataInputStream.readUTF();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            ++this.mPosition;
            return this.mDataInputStream.readUnsignedByte();
        }

        public long readUnsignedInt() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            int n;
            this.mPosition = n = this.mPosition + 2;
            if (n <= this.mLength) {
                int n2 = this.mDataInputStream.read();
                if ((n2 | (n = this.mDataInputStream.read())) >= 0) {
                    Object object = this.mByteOrder;
                    if (object == LITTLE_ENDIAN) {
                        return (n << 8) + n2;
                    }
                    if (object == BIG_ENDIAN) {
                        return (n2 << 8) + n;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid byte order: ");
                    ((StringBuilder)object).append(this.mByteOrder);
                    throw new IOException(((StringBuilder)object).toString());
                }
                throw new EOFException();
            }
            throw new EOFException();
        }

        public void seek(long l) throws IOException {
            int n = this.mPosition;
            if ((long)n > l) {
                this.mPosition = 0;
                this.mDataInputStream.reset();
                this.mDataInputStream.mark(this.mLength);
            } else {
                l -= (long)n;
            }
            n = (int)l;
            if (this.skipBytes(n) == n) {
                return;
            }
            throw new IOException("Couldn't seek up to the byteCount");
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            int n2 = Math.min(n, this.mLength - this.mPosition);
            for (n = 0; n < n2; n += this.mDataInputStream.skipBytes(n2 - n)) {
            }
            this.mPosition += n;
            return n;
        }
    }

    private static class ByteOrderedDataOutputStream
    extends FilterOutputStream {
        private ByteOrder mByteOrder;
        private final OutputStream mOutputStream;

        public ByteOrderedDataOutputStream(OutputStream outputStream, ByteOrder byteOrder) {
            super(outputStream);
            this.mOutputStream = outputStream;
            this.mByteOrder = byteOrder;
        }

        public void setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.mOutputStream.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.mOutputStream.write(byArray, n, n2);
        }

        public void writeByte(int n) throws IOException {
            this.mOutputStream.write(n);
        }

        public void writeInt(int n) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(n >>> 0 & 0xFF);
                this.mOutputStream.write(n >>> 8 & 0xFF);
                this.mOutputStream.write(n >>> 16 & 0xFF);
                this.mOutputStream.write(n >>> 24 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(n >>> 24 & 0xFF);
                this.mOutputStream.write(n >>> 16 & 0xFF);
                this.mOutputStream.write(n >>> 8 & 0xFF);
                this.mOutputStream.write(n >>> 0 & 0xFF);
            }
        }

        public void writeShort(short s) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(s >>> 0 & 0xFF);
                this.mOutputStream.write(s >>> 8 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(s >>> 8 & 0xFF);
                this.mOutputStream.write(s >>> 0 & 0xFF);
            }
        }

        public void writeUnsignedInt(long l) throws IOException {
            this.writeInt((int)l);
        }

        public void writeUnsignedShort(int n) throws IOException {
            this.writeShort((short)n);
        }
    }

    private static class ExifAttribute {
        public final byte[] bytes;
        public final int format;
        public final int numberOfComponents;

        ExifAttribute(int n, int n2, byte[] byArray) {
            this.format = n;
            this.numberOfComponents = n2;
            this.bytes = byArray;
        }

        public static ExifAttribute createByte(String object) {
            if (((String)object).length() == 1 && ((String)object).charAt(0) >= '0' && ((String)object).charAt(0) <= '1') {
                return new ExifAttribute(1, 1, new byte[]{(byte)(((String)object).charAt(0) - 48)});
            }
            object = ((String)object).getBytes(ASCII);
            return new ExifAttribute(1, ((Object)object).length, (byte[])object);
        }

        public static ExifAttribute createDouble(double d, ByteOrder byteOrder) {
            return ExifAttribute.createDouble(new double[]{d}, byteOrder);
        }

        public static ExifAttribute createDouble(double[] dArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * dArray.length]);
            byteBuffer.order(byteOrder);
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                byteBuffer.putDouble(dArray[i]);
            }
            return new ExifAttribute(12, dArray.length, byteBuffer.array());
        }

        public static ExifAttribute createSLong(int n, ByteOrder byteOrder) {
            return ExifAttribute.createSLong(new int[]{n}, byteOrder);
        }

        public static ExifAttribute createSLong(int[] nArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * nArray.length]);
            byteBuffer.order(byteOrder);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                byteBuffer.putInt(nArray[i]);
            }
            return new ExifAttribute(9, nArray.length, byteBuffer.array());
        }

        public static ExifAttribute createSRational(Rational rational, ByteOrder byteOrder) {
            return ExifAttribute.createSRational(new Rational[]{rational}, byteOrder);
        }

        public static ExifAttribute createSRational(Rational[] rationalArray, ByteOrder object) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * rationalArray.length]);
            byteBuffer.order((ByteOrder)object);
            int n = rationalArray.length;
            for (int i = 0; i < n; ++i) {
                object = rationalArray[i];
                byteBuffer.putInt((int)((Rational)object).numerator);
                byteBuffer.putInt((int)((Rational)object).denominator);
            }
            return new ExifAttribute(10, rationalArray.length, byteBuffer.array());
        }

        public static ExifAttribute createString(String object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
            stringBuilder.append('\u0000');
            object = stringBuilder.toString().getBytes(ASCII);
            return new ExifAttribute(2, ((Object)object).length, (byte[])object);
        }

        public static ExifAttribute createULong(long l, ByteOrder byteOrder) {
            return ExifAttribute.createULong(new long[]{l}, byteOrder);
        }

        public static ExifAttribute createULong(long[] lArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * lArray.length]);
            byteBuffer.order(byteOrder);
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                byteBuffer.putInt((int)lArray[i]);
            }
            return new ExifAttribute(4, lArray.length, byteBuffer.array());
        }

        public static ExifAttribute createURational(Rational rational, ByteOrder byteOrder) {
            return ExifAttribute.createURational(new Rational[]{rational}, byteOrder);
        }

        public static ExifAttribute createURational(Rational[] rationalArray, ByteOrder object) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * rationalArray.length]);
            byteBuffer.order((ByteOrder)object);
            int n = rationalArray.length;
            for (int i = 0; i < n; ++i) {
                object = rationalArray[i];
                byteBuffer.putInt((int)((Rational)object).numerator);
                byteBuffer.putInt((int)((Rational)object).denominator);
            }
            return new ExifAttribute(5, rationalArray.length, byteBuffer.array());
        }

        public static ExifAttribute createUShort(int n, ByteOrder byteOrder) {
            return ExifAttribute.createUShort(new int[]{n}, byteOrder);
        }

        public static ExifAttribute createUShort(int[] nArray, ByteOrder byteOrder) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * nArray.length]);
            byteBuffer.order(byteOrder);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                byteBuffer.putShort((short)nArray[i]);
            }
            return new ExifAttribute(3, nArray.length, byteBuffer.array());
        }

        public double getDoubleValue(ByteOrder rationalArray) {
            if ((rationalArray = this.getValue((ByteOrder)rationalArray)) != null) {
                if (rationalArray instanceof String) {
                    return Double.parseDouble((String)rationalArray);
                }
                if (rationalArray instanceof long[]) {
                    if ((rationalArray = (Rational[])((long[])rationalArray)).length == 1) {
                        return (double)rationalArray[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (rationalArray instanceof int[]) {
                    if ((rationalArray = (Rational[])((int[])rationalArray)).length == 1) {
                        return (double)rationalArray[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (rationalArray instanceof double[]) {
                    if ((rationalArray = (Rational[])((double[])rationalArray)).length == 1) {
                        return (double)rationalArray[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (rationalArray instanceof Rational[]) {
                    if ((rationalArray = (Rational[])rationalArray).length == 1) {
                        return rationalArray[0].calculate();
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                throw new NumberFormatException("Couldn't find a double value");
            }
            throw new NumberFormatException("NULL can't be converted to a double value");
        }

        public int getIntValue(ByteOrder object) {
            if ((object = this.getValue((ByteOrder)object)) != null) {
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof long[]) {
                    if (((Object)(object = (Object)((long[])object))).length == 1) {
                        return (int)object[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                if (object instanceof int[]) {
                    if (((Object)(object = (Object)((int[])object))).length == 1) {
                        return (int)object[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                }
                throw new NumberFormatException("Couldn't find a integer value");
            }
            throw new NumberFormatException("NULL can't be converted to a integer value");
        }

        public String getStringValue(ByteOrder object) {
            Object object2 = this.getValue((ByteOrder)object);
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof String) {
                return (String)object2;
            }
            object = new StringBuilder();
            boolean bl = object2 instanceof long[];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (bl) {
                object2 = (long[])object2;
                while (n4 < ((Object)object2).length) {
                    ((StringBuilder)object).append((long)object2[n4]);
                    n4 = n = n4 + 1;
                    if (n == ((Rational[])object2).length) continue;
                    ((StringBuilder)object).append(",");
                    n4 = n;
                }
                return ((StringBuilder)object).toString();
            }
            if (object2 instanceof int[]) {
                object2 = (int[])object2;
                n4 = n;
                while (n4 < ((Object)object2).length) {
                    ((StringBuilder)object).append((int)object2[n4]);
                    n4 = n = n4 + 1;
                    if (n == ((Rational[])object2).length) continue;
                    ((StringBuilder)object).append(",");
                    n4 = n;
                }
                return ((StringBuilder)object).toString();
            }
            if (object2 instanceof double[]) {
                object2 = (double[])object2;
                n4 = n2;
                while (n4 < ((Rational[])object2).length) {
                    ((StringBuilder)object).append((double)object2[n4]);
                    n4 = n = n4 + 1;
                    if (n == ((Rational[])object2).length) continue;
                    ((StringBuilder)object).append(",");
                    n4 = n;
                }
                return ((StringBuilder)object).toString();
            }
            if (object2 instanceof Rational[]) {
                object2 = object2;
                n4 = n3;
                while (n4 < ((Rational[])object2).length) {
                    ((StringBuilder)object).append(object2[n4].numerator);
                    ((StringBuilder)object).append('/');
                    ((StringBuilder)object).append(object2[n4].denominator);
                    n4 = n = n4 + 1;
                    if (n == ((Rational[])object2).length) continue;
                    ((StringBuilder)object).append(",");
                    n4 = n;
                }
                return ((StringBuilder)object).toString();
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        Object getValue(ByteOrder var1_1) {
            block102: {
                block103: {
                    block101: {
                        var2_7 = null;
                        var2_7 = var3_21 = new ByteOrderedDataInputStream(this.bytes);
                        var3_21.setByteOrder((ByteOrder)var1_1);
                        var2_7 = var3_21;
                        var4_23 = this.format;
                        var5_24 = 1;
                        var6_25 = 0;
                        var7_26 = 0;
                        var8_27 = 0;
                        var9_28 = 0;
                        var10_29 = 0;
                        var11_30 = 0;
                        var12_31 = 0;
                        var13_32 = 0;
                        var14_33 = 0;
                        switch (var4_23) {
                            default: {
                                break;
                            }
                            case 12: {
                                var2_7 = var3_21;
                                var1_1 = new double[this.numberOfComponents];
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = (Rational)var3_21.readDouble();
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_8) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_8);
                                }
                                return var1_1;
                            }
                            case 11: {
                                var2_7 = var3_21;
                                var1_1 = new double[this.numberOfComponents];
                                var14_33 = var6_25;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = (Rational)((double)var3_21.readFloat());
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_9) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_9);
                                }
                                return var1_1;
                            }
                            case 10: {
                                var2_7 = var3_21;
                                var1_1 = new Rational[this.numberOfComponents];
                                var14_33 = var7_26;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = new Rational(var3_21.readInt(), var3_21.readInt());
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_10) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_10);
                                }
                                return var1_1;
                            }
                            case 9: {
                                var2_7 = var3_21;
                                var1_1 = new int[this.numberOfComponents];
                                var14_33 = var8_27;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = (Rational)var3_21.readInt();
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_11) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_11);
                                }
                                return var1_1;
                            }
                            case 8: {
                                var2_7 = var3_21;
                                var1_1 = new int[this.numberOfComponents];
                                var14_33 = var9_28;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = (Rational)var3_21.readShort();
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_12) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_12);
                                }
                                return var1_1;
                            }
                            case 5: {
                                var2_7 = var3_21;
                                var1_1 = new Rational[this.numberOfComponents];
                                var14_33 = var10_29;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = new Rational(var3_21.readUnsignedInt(), var3_21.readUnsignedInt());
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_13) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_13);
                                }
                                return var1_1;
                            }
                            case 4: {
                                var2_7 = var3_21;
                                var1_1 = new long[this.numberOfComponents];
                                var14_33 = var11_30;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = (Rational)var3_21.readUnsignedInt();
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_14) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_14);
                                }
                                return var1_1;
                            }
                            case 3: {
                                var2_7 = var3_21;
                                var1_1 = new int[this.numberOfComponents];
                                var14_33 = var12_31;
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var1_1[var14_33] = (Rational)var3_21.readUnsignedShort();
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_15) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_15);
                                }
                                return var1_1;
                            }
                            case 2: 
                            case 7: {
                                var14_33 = var13_32;
                                var2_7 = var3_21;
                                if (this.numberOfComponents < ExifInterface.EXIF_ASCII_PREFIX.length) ** GOTO lbl212
                                var14_33 = 0;
                                while (true) {
                                    var6_25 = var5_24;
                                    var2_7 = var3_21;
                                    if (var14_33 >= ExifInterface.EXIF_ASCII_PREFIX.length) break;
                                    var2_7 = var3_21;
                                    if (this.bytes[var14_33] != ExifInterface.EXIF_ASCII_PREFIX[var14_33]) {
                                        var6_25 = 0;
                                        break;
                                    }
                                    ++var14_33;
                                    continue;
                                    break;
                                }
                                var14_33 = var13_32;
                                if (var6_25 != 0) {
                                    var2_7 = var3_21;
                                    var14_33 = ExifInterface.EXIF_ASCII_PREFIX.length;
                                }
lbl212:
                                // 4 sources

                                var2_7 = var3_21;
                                var2_7 = var3_21;
                                var1_1 = new StringBuilder();
                                while (true) {
                                    var2_7 = var3_21;
                                    if (var14_33 >= this.numberOfComponents) break;
                                    var2_7 = var3_21;
                                    var6_25 = this.bytes[var14_33];
                                    if (var6_25 == 0) break;
                                    if (var6_25 < 32) ** GOTO lbl230
                                    var2_7 = var3_21;
                                    var1_1.append((char)var6_25);
                                    ** GOTO lbl234
lbl230:
                                    // 1 sources

                                    var2_7 = var3_21;
                                    var1_1.append('?');
lbl234:
                                    // 2 sources

                                    ++var14_33;
                                }
                                var2_7 = var3_21;
                                var1_1 = var1_1.toString();
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_16) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_16);
                                }
                                return var1_1;
                            }
                            case 1: 
                            case 6: {
                                var2_7 = var3_21;
                                var1_1 = this.bytes;
                                var2_7 = var3_21;
                                ** try [egrp 48[TRYBLOCK] [87, 88 : 816->822)] { 
lbl252:
                                // 1 sources

                                if (((Rational[])var1_1).length == 1 && var1_1[0] >= 0 && var1_1[0] <= true) {
                                    var2_7 = var3_21;
                                    var1_1 = new String(new char[]{(char)(var1_1[0] + 48)});
                                    try {
                                        var3_21.close();
                                    }
                                    catch (IOException var2_17) {
                                        Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_17);
                                    }
                                    return var1_1;
                                }
                                var2_7 = var3_21;
                                var1_1 = new String((byte[])var1_1, ExifInterface.ASCII);
                                try {
                                    var3_21.close();
                                }
                                catch (IOException var2_18) {
                                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_18);
                                }
                                return var1_1;
                            }
                        }
                        try {
                            var3_21.close();
                        }
                        catch (IOException var1_2) {
                            Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var1_2);
                        }
                        return null;
lbl280:
                        // 40 sources

                        catch (IOException var2_19) {
                            var1_1 = var3_21;
                            var3_21 = var2_19;
                            break block101;
                        }
                        catch (Throwable var1_3) {
                            break block102;
                        }
                        catch (IOException var3_22) {
                            var1_1 = null;
                        }
                    }
                    var2_7 = var1_1;
                    Log.w((String)"ExifInterface", (String)"IOException occurred during reading a value", (Throwable)var3_21);
                    if (var1_1 == null) break block103;
                    try {
                        var1_1.close();
                    }
                    catch (IOException var1_4) {
                        Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var1_4);
                    }
                }
                return null;
lbl302:
                // 41 sources

                catch (Throwable var1_5) {
                    // empty catch block
                }
            }
            if (var2_7 != null) {
                try {
                    var2_7.close();
                }
                catch (IOException var2_20) {
                    Log.e((String)"ExifInterface", (String)"IOException occurred while closing InputStream", (Throwable)var2_20);
                }
            }
            throw var1_6;
        }

        public int size() {
            return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(IFD_FORMAT_NAMES[this.format]);
            stringBuilder.append(", data length:");
            stringBuilder.append(this.bytes.length);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    static class ExifTag {
        public final String name;
        public final int number;
        public final int primaryFormat;
        public final int secondaryFormat;

        ExifTag(String string2, int n, int n2) {
            this.name = string2;
            this.number = n;
            this.primaryFormat = n2;
            this.secondaryFormat = -1;
        }

        ExifTag(String string2, int n, int n2, int n3) {
            this.name = string2;
            this.number = n;
            this.primaryFormat = n2;
            this.secondaryFormat = n3;
        }

        boolean isFormatCompatible(int n) {
            int n2;
            int n3 = this.primaryFormat;
            if (n3 != 7 && n != 7 && n3 != n && (n2 = this.secondaryFormat) != n) {
                if ((n3 == 4 || n2 == 4) && n == 3) {
                    return true;
                }
                if ((n3 == 9 || n2 == 9) && n == 8) {
                    return true;
                }
                return (n3 == 12 || n2 == 12) && n == 11;
            }
            return true;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IfdType {
    }

    private static class Rational {
        public final long denominator;
        public final long numerator;

        Rational(double d) {
            this((long)(d * 10000.0), 10000L);
        }

        Rational(long l, long l2) {
            if (l2 == 0L) {
                this.numerator = 0L;
                this.denominator = 1L;
                return;
            }
            this.numerator = l;
            this.denominator = l2;
        }

        public double calculate() {
            return (double)this.numerator / (double)this.denominator;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.numerator);
            stringBuilder.append("/");
            stringBuilder.append(this.denominator);
            return stringBuilder.toString();
        }
    }
}

