/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.collection.ArraySet;
import androidx.core.os.CancellationSignal;
import androidx.fragment.R;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.BackStackState;
import androidx.fragment.app.DefaultSpecialEffectsController;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentAnim;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentLayoutInflaterFactory;
import androidx.fragment.app.FragmentLifecycleCallbacksDispatcher;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.fragment.app.FragmentManagerState;
import androidx.fragment.app.FragmentManagerViewModel;
import androidx.fragment.app.FragmentOnAttachListener;
import androidx.fragment.app.FragmentResultListener;
import androidx.fragment.app.FragmentResultOwner;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.FragmentStore;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.FragmentTransition;
import androidx.fragment.app.LogWriter;
import androidx.fragment.app.SpecialEffectsController;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FragmentManager
implements FragmentResultOwner {
    private static boolean DEBUG = false;
    private static final String EXTRA_CREATED_FILLIN_INTENT = "androidx.fragment.extra.ACTIVITY_OPTIONS_BUNDLE";
    public static final int POP_BACK_STACK_INCLUSIVE = 1;
    static final String TAG = "FragmentManager";
    static boolean USE_STATE_MANAGER = true;
    ArrayList<BackStackRecord> mBackStack;
    private ArrayList<OnBackStackChangedListener> mBackStackChangeListeners;
    private final AtomicInteger mBackStackIndex;
    private FragmentContainer mContainer;
    private ArrayList<Fragment> mCreatedMenus;
    int mCurState = -1;
    private SpecialEffectsControllerFactory mDefaultSpecialEffectsControllerFactory;
    private boolean mDestroyed;
    private Runnable mExecCommit;
    private boolean mExecutingActions;
    private Map<Fragment, HashSet<CancellationSignal>> mExitAnimationCancellationSignals;
    private FragmentFactory mFragmentFactory = null;
    private final FragmentStore mFragmentStore;
    private final FragmentTransition.Callback mFragmentTransitionCallback;
    private boolean mHavePendingDeferredStart;
    private FragmentHostCallback<?> mHost;
    private FragmentFactory mHostFragmentFactory;
    ArrayDeque<LaunchedFragmentInfo> mLaunchedFragments;
    private final FragmentLayoutInflaterFactory mLayoutInflaterFactory;
    private final FragmentLifecycleCallbacksDispatcher mLifecycleCallbacksDispatcher;
    private boolean mNeedMenuInvalidate;
    private FragmentManagerViewModel mNonConfig;
    private final CopyOnWriteArrayList<FragmentOnAttachListener> mOnAttachListeners;
    private final OnBackPressedCallback mOnBackPressedCallback;
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    private Fragment mParent;
    private final ArrayList<OpGenerator> mPendingActions = new ArrayList();
    private ArrayList<StartEnterTransitionListener> mPostponedTransactions;
    Fragment mPrimaryNav;
    private ActivityResultLauncher<String[]> mRequestPermissions;
    private final Map<String, LifecycleAwareResultListener> mResultListeners;
    private final Map<String, Bundle> mResults;
    private SpecialEffectsControllerFactory mSpecialEffectsControllerFactory = null;
    private ActivityResultLauncher<Intent> mStartActivityForResult;
    private ActivityResultLauncher<IntentSenderRequest> mStartIntentSenderForResult;
    private boolean mStateSaved;
    private boolean mStopped;
    private ArrayList<Fragment> mTmpAddedFragments;
    private ArrayList<Boolean> mTmpIsPop;
    private ArrayList<BackStackRecord> mTmpRecords;

    public FragmentManager() {
        this.mFragmentStore = new FragmentStore();
        this.mLayoutInflaterFactory = new FragmentLayoutInflaterFactory(this);
        this.mOnBackPressedCallback = new OnBackPressedCallback(false){

            @Override
            public void handleOnBackPressed() {
                FragmentManager.this.handleOnBackPressed();
            }
        };
        this.mBackStackIndex = new AtomicInteger();
        this.mResults = Collections.synchronizedMap(new HashMap());
        this.mResultListeners = Collections.synchronizedMap(new HashMap());
        this.mExitAnimationCancellationSignals = Collections.synchronizedMap(new HashMap());
        this.mFragmentTransitionCallback = new FragmentTransition.Callback(){

            @Override
            public void onComplete(Fragment fragment, CancellationSignal cancellationSignal) {
                if (!cancellationSignal.isCanceled()) {
                    FragmentManager.this.removeCancellationSignal(fragment, cancellationSignal);
                }
            }

            @Override
            public void onStart(Fragment fragment, CancellationSignal cancellationSignal) {
                FragmentManager.this.addCancellationSignal(fragment, cancellationSignal);
            }
        };
        this.mLifecycleCallbacksDispatcher = new FragmentLifecycleCallbacksDispatcher(this);
        this.mOnAttachListeners = new CopyOnWriteArrayList();
        this.mHostFragmentFactory = new FragmentFactory(){

            @Override
            public Fragment instantiate(ClassLoader classLoader, String string2) {
                return FragmentManager.this.getHost().instantiate(FragmentManager.this.getHost().getContext(), string2, null);
            }
        };
        this.mDefaultSpecialEffectsControllerFactory = new SpecialEffectsControllerFactory(){

            @Override
            public SpecialEffectsController createController(ViewGroup viewGroup) {
                return new DefaultSpecialEffectsController(viewGroup);
            }
        };
        this.mLaunchedFragments = new ArrayDeque();
        this.mExecCommit = new Runnable(){

            @Override
            public void run() {
                FragmentManager.this.execPendingActions(true);
            }
        };
    }

    private void addAddedFragments(ArraySet<Fragment> arraySet) {
        int n = this.mCurState;
        if (n < 1) {
            return;
        }
        n = Math.min(n, 5);
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment.mState >= n) continue;
            this.moveToState(fragment, n);
            if (fragment.mView == null || fragment.mHidden || !fragment.mIsNewlyAdded) continue;
            arraySet.add(fragment);
        }
    }

    private void cancelExitAnimation(Fragment fragment) {
        HashSet<CancellationSignal> hashSet = this.mExitAnimationCancellationSignals.get(fragment);
        if (hashSet != null) {
            Iterator<CancellationSignal> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                iterator.next().cancel();
            }
            hashSet.clear();
            this.destroyFragmentView(fragment);
            this.mExitAnimationCancellationSignals.remove(fragment);
        }
    }

    private void checkStateLoss() {
        if (!this.isStateSaved()) {
            return;
        }
        throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    private Set<SpecialEffectsController> collectAllSpecialEffectsController() {
        HashSet<SpecialEffectsController> hashSet = new HashSet<SpecialEffectsController>();
        Iterator<FragmentStateManager> iterator = this.mFragmentStore.getActiveFragmentStateManagers().iterator();
        while (iterator.hasNext()) {
            ViewGroup viewGroup = iterator.next().getFragment().mContainer;
            if (viewGroup == null) continue;
            hashSet.add(SpecialEffectsController.getOrCreateController(viewGroup, this.getSpecialEffectsControllerFactory()));
        }
        return hashSet;
    }

    private Set<SpecialEffectsController> collectChangedControllers(ArrayList<BackStackRecord> arrayList, int n, int n2) {
        HashSet<SpecialEffectsController> hashSet = new HashSet<SpecialEffectsController>();
        while (n < n2) {
            Iterator iterator = arrayList.get((int)n).mOps.iterator();
            while (iterator.hasNext()) {
                Fragment fragment = ((FragmentTransaction.Op)iterator.next()).mFragment;
                if (fragment == null || (fragment = fragment.mContainer) == null) continue;
                hashSet.add(SpecialEffectsController.getOrCreateController((ViewGroup)fragment, this));
            }
            ++n;
        }
        return hashSet;
    }

    private void completeShowHideFragment(final Fragment fragment) {
        if (fragment.mView != null) {
            FragmentAnim.AnimationOrAnimator animationOrAnimator = FragmentAnim.loadAnimation(this.mHost.getContext(), fragment, fragment.mHidden ^ true, fragment.getPopDirection());
            if (animationOrAnimator != null && animationOrAnimator.animator != null) {
                animationOrAnimator.animator.setTarget((Object)fragment.mView);
                if (fragment.mHidden) {
                    if (fragment.isHideReplaced()) {
                        fragment.setHideReplaced(false);
                    } else {
                        final ViewGroup viewGroup = fragment.mContainer;
                        final View view = fragment.mView;
                        viewGroup.startViewTransition(view);
                        animationOrAnimator.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animator2) {
                                viewGroup.endViewTransition(view);
                                animator2.removeListener((Animator.AnimatorListener)this);
                                if (fragment.mView != null && fragment.mHidden) {
                                    fragment.mView.setVisibility(8);
                                }
                            }
                        });
                    }
                } else {
                    fragment.mView.setVisibility(0);
                }
                animationOrAnimator.animator.start();
            } else {
                if (animationOrAnimator != null) {
                    fragment.mView.startAnimation(animationOrAnimator.animation);
                    animationOrAnimator.animation.start();
                }
                int n = fragment.mHidden && !fragment.isHideReplaced() ? 8 : 0;
                fragment.mView.setVisibility(n);
                if (fragment.isHideReplaced()) {
                    fragment.setHideReplaced(false);
                }
            }
        }
        this.invalidateMenuForFragment(fragment);
        fragment.mHiddenChanged = false;
        fragment.onHiddenChanged(fragment.mHidden);
    }

    private void destroyFragmentView(Fragment fragment) {
        fragment.performDestroyView();
        this.mLifecycleCallbacksDispatcher.dispatchOnFragmentViewDestroyed(fragment, false);
        fragment.mContainer = null;
        fragment.mView = null;
        fragment.mViewLifecycleOwner = null;
        fragment.mViewLifecycleOwnerLiveData.setValue(null);
        fragment.mInLayout = false;
    }

    private void dispatchParentPrimaryNavigationFragmentChanged(Fragment fragment) {
        if (fragment != null && fragment.equals(this.findActiveFragment(fragment.mWho))) {
            fragment.performPrimaryNavigationFragmentChanged();
        }
    }

    private void dispatchStateChange(int n) {
        this.mExecutingActions = true;
        this.mFragmentStore.dispatchStateChange(n);
        this.moveToState(n, false);
        if (USE_STATE_MANAGER) {
            Iterator<SpecialEffectsController> iterator = this.collectAllSpecialEffectsController().iterator();
            while (iterator.hasNext()) {
                iterator.next().forceCompleteAllOperations();
            }
        }
        this.execPendingActions(true);
        return;
        finally {
            this.mExecutingActions = false;
        }
    }

    private void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    @Deprecated
    public static void enableDebugLogging(boolean bl) {
        DEBUG = bl;
    }

    public static void enableNewStateManager(boolean bl) {
        USE_STATE_MANAGER = bl;
    }

    private void endAnimatingAwayFragments() {
        block3: {
            block2: {
                if (!USE_STATE_MANAGER) break block2;
                Iterator<SpecialEffectsController> iterator = this.collectAllSpecialEffectsController().iterator();
                while (iterator.hasNext()) {
                    iterator.next().forceCompleteAllOperations();
                }
                break block3;
            }
            if (this.mExitAnimationCancellationSignals.isEmpty()) break block3;
            for (Fragment fragment : this.mExitAnimationCancellationSignals.keySet()) {
                this.cancelExitAnimation(fragment);
                this.moveToState(fragment);
            }
        }
    }

    private void ensureExecReady(boolean bl) {
        if (!this.mExecutingActions) {
            if (this.mHost == null) {
                if (this.mDestroyed) {
                    throw new IllegalStateException("FragmentManager has been destroyed");
                }
                throw new IllegalStateException("FragmentManager has not been attached to a host.");
            }
            if (Looper.myLooper() == this.mHost.getHandler().getLooper()) {
                if (!bl) {
                    this.checkStateLoss();
                }
                if (this.mTmpRecords == null) {
                    this.mTmpRecords = new ArrayList();
                    this.mTmpIsPop = new ArrayList();
                }
                this.mExecutingActions = true;
                try {
                    this.executePostponedTransaction(null, null);
                    return;
                }
                finally {
                    this.mExecutingActions = false;
                }
            }
            throw new IllegalStateException("Must be called from main thread of fragment host");
        }
        throw new IllegalStateException("FragmentManager is already executing transactions");
    }

    private static void executeOps(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n, int n2) {
        while (n < n2) {
            BackStackRecord backStackRecord = arrayList.get(n);
            boolean bl = arrayList2.get(n);
            boolean bl2 = true;
            if (bl) {
                backStackRecord.bumpBackStackNesting(-1);
                if (n != n2 - 1) {
                    bl2 = false;
                }
                backStackRecord.executePopOps(bl2);
            } else {
                backStackRecord.bumpBackStackNesting(1);
                backStackRecord.executeOps();
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeOpsTogether(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> object, int n, int n2) {
        Object object2;
        int n3;
        boolean bl = arrayList.get((int)n).mReorderingAllowed;
        ArrayList<Fragment> arrayList22 = this.mTmpAddedFragments;
        if (arrayList22 == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            arrayList22.clear();
        }
        this.mTmpAddedFragments.addAll(this.mFragmentStore.getFragments());
        Fragment fragment = this.getPrimaryNavigationFragment();
        boolean bl2 = false;
        for (n3 = n; n3 < n2; ++n3) {
            void var6_8;
            object2 = arrayList.get(n3);
            if (!((Boolean)((ArrayList)object).get(n3)).booleanValue()) {
                Fragment fragment2 = ((BackStackRecord)object2).expandOps(this.mTmpAddedFragments, (Fragment)var6_8);
            } else {
                Fragment fragment3 = ((BackStackRecord)object2).trackAddedFragmentsInPop(this.mTmpAddedFragments, (Fragment)var6_8);
            }
            if (!bl2 && !((BackStackRecord)object2).mAddToBackStack) {
                bl2 = false;
                continue;
            }
            bl2 = true;
        }
        this.mTmpAddedFragments.clear();
        if (!bl && this.mCurState >= 1) {
            if (USE_STATE_MANAGER) {
                for (n3 = n; n3 < n2; ++n3) {
                    Iterator iterator = arrayList.get((int)n3).mOps.iterator();
                    while (iterator.hasNext()) {
                        object2 = ((FragmentTransaction.Op)iterator.next()).mFragment;
                        if (object2 == null || ((Fragment)object2).mFragmentManager == null) continue;
                        object2 = this.createOrGetFragmentStateManager((Fragment)object2);
                        this.mFragmentStore.makeActive((FragmentStateManager)object2);
                    }
                }
            } else {
                FragmentTransition.startTransitions(this.mHost.getContext(), this.mContainer, arrayList, (ArrayList<Boolean>)object, n, n2, false, this.mFragmentTransitionCallback);
            }
        }
        FragmentManager.executeOps(arrayList, (ArrayList<Boolean>)object, n, n2);
        if (USE_STATE_MANAGER) {
            bl = (Boolean)((ArrayList)object).get(n2 - 1);
            for (n3 = n; n3 < n2; ++n3) {
                BackStackRecord backStackRecord = arrayList.get(n3);
                if (bl) {
                    for (int i = backStackRecord.mOps.size() - 1; i >= 0; --i) {
                        object2 = ((FragmentTransaction.Op)backStackRecord.mOps.get((int)i)).mFragment;
                        if (object2 == null) continue;
                        this.createOrGetFragmentStateManager((Fragment)object2).moveToExpectedState();
                    }
                    continue;
                }
                Iterator iterator = backStackRecord.mOps.iterator();
                while (iterator.hasNext()) {
                    object2 = ((FragmentTransaction.Op)iterator.next()).mFragment;
                    if (object2 == null) continue;
                    this.createOrGetFragmentStateManager((Fragment)object2).moveToExpectedState();
                }
            }
            this.moveToState(this.mCurState, true);
            for (SpecialEffectsController specialEffectsController : this.collectChangedControllers(arrayList, n, n2)) {
                specialEffectsController.updateOperationDirection(bl);
                specialEffectsController.markPostponedState();
                specialEffectsController.executePendingOperations();
            }
        } else {
            if (bl) {
                ArraySet<Fragment> arraySet = new ArraySet<Fragment>();
                this.addAddedFragments(arraySet);
                n3 = this.postponePostponableTransactions(arrayList, (ArrayList<Boolean>)object, n, n2, arraySet);
                this.makeRemovedFragmentsInvisible(arraySet);
            } else {
                n3 = n2;
            }
            Object object3 = object;
            if (n3 != n && bl) {
                if (this.mCurState >= 1) {
                    FragmentTransition.startTransitions(this.mHost.getContext(), this.mContainer, arrayList, (ArrayList<Boolean>)object, n, n3, true, this.mFragmentTransitionCallback);
                }
                object = object3;
                this.moveToState(this.mCurState, true);
            } else {
                object = object3;
            }
        }
        while (n < n2) {
            BackStackRecord backStackRecord = arrayList.get(n);
            if (((Boolean)((ArrayList)object).get(n)).booleanValue() && backStackRecord.mIndex >= 0) {
                backStackRecord.mIndex = -1;
            }
            backStackRecord.runOnCommitRunnables();
            ++n;
        }
        if (bl2) {
            this.reportBackStackChanged();
        }
    }

    private void executePostponedTransaction(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
        ArrayList<StartEnterTransitionListener> arrayList3 = this.mPostponedTransactions;
        int n = arrayList3 == null ? 0 : arrayList3.size();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int n4;
            block7: {
                block8: {
                    block6: {
                        arrayList3 = this.mPostponedTransactions.get(n2);
                        if (arrayList == null || ((StartEnterTransitionListener)((Object)arrayList3)).mIsBack || (n = arrayList.indexOf(((StartEnterTransitionListener)((Object)arrayList3)).mRecord)) == -1 || arrayList2 == null || !arrayList2.get(n).booleanValue()) break block6;
                        this.mPostponedTransactions.remove(n2);
                        n4 = n2 - 1;
                        n = n3 - 1;
                        ((StartEnterTransitionListener)((Object)arrayList3)).cancelTransaction();
                        break block7;
                    }
                    if (((StartEnterTransitionListener)((Object)arrayList3)).isReady()) break block8;
                    n = n3;
                    n4 = n2;
                    if (arrayList == null) break block7;
                    n = n3;
                    n4 = n2;
                    if (!((StartEnterTransitionListener)((Object)arrayList3)).mRecord.interactsWith(arrayList, 0, arrayList.size())) break block7;
                }
                this.mPostponedTransactions.remove(n2);
                n4 = n2 - 1;
                n = n3 - 1;
                if (arrayList != null && !((StartEnterTransitionListener)((Object)arrayList3)).mIsBack && (n2 = arrayList.indexOf(((StartEnterTransitionListener)((Object)arrayList3)).mRecord)) != -1 && arrayList2 != null && arrayList2.get(n2).booleanValue()) {
                    ((StartEnterTransitionListener)((Object)arrayList3)).cancelTransaction();
                } else {
                    ((StartEnterTransitionListener)((Object)arrayList3)).completeTransaction();
                }
            }
            n2 = n4 + 1;
            n3 = n;
        }
    }

    public static <F extends Fragment> F findFragment(View view) {
        Object object = FragmentManager.findViewFragment(view);
        if (object != null) {
            return (F)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("View ");
        ((StringBuilder)object).append(view);
        ((StringBuilder)object).append(" does not have a Fragment set");
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    static FragmentManager findFragmentManager(View object) {
        Object object2;
        block8: {
            block7: {
                FragmentActivity fragmentActivity;
                block5: {
                    block6: {
                        object2 = FragmentManager.findViewFragment(object);
                        if (object2 == null) break block5;
                        if (!((Fragment)object2).isAdded()) break block6;
                        object = ((Fragment)object2).getChildFragmentManager();
                        break block7;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The Fragment ");
                    stringBuilder.append(object2);
                    stringBuilder.append(" that owns View ");
                    stringBuilder.append(object);
                    stringBuilder.append(" has already been destroyed. Nested fragments should always use the child FragmentManager.");
                    throw new IllegalStateException(stringBuilder.toString());
                }
                object2 = object.getContext();
                FragmentActivity fragmentActivity2 = null;
                while (true) {
                    fragmentActivity = fragmentActivity2;
                    if (!(object2 instanceof ContextWrapper)) break;
                    if (object2 instanceof FragmentActivity) {
                        fragmentActivity = (FragmentActivity)object2;
                        break;
                    }
                    object2 = ((ContextWrapper)object2).getBaseContext();
                }
                if (fragmentActivity == null) break block8;
                object = fragmentActivity.getSupportFragmentManager();
            }
            return object;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("View ");
        ((StringBuilder)object2).append(object);
        ((StringBuilder)object2).append(" is not within a subclass of FragmentActivity.");
        throw new IllegalStateException(((StringBuilder)object2).toString());
    }

    private static Fragment findViewFragment(View view) {
        while (view != null) {
            Fragment fragment = FragmentManager.getViewFragment(view);
            if (fragment != null) {
                return fragment;
            }
            if ((view = view.getParent()) instanceof View) continue;
            view = null;
        }
        return null;
    }

    private void forcePostponedTransactions() {
        block3: {
            block2: {
                if (!USE_STATE_MANAGER) break block2;
                Iterator<SpecialEffectsController> iterator = this.collectAllSpecialEffectsController().iterator();
                while (iterator.hasNext()) {
                    iterator.next().forcePostponedExecutePendingOperations();
                }
                break block3;
            }
            if (this.mPostponedTransactions == null) break block3;
            while (!this.mPostponedTransactions.isEmpty()) {
                this.mPostponedTransactions.remove(0).completeTransaction();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateOpsForPendingActions(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
        ArrayList<OpGenerator> arrayList3 = this.mPendingActions;
        synchronized (arrayList3) {
            boolean bl = this.mPendingActions.isEmpty();
            int n = 0;
            if (bl) {
                return false;
            }
            int n2 = this.mPendingActions.size();
            bl = false;
            while (true) {
                if (n >= n2) {
                    this.mPendingActions.clear();
                    this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                    return bl;
                }
                bl |= this.mPendingActions.get(n).generateOps(arrayList, arrayList2);
                ++n;
            }
        }
    }

    private FragmentManagerViewModel getChildNonConfig(Fragment fragment) {
        return this.mNonConfig.getChildNonConfig(fragment);
    }

    private ViewGroup getFragmentContainer(Fragment fragment) {
        if (fragment.mContainer != null) {
            return fragment.mContainer;
        }
        if (fragment.mContainerId <= 0) {
            return null;
        }
        if (this.mContainer.onHasView() && (fragment = this.mContainer.onFindViewById(fragment.mContainerId)) instanceof ViewGroup) {
            return (ViewGroup)fragment;
        }
        return null;
    }

    static Fragment getViewFragment(View object) {
        if ((object = object.getTag(R.id.fragment_container_view_tag)) instanceof Fragment) {
            return (Fragment)object;
        }
        return null;
    }

    static boolean isLoggingEnabled(int n) {
        boolean bl = DEBUG || Log.isLoggable((String)TAG, (int)n);
        return bl;
    }

    private boolean isMenuAvailable(Fragment fragment) {
        boolean bl = fragment.mHasMenu && fragment.mMenuVisible || fragment.mChildFragmentManager.checkForMenus();
        return bl;
    }

    private void makeRemovedFragmentsInvisible(ArraySet<Fragment> arraySet) {
        int n = arraySet.size();
        for (int i = 0; i < n; ++i) {
            Fragment fragment = arraySet.valueAt(i);
            if (fragment.mAdded) continue;
            View view = fragment.requireView();
            fragment.mPostponedAlpha = view.getAlpha();
            view.setAlpha(0.0f);
        }
    }

    private boolean popBackStackImmediate(String string2, int n, int n2) {
        this.execPendingActions(false);
        this.ensureExecReady(true);
        Fragment fragment = this.mPrimaryNav;
        if (fragment != null && n < 0 && string2 == null && fragment.getChildFragmentManager().popBackStackImmediate()) {
            return true;
        }
        boolean bl = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, string2, n, n2);
        if (bl) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return bl;
    }

    private int postponePostponableTransactions(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n, int n2, ArraySet<Fragment> arraySet) {
        int n3 = n2;
        for (int i = n2 - 1; i >= n; --i) {
            BackStackRecord backStackRecord = arrayList.get(i);
            boolean bl = arrayList2.get(i);
            boolean bl2 = backStackRecord.isPostponed() && !backStackRecord.interactsWith(arrayList, i + 1, n2);
            int n4 = n3;
            if (bl2) {
                if (this.mPostponedTransactions == null) {
                    this.mPostponedTransactions = new ArrayList();
                }
                StartEnterTransitionListener startEnterTransitionListener = new StartEnterTransitionListener(backStackRecord, bl);
                this.mPostponedTransactions.add(startEnterTransitionListener);
                backStackRecord.setOnStartPostponedListener(startEnterTransitionListener);
                if (bl) {
                    backStackRecord.executeOps();
                } else {
                    backStackRecord.executePopOps(false);
                }
                n4 = n3 - 1;
                if (i != n4) {
                    arrayList.remove(i);
                    arrayList.add(n4, backStackRecord);
                }
                this.addAddedFragments(arraySet);
            }
            n3 = n4;
        }
        return n3;
    }

    private void removeRedundantOperationsAndExecute(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
        if (arrayList.isEmpty()) {
            return;
        }
        if (arrayList.size() == arrayList2.size()) {
            this.executePostponedTransaction(arrayList, arrayList2);
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = n2;
                int n5 = n3;
                if (!arrayList.get((int)n2).mReorderingAllowed) {
                    if (n3 != n2) {
                        this.executeOpsTogether(arrayList, arrayList2, n3, n2);
                    }
                    n5 = n3 = n2 + 1;
                    if (arrayList2.get(n2).booleanValue()) {
                        while (true) {
                            n5 = n3;
                            if (n3 >= n) break;
                            n5 = n3;
                            if (!arrayList2.get(n3).booleanValue()) break;
                            n5 = n3;
                            if (arrayList.get((int)n3).mReorderingAllowed) break;
                            ++n3;
                        }
                    }
                    this.executeOpsTogether(arrayList, arrayList2, n2, n5);
                    n4 = n5 - 1;
                }
                n2 = n4 + 1;
                n3 = n5;
            }
            if (n3 != n) {
                this.executeOpsTogether(arrayList, arrayList2, n3, n);
            }
            return;
        }
        throw new IllegalStateException("Internal error with the back stack records");
    }

    private void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    static int reverseTransit(int n) {
        int n2 = 8194;
        if (n != 4097) {
            n2 = n != 4099 ? (n != 8194 ? 0 : 4097) : 4099;
        }
        return n2;
    }

    private void setVisibleRemovingFragment(Fragment fragment) {
        ViewGroup viewGroup = this.getFragmentContainer(fragment);
        if (viewGroup != null && fragment.getEnterAnim() + fragment.getExitAnim() + fragment.getPopEnterAnim() + fragment.getPopExitAnim() > 0) {
            if (viewGroup.getTag(R.id.visible_removing_fragment_view_tag) == null) {
                viewGroup.setTag(R.id.visible_removing_fragment_view_tag, (Object)fragment);
            }
            ((Fragment)viewGroup.getTag(R.id.visible_removing_fragment_view_tag)).setPopDirection(fragment.getPopDirection());
        }
    }

    private void startPendingDeferredFragments() {
        Iterator<FragmentStateManager> iterator = this.mFragmentStore.getActiveFragmentStateManagers().iterator();
        while (iterator.hasNext()) {
            this.performPendingDeferredStart(iterator.next());
        }
    }

    private void throwException(RuntimeException runtimeException) {
        Log.e((String)TAG, (String)runtimeException.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        PrintWriter printWriter = new PrintWriter(new LogWriter(TAG));
        FragmentHostCallback<?> fragmentHostCallback = this.mHost;
        if (fragmentHostCallback != null) {
            try {
                fragmentHostCallback.onDump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            }
        } else {
            try {
                this.dump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            }
        }
        throw runtimeException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOnBackPressedCallbackEnabled() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            boolean bl = this.mPendingActions.isEmpty();
            boolean bl2 = true;
            if (!bl) {
                this.mOnBackPressedCallback.setEnabled(true);
                return;
            }
            OnBackPressedCallback onBackPressedCallback = this.mOnBackPressedCallback;
            if (this.getBackStackEntryCount() <= 0 || !this.isPrimaryNavigation(this.mParent)) {
                bl2 = false;
            }
            onBackPressedCallback.setEnabled(bl2);
            return;
        }
    }

    void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
    }

    void addCancellationSignal(Fragment fragment, CancellationSignal cancellationSignal) {
        if (this.mExitAnimationCancellationSignals.get(fragment) == null) {
            this.mExitAnimationCancellationSignals.put(fragment, new HashSet());
        }
        this.mExitAnimationCancellationSignals.get(fragment).add(cancellationSignal);
    }

    FragmentStateManager addFragment(Fragment fragment) {
        Object object;
        if (FragmentManager.isLoggingEnabled(2)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("add: ");
            ((StringBuilder)object).append(fragment);
            Log.v((String)TAG, (String)((StringBuilder)object).toString());
        }
        object = this.createOrGetFragmentStateManager(fragment);
        fragment.mFragmentManager = this;
        this.mFragmentStore.makeActive((FragmentStateManager)object);
        if (!fragment.mDetached) {
            this.mFragmentStore.addFragment(fragment);
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
        }
        return object;
    }

    public void addFragmentOnAttachListener(FragmentOnAttachListener fragmentOnAttachListener) {
        this.mOnAttachListeners.add(fragmentOnAttachListener);
    }

    public void addOnBackStackChangedListener(OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(onBackStackChangedListener);
    }

    void addRetainedFragment(Fragment fragment) {
        this.mNonConfig.addRetainedFragment(fragment);
    }

    int allocBackStackIndex() {
        return this.mBackStackIndex.getAndIncrement();
    }

    void attachController(FragmentHostCallback<?> object, FragmentContainer object2, Fragment object3) {
        if (this.mHost == null) {
            this.mHost = object;
            this.mContainer = object2;
            this.mParent = object3;
            if (object3 != null) {
                this.addFragmentOnAttachListener(new FragmentOnAttachListener((Fragment)object3){
                    final /* synthetic */ Fragment val$parent;
                    {
                        this.val$parent = fragment;
                    }

                    @Override
                    public void onAttachFragment(FragmentManager fragmentManager, Fragment fragment) {
                        this.val$parent.onAttachFragment(fragment);
                    }
                });
            } else if (object instanceof FragmentOnAttachListener) {
                this.addFragmentOnAttachListener((FragmentOnAttachListener)object);
            }
            if (this.mParent != null) {
                this.updateOnBackPressedCallbackEnabled();
            }
            if (object instanceof OnBackPressedDispatcherOwner) {
                OnBackPressedDispatcher onBackPressedDispatcher;
                object2 = (OnBackPressedDispatcherOwner)object;
                this.mOnBackPressedDispatcher = onBackPressedDispatcher = object2.getOnBackPressedDispatcher();
                if (object3 != null) {
                    object2 = object3;
                }
                onBackPressedDispatcher.addCallback((LifecycleOwner)object2, this.mOnBackPressedCallback);
            }
            this.mNonConfig = object3 != null ? ((Fragment)object3).mFragmentManager.getChildNonConfig((Fragment)object3) : (object instanceof ViewModelStoreOwner ? FragmentManagerViewModel.getInstance(((ViewModelStoreOwner)object).getViewModelStore()) : new FragmentManagerViewModel(false));
            this.mNonConfig.setIsStateSaved(this.isStateSaved());
            this.mFragmentStore.setNonConfig(this.mNonConfig);
            object = this.mHost;
            if (object instanceof ActivityResultRegistryOwner) {
                object2 = ((ActivityResultRegistryOwner)object).getActivityResultRegistry();
                if (object3 != null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(((Fragment)object3).mWho);
                    ((StringBuilder)object).append(":");
                    object = ((StringBuilder)object).toString();
                } else {
                    object = "";
                }
                object3 = new StringBuilder();
                ((StringBuilder)object3).append("FragmentManager:");
                ((StringBuilder)object3).append((String)object);
                object = ((StringBuilder)object3).toString();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object);
                ((StringBuilder)object3).append("StartActivityForResult");
                this.mStartActivityForResult = ((ActivityResultRegistry)object2).register(((StringBuilder)object3).toString(), new ActivityResultContracts.StartActivityForResult(), new ActivityResultCallback<ActivityResult>(){

                    @Override
                    public void onActivityResult(ActivityResult object) {
                        Object object2 = FragmentManager.this.mLaunchedFragments.pollFirst();
                        if (object2 == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("No Activities were started for result for ");
                            ((StringBuilder)object).append(this);
                            Log.w((String)FragmentManager.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        String string2 = ((LaunchedFragmentInfo)object2).mWho;
                        int n = ((LaunchedFragmentInfo)object2).mRequestCode;
                        object2 = FragmentManager.this.mFragmentStore.findFragmentByWho(string2);
                        if (object2 == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Activity result delivered for unknown Fragment ");
                            ((StringBuilder)object).append(string2);
                            Log.w((String)FragmentManager.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        ((Fragment)object2).onActivityResult(n, ((ActivityResult)object).getResultCode(), ((ActivityResult)object).getData());
                    }
                });
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object);
                ((StringBuilder)object3).append("StartIntentSenderForResult");
                this.mStartIntentSenderForResult = ((ActivityResultRegistry)object2).register(((StringBuilder)object3).toString(), new FragmentIntentSenderContract(), new ActivityResultCallback<ActivityResult>(){

                    @Override
                    public void onActivityResult(ActivityResult object) {
                        Object object2 = FragmentManager.this.mLaunchedFragments.pollFirst();
                        if (object2 == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("No IntentSenders were started for ");
                            ((StringBuilder)object).append(this);
                            Log.w((String)FragmentManager.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        String string2 = ((LaunchedFragmentInfo)object2).mWho;
                        int n = ((LaunchedFragmentInfo)object2).mRequestCode;
                        object2 = FragmentManager.this.mFragmentStore.findFragmentByWho(string2);
                        if (object2 == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Intent Sender result delivered for unknown Fragment ");
                            ((StringBuilder)object).append(string2);
                            Log.w((String)FragmentManager.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        ((Fragment)object2).onActivityResult(n, ((ActivityResult)object).getResultCode(), ((ActivityResult)object).getData());
                    }
                });
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object);
                ((StringBuilder)object3).append("RequestPermissions");
                this.mRequestPermissions = ((ActivityResultRegistry)object2).register(((StringBuilder)object3).toString(), new ActivityResultContracts.RequestMultiplePermissions(), new ActivityResultCallback<Map<String, Boolean>>(){

                    @Override
                    public void onActivityResult(Map<String, Boolean> object) {
                        int n;
                        Object object2 = object.keySet().toArray(new String[0]);
                        object = new ArrayList<Boolean>(object.values());
                        int[] nArray = new int[((ArrayList)object).size()];
                        for (n = 0; n < ((ArrayList)object).size(); ++n) {
                            int n2 = (Boolean)((ArrayList)object).get(n) != false ? 0 : -1;
                            nArray[n] = n2;
                        }
                        Object object3 = FragmentManager.this.mLaunchedFragments.pollFirst();
                        if (object3 == null) {
                            object = new StringBuilder();
                            ((StringBuilder)object).append("No permissions were requested for ");
                            ((StringBuilder)object).append(this);
                            Log.w((String)FragmentManager.TAG, (String)((StringBuilder)object).toString());
                            return;
                        }
                        object = ((LaunchedFragmentInfo)object3).mWho;
                        n = ((LaunchedFragmentInfo)object3).mRequestCode;
                        object3 = FragmentManager.this.mFragmentStore.findFragmentByWho((String)object);
                        if (object3 == null) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Permission request result delivered for unknown Fragment ");
                            ((StringBuilder)object2).append((String)object);
                            Log.w((String)FragmentManager.TAG, (String)((StringBuilder)object2).toString());
                            return;
                        }
                        ((Fragment)object3).onRequestPermissionsResult(n, (String[])object2, nArray);
                    }
                });
            }
            return;
        }
        throw new IllegalStateException("Already attached");
    }

    void attachFragment(Fragment fragment) {
        StringBuilder stringBuilder;
        if (FragmentManager.isLoggingEnabled(2)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("attach: ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                this.mFragmentStore.addFragment(fragment);
                if (FragmentManager.isLoggingEnabled(2)) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("add from attach: ");
                    stringBuilder.append(fragment);
                    Log.v((String)TAG, (String)stringBuilder.toString());
                }
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
            }
        }
    }

    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    boolean checkForMenus() {
        Iterator<Fragment> iterator = this.mFragmentStore.getActiveFragments().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Fragment fragment = iterator.next();
            boolean bl2 = bl;
            if (fragment != null) {
                bl2 = this.isMenuAvailable(fragment);
            }
            bl = bl2;
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void clearFragmentResult(String string2) {
        this.mResults.remove(string2);
    }

    @Override
    public final void clearFragmentResultListener(String object) {
        if ((object = this.mResultListeners.remove(object)) != null) {
            ((LifecycleAwareResultListener)object).removeObserver();
        }
    }

    void completeExecute(BackStackRecord backStackRecord, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            backStackRecord.executePopOps(bl3);
        } else {
            backStackRecord.executeOps();
        }
        ArrayList<BackStackRecord> arrayList = new ArrayList<BackStackRecord>(1);
        ArrayList<Boolean> object2 = new ArrayList<Boolean>(1);
        arrayList.add(backStackRecord);
        object2.add(bl);
        if (bl2 && this.mCurState >= 1) {
            FragmentTransition.startTransitions(this.mHost.getContext(), this.mContainer, arrayList, object2, 0, 1, true, this.mFragmentTransitionCallback);
        }
        if (bl3) {
            this.moveToState(this.mCurState, true);
        }
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment == null || fragment.mView == null || !fragment.mIsNewlyAdded || !backStackRecord.interactsWith(fragment.mContainerId)) continue;
            if (fragment.mPostponedAlpha > 0.0f) {
                fragment.mView.setAlpha(fragment.mPostponedAlpha);
            }
            if (bl3) {
                fragment.mPostponedAlpha = 0.0f;
                continue;
            }
            fragment.mPostponedAlpha = -1.0f;
            fragment.mIsNewlyAdded = false;
        }
    }

    FragmentStateManager createOrGetFragmentStateManager(Fragment object) {
        FragmentStateManager fragmentStateManager = this.mFragmentStore.getFragmentStateManager(((Fragment)object).mWho);
        if (fragmentStateManager != null) {
            return fragmentStateManager;
        }
        object = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, (Fragment)object);
        ((FragmentStateManager)object).restoreState(this.mHost.getContext().getClassLoader());
        ((FragmentStateManager)object).setFragmentManagerState(this.mCurState);
        return object;
    }

    void detachFragment(Fragment fragment) {
        StringBuilder stringBuilder;
        if (FragmentManager.isLoggingEnabled(2)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("detach: ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("remove from detach: ");
                    stringBuilder.append(fragment);
                    Log.v((String)TAG, (String)stringBuilder.toString());
                }
                this.mFragmentStore.removeFragment(fragment);
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
                this.setVisibleRemovingFragment(fragment);
            }
        }
    }

    void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(4);
    }

    void dispatchAttach() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(0);
    }

    void dispatchConfigurationChanged(Configuration configuration) {
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.performConfigurationChanged(configuration);
        }
    }

    boolean dispatchContextItemSelected(MenuItem menuItem) {
        if (this.mCurState < 1) {
            return false;
        }
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null || !fragment.performContextItemSelected(menuItem)) continue;
            return true;
        }
        return false;
    }

    void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(1);
    }

    boolean dispatchCreateOptionsMenu(Menu object, MenuInflater menuInflater) {
        int n = this.mCurState;
        int n2 = 0;
        if (n < 1) {
            return false;
        }
        ArrayList<Fragment> arrayList = null;
        Iterator<Fragment> iterator = this.mFragmentStore.getFragments().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Fragment fragment = iterator.next();
            if (fragment == null || !this.isParentMenuVisible(fragment) || !fragment.performCreateOptionsMenu((Menu)object, menuInflater)) continue;
            ArrayList<Fragment> arrayList2 = arrayList;
            if (arrayList == null) {
                arrayList2 = new ArrayList<Fragment>();
            }
            arrayList2.add(fragment);
            bl = true;
            arrayList = arrayList2;
        }
        if (this.mCreatedMenus != null) {
            while (n2 < this.mCreatedMenus.size()) {
                object = this.mCreatedMenus.get(n2);
                if (arrayList == null || !arrayList.contains(object)) {
                    ((Fragment)object).onDestroyOptionsMenu();
                }
                ++n2;
            }
        }
        this.mCreatedMenus = arrayList;
        return bl;
    }

    void dispatchDestroy() {
        ActivityResultLauncher<Intent> activityResultLauncher;
        this.mDestroyed = true;
        this.execPendingActions(true);
        this.endAnimatingAwayFragments();
        this.dispatchStateChange(-1);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
        if (this.mOnBackPressedDispatcher != null) {
            this.mOnBackPressedCallback.remove();
            this.mOnBackPressedDispatcher = null;
        }
        if ((activityResultLauncher = this.mStartActivityForResult) != null) {
            activityResultLauncher.unregister();
            this.mStartIntentSenderForResult.unregister();
            this.mRequestPermissions.unregister();
        }
    }

    void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    void dispatchLowMemory() {
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.performLowMemory();
        }
    }

    void dispatchMultiWindowModeChanged(boolean bl) {
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.performMultiWindowModeChanged(bl);
        }
    }

    void dispatchOnAttachFragment(Fragment fragment) {
        Iterator<FragmentOnAttachListener> iterator = this.mOnAttachListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAttachFragment(this, fragment);
        }
    }

    boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        if (this.mCurState < 1) {
            return false;
        }
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null || !fragment.performOptionsItemSelected(menuItem)) continue;
            return true;
        }
        return false;
    }

    void dispatchOptionsMenuClosed(Menu menu2) {
        if (this.mCurState < 1) {
            return;
        }
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.performOptionsMenuClosed(menu2);
        }
    }

    void dispatchPause() {
        this.dispatchStateChange(5);
    }

    void dispatchPictureInPictureModeChanged(boolean bl) {
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.performPictureInPictureModeChanged(bl);
        }
    }

    boolean dispatchPrepareOptionsMenu(Menu menu2) {
        int n = this.mCurState;
        boolean bl = false;
        if (n < 1) {
            return false;
        }
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null || !this.isParentMenuVisible(fragment) || !fragment.performPrepareOptionsMenu(menu2)) continue;
            bl = true;
        }
        return bl;
    }

    void dispatchPrimaryNavigationFragmentChanged() {
        this.updateOnBackPressedCallbackEnabled();
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(7);
    }

    void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(5);
    }

    void dispatchStop() {
        this.mStopped = true;
        this.mNonConfig.setIsStateSaved(true);
        this.dispatchStateChange(4);
    }

    void dispatchViewCreated() {
        this.dispatchStateChange(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(String string2, FileDescriptor arrayList, PrintWriter printWriter, String[] object) {
        int n;
        int n2;
        CharSequence charSequence = new StringBuilder();
        charSequence.append(string2);
        charSequence.append("    ");
        charSequence = charSequence.toString();
        this.mFragmentStore.dump(string2, (FileDescriptor)((Object)arrayList), printWriter, (String[])object);
        arrayList = this.mCreatedMenus;
        int n3 = 0;
        if (arrayList != null && (n2 = arrayList.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Fragments Created Menus:");
            for (n = 0; n < n2; ++n) {
                arrayList = this.mCreatedMenus.get(n);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n);
                printWriter.print(": ");
                printWriter.println(((Fragment)((Object)arrayList)).toString());
            }
        }
        if ((arrayList = this.mBackStack) != null && (n2 = arrayList.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack:");
            for (n = 0; n < n2; ++n) {
                arrayList = this.mBackStack.get(n);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n);
                printWriter.print(": ");
                printWriter.println(((BackStackRecord)((Object)arrayList)).toString());
                ((BackStackRecord)((Object)arrayList)).dump((String)charSequence, printWriter);
            }
        }
        printWriter.print(string2);
        arrayList = new StringBuilder();
        ((StringBuilder)((Object)arrayList)).append("Back Stack Index: ");
        ((StringBuilder)((Object)arrayList)).append(this.mBackStackIndex.get());
        printWriter.println(((StringBuilder)((Object)arrayList)).toString());
        arrayList = this.mPendingActions;
        synchronized (arrayList) {
            n2 = this.mPendingActions.size();
            if (n2 > 0) {
                printWriter.print(string2);
                printWriter.println("Pending Actions:");
                for (n = n3; n < n2; ++n) {
                    object = this.mPendingActions.get(n);
                    printWriter.print(string2);
                    printWriter.print("  #");
                    printWriter.print(n);
                    printWriter.print(": ");
                    printWriter.println(object);
                }
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mHost=");
        printWriter.println(this.mHost);
        printWriter.print(string2);
        printWriter.print("  mContainer=");
        printWriter.println(this.mContainer);
        if (this.mParent != null) {
            printWriter.print(string2);
            printWriter.print("  mParent=");
            printWriter.println(this.mParent);
        }
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mStopped=");
        printWriter.print(this.mStopped);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            printWriter.print(string2);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.mNeedMenuInvalidate);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueueAction(OpGenerator object, boolean bl) {
        if (!bl) {
            if (this.mHost == null) {
                if (this.mDestroyed) {
                    throw new IllegalStateException("FragmentManager has been destroyed");
                }
                throw new IllegalStateException("FragmentManager has not been attached to a host.");
            }
            this.checkStateLoss();
        }
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mHost != null) {
                this.mPendingActions.add((OpGenerator)object);
                this.scheduleCommit();
                return;
            }
            if (bl) {
                return;
            }
            object = new IllegalStateException("Activity has been destroyed");
            throw object;
        }
    }

    boolean execPendingActions(boolean bl) {
        this.ensureExecReady(bl);
        bl = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
                bl = true;
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return bl;
    }

    void execSingleAction(OpGenerator opGenerator, boolean bl) {
        if (bl && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(bl);
        if (opGenerator.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
    }

    public boolean executePendingTransactions() {
        boolean bl = this.execPendingActions(true);
        this.forcePostponedTransactions();
        return bl;
    }

    Fragment findActiveFragment(String string2) {
        return this.mFragmentStore.findActiveFragment(string2);
    }

    public Fragment findFragmentById(int n) {
        return this.mFragmentStore.findFragmentById(n);
    }

    public Fragment findFragmentByTag(String string2) {
        return this.mFragmentStore.findFragmentByTag(string2);
    }

    Fragment findFragmentByWho(String string2) {
        return this.mFragmentStore.findFragmentByWho(string2);
    }

    int getActiveFragmentCount() {
        return this.mFragmentStore.getActiveFragmentCount();
    }

    List<Fragment> getActiveFragments() {
        return this.mFragmentStore.getActiveFragments();
    }

    public BackStackEntry getBackStackEntryAt(int n) {
        return this.mBackStack.get(n);
    }

    public int getBackStackEntryCount() {
        ArrayList<BackStackRecord> arrayList = this.mBackStack;
        int n = arrayList != null ? arrayList.size() : 0;
        return n;
    }

    FragmentContainer getContainer() {
        return this.mContainer;
    }

    public Fragment getFragment(Bundle object, String string2) {
        if ((object = object.getString(string2)) == null) {
            return null;
        }
        Fragment fragment = this.findActiveFragment((String)object);
        if (fragment == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment no longer exists for key ");
            stringBuilder.append(string2);
            stringBuilder.append(": unique id ");
            stringBuilder.append((String)object);
            this.throwException(new IllegalStateException(stringBuilder.toString()));
        }
        return fragment;
    }

    public FragmentFactory getFragmentFactory() {
        Object object = this.mFragmentFactory;
        if (object != null) {
            return object;
        }
        object = this.mParent;
        if (object != null) {
            return ((Fragment)object).mFragmentManager.getFragmentFactory();
        }
        return this.mHostFragmentFactory;
    }

    FragmentStore getFragmentStore() {
        return this.mFragmentStore;
    }

    public List<Fragment> getFragments() {
        return this.mFragmentStore.getFragments();
    }

    FragmentHostCallback<?> getHost() {
        return this.mHost;
    }

    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this.mLayoutInflaterFactory;
    }

    FragmentLifecycleCallbacksDispatcher getLifecycleCallbacksDispatcher() {
        return this.mLifecycleCallbacksDispatcher;
    }

    Fragment getParent() {
        return this.mParent;
    }

    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    SpecialEffectsControllerFactory getSpecialEffectsControllerFactory() {
        Object object = this.mSpecialEffectsControllerFactory;
        if (object != null) {
            return object;
        }
        object = this.mParent;
        if (object != null) {
            return ((Fragment)object).mFragmentManager.getSpecialEffectsControllerFactory();
        }
        return this.mDefaultSpecialEffectsControllerFactory;
    }

    ViewModelStore getViewModelStore(Fragment fragment) {
        return this.mNonConfig.getViewModelStore(fragment);
    }

    void handleOnBackPressed() {
        this.execPendingActions(true);
        if (this.mOnBackPressedCallback.isEnabled()) {
            this.popBackStackImmediate();
        } else {
            this.mOnBackPressedDispatcher.onBackPressed();
        }
    }

    void hideFragment(Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("hide: ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = true ^ fragment.mHiddenChanged;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void invalidateMenuForFragment(Fragment fragment) {
        if (fragment.mAdded && this.isMenuAvailable(fragment)) {
            this.mNeedMenuInvalidate = true;
        }
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    boolean isParentMenuVisible(Fragment fragment) {
        if (fragment == null) {
            return true;
        }
        return fragment.isMenuVisible();
    }

    boolean isPrimaryNavigation(Fragment fragment) {
        boolean bl = true;
        if (fragment == null) {
            return true;
        }
        FragmentManager fragmentManager = fragment.mFragmentManager;
        if (!fragment.equals(fragmentManager.getPrimaryNavigationFragment()) || !this.isPrimaryNavigation(fragmentManager.mParent)) {
            bl = false;
        }
        return bl;
    }

    boolean isStateAtLeast(int n) {
        boolean bl = this.mCurState >= n;
        return bl;
    }

    public boolean isStateSaved() {
        boolean bl = this.mStateSaved || this.mStopped;
        return bl;
    }

    void launchRequestPermissions(Fragment object, String[] stringArray, int n) {
        if (this.mRequestPermissions != null) {
            object = new LaunchedFragmentInfo(((Fragment)object).mWho, n);
            this.mLaunchedFragments.addLast((LaunchedFragmentInfo)object);
            this.mRequestPermissions.launch(stringArray);
        } else {
            this.mHost.onRequestPermissionsFromFragment((Fragment)object, stringArray, n);
        }
    }

    void launchStartActivityForResult(Fragment object, Intent intent, int n, Bundle bundle) {
        if (this.mStartActivityForResult != null) {
            object = new LaunchedFragmentInfo(((Fragment)object).mWho, n);
            this.mLaunchedFragments.addLast((LaunchedFragmentInfo)object);
            if (intent != null && bundle != null) {
                intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
            }
            this.mStartActivityForResult.launch(intent);
        } else {
            this.mHost.onStartActivityFromFragment((Fragment)object, intent, n, bundle);
        }
    }

    void launchStartIntentSenderForResult(Fragment fragment, IntentSender object, int n, Intent object2, int n2, int n3, int n4, Bundle bundle) throws IntentSender.SendIntentException {
        if (this.mStartIntentSenderForResult != null) {
            if (bundle != null) {
                if (object2 == null) {
                    object2 = new Intent();
                    object2.putExtra(EXTRA_CREATED_FILLIN_INTENT, true);
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("ActivityOptions ");
                    stringBuilder.append(bundle);
                    stringBuilder.append(" were added to fillInIntent ");
                    stringBuilder.append(object2);
                    stringBuilder.append(" for fragment ");
                    stringBuilder.append(fragment);
                    Log.v((String)TAG, (String)stringBuilder.toString());
                }
                object2.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
            }
            object = new IntentSenderRequest.Builder((IntentSender)object).setFillInIntent((Intent)object2).setFlags(n3, n2).build();
            object2 = new LaunchedFragmentInfo(fragment.mWho, n);
            this.mLaunchedFragments.addLast((LaunchedFragmentInfo)object2);
            if (FragmentManager.isLoggingEnabled(2)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Fragment ");
                ((StringBuilder)object2).append(fragment);
                ((StringBuilder)object2).append("is launching an IntentSender for result ");
                Log.v((String)TAG, (String)((StringBuilder)object2).toString());
            }
            this.mStartIntentSenderForResult.launch((IntentSenderRequest)object);
        } else {
            this.mHost.onStartIntentSenderFromFragment(fragment, (IntentSender)object, n, (Intent)object2, n2, n3, n4, bundle);
        }
    }

    void moveFragmentToExpectedState(Fragment fragment) {
        if (!this.mFragmentStore.containsActiveFragment(fragment.mWho)) {
            if (FragmentManager.isLoggingEnabled(3)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Ignoring moving ");
                stringBuilder.append(fragment);
                stringBuilder.append(" to state ");
                stringBuilder.append(this.mCurState);
                stringBuilder.append("since it is not added to ");
                stringBuilder.append(this);
                Log.d((String)TAG, (String)stringBuilder.toString());
            }
            return;
        }
        this.moveToState(fragment);
        if (fragment.mView != null && fragment.mIsNewlyAdded && fragment.mContainer != null) {
            if (fragment.mPostponedAlpha > 0.0f) {
                fragment.mView.setAlpha(fragment.mPostponedAlpha);
            }
            fragment.mPostponedAlpha = 0.0f;
            fragment.mIsNewlyAdded = false;
            FragmentAnim.AnimationOrAnimator animationOrAnimator = FragmentAnim.loadAnimation(this.mHost.getContext(), fragment, true, fragment.getPopDirection());
            if (animationOrAnimator != null) {
                if (animationOrAnimator.animation != null) {
                    fragment.mView.startAnimation(animationOrAnimator.animation);
                } else {
                    animationOrAnimator.animator.setTarget((Object)fragment.mView);
                    animationOrAnimator.animator.start();
                }
            }
        }
        if (fragment.mHiddenChanged) {
            this.completeShowHideFragment(fragment);
        }
    }

    void moveToState(int n, boolean bl) {
        FragmentHostCallback<?> fragmentHostCallback;
        if (this.mHost == null && n != -1) {
            throw new IllegalStateException("No activity");
        }
        if (!bl && n == this.mCurState) {
            return;
        }
        this.mCurState = n;
        if (USE_STATE_MANAGER) {
            this.mFragmentStore.moveToExpectedState();
        } else {
            Iterator<Fragment> object2 = this.mFragmentStore.getFragments().iterator();
            while (object2.hasNext()) {
                this.moveFragmentToExpectedState(object2.next());
            }
            for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
                Fragment fragment = fragmentStateManager.getFragment();
                if (!fragment.mIsNewlyAdded) {
                    this.moveFragmentToExpectedState(fragment);
                }
                if ((n = fragment.mRemoving && !fragment.isInBackStack() ? 1 : 0) == 0) continue;
                this.mFragmentStore.makeInactive(fragmentStateManager);
            }
        }
        this.startPendingDeferredFragments();
        if (this.mNeedMenuInvalidate && (fragmentHostCallback = this.mHost) != null && this.mCurState == 7) {
            fragmentHostCallback.onSupportInvalidateOptionsMenu();
            this.mNeedMenuInvalidate = false;
        }
    }

    void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState);
    }

    /*
     * Unable to fully structure code
     */
    void moveToState(Fragment var1_1, int var2_2) {
        block43: {
            block36: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        var3_3 = this.mFragmentStore.getFragmentStateManager(var1_1.mWho);
                                        var4_4 = 1;
                                        var5_5 = var3_3;
                                        if (var3_3 == null) {
                                            var5_5 = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, var1_1);
                                            var5_5.setFragmentManagerState(1);
                                        }
                                        var6_6 = var2_2;
                                        if (var1_1.mFromLayout) {
                                            var6_6 = var2_2;
                                            if (var1_1.mInLayout) {
                                                var6_6 = var2_2;
                                                if (var1_1.mState == 2) {
                                                    var6_6 = Math.max(var2_2, 2);
                                                }
                                            }
                                        }
                                        if (var1_1.mState > (var2_2 = Math.min(var6_6, var5_5.computeExpectedState()))) break block36;
                                        if (var1_1.mState < var2_2 && !this.mExitAnimationCancellationSignals.isEmpty()) {
                                            this.cancelExitAnimation(var1_1);
                                        }
                                        if ((var6_6 = var1_1.mState) == -1) break block37;
                                        if (var6_6 == 0) break block38;
                                        if (var6_6 == 1) break block39;
                                        if (var6_6 == 2) break block40;
                                        if (var6_6 == 4) break block41;
                                        if (var6_6 == 5) break block42;
                                        var6_6 = var2_2;
                                        break block43;
                                    }
                                    if (var2_2 > -1) {
                                        var5_5.attach();
                                    }
                                }
                                if (var2_2 > 0) {
                                    var5_5.create();
                                }
                            }
                            if (var2_2 > -1) {
                                var5_5.ensureInflatedView();
                            }
                            if (var2_2 > 1) {
                                var5_5.createView();
                            }
                        }
                        if (var2_2 > 2) {
                            var5_5.activityCreated();
                        }
                    }
                    if (var2_2 > 4) {
                        var5_5.start();
                    }
                }
                var6_6 = var2_2;
                if (var2_2 > 5) {
                    var5_5.resume();
                    var6_6 = var2_2;
                }
                break block43;
            }
            var6_6 = var2_2;
            if (var1_1.mState <= var2_2) break block43;
            var6_6 = var1_1.mState;
            if (var6_6 == 0) ** GOTO lbl121
            if (var6_6 == 1) ** GOTO lbl116
            if (var6_6 == 2) ** GOTO lbl75
            if (var6_6 == 4) ** GOTO lbl64
            if (var6_6 == 5) ** GOTO lbl62
            if (var6_6 != 7) {
                var6_6 = var2_2;
            } else {
                if (var2_2 < 7) {
                    var5_5.pause();
                }
lbl62:
                // 4 sources

                if (var2_2 < 5) {
                    var5_5.stop();
                }
lbl64:
                // 4 sources

                if (var2_2 < 4) {
                    if (FragmentManager.isLoggingEnabled(3)) {
                        var3_3 = new StringBuilder();
                        var3_3.append("movefrom ACTIVITY_CREATED: ");
                        var3_3.append(var1_1);
                        Log.d((String)"FragmentManager", (String)var3_3.toString());
                    }
                    if (var1_1.mView != null && this.mHost.onShouldSaveFragmentState(var1_1) && var1_1.mSavedViewState == null) {
                        var5_5.saveViewState();
                    }
                }
lbl75:
                // 6 sources

                if (var2_2 < 2) {
                    var7_7 = null;
                    if (var1_1.mView != null && var1_1.mContainer != null) {
                        var1_1.mContainer.endViewTransition(var1_1.mView);
                        var1_1.mView.clearAnimation();
                        if (!var1_1.isRemovingParent()) {
                            var3_3 = var7_7;
                            if (this.mCurState > -1) {
                                var3_3 = var7_7;
                                if (!this.mDestroyed) {
                                    var3_3 = var7_7;
                                    if (var1_1.mView.getVisibility() == 0) {
                                        var3_3 = var7_7;
                                        if (var1_1.mPostponedAlpha >= 0.0f) {
                                            var3_3 = FragmentAnim.loadAnimation(this.mHost.getContext(), var1_1, false, var1_1.getPopDirection());
                                        }
                                    }
                                }
                            }
                            var1_1.mPostponedAlpha = 0.0f;
                            var7_7 = var1_1.mContainer;
                            var8_8 = var1_1.mView;
                            if (var3_3 != null) {
                                FragmentAnim.animateRemoveFragment(var1_1, (FragmentAnim.AnimationOrAnimator)var3_3, this.mFragmentTransitionCallback);
                            }
                            var7_7.removeView(var8_8);
                            if (FragmentManager.isLoggingEnabled(2)) {
                                var3_3 = new StringBuilder();
                                var3_3.append("Removing view ");
                                var3_3.append(var8_8);
                                var3_3.append(" for fragment ");
                                var3_3.append(var1_1);
                                var3_3.append(" from container ");
                                var3_3.append(var7_7);
                                Log.v((String)"FragmentManager", (String)var3_3.toString());
                            }
                            if (var7_7 != var1_1.mContainer) {
                                return;
                            }
                        }
                    }
                    if (this.mExitAnimationCancellationSignals.get(var1_1) == null) {
                        var5_5.destroyFragmentView();
                    }
                }
lbl116:
                // 6 sources

                if (var2_2 < 1) {
                    if (this.mExitAnimationCancellationSignals.get(var1_1) != null) {
                        var2_2 = var4_4;
                    } else {
                        var5_5.destroy();
                    }
                }
lbl121:
                // 5 sources

                if (var2_2 < 0) {
                    var5_5.detach();
                }
                var6_6 = var2_2;
            }
        }
        if (var1_1.mState != var6_6) {
            if (FragmentManager.isLoggingEnabled(3)) {
                var5_5 = new StringBuilder();
                var5_5.append("moveToState: Fragment state for ");
                var5_5.append(var1_1);
                var5_5.append(" not updated inline; expected state ");
                var5_5.append(var6_6);
                var5_5.append(" found ");
                var5_5.append(var1_1.mState);
                Log.d((String)"FragmentManager", (String)var5_5.toString());
            }
            var1_1.mState = var6_6;
        }
    }

    void noteStateNotSaved() {
        if (this.mHost == null) {
            return;
        }
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    void onContainerAvailable(FragmentContainerView fragmentContainerView) {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            Fragment fragment = fragmentStateManager.getFragment();
            if (fragment.mContainerId != fragmentContainerView.getId() || fragment.mView == null || fragment.mView.getParent() != null) continue;
            fragment.mContainer = fragmentContainerView;
            fragmentStateManager.addViewToContainer();
        }
    }

    @Deprecated
    public FragmentTransaction openTransaction() {
        return this.beginTransaction();
    }

    void performPendingDeferredStart(FragmentStateManager fragmentStateManager) {
        Fragment fragment = fragmentStateManager.getFragment();
        if (fragment.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            fragment.mDeferStart = false;
            if (USE_STATE_MANAGER) {
                fragmentStateManager.moveToExpectedState();
            } else {
                this.moveToState(fragment);
            }
        }
    }

    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    public void popBackStack(int n, int n2) {
        if (n >= 0) {
            this.enqueueAction(new PopBackStackState(null, n, n2), false);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bad id: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void popBackStack(String string2, int n) {
        this.enqueueAction(new PopBackStackState(string2, -1, n), false);
    }

    public boolean popBackStackImmediate() {
        return this.popBackStackImmediate(null, -1, 0);
    }

    public boolean popBackStackImmediate(int n, int n2) {
        if (n >= 0) {
            return this.popBackStackImmediate(null, n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bad id: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean popBackStackImmediate(String string2, int n) {
        return this.popBackStackImmediate(string2, -1, n);
    }

    boolean popBackStackState(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, String string2, int n, int n2) {
        ArrayList<BackStackRecord> arrayList3 = this.mBackStack;
        if (arrayList3 == null) {
            return false;
        }
        if (string2 == null && n < 0 && (n2 & 1) == 0) {
            n = arrayList3.size() - 1;
            if (n < 0) {
                return false;
            }
            arrayList.add(this.mBackStack.remove(n));
            arrayList2.add(true);
        } else {
            if (string2 == null && n < 0) {
                n = -1;
            } else {
                int n3;
                for (n3 = arrayList3.size() - 1; n3 >= 0; --n3) {
                    arrayList3 = this.mBackStack.get(n3);
                    if (string2 != null && string2.equals(((BackStackRecord)((Object)arrayList3)).getName()) || n >= 0 && n == ((BackStackRecord)((Object)arrayList3)).mIndex) break;
                }
                if (n3 < 0) {
                    return false;
                }
                int n4 = n3;
                if ((n2 & 1) != 0) {
                    while (true) {
                        n4 = n2 = n3 - 1;
                        if (n2 < 0) break;
                        arrayList3 = this.mBackStack.get(n2);
                        if (string2 != null) {
                            n3 = n2;
                            if (string2.equals(((BackStackRecord)((Object)arrayList3)).getName())) continue;
                        }
                        n4 = n2;
                        if (n < 0) break;
                        n4 = n2;
                        if (n != ((BackStackRecord)((Object)arrayList3)).mIndex) break;
                        n3 = n2;
                    }
                }
                n = n4;
            }
            if (n == this.mBackStack.size() - 1) {
                return false;
            }
            for (n2 = this.mBackStack.size() - 1; n2 > n; --n2) {
                arrayList.add(this.mBackStack.remove(n2));
                arrayList2.add(true);
            }
        }
        return true;
    }

    public void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment ");
            stringBuilder.append(fragment);
            stringBuilder.append(" is not currently in the FragmentManager");
            this.throwException(new IllegalStateException(stringBuilder.toString()));
        }
        bundle.putString(string2, fragment.mWho);
    }

    public void registerFragmentLifecycleCallbacks(FragmentLifecycleCallbacks fragmentLifecycleCallbacks, boolean bl) {
        this.mLifecycleCallbacksDispatcher.registerFragmentLifecycleCallbacks(fragmentLifecycleCallbacks, bl);
    }

    void removeCancellationSignal(Fragment fragment, CancellationSignal cancellationSignal) {
        HashSet<CancellationSignal> hashSet = this.mExitAnimationCancellationSignals.get(fragment);
        if (hashSet != null && hashSet.remove(cancellationSignal) && hashSet.isEmpty()) {
            this.mExitAnimationCancellationSignals.remove(fragment);
            if (fragment.mState < 5) {
                this.destroyFragmentView(fragment);
                this.moveToState(fragment);
            }
        }
    }

    void removeFragment(Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("remove: ");
            stringBuilder.append(fragment);
            stringBuilder.append(" nesting=");
            stringBuilder.append(fragment.mBackStackNesting);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        boolean bl = fragment.isInBackStack();
        if (!fragment.mDetached || bl ^ true) {
            this.mFragmentStore.removeFragment(fragment);
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mRemoving = true;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    public void removeFragmentOnAttachListener(FragmentOnAttachListener fragmentOnAttachListener) {
        this.mOnAttachListeners.remove(fragmentOnAttachListener);
    }

    public void removeOnBackStackChangedListener(OnBackStackChangedListener onBackStackChangedListener) {
        ArrayList<OnBackStackChangedListener> arrayList = this.mBackStackChangeListeners;
        if (arrayList != null) {
            arrayList.remove(onBackStackChangedListener);
        }
    }

    void removeRetainedFragment(Fragment fragment) {
        this.mNonConfig.removeRetainedFragment(fragment);
    }

    void restoreAllState(Parcelable parcelable, FragmentManagerNonConfig fragmentManagerNonConfig) {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You must use restoreSaveState when your FragmentHostCallback implements ViewModelStoreOwner"));
        }
        this.mNonConfig.restoreFromSnapshot(fragmentManagerNonConfig);
        this.restoreSaveState(parcelable);
    }

    void restoreSaveState(Parcelable object) {
        ArrayList<String> arrayList;
        int n;
        Object object2;
        if (object == null) {
            return;
        }
        FragmentManagerState fragmentManagerState = (FragmentManagerState)object;
        if (fragmentManagerState.mActive == null) {
            return;
        }
        this.mFragmentStore.resetActiveFragments();
        for (Object object3 : fragmentManagerState.mActive) {
            if (object3 == null) continue;
            object = this.mNonConfig.findRetainedFragmentByWho(((FragmentState)object3).mWho);
            if (object != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("restoreSaveState: re-attaching retained ");
                    ((StringBuilder)object2).append(object);
                    Log.v((String)TAG, (String)((StringBuilder)object2).toString());
                }
                object = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, (Fragment)object, (FragmentState)object3);
            } else {
                object = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, this.mHost.getContext().getClassLoader(), this.getFragmentFactory(), (FragmentState)object3);
            }
            object3 = ((FragmentStateManager)object).getFragment();
            ((Fragment)object3).mFragmentManager = this;
            if (FragmentManager.isLoggingEnabled(2)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("restoreSaveState: active (");
                ((StringBuilder)object2).append(((Fragment)object3).mWho);
                ((StringBuilder)object2).append("): ");
                ((StringBuilder)object2).append(object3);
                Log.v((String)TAG, (String)((StringBuilder)object2).toString());
            }
            ((FragmentStateManager)object).restoreState(this.mHost.getContext().getClassLoader());
            this.mFragmentStore.makeActive((FragmentStateManager)object);
            ((FragmentStateManager)object).setFragmentManagerState(this.mCurState);
        }
        for (Fragment fragment : this.mNonConfig.getRetainedFragments()) {
            if (this.mFragmentStore.containsActiveFragment(fragment.mWho)) continue;
            if (FragmentManager.isLoggingEnabled(2)) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Discarding retained Fragment ");
                ((StringBuilder)object2).append(fragment);
                ((StringBuilder)object2).append(" that was not found in the set of active Fragments ");
                ((StringBuilder)object2).append(fragmentManagerState.mActive);
                Log.v((String)TAG, (String)((StringBuilder)object2).toString());
            }
            this.mNonConfig.removeRetainedFragment(fragment);
            fragment.mFragmentManager = this;
            object2 = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, fragment);
            ((FragmentStateManager)object2).setFragmentManagerState(1);
            ((FragmentStateManager)object2).moveToExpectedState();
            fragment.mRemoving = true;
            ((FragmentStateManager)object2).moveToExpectedState();
        }
        this.mFragmentStore.restoreAddedFragments(fragmentManagerState.mAdded);
        object = fragmentManagerState.mBackStack;
        int n2 = 0;
        if (object != null) {
            this.mBackStack = new ArrayList(fragmentManagerState.mBackStack.length);
            for (n = 0; n < fragmentManagerState.mBackStack.length; ++n) {
                object = fragmentManagerState.mBackStack[n].instantiate(this);
                if (FragmentManager.isLoggingEnabled(2)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("restoreAllState: back stack #");
                    stringBuilder.append(n);
                    stringBuilder.append(" (index ");
                    stringBuilder.append(((BackStackRecord)object).mIndex);
                    stringBuilder.append("): ");
                    stringBuilder.append(object);
                    Log.v((String)TAG, (String)stringBuilder.toString());
                    PrintWriter printWriter = new PrintWriter(new LogWriter(TAG));
                    ((BackStackRecord)object).dump("  ", printWriter, false);
                    printWriter.close();
                }
                this.mBackStack.add((BackStackRecord)object);
            }
        } else {
            this.mBackStack = null;
        }
        this.mBackStackIndex.set(fragmentManagerState.mBackStackIndex);
        if (fragmentManagerState.mPrimaryNavActiveWho != null) {
            this.mPrimaryNav = object = this.findActiveFragment(fragmentManagerState.mPrimaryNavActiveWho);
            this.dispatchParentPrimaryNavigationFragmentChanged((Fragment)object);
        }
        if ((arrayList = fragmentManagerState.mResultKeys) != null) {
            for (n = n2; n < arrayList.size(); ++n) {
                object = fragmentManagerState.mResults.get(n);
                object.setClassLoader(this.mHost.getContext().getClassLoader());
                this.mResults.put(arrayList.get(n), (Bundle)object);
            }
        }
        this.mLaunchedFragments = new ArrayDeque<LaunchedFragmentInfo>(fragmentManagerState.mLaunchedFragments);
    }

    @Deprecated
    FragmentManagerNonConfig retainNonConfig() {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You cannot use retainNonConfig when your FragmentHostCallback implements ViewModelStoreOwner."));
        }
        return this.mNonConfig.getSnapshot();
    }

    Parcelable saveAllState() {
        this.forcePostponedTransactions();
        this.endAnimatingAwayFragments();
        this.execPendingActions(true);
        this.mStateSaved = true;
        this.mNonConfig.setIsStateSaved(true);
        ArrayList<FragmentState> arrayList = this.mFragmentStore.saveActiveFragments();
        boolean bl = arrayList.isEmpty();
        BackStackState[] backStackStateArray = null;
        if (bl) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)"saveAllState: no fragments!");
            }
            return null;
        }
        ArrayList<String> arrayList2 = this.mFragmentStore.saveAddedFragments();
        ArrayList<BackStackRecord> arrayList3 = this.mBackStack;
        Object object = backStackStateArray;
        if (arrayList3 != null) {
            int n = arrayList3.size();
            object = backStackStateArray;
            if (n > 0) {
                backStackStateArray = new BackStackState[n];
                int n2 = 0;
                while (true) {
                    object = backStackStateArray;
                    if (n2 >= n) break;
                    backStackStateArray[n2] = new BackStackState(this.mBackStack.get(n2));
                    if (FragmentManager.isLoggingEnabled(2)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("saveAllState: adding back stack #");
                        ((StringBuilder)object).append(n2);
                        ((StringBuilder)object).append(": ");
                        ((StringBuilder)object).append(this.mBackStack.get(n2));
                        Log.v((String)TAG, (String)((StringBuilder)object).toString());
                    }
                    ++n2;
                }
            }
        }
        backStackStateArray = new FragmentManagerState();
        backStackStateArray.mActive = arrayList;
        backStackStateArray.mAdded = arrayList2;
        backStackStateArray.mBackStack = object;
        backStackStateArray.mBackStackIndex = this.mBackStackIndex.get();
        object = this.mPrimaryNav;
        if (object != null) {
            backStackStateArray.mPrimaryNavActiveWho = ((Fragment)object).mWho;
        }
        backStackStateArray.mResultKeys.addAll(this.mResults.keySet());
        backStackStateArray.mResults.addAll(this.mResults.values());
        backStackStateArray.mLaunchedFragments = new ArrayList<LaunchedFragmentInfo>(this.mLaunchedFragments);
        return backStackStateArray;
    }

    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        FragmentStateManager fragmentStateManager = this.mFragmentStore.getFragmentStateManager(fragment.mWho);
        if (fragmentStateManager == null || !fragmentStateManager.getFragment().equals(fragment)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment ");
            stringBuilder.append(fragment);
            stringBuilder.append(" is not currently in the FragmentManager");
            this.throwException(new IllegalStateException(stringBuilder.toString()));
        }
        return fragmentStateManager.saveInstanceState();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scheduleCommit() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            ArrayList<StartEnterTransitionListener> arrayList2 = this.mPostponedTransactions;
            boolean bl = false;
            boolean bl2 = arrayList2 != null && !arrayList2.isEmpty();
            if (this.mPendingActions.size() == 1) {
                bl = true;
            }
            if (bl2 || bl) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
                this.updateOnBackPressedCallbackEnabled();
            }
            return;
        }
    }

    void setExitAnimationOrder(Fragment fragment, boolean bl) {
        if ((fragment = this.getFragmentContainer(fragment)) != null && fragment instanceof FragmentContainerView) {
            ((FragmentContainerView)((Object)fragment)).setDrawDisappearingViewsLast(bl ^ true);
        }
    }

    public void setFragmentFactory(FragmentFactory fragmentFactory) {
        this.mFragmentFactory = fragmentFactory;
    }

    @Override
    public final void setFragmentResult(String string2, Bundle bundle) {
        LifecycleAwareResultListener lifecycleAwareResultListener = this.mResultListeners.get(string2);
        if (lifecycleAwareResultListener != null && lifecycleAwareResultListener.isAtLeast(Lifecycle.State.STARTED)) {
            lifecycleAwareResultListener.onFragmentResult(string2, bundle);
        } else {
            this.mResults.put(string2, bundle);
        }
    }

    @Override
    public final void setFragmentResultListener(String object, LifecycleOwner object2, FragmentResultListener fragmentResultListener) {
        Lifecycle lifecycle = object2.getLifecycle();
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        object2 = new LifecycleEventObserver((String)object, fragmentResultListener, lifecycle){
            final /* synthetic */ Lifecycle val$lifecycle;
            final /* synthetic */ FragmentResultListener val$listener;
            final /* synthetic */ String val$requestKey;
            {
                this.val$requestKey = string2;
                this.val$listener = fragmentResultListener;
                this.val$lifecycle = lifecycle;
            }

            @Override
            public void onStateChanged(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
                if (event == Lifecycle.Event.ON_START && (lifecycleOwner = (Bundle)FragmentManager.this.mResults.get(this.val$requestKey)) != null) {
                    this.val$listener.onFragmentResult(this.val$requestKey, (Bundle)lifecycleOwner);
                    FragmentManager.this.clearFragmentResult(this.val$requestKey);
                }
                if (event == Lifecycle.Event.ON_DESTROY) {
                    this.val$lifecycle.removeObserver(this);
                    FragmentManager.this.mResultListeners.remove(this.val$requestKey);
                }
            }
        };
        lifecycle.addObserver((LifecycleObserver)object2);
        object = this.mResultListeners.put((String)object, new LifecycleAwareResultListener(lifecycle, fragmentResultListener, (LifecycleEventObserver)object2));
        if (object != null) {
            ((LifecycleAwareResultListener)object).removeObserver();
        }
    }

    void setMaxLifecycle(Fragment fragment, Lifecycle.State object) {
        if (fragment.equals(this.findActiveFragment(fragment.mWho)) && (fragment.mHost == null || fragment.mFragmentManager == this)) {
            fragment.mMaxState = object;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Fragment ");
        ((StringBuilder)object).append(fragment);
        ((StringBuilder)object).append(" is not an active fragment of FragmentManager ");
        ((StringBuilder)object).append(this);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    void setPrimaryNavigationFragment(Fragment fragment) {
        if (fragment != null && (!fragment.equals(this.findActiveFragment(fragment.mWho)) || fragment.mHost != null && fragment.mFragmentManager != this)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fragment ");
            stringBuilder.append(fragment);
            stringBuilder.append(" is not an active fragment of FragmentManager ");
            stringBuilder.append(this);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        Fragment fragment2 = this.mPrimaryNav;
        this.mPrimaryNav = fragment;
        this.dispatchParentPrimaryNavigationFragmentChanged(fragment2);
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    void setSpecialEffectsControllerFactory(SpecialEffectsControllerFactory specialEffectsControllerFactory) {
        this.mSpecialEffectsControllerFactory = specialEffectsControllerFactory;
    }

    void showFragment(Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("show: ");
            stringBuilder.append(fragment);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged ^= true;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        FragmentHostCallback<?> fragmentHostCallback = this.mParent;
        if (fragmentHostCallback != null) {
            stringBuilder.append(fragmentHostCallback.getClass().getSimpleName());
            stringBuilder.append("{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this.mParent)));
            stringBuilder.append("}");
        } else {
            fragmentHostCallback = this.mHost;
            if (fragmentHostCallback != null) {
                stringBuilder.append(fragmentHostCallback.getClass().getSimpleName());
                stringBuilder.append("{");
                stringBuilder.append(Integer.toHexString(System.identityHashCode(this.mHost)));
                stringBuilder.append("}");
            } else {
                stringBuilder.append("null");
            }
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }

    public void unregisterFragmentLifecycleCallbacks(FragmentLifecycleCallbacks fragmentLifecycleCallbacks) {
        this.mLifecycleCallbacksDispatcher.unregisterFragmentLifecycleCallbacks(fragmentLifecycleCallbacks);
    }

    public static interface BackStackEntry {
        @Deprecated
        public CharSequence getBreadCrumbShortTitle();

        @Deprecated
        public int getBreadCrumbShortTitleRes();

        @Deprecated
        public CharSequence getBreadCrumbTitle();

        @Deprecated
        public int getBreadCrumbTitleRes();

        public int getId();

        public String getName();
    }

    static class FragmentIntentSenderContract
    extends ActivityResultContract<IntentSenderRequest, ActivityResult> {
        FragmentIntentSenderContract() {
        }

        @Override
        public Intent createIntent(Context object, IntentSenderRequest intentSenderRequest) {
            Intent intent = new Intent("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST");
            Intent intent2 = intentSenderRequest.getFillInIntent();
            object = intentSenderRequest;
            if (intent2 != null) {
                Bundle bundle = intent2.getBundleExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
                object = intentSenderRequest;
                if (bundle != null) {
                    intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", bundle);
                    intent2.removeExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
                    object = intentSenderRequest;
                    if (intent2.getBooleanExtra(FragmentManager.EXTRA_CREATED_FILLIN_INTENT, false)) {
                        object = new IntentSenderRequest.Builder(intentSenderRequest.getIntentSender()).setFillInIntent(null).setFlags(intentSenderRequest.getFlagsValues(), intentSenderRequest.getFlagsMask()).build();
                    }
                }
            }
            intent.putExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST", (Parcelable)object);
            if (FragmentManager.isLoggingEnabled(2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("CreateIntent created the following intent: ");
                ((StringBuilder)object).append(intent);
                Log.v((String)FragmentManager.TAG, (String)((StringBuilder)object).toString());
            }
            return intent;
        }

        @Override
        public ActivityResult parseResult(int n, Intent intent) {
            return new ActivityResult(n, intent);
        }
    }

    public static abstract class FragmentLifecycleCallbacks {
        @Deprecated
        public void onFragmentActivityCreated(FragmentManager fragmentManager, Fragment fragment, Bundle bundle) {
        }

        public void onFragmentAttached(FragmentManager fragmentManager, Fragment fragment, Context context) {
        }

        public void onFragmentCreated(FragmentManager fragmentManager, Fragment fragment, Bundle bundle) {
        }

        public void onFragmentDestroyed(FragmentManager fragmentManager, Fragment fragment) {
        }

        public void onFragmentDetached(FragmentManager fragmentManager, Fragment fragment) {
        }

        public void onFragmentPaused(FragmentManager fragmentManager, Fragment fragment) {
        }

        public void onFragmentPreAttached(FragmentManager fragmentManager, Fragment fragment, Context context) {
        }

        public void onFragmentPreCreated(FragmentManager fragmentManager, Fragment fragment, Bundle bundle) {
        }

        public void onFragmentResumed(FragmentManager fragmentManager, Fragment fragment) {
        }

        public void onFragmentSaveInstanceState(FragmentManager fragmentManager, Fragment fragment, Bundle bundle) {
        }

        public void onFragmentStarted(FragmentManager fragmentManager, Fragment fragment) {
        }

        public void onFragmentStopped(FragmentManager fragmentManager, Fragment fragment) {
        }

        public void onFragmentViewCreated(FragmentManager fragmentManager, Fragment fragment, View view, Bundle bundle) {
        }

        public void onFragmentViewDestroyed(FragmentManager fragmentManager, Fragment fragment) {
        }
    }

    static class LaunchedFragmentInfo
    implements Parcelable {
        public static final Parcelable.Creator<LaunchedFragmentInfo> CREATOR = new Parcelable.Creator<LaunchedFragmentInfo>(){

            public LaunchedFragmentInfo createFromParcel(Parcel parcel) {
                return new LaunchedFragmentInfo(parcel);
            }

            public LaunchedFragmentInfo[] newArray(int n) {
                return new LaunchedFragmentInfo[n];
            }
        };
        int mRequestCode;
        String mWho;

        LaunchedFragmentInfo(Parcel parcel) {
            this.mWho = parcel.readString();
            this.mRequestCode = parcel.readInt();
        }

        LaunchedFragmentInfo(String string2, int n) {
            this.mWho = string2;
            this.mRequestCode = n;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.mWho);
            parcel.writeInt(this.mRequestCode);
        }
    }

    private static class LifecycleAwareResultListener
    implements FragmentResultListener {
        private final Lifecycle mLifecycle;
        private final FragmentResultListener mListener;
        private final LifecycleEventObserver mObserver;

        LifecycleAwareResultListener(Lifecycle lifecycle, FragmentResultListener fragmentResultListener, LifecycleEventObserver lifecycleEventObserver) {
            this.mLifecycle = lifecycle;
            this.mListener = fragmentResultListener;
            this.mObserver = lifecycleEventObserver;
        }

        public boolean isAtLeast(Lifecycle.State state) {
            return this.mLifecycle.getCurrentState().isAtLeast(state);
        }

        @Override
        public void onFragmentResult(String string2, Bundle bundle) {
            this.mListener.onFragmentResult(string2, bundle);
        }

        public void removeObserver() {
            this.mLifecycle.removeObserver(this.mObserver);
        }
    }

    public static interface OnBackStackChangedListener {
        public void onBackStackChanged();
    }

    static interface OpGenerator {
        public boolean generateOps(ArrayList<BackStackRecord> var1, ArrayList<Boolean> var2);
    }

    private class PopBackStackState
    implements OpGenerator {
        final int mFlags;
        final int mId;
        final String mName;

        PopBackStackState(String string2, int n, int n2) {
            this.mName = string2;
            this.mId = n;
            this.mFlags = n2;
        }

        @Override
        public boolean generateOps(ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2) {
            if (FragmentManager.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && FragmentManager.this.mPrimaryNav.getChildFragmentManager().popBackStackImmediate()) {
                return false;
            }
            return FragmentManager.this.popBackStackState(arrayList, arrayList2, this.mName, this.mId, this.mFlags);
        }
    }

    static class StartEnterTransitionListener
    implements Fragment.OnStartEnterTransitionListener {
        final boolean mIsBack;
        private int mNumPostponed;
        final BackStackRecord mRecord;

        StartEnterTransitionListener(BackStackRecord backStackRecord, boolean bl) {
            this.mIsBack = bl;
            this.mRecord = backStackRecord;
        }

        void cancelTransaction() {
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, false, false);
        }

        void completeTransaction() {
            boolean bl = this.mNumPostponed > 0;
            for (Fragment fragment : this.mRecord.mManager.getFragments()) {
                fragment.setOnStartEnterTransitionListener(null);
                if (!bl || !fragment.isPostponed()) continue;
                fragment.startPostponedEnterTransition();
            }
            this.mRecord.mManager.completeExecute(this.mRecord, this.mIsBack, bl ^ true, true);
        }

        public boolean isReady() {
            boolean bl = this.mNumPostponed == 0;
            return bl;
        }

        @Override
        public void onStartEnterTransition() {
            int n;
            this.mNumPostponed = n = this.mNumPostponed - 1;
            if (n != 0) {
                return;
            }
            this.mRecord.mManager.scheduleCommit();
        }

        @Override
        public void startListening() {
            ++this.mNumPostponed;
        }
    }
}

