/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.os.CancellationSignal;
import androidx.core.view.ViewCompat;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class SpecialEffectsController {
    private final ViewGroup mContainer;
    boolean mIsContainerPostponed = false;
    boolean mOperationDirectionIsPop = false;
    final ArrayList<Operation> mPendingOperations = new ArrayList();
    final ArrayList<Operation> mRunningOperations = new ArrayList();

    SpecialEffectsController(ViewGroup viewGroup) {
        this.mContainer = viewGroup;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enqueue(Operation.State object, Operation.LifecycleImpact lifecycleImpact, FragmentStateManager fragmentStateManager) {
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            CancellationSignal cancellationSignal = new CancellationSignal();
            Operation operation = this.findPendingOperation(fragmentStateManager.getFragment());
            if (operation != null) {
                operation.mergeWith((Operation.State)((Object)object), lifecycleImpact);
                return;
            }
            operation = new FragmentStateManagerOperation((Operation.State)((Object)object), lifecycleImpact, fragmentStateManager, cancellationSignal);
            this.mPendingOperations.add(operation);
            object = new Runnable((FragmentStateManagerOperation)operation){
                final /* synthetic */ FragmentStateManagerOperation val$operation;
                {
                    this.val$operation = fragmentStateManagerOperation;
                }

                @Override
                public void run() {
                    if (SpecialEffectsController.this.mPendingOperations.contains(this.val$operation)) {
                        this.val$operation.getFinalState().applyState(this.val$operation.getFragment().mView);
                    }
                }
            };
            operation.addCompletionListener((Runnable)object);
            object = new Runnable((FragmentStateManagerOperation)operation){
                final /* synthetic */ FragmentStateManagerOperation val$operation;
                {
                    this.val$operation = fragmentStateManagerOperation;
                }

                @Override
                public void run() {
                    SpecialEffectsController.this.mPendingOperations.remove(this.val$operation);
                    SpecialEffectsController.this.mRunningOperations.remove(this.val$operation);
                }
            };
            operation.addCompletionListener((Runnable)object);
            return;
        }
    }

    private Operation findPendingOperation(Fragment fragment) {
        for (Operation operation : this.mPendingOperations) {
            if (!operation.getFragment().equals(fragment) || operation.isCanceled()) continue;
            return operation;
        }
        return null;
    }

    private Operation findRunningOperation(Fragment fragment) {
        for (Operation operation : this.mRunningOperations) {
            if (!operation.getFragment().equals(fragment) || operation.isCanceled()) continue;
            return operation;
        }
        return null;
    }

    static SpecialEffectsController getOrCreateController(ViewGroup viewGroup, FragmentManager fragmentManager) {
        return SpecialEffectsController.getOrCreateController(viewGroup, fragmentManager.getSpecialEffectsControllerFactory());
    }

    static SpecialEffectsController getOrCreateController(ViewGroup viewGroup, SpecialEffectsControllerFactory object) {
        Object object2 = viewGroup.getTag(R.id.special_effects_controller_view_tag);
        if (object2 instanceof SpecialEffectsController) {
            return (SpecialEffectsController)object2;
        }
        object = object.createController(viewGroup);
        viewGroup.setTag(R.id.special_effects_controller_view_tag, object);
        return object;
    }

    private void updateFinalState() {
        for (Operation operation : this.mPendingOperations) {
            if (operation.getLifecycleImpact() != Operation.LifecycleImpact.ADDING) continue;
            operation.mergeWith(Operation.State.from(operation.getFragment().requireView().getVisibility()), Operation.LifecycleImpact.NONE);
        }
    }

    void enqueueAdd(Operation.State state, FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SpecialEffectsController: Enqueuing add operation for fragment ");
            stringBuilder.append(fragmentStateManager.getFragment());
            Log.v((String)"FragmentManager", (String)stringBuilder.toString());
        }
        this.enqueue(state, Operation.LifecycleImpact.ADDING, fragmentStateManager);
    }

    void enqueueHide(FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SpecialEffectsController: Enqueuing hide operation for fragment ");
            stringBuilder.append(fragmentStateManager.getFragment());
            Log.v((String)"FragmentManager", (String)stringBuilder.toString());
        }
        this.enqueue(Operation.State.GONE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    void enqueueRemove(FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SpecialEffectsController: Enqueuing remove operation for fragment ");
            stringBuilder.append(fragmentStateManager.getFragment());
            Log.v((String)"FragmentManager", (String)stringBuilder.toString());
        }
        this.enqueue(Operation.State.REMOVED, Operation.LifecycleImpact.REMOVING, fragmentStateManager);
    }

    void enqueueShow(FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SpecialEffectsController: Enqueuing show operation for fragment ");
            stringBuilder.append(fragmentStateManager.getFragment());
            Log.v((String)"FragmentManager", (String)stringBuilder.toString());
        }
        this.enqueue(Operation.State.VISIBLE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    abstract void executeOperations(List<Operation> var1, boolean var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void executePendingOperations() {
        if (this.mIsContainerPostponed) {
            return;
        }
        if (!ViewCompat.isAttachedToWindow((View)this.mContainer)) {
            this.forceCompleteAllOperations();
            this.mOperationDirectionIsPop = false;
            return;
        }
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            if (!this.mPendingOperations.isEmpty()) {
                ArrayList<Operation> arrayList2;
                Object object = new ArrayList(this.mRunningOperations);
                this.mRunningOperations.clear();
                Iterator<Operation> iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    arrayList2 = iterator.next();
                    if (FragmentManager.isLoggingEnabled(2)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("SpecialEffectsController: Cancelling operation ");
                        ((StringBuilder)object).append(arrayList2);
                        Log.v((String)"FragmentManager", (String)((StringBuilder)object).toString());
                    }
                    ((Operation)((Object)arrayList2)).cancel();
                    if (((Operation)((Object)arrayList2)).isComplete()) continue;
                    this.mRunningOperations.add((Operation)((Object)arrayList2));
                }
                this.updateFinalState();
                arrayList2 = new ArrayList<Operation>(this.mPendingOperations);
                this.mPendingOperations.clear();
                this.mRunningOperations.addAll(arrayList2);
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    ((Operation)object.next()).onStart();
                }
                this.executeOperations(arrayList2, this.mOperationDirectionIsPop);
                this.mOperationDirectionIsPop = false;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void forceCompleteAllOperations() {
        boolean bl = ViewCompat.isAttachedToWindow((View)this.mContainer);
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            StringBuilder stringBuilder;
            Operation operation;
            this.updateFinalState();
            Object object = this.mPendingOperations.iterator();
            while (object.hasNext()) {
                object.next().onStart();
            }
            object = new ArrayList(this.mRunningOperations);
            Iterator<Operation> iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                operation = iterator.next();
                if (FragmentManager.isLoggingEnabled(2)) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("SpecialEffectsController: ");
                    if (bl) {
                        object = "";
                    } else {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Container ");
                        ((StringBuilder)object).append(this.mContainer);
                        ((StringBuilder)object).append(" is not attached to window. ");
                        object = ((StringBuilder)object).toString();
                    }
                    stringBuilder.append((String)object);
                    stringBuilder.append("Cancelling running operation ");
                    stringBuilder.append(operation);
                    Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                }
                operation.cancel();
            }
            object = new ArrayList(this.mPendingOperations);
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                operation = iterator.next();
                if (FragmentManager.isLoggingEnabled(2)) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("SpecialEffectsController: ");
                    if (bl) {
                        object = "";
                    } else {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Container ");
                        ((StringBuilder)object).append(this.mContainer);
                        ((StringBuilder)object).append(" is not attached to window. ");
                        object = ((StringBuilder)object).toString();
                    }
                    stringBuilder.append((String)object);
                    stringBuilder.append("Cancelling pending operation ");
                    stringBuilder.append(operation);
                    Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                }
                operation.cancel();
            }
            return;
        }
    }

    void forcePostponedExecutePendingOperations() {
        if (this.mIsContainerPostponed) {
            this.mIsContainerPostponed = false;
            this.executePendingOperations();
        }
    }

    Operation.LifecycleImpact getAwaitingCompletionLifecycleImpact(FragmentStateManager object) {
        Object object2 = this.findPendingOperation(((FragmentStateManager)object).getFragment());
        object2 = object2 != null ? object2.getLifecycleImpact() : null;
        if ((object = this.findRunningOperation(((FragmentStateManager)object).getFragment())) != null && (object2 == null || object2 == Operation.LifecycleImpact.NONE)) {
            return ((Operation)object).getLifecycleImpact();
        }
        return object2;
    }

    public ViewGroup getContainer() {
        return this.mContainer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void markPostponedState() {
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            this.updateFinalState();
            this.mIsContainerPostponed = false;
            for (int i = this.mPendingOperations.size() - 1; i >= 0; --i) {
                Operation operation = this.mPendingOperations.get(i);
                Operation.State state = Operation.State.from(operation.getFragment().mView);
                if (operation.getFinalState() != Operation.State.VISIBLE || state == Operation.State.VISIBLE) continue;
                this.mIsContainerPostponed = operation.getFragment().isPostponed();
                break;
            }
            return;
        }
    }

    void updateOperationDirection(boolean bl) {
        this.mOperationDirectionIsPop = bl;
    }

    private static class FragmentStateManagerOperation
    extends Operation {
        private final FragmentStateManager mFragmentStateManager;

        FragmentStateManagerOperation(Operation.State state, Operation.LifecycleImpact lifecycleImpact, FragmentStateManager fragmentStateManager, CancellationSignal cancellationSignal) {
            super(state, lifecycleImpact, fragmentStateManager.getFragment(), cancellationSignal);
            this.mFragmentStateManager = fragmentStateManager;
        }

        @Override
        public void complete() {
            super.complete();
            this.mFragmentStateManager.moveToExpectedState();
        }

        @Override
        void onStart() {
            if (this.getLifecycleImpact() == Operation.LifecycleImpact.ADDING) {
                Fragment fragment = this.mFragmentStateManager.getFragment();
                View view = fragment.mView.findFocus();
                if (view != null) {
                    fragment.setFocusedView(view);
                    if (FragmentManager.isLoggingEnabled(2)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("requestFocus: Saved focused view ");
                        stringBuilder.append(view);
                        stringBuilder.append(" for Fragment ");
                        stringBuilder.append(fragment);
                        Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                    }
                }
                if ((view = this.getFragment().requireView()).getParent() == null) {
                    this.mFragmentStateManager.addViewToContainer();
                    view.setAlpha(0.0f);
                }
                if (view.getAlpha() == 0.0f && view.getVisibility() == 0) {
                    view.setVisibility(4);
                }
                view.setAlpha(fragment.getPostOnViewCreatedAlpha());
            }
        }
    }

    static class Operation {
        private final List<Runnable> mCompletionListeners = new ArrayList<Runnable>();
        private State mFinalState;
        private final Fragment mFragment;
        private boolean mIsCanceled = false;
        private boolean mIsComplete = false;
        private LifecycleImpact mLifecycleImpact;
        private final HashSet<CancellationSignal> mSpecialEffectsSignals = new HashSet();

        Operation(State state, LifecycleImpact lifecycleImpact, Fragment fragment, CancellationSignal cancellationSignal) {
            this.mFinalState = state;
            this.mLifecycleImpact = lifecycleImpact;
            this.mFragment = fragment;
            cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                @Override
                public void onCancel() {
                    Operation.this.cancel();
                }
            });
        }

        final void addCompletionListener(Runnable runnable) {
            this.mCompletionListeners.add(runnable);
        }

        final void cancel() {
            if (this.isCanceled()) {
                return;
            }
            this.mIsCanceled = true;
            if (this.mSpecialEffectsSignals.isEmpty()) {
                this.complete();
            } else {
                Iterator<CancellationSignal> iterator = new ArrayList<CancellationSignal>(this.mSpecialEffectsSignals).iterator();
                while (iterator.hasNext()) {
                    iterator.next().cancel();
                }
            }
        }

        public void complete() {
            Object object;
            if (this.mIsComplete) {
                return;
            }
            if (FragmentManager.isLoggingEnabled(2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("SpecialEffectsController: ");
                ((StringBuilder)object).append(this);
                ((StringBuilder)object).append(" has called complete.");
                Log.v((String)"FragmentManager", (String)((StringBuilder)object).toString());
            }
            this.mIsComplete = true;
            object = this.mCompletionListeners.iterator();
            while (object.hasNext()) {
                ((Runnable)object.next()).run();
            }
        }

        public final void completeSpecialEffect(CancellationSignal cancellationSignal) {
            if (this.mSpecialEffectsSignals.remove(cancellationSignal) && this.mSpecialEffectsSignals.isEmpty()) {
                this.complete();
            }
        }

        public State getFinalState() {
            return this.mFinalState;
        }

        public final Fragment getFragment() {
            return this.mFragment;
        }

        LifecycleImpact getLifecycleImpact() {
            return this.mLifecycleImpact;
        }

        final boolean isCanceled() {
            return this.mIsCanceled;
        }

        final boolean isComplete() {
            return this.mIsComplete;
        }

        public final void markStartedSpecialEffect(CancellationSignal cancellationSignal) {
            this.onStart();
            this.mSpecialEffectsSignals.add(cancellationSignal);
        }

        final void mergeWith(State object, LifecycleImpact object2) {
            int n = 3.$SwitchMap$androidx$fragment$app$SpecialEffectsController$Operation$LifecycleImpact[((Enum)object2).ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3 && this.mFinalState != State.REMOVED) {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("SpecialEffectsController: For fragment ");
                            ((StringBuilder)object2).append(this.mFragment);
                            ((StringBuilder)object2).append(" mFinalState = ");
                            ((StringBuilder)object2).append((Object)this.mFinalState);
                            ((StringBuilder)object2).append(" -> ");
                            ((StringBuilder)object2).append(object);
                            ((StringBuilder)object2).append(". ");
                            Log.v((String)"FragmentManager", (String)((StringBuilder)object2).toString());
                        }
                        this.mFinalState = object;
                    }
                } else {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("SpecialEffectsController: For fragment ");
                        ((StringBuilder)object).append(this.mFragment);
                        ((StringBuilder)object).append(" mFinalState = ");
                        ((StringBuilder)object).append((Object)this.mFinalState);
                        ((StringBuilder)object).append(" -> REMOVED. mLifecycleImpact  = ");
                        ((StringBuilder)object).append((Object)this.mLifecycleImpact);
                        ((StringBuilder)object).append(" to REMOVING.");
                        Log.v((String)"FragmentManager", (String)((StringBuilder)object).toString());
                    }
                    this.mFinalState = State.REMOVED;
                    this.mLifecycleImpact = LifecycleImpact.REMOVING;
                }
            } else if (this.mFinalState == State.REMOVED) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("SpecialEffectsController: For fragment ");
                    ((StringBuilder)object).append(this.mFragment);
                    ((StringBuilder)object).append(" mFinalState = REMOVED -> VISIBLE. mLifecycleImpact = ");
                    ((StringBuilder)object).append((Object)this.mLifecycleImpact);
                    ((StringBuilder)object).append(" to ADDING.");
                    Log.v((String)"FragmentManager", (String)((StringBuilder)object).toString());
                }
                this.mFinalState = State.VISIBLE;
                this.mLifecycleImpact = LifecycleImpact.ADDING;
            }
        }

        void onStart() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Operation ");
            stringBuilder.append("{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append("} ");
            stringBuilder.append("{");
            stringBuilder.append("mFinalState = ");
            stringBuilder.append((Object)this.mFinalState);
            stringBuilder.append("} ");
            stringBuilder.append("{");
            stringBuilder.append("mLifecycleImpact = ");
            stringBuilder.append((Object)this.mLifecycleImpact);
            stringBuilder.append("} ");
            stringBuilder.append("{");
            stringBuilder.append("mFragment = ");
            stringBuilder.append(this.mFragment);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        static final class LifecycleImpact
        extends Enum<LifecycleImpact> {
            private static final /* synthetic */ LifecycleImpact[] $VALUES;
            public static final /* enum */ LifecycleImpact ADDING;
            public static final /* enum */ LifecycleImpact NONE;
            public static final /* enum */ LifecycleImpact REMOVING;

            static {
                LifecycleImpact lifecycleImpact;
                LifecycleImpact lifecycleImpact2;
                LifecycleImpact lifecycleImpact3;
                NONE = lifecycleImpact3 = new LifecycleImpact();
                ADDING = lifecycleImpact2 = new LifecycleImpact();
                REMOVING = lifecycleImpact = new LifecycleImpact();
                $VALUES = new LifecycleImpact[]{lifecycleImpact3, lifecycleImpact2, lifecycleImpact};
            }

            public static LifecycleImpact valueOf(String string2) {
                return Enum.valueOf(LifecycleImpact.class, string2);
            }

            public static LifecycleImpact[] values() {
                return (LifecycleImpact[])$VALUES.clone();
            }
        }

        static final class State
        extends Enum<State> {
            private static final /* synthetic */ State[] $VALUES;
            public static final /* enum */ State GONE;
            public static final /* enum */ State INVISIBLE;
            public static final /* enum */ State REMOVED;
            public static final /* enum */ State VISIBLE;

            static {
                State state;
                State state2;
                State state3;
                State state4;
                REMOVED = state4 = new State();
                VISIBLE = state3 = new State();
                GONE = state2 = new State();
                INVISIBLE = state = new State();
                $VALUES = new State[]{state4, state3, state2, state};
            }

            static State from(int n) {
                if (n != 0) {
                    if (n != 4) {
                        if (n == 8) {
                            return GONE;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unknown visibility ");
                        stringBuilder.append(n);
                        throw new IllegalArgumentException(stringBuilder.toString());
                    }
                    return INVISIBLE;
                }
                return VISIBLE;
            }

            static State from(View view) {
                if (view.getAlpha() == 0.0f && view.getVisibility() == 0) {
                    return INVISIBLE;
                }
                return State.from(view.getVisibility());
            }

            public static State valueOf(String string2) {
                return Enum.valueOf(State.class, string2);
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            void applyState(View view) {
                int n = 3.$SwitchMap$androidx$fragment$app$SpecialEffectsController$Operation$State[this.ordinal()];
                if (n != 1) {
                    if (n != 2) {
                        if (n != 3) {
                            if (n == 4) {
                                if (FragmentManager.isLoggingEnabled(2)) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append("SpecialEffectsController: Setting view ");
                                    stringBuilder.append(view);
                                    stringBuilder.append(" to INVISIBLE");
                                    Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                                }
                                view.setVisibility(4);
                            }
                        } else {
                            if (FragmentManager.isLoggingEnabled(2)) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("SpecialEffectsController: Setting view ");
                                stringBuilder.append(view);
                                stringBuilder.append(" to GONE");
                                Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                            }
                            view.setVisibility(8);
                        }
                    } else {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("SpecialEffectsController: Setting view ");
                            stringBuilder.append(view);
                            stringBuilder.append(" to VISIBLE");
                            Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                        }
                        view.setVisibility(0);
                    }
                } else {
                    ViewGroup viewGroup = (ViewGroup)view.getParent();
                    if (viewGroup != null) {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("SpecialEffectsController: Removing view ");
                            stringBuilder.append(view);
                            stringBuilder.append(" from container ");
                            stringBuilder.append(viewGroup);
                            Log.v((String)"FragmentManager", (String)stringBuilder.toString());
                        }
                        viewGroup.removeView(view);
                    }
                }
            }
        }
    }
}

