/*
 * Decompiled with CFR 0.152.
 */
package androidx.gridlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.LogPrinter;
import android.util.Pair;
import android.util.Printer;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewGroupCompat;
import androidx.gridlayout.R;
import androidx.legacy.widget.Space;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GridLayout
extends ViewGroup {
    private static final int ALIGNMENT_MODE;
    public static final int ALIGN_BOUNDS = 0;
    public static final int ALIGN_MARGINS = 1;
    public static final Alignment BASELINE;
    public static final Alignment BOTTOM;
    static final int CAN_STRETCH = 2;
    public static final Alignment CENTER;
    private static final int COLUMN_COUNT;
    private static final int COLUMN_ORDER_PRESERVED;
    private static final int DEFAULT_ALIGNMENT_MODE = 1;
    static final int DEFAULT_CONTAINER_MARGIN = 0;
    private static final int DEFAULT_COUNT = Integer.MIN_VALUE;
    static final boolean DEFAULT_ORDER_PRESERVED = true;
    private static final int DEFAULT_ORIENTATION = 0;
    private static final boolean DEFAULT_USE_DEFAULT_MARGINS = false;
    public static final Alignment END;
    public static final Alignment FILL;
    public static final int HORIZONTAL = 0;
    static final int INFLEXIBLE = 0;
    private static final Alignment LEADING;
    public static final Alignment LEFT;
    static final Printer LOG_PRINTER;
    static final int MAX_SIZE = 100000;
    static final Printer NO_PRINTER;
    private static final int ORIENTATION;
    public static final Alignment RIGHT;
    private static final int ROW_COUNT;
    private static final int ROW_ORDER_PRESERVED;
    public static final Alignment START;
    public static final Alignment TOP;
    private static final Alignment TRAILING;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    static final Alignment UNDEFINED_ALIGNMENT;
    static final int UNINITIALIZED_HASH = 0;
    private static final int USE_DEFAULT_MARGINS;
    public static final int VERTICAL = 1;
    int mAlignmentMode = 1;
    int mDefaultGap;
    final Axis mHorizontalAxis = new Axis(true);
    int mLastLayoutParamsHashCode = 0;
    int mOrientation = 0;
    Printer mPrinter;
    boolean mUseDefaultMargins = false;
    final Axis mVerticalAxis = new Axis(false);

    static {
        Alignment alignment;
        Alignment alignment2;
        LOG_PRINTER = new LogPrinter(3, GridLayout.class.getName());
        NO_PRINTER = new Printer(){

            public void println(String string2) {
            }
        };
        ORIENTATION = R.styleable.GridLayout_orientation;
        ROW_COUNT = R.styleable.GridLayout_rowCount;
        COLUMN_COUNT = R.styleable.GridLayout_columnCount;
        USE_DEFAULT_MARGINS = R.styleable.GridLayout_useDefaultMargins;
        ALIGNMENT_MODE = R.styleable.GridLayout_alignmentMode;
        ROW_ORDER_PRESERVED = R.styleable.GridLayout_rowOrderPreserved;
        COLUMN_ORDER_PRESERVED = R.styleable.GridLayout_columnOrderPreserved;
        UNDEFINED_ALIGNMENT = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return Integer.MIN_VALUE;
            }

            @Override
            String getDebugString() {
                return "UNDEFINED";
            }

            @Override
            int getGravityOffset(View view, int n) {
                return Integer.MIN_VALUE;
            }
        };
        LEADING = alignment2 = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return 0;
            }

            @Override
            String getDebugString() {
                return "LEADING";
            }

            @Override
            int getGravityOffset(View view, int n) {
                return 0;
            }
        };
        TRAILING = alignment = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return n;
            }

            @Override
            String getDebugString() {
                return "TRAILING";
            }

            @Override
            int getGravityOffset(View view, int n) {
                return n;
            }
        };
        TOP = alignment2;
        BOTTOM = alignment;
        START = alignment2;
        END = alignment;
        LEFT = GridLayout.createSwitchingAlignment(alignment2, alignment);
        RIGHT = GridLayout.createSwitchingAlignment(alignment, alignment2);
        CENTER = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return n >> 1;
            }

            @Override
            String getDebugString() {
                return "CENTER";
            }

            @Override
            int getGravityOffset(View view, int n) {
                return n >> 1;
            }
        };
        BASELINE = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                if (view.getVisibility() == 8) {
                    return 0;
                }
                n = n2 = view.getBaseline();
                if (n2 == -1) {
                    n = Integer.MIN_VALUE;
                }
                return n;
            }

            @Override
            public Bounds getBounds() {
                return new Bounds(){
                    private int size;

                    @Override
                    protected int getOffset(GridLayout gridLayout, View view, Alignment alignment, int n, boolean bl) {
                        return Math.max(0, super.getOffset(gridLayout, view, alignment, n, bl));
                    }

                    @Override
                    protected void include(int n, int n2) {
                        super.include(n, n2);
                        this.size = Math.max(this.size, n + n2);
                    }

                    @Override
                    protected void reset() {
                        super.reset();
                        this.size = Integer.MIN_VALUE;
                    }

                    @Override
                    protected int size(boolean bl) {
                        return Math.max(super.size(bl), this.size);
                    }
                };
            }

            @Override
            String getDebugString() {
                return "BASELINE";
            }

            @Override
            int getGravityOffset(View view, int n) {
                return 0;
            }
        };
        FILL = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return Integer.MIN_VALUE;
            }

            @Override
            String getDebugString() {
                return "FILL";
            }

            @Override
            int getGravityOffset(View view, int n) {
                return 0;
            }

            @Override
            public int getSizeInCell(View view, int n, int n2) {
                return n2;
            }
        };
    }

    public GridLayout(Context context) {
        this(context, null);
    }

    public GridLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public GridLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mPrinter = LOG_PRINTER;
        this.mDefaultGap = context.getResources().getDimensionPixelOffset(R.dimen.default_gap);
        attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout);
        try {
            this.setRowCount(attributeSet.getInt(ROW_COUNT, Integer.MIN_VALUE));
            this.setColumnCount(attributeSet.getInt(COLUMN_COUNT, Integer.MIN_VALUE));
            this.setOrientation(attributeSet.getInt(ORIENTATION, 0));
            this.setUseDefaultMargins(attributeSet.getBoolean(USE_DEFAULT_MARGINS, false));
            this.setAlignmentMode(attributeSet.getInt(ALIGNMENT_MODE, 1));
            this.setRowOrderPreserved(attributeSet.getBoolean(ROW_ORDER_PRESERVED, true));
            this.setColumnOrderPreserved(attributeSet.getBoolean(COLUMN_ORDER_PRESERVED, true));
            return;
        }
        finally {
            attributeSet.recycle();
        }
    }

    static int adjust(int n, int n2) {
        return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)(n2 + n)), (int)View.MeasureSpec.getMode((int)n));
    }

    static <T> T[] append(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    static boolean canStretch(int n) {
        boolean bl = (n & 2) != 0;
        return bl;
    }

    private void checkLayoutParams(LayoutParams object, boolean bl) {
        String string2 = bl ? "column" : "row";
        object = bl ? ((LayoutParams)((Object)object)).columnSpec : ((LayoutParams)((Object)object)).rowSpec;
        Interval interval = ((Spec)object).span;
        if (interval.min != Integer.MIN_VALUE && interval.min < 0) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" indices must be positive");
            GridLayout.handleInvalidParams(((StringBuilder)object).toString());
        }
        object = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        int n = ((Axis)object).definedCount;
        if (n != Integer.MIN_VALUE) {
            if (interval.max > n) {
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" indices (start + span) mustn't exceed the ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" count");
                GridLayout.handleInvalidParams(((StringBuilder)object).toString());
            }
            if (interval.size() > n) {
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" span mustn't exceed the ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" count");
                GridLayout.handleInvalidParams(((StringBuilder)object).toString());
            }
        }
    }

    private static int clip(Interval interval, boolean bl, int n) {
        int n2 = interval.size();
        if (n == 0) {
            return n2;
        }
        int n3 = bl ? Math.min(interval.min, n) : 0;
        return Math.min(n2, n - n3);
    }

    private int computeLayoutParamsHashCode() {
        int n = this.getChildCount();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            n2 = n2 * 31 + ((LayoutParams)view.getLayoutParams()).hashCode();
        }
        return n2;
    }

    private void consistencyCheck() {
        int n = this.mLastLayoutParamsHashCode;
        if (n == 0) {
            this.validateLayoutParams();
            this.mLastLayoutParamsHashCode = this.computeLayoutParamsHashCode();
        } else if (n != this.computeLayoutParamsHashCode()) {
            this.mPrinter.println("The fields of some layout parameters were modified in between layout operations. Check the javadoc for GridLayout.LayoutParams#rowSpec.");
            this.invalidateStructure();
            this.consistencyCheck();
        }
    }

    private static Alignment createSwitchingAlignment(final Alignment alignment, final Alignment alignment2) {
        return new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                int n3 = ViewCompat.getLayoutDirection(view);
                boolean bl = true;
                if (n3 != 1) {
                    bl = false;
                }
                Alignment alignment3 = !bl ? alignment : alignment2;
                return alignment3.getAlignmentValue(view, n, n2);
            }

            @Override
            String getDebugString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SWITCHING[L:");
                stringBuilder.append(alignment.getDebugString());
                stringBuilder.append(", R:");
                stringBuilder.append(alignment2.getDebugString());
                stringBuilder.append("]");
                return stringBuilder.toString();
            }

            @Override
            int getGravityOffset(View view, int n) {
                int n2 = ViewCompat.getLayoutDirection(view);
                boolean bl = true;
                if (n2 != 1) {
                    bl = false;
                }
                Alignment alignment3 = !bl ? alignment : alignment2;
                return alignment3.getGravityOffset(view, n);
            }
        };
    }

    private void drawLine(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        if (this.isLayoutRtlCompat()) {
            int n5 = this.getWidth();
            canvas.drawLine((float)(n5 - n), (float)n2, (float)(n5 - n3), (float)n4, paint);
        } else {
            canvas.drawLine((float)n, (float)n2, (float)n3, (float)n4, paint);
        }
    }

    private static boolean fits(int[] nArray, int n, int n2, int n3) {
        if (n3 > nArray.length) {
            return false;
        }
        while (n2 < n3) {
            if (nArray[n2] > n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static Alignment getAlignment(int n, boolean bl) {
        int n2;
        int n3 = bl ? 7 : 112;
        if ((n = (n & n3) >> (n2 = bl ? 0 : 4)) != 1) {
            if (n != 3) {
                if (n != 5) {
                    if (n != 7) {
                        if (n != 0x800003) {
                            if (n != 0x800005) {
                                return UNDEFINED_ALIGNMENT;
                            }
                            return END;
                        }
                        return START;
                    }
                    return FILL;
                }
                Alignment alignment = bl ? RIGHT : BOTTOM;
                return alignment;
            }
            Alignment alignment = bl ? LEFT : TOP;
            return alignment;
        }
        return CENTER;
    }

    private int getDefaultMargin(View view, LayoutParams object, boolean bl, boolean bl2) {
        boolean bl3;
        block5: {
            block6: {
                Axis axis;
                boolean bl4;
                block4: {
                    bl3 = this.mUseDefaultMargins;
                    bl4 = false;
                    if (!bl3) {
                        return 0;
                    }
                    object = bl ? object.columnSpec : object.rowSpec;
                    axis = bl ? this.mHorizontalAxis : this.mVerticalAxis;
                    object = ((Spec)object).span;
                    bl3 = bl && this.isLayoutRtlCompat() ? !bl2 : bl2;
                    if (!bl3) break block4;
                    bl3 = bl4;
                    if (((Interval)object).min != 0) break block5;
                    break block6;
                }
                bl3 = bl4;
                if (((Interval)object).max != axis.getCount()) break block5;
            }
            bl3 = true;
        }
        return this.getDefaultMargin(view, bl3, bl, bl2);
    }

    private int getDefaultMargin(View view, boolean bl, boolean bl2) {
        if (view.getClass() != Space.class && view.getClass() != android.widget.Space.class) {
            return this.mDefaultGap / 2;
        }
        return 0;
    }

    private int getDefaultMargin(View view, boolean bl, boolean bl2, boolean bl3) {
        return this.getDefaultMargin(view, bl2, bl3);
    }

    private int getMargin(View object, boolean bl, boolean bl2) {
        if (this.mAlignmentMode == 1) {
            return this.getMargin1((View)object, bl, bl2);
        }
        Object object2 = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        object2 = bl2 ? (Object)((Axis)object2).getLeadingMargins() : (Object)((Axis)object2).getTrailingMargins();
        object = this.getLayoutParams((View)object);
        object = bl ? object.columnSpec : object.rowSpec;
        object = object.span;
        int n = bl2 ? object.min : object.max;
        return (int)object2[n];
    }

    private int getMeasurement(View view, boolean bl) {
        int n = bl ? view.getMeasuredWidth() : view.getMeasuredHeight();
        return n;
    }

    private int getTotalMargin(View view, boolean bl) {
        return this.getMargin(view, bl, true) + this.getMargin(view, bl, false);
    }

    static void handleInvalidParams(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(". ");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private void invalidateStructure() {
        this.mLastLayoutParamsHashCode = 0;
        Axis axis = this.mHorizontalAxis;
        if (axis != null) {
            axis.invalidateStructure();
        }
        if ((axis = this.mVerticalAxis) != null) {
            axis.invalidateStructure();
        }
        this.invalidateValues();
    }

    private void invalidateValues() {
        Axis axis = this.mHorizontalAxis;
        if (axis != null && this.mVerticalAxis != null) {
            axis.invalidateValues();
            this.mVerticalAxis.invalidateValues();
        }
    }

    private boolean isLayoutRtlCompat() {
        int n = ViewCompat.getLayoutDirection((View)this);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    static int max2(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    private void measureChildWithMargins2(View view, int n, int n2, int n3, int n4) {
        view.measure(GridLayout.getChildMeasureSpec((int)n, (int)this.getTotalMargin(view, true), (int)n3), GridLayout.getChildMeasureSpec((int)n2, (int)this.getTotalMargin(view, false), (int)n4));
    }

    private void measureChildrenWithMargins(int n, int n2, boolean bl) {
        int n3 = this.getChildCount();
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = this.getLayoutParams(view);
            if (bl) {
                this.measureChildWithMargins2(view, n, n2, layoutParams.width, layoutParams.height);
                continue;
            }
            boolean bl2 = this.mOrientation == 0;
            Object object = bl2 ? layoutParams.columnSpec : layoutParams.rowSpec;
            if (((Spec)object).getAbsoluteAlignment(bl2) != FILL) continue;
            Interval interval = ((Spec)object).span;
            object = bl2 ? this.mHorizontalAxis : this.mVerticalAxis;
            object = ((Axis)object).getLocations();
            reference var11_11 = object[interval.max] - object[interval.min] - this.getTotalMargin(view, bl2);
            if (bl2) {
                this.measureChildWithMargins2(view, n, n2, (int)var11_11, layoutParams.height);
                continue;
            }
            this.measureChildWithMargins2(view, n, n2, layoutParams.width, (int)var11_11);
        }
    }

    private static void procrusteanFill(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        Arrays.fill(nArray, Math.min(n, n4), Math.min(n2, n4), n3);
    }

    private static void setCellGroup(LayoutParams layoutParams, int n, int n2, int n3, int n4) {
        layoutParams.setRowSpecSpan(new Interval(n, n2 + n));
        layoutParams.setColumnSpecSpan(new Interval(n3, n4 + n3));
    }

    public static Spec spec(int n) {
        return GridLayout.spec(n, 1);
    }

    public static Spec spec(int n, float f) {
        return GridLayout.spec(n, 1, f);
    }

    public static Spec spec(int n, int n2) {
        return GridLayout.spec(n, n2, UNDEFINED_ALIGNMENT);
    }

    public static Spec spec(int n, int n2, float f) {
        return GridLayout.spec(n, n2, UNDEFINED_ALIGNMENT, f);
    }

    public static Spec spec(int n, int n2, Alignment alignment) {
        return GridLayout.spec(n, n2, alignment, 0.0f);
    }

    public static Spec spec(int n, int n2, Alignment alignment, float f) {
        boolean bl = n != Integer.MIN_VALUE;
        return new Spec(bl, n, n2, alignment, f);
    }

    public static Spec spec(int n, Alignment alignment) {
        return GridLayout.spec(n, 1, alignment);
    }

    public static Spec spec(int n, Alignment alignment, float f) {
        return GridLayout.spec(n, 1, alignment, f);
    }

    private void validateLayoutParams() {
        boolean bl = this.mOrientation == 0;
        Object object = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        int n = ((Axis)object).definedCount != Integer.MIN_VALUE ? ((Axis)object).definedCount : 0;
        int[] nArray = new int[n];
        int n2 = this.getChildCount();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            int n7;
            int n8;
            LayoutParams layoutParams;
            block10: {
                block12: {
                    int n9;
                    int n10;
                    boolean bl2;
                    block11: {
                        layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
                        object = bl ? layoutParams.rowSpec : layoutParams.columnSpec;
                        Interval interval = ((Spec)object).span;
                        boolean bl3 = ((Spec)object).startDefined;
                        n8 = interval.size();
                        if (bl3) {
                            n3 = interval.min;
                        }
                        object = bl ? layoutParams.columnSpec : layoutParams.rowSpec;
                        interval = ((Spec)object).span;
                        bl2 = ((Spec)object).startDefined;
                        n7 = GridLayout.clip(interval, bl2, n);
                        if (bl2) {
                            n4 = interval.min;
                        }
                        n6 = n3;
                        n5 = n4;
                        if (n == 0) break block10;
                        n10 = n3;
                        n9 = n4;
                        if (!bl3) break block11;
                        n6 = n3;
                        n5 = n4;
                        if (bl2) break block12;
                        n9 = n4;
                        n10 = n3;
                    }
                    while (true) {
                        n3 = n9 + n7;
                        n6 = ++n10;
                        n5 = n9;
                        if (GridLayout.fits(nArray, n10, n9, n3)) break;
                        if (bl2) continue;
                        if (n3 <= n) {
                            ++n9;
                            continue;
                        }
                        ++n10;
                        n9 = 0;
                    }
                }
                GridLayout.procrusteanFill(nArray, n5, n5 + n7, n6 + n8);
            }
            if (bl) {
                GridLayout.setCellGroup(layoutParams, n6, n8, n5, n7);
            } else {
                GridLayout.setCellGroup(layoutParams, n5, n7, n6, n8);
            }
            n4 = n5 + n7;
            n3 = n6;
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams object) {
        if (!(object instanceof LayoutParams)) {
            return false;
        }
        object = (LayoutParams)((Object)object);
        this.checkLayoutParams((LayoutParams)((Object)object), true);
        this.checkLayoutParams((LayoutParams)((Object)object), false);
        return true;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    public int getAlignmentMode() {
        return this.mAlignmentMode;
    }

    public int getColumnCount() {
        return this.mHorizontalAxis.getCount();
    }

    final LayoutParams getLayoutParams(View view) {
        return (LayoutParams)view.getLayoutParams();
    }

    int getMargin1(View view, boolean bl, boolean bl2) {
        LayoutParams layoutParams = this.getLayoutParams(view);
        int n = bl ? (bl2 ? layoutParams.leftMargin : layoutParams.rightMargin) : (bl2 ? layoutParams.topMargin : layoutParams.bottomMargin);
        int n2 = n;
        if (n == Integer.MIN_VALUE) {
            n2 = this.getDefaultMargin(view, layoutParams, bl, bl2);
        }
        return n2;
    }

    final int getMeasurementIncludingMargin(View view, boolean bl) {
        if (view.getVisibility() == 8) {
            return 0;
        }
        return this.getMeasurement(view, bl) + this.getTotalMargin(view, bl);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public Printer getPrinter() {
        return this.mPrinter;
    }

    public int getRowCount() {
        return this.mVerticalAxis.getCount();
    }

    public boolean getUseDefaultMargins() {
        return this.mUseDefaultMargins;
    }

    public boolean isColumnOrderPreserved() {
        return this.mHorizontalAxis.isOrderPreserved();
    }

    public boolean isRowOrderPreserved() {
        return this.mVerticalAxis.isOrderPreserved();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        Object object = this;
        this.consistencyCheck();
        int n5 = n3 - n;
        int n6 = this.getPaddingLeft();
        n3 = this.getPaddingTop();
        int n7 = this.getPaddingRight();
        n = this.getPaddingBottom();
        object.mHorizontalAxis.layout(n5 - n6 - n7);
        object.mVerticalAxis.layout(n4 - n2 - n3 - n);
        int[] nArray = object.mHorizontalAxis.getLocations();
        object = object.mVerticalAxis.getLocations();
        n4 = this.getChildCount();
        n = 0;
        while (true) {
            GridLayout gridLayout = this;
            if (n >= n4) break;
            View view = gridLayout.getChildAt(n);
            if (view.getVisibility() != 8) {
                Object object2 = gridLayout.getLayoutParams(view);
                Object object3 = ((LayoutParams)((Object)object2)).columnSpec;
                object2 = ((LayoutParams)((Object)object2)).rowSpec;
                Object object4 = ((Spec)object3).span;
                Object object5 = ((Spec)object2).span;
                n2 = nArray[((Interval)object4).min];
                Object object6 = object[((Interval)object5).min];
                int n8 = nArray[((Interval)object4).max];
                Object object7 = object[((Interval)object5).max];
                int n9 = n8 - n2;
                Object object8 = object7 - object6;
                int n10 = gridLayout.getMeasurement(view, true);
                int n11 = gridLayout.getMeasurement(view, false);
                object3 = ((Spec)object3).getAbsoluteAlignment(true);
                object4 = ((Spec)object2).getAbsoluteAlignment(false);
                object2 = gridLayout.mHorizontalAxis.getGroupBounds().getValue(n);
                object5 = gridLayout.mVerticalAxis.getGroupBounds().getValue(n);
                int n12 = ((Alignment)object3).getGravityOffset(view, n9 - ((Bounds)object2).size(true));
                object7 = ((Alignment)object4).getGravityOffset(view, (int)(object8 - ((Bounds)object5).size(true)));
                int n13 = gridLayout.getMargin(view, true, true);
                n8 = gridLayout.getMargin(view, false, true);
                int n14 = gridLayout.getMargin(view, true, false);
                int n15 = gridLayout.getMargin(view, false, false);
                int n16 = n13 + n14;
                int n17 = n8 + n15;
                int n18 = ((Bounds)object2).getOffset(this, view, (Alignment)object3, n10 + n16, true);
                n15 = ((Bounds)object5).getOffset(this, view, (Alignment)object4, n11 + n17, false);
                n9 = ((Alignment)object3).getSizeInCell(view, n10, n9 - n16);
                object8 = ((Alignment)object4).getSizeInCell(view, n11, (int)(object8 - n17));
                n2 = n2 + n12 + n18;
                n2 = !this.isLayoutRtlCompat() ? n6 + n13 + n2 : n5 - n9 - n7 - n14 - n2;
                object6 = n3 + object6 + object7 + n15 + n8;
                if (n9 != view.getMeasuredWidth() || object8 != view.getMeasuredHeight()) {
                    view.measure(View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)object8, (int)0x40000000));
                }
                view.layout(n2, (int)object6, n9 + n2, (int)(object8 + object6));
            }
            ++n;
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        this.consistencyCheck();
        this.invalidateValues();
        int n5 = this.getPaddingLeft() + this.getPaddingRight();
        int n6 = this.getPaddingTop() + this.getPaddingBottom();
        int n7 = GridLayout.adjust(n, -n5);
        int n8 = GridLayout.adjust(n2, -n6);
        this.measureChildrenWithMargins(n7, n8, true);
        if (this.mOrientation == 0) {
            n4 = this.mHorizontalAxis.getMeasure(n7);
            this.measureChildrenWithMargins(n7, n8, false);
            n3 = this.mVerticalAxis.getMeasure(n8);
        } else {
            n3 = this.mVerticalAxis.getMeasure(n8);
            this.measureChildrenWithMargins(n7, n8, false);
            n4 = this.mHorizontalAxis.getMeasure(n7);
        }
        n4 = Math.max(n4 + n5, this.getSuggestedMinimumWidth());
        n3 = Math.max(n3 + n6, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSizeAndState((int)n4, (int)n, (int)0), View.resolveSizeAndState((int)n3, (int)n2, (int)0));
    }

    public void requestLayout() {
        super.requestLayout();
        this.invalidateStructure();
    }

    public void setAlignmentMode(int n) {
        this.mAlignmentMode = n;
        this.requestLayout();
    }

    public void setColumnCount(int n) {
        this.mHorizontalAxis.setCount(n);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setColumnOrderPreserved(boolean bl) {
        this.mHorizontalAxis.setOrderPreserved(bl);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setOrientation(int n) {
        if (this.mOrientation != n) {
            this.mOrientation = n;
            this.invalidateStructure();
            this.requestLayout();
        }
    }

    public void setPrinter(Printer printer) {
        Printer printer2 = printer;
        if (printer == null) {
            printer2 = NO_PRINTER;
        }
        this.mPrinter = printer2;
    }

    public void setRowCount(int n) {
        this.mVerticalAxis.setCount(n);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setRowOrderPreserved(boolean bl) {
        this.mVerticalAxis.setOrderPreserved(bl);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setUseDefaultMargins(boolean bl) {
        this.mUseDefaultMargins = bl;
        this.requestLayout();
    }

    public static abstract class Alignment {
        Alignment() {
        }

        abstract int getAlignmentValue(View var1, int var2, int var3);

        Bounds getBounds() {
            return new Bounds();
        }

        abstract String getDebugString();

        abstract int getGravityOffset(View var1, int var2);

        int getSizeInCell(View view, int n, int n2) {
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Alignment:");
            stringBuilder.append(this.getDebugString());
            return stringBuilder.toString();
        }
    }

    static final class Arc {
        public final Interval span;
        public boolean valid = true;
        public final MutableInt value;

        public Arc(Interval interval, MutableInt mutableInt) {
            this.span = interval;
            this.value = mutableInt;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.span);
            stringBuilder.append(" ");
            String string2 = !this.valid ? "+>" : "->";
            stringBuilder.append(string2);
            stringBuilder.append(" ");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    static final class Assoc<K, V>
    extends ArrayList<Pair<K, V>> {
        private final Class<K> keyType;
        private final Class<V> valueType;

        private Assoc(Class<K> clazz, Class<V> clazz2) {
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        public static <K, V> Assoc<K, V> of(Class<K> clazz, Class<V> clazz2) {
            return new Assoc<K, V>(clazz, clazz2);
        }

        public PackedMap<K, V> pack() {
            int n = this.size();
            Object[] objectArray = (Object[])Array.newInstance(this.keyType, n);
            Object[] objectArray2 = (Object[])Array.newInstance(this.valueType, n);
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((Pair)this.get((int)i)).first;
                objectArray2[i] = ((Pair)this.get((int)i)).second;
            }
            return new PackedMap<Object, Object>(objectArray, objectArray2);
        }

        public void put(K k, V v) {
            this.add(Pair.create(k, v));
        }
    }

    final class Axis {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        static final int COMPLETE = 2;
        static final int NEW = 0;
        static final int PENDING = 1;
        public Arc[] arcs;
        public boolean arcsValid = false;
        PackedMap<Interval, MutableInt> backwardLinks;
        public boolean backwardLinksValid = false;
        public int definedCount = Integer.MIN_VALUE;
        public int[] deltas;
        PackedMap<Interval, MutableInt> forwardLinks;
        public boolean forwardLinksValid = false;
        PackedMap<Spec, Bounds> groupBounds;
        public boolean groupBoundsValid = false;
        public boolean hasWeights;
        public boolean hasWeightsValid = false;
        public final boolean horizontal;
        public int[] leadingMargins;
        public boolean leadingMarginsValid = false;
        public int[] locations;
        public boolean locationsValid = false;
        private int maxIndex = Integer.MIN_VALUE;
        boolean orderPreserved = true;
        private MutableInt parentMax;
        private MutableInt parentMin = new MutableInt(0);
        public int[] trailingMargins;
        public boolean trailingMarginsValid = false;

        Axis(boolean bl) {
            this.parentMax = new MutableInt(-100000);
            this.horizontal = bl;
        }

        private void addComponentSizes(List<Arc> list, PackedMap<Interval, MutableInt> packedMap) {
            for (int i = 0; i < ((Interval[])packedMap.keys).length; ++i) {
                this.include(list, ((Interval[])packedMap.keys)[i], ((MutableInt[])packedMap.values)[i], false);
            }
        }

        private String arcsToString(List<Arc> object) {
            String string2 = this.horizontal ? "x" : "y";
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Arc)object.next();
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                int n = ((Arc)object2).span.min;
                int n2 = ((Arc)object2).span.max;
                int n3 = ((Arc)object2).value.value;
                if (n < n2) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(n2);
                    ((StringBuilder)object2).append("-");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(n);
                    ((StringBuilder)object2).append(">=");
                } else {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(n);
                    ((StringBuilder)object2).append("-");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(n2);
                    ((StringBuilder)object2).append("<=");
                    n3 = -n3;
                }
                ((StringBuilder)object2).append(n3);
                stringBuilder.append(((StringBuilder)object2).toString());
            }
            return stringBuilder.toString();
        }

        private int calculateMaxIndex() {
            int n;
            int n2 = GridLayout.this.getChildCount();
            int n3 = -1;
            for (n = 0; n < n2; ++n) {
                Object object = GridLayout.this.getChildAt(n);
                object = GridLayout.this.getLayoutParams((View)object);
                object = this.horizontal ? ((LayoutParams)((Object)object)).columnSpec : ((LayoutParams)((Object)object)).rowSpec;
                object = ((Spec)object).span;
                n3 = Math.max(Math.max(Math.max(n3, ((Interval)object).min), ((Interval)object).max), ((Interval)object).size());
            }
            n = n3;
            if (n3 == -1) {
                n = Integer.MIN_VALUE;
            }
            return n;
        }

        private float calculateTotalWeight() {
            int n = GridLayout.this.getChildCount();
            float f = 0.0f;
            for (int i = 0; i < n; ++i) {
                Object object = GridLayout.this.getChildAt(i);
                if (object.getVisibility() == 8) continue;
                object = GridLayout.this.getLayoutParams((View)object);
                object = this.horizontal ? object.columnSpec : object.rowSpec;
                f += object.weight;
            }
            return f;
        }

        private void computeArcs() {
            this.getForwardLinks();
            this.getBackwardLinks();
        }

        private void computeGroupBounds() {
            int n;
            Object object = (Bounds[])this.groupBounds.values;
            for (n = 0; n < ((Bounds[])object).length; ++n) {
                object[n].reset();
            }
            int n2 = GridLayout.this.getChildCount();
            for (n = 0; n < n2; ++n) {
                View view = GridLayout.this.getChildAt(n);
                object = GridLayout.this.getLayoutParams(view);
                object = this.horizontal ? object.columnSpec : object.rowSpec;
                int n3 = GridLayout.this.getMeasurementIncludingMargin(view, this.horizontal);
                int n4 = object.weight == 0.0f ? 0 : this.getDeltas()[n];
                this.groupBounds.getValue(n).include(GridLayout.this, view, (Spec)object, this, n3 + n4);
            }
        }

        private boolean computeHasWeights() {
            int n = GridLayout.this.getChildCount();
            for (int i = 0; i < n; ++i) {
                Object object = GridLayout.this.getChildAt(i);
                if (object.getVisibility() == 8) continue;
                object = GridLayout.this.getLayoutParams((View)object);
                object = this.horizontal ? object.columnSpec : object.rowSpec;
                if (object.weight == 0.0f) continue;
                return true;
            }
            return false;
        }

        private void computeLinks(PackedMap<Interval, MutableInt> packedMap, boolean bl) {
            int n;
            Object[] objectArray = (MutableInt[])packedMap.values;
            int n2 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n].reset();
            }
            objectArray = (Bounds[])this.getGroupBounds().values;
            for (n = n2; n < objectArray.length; ++n) {
                n2 = ((Bounds)objectArray[n]).size(bl);
                MutableInt mutableInt = packedMap.getValue(n);
                int n3 = mutableInt.value;
                if (!bl) {
                    n2 = -n2;
                }
                mutableInt.value = Math.max(n3, n2);
            }
        }

        private void computeLocations(int[] nArray) {
            if (!this.hasWeights()) {
                this.solve(nArray);
            } else {
                this.solveAndDistributeSpace(nArray);
            }
            if (!this.orderPreserved) {
                int n = nArray[0];
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = nArray[i] - n;
                }
            }
        }

        private void computeMargins(boolean bl) {
            int[] nArray = bl ? this.leadingMargins : this.trailingMargins;
            int n = GridLayout.this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = GridLayout.this.getChildAt(i);
                if (view.getVisibility() == 8) continue;
                Object object = GridLayout.this.getLayoutParams(view);
                object = this.horizontal ? object.columnSpec : object.rowSpec;
                object = ((Spec)object).span;
                int n2 = bl ? ((Interval)object).min : ((Interval)object).max;
                nArray[n2] = Math.max(nArray[n2], GridLayout.this.getMargin1(view, this.horizontal, bl));
            }
        }

        private Arc[] createArcs() {
            int n;
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            this.addComponentSizes(arrayList, this.getForwardLinks());
            this.addComponentSizes(arrayList2, this.getBackwardLinks());
            if (this.orderPreserved) {
                n = 0;
                while (n < this.getCount()) {
                    int n2 = n + 1;
                    this.include(arrayList, new Interval(n, n2), new MutableInt(0));
                    n = n2;
                }
            }
            n = this.getCount();
            this.include(arrayList, new Interval(0, n), this.parentMin, false);
            this.include(arrayList2, new Interval(n, 0), this.parentMax, false);
            return GridLayout.append(this.topologicalSort(arrayList), this.topologicalSort(arrayList2));
        }

        private PackedMap<Spec, Bounds> createGroupBounds() {
            Assoc<Spec, Bounds> assoc = Assoc.of(Spec.class, Bounds.class);
            int n = GridLayout.this.getChildCount();
            for (int i = 0; i < n; ++i) {
                Object object = GridLayout.this.getChildAt(i);
                object = GridLayout.this.getLayoutParams((View)object);
                object = this.horizontal ? ((LayoutParams)((Object)object)).columnSpec : ((LayoutParams)((Object)object)).rowSpec;
                assoc.put((Spec)object, ((Spec)object).getAbsoluteAlignment(this.horizontal).getBounds());
            }
            return assoc.pack();
        }

        private PackedMap<Interval, MutableInt> createLinks(boolean bl) {
            Assoc<Interval, MutableInt> assoc = Assoc.of(Interval.class, MutableInt.class);
            Spec[] specArray = (Spec[])this.getGroupBounds().keys;
            int n = specArray.length;
            for (int i = 0; i < n; ++i) {
                Interval interval = bl ? specArray[i].span : specArray[i].span.inverse();
                assoc.put(interval, new MutableInt());
            }
            return assoc.pack();
        }

        private PackedMap<Interval, MutableInt> getBackwardLinks() {
            if (this.backwardLinks == null) {
                this.backwardLinks = this.createLinks(false);
            }
            if (!this.backwardLinksValid) {
                this.computeLinks(this.backwardLinks, false);
                this.backwardLinksValid = true;
            }
            return this.backwardLinks;
        }

        private PackedMap<Interval, MutableInt> getForwardLinks() {
            if (this.forwardLinks == null) {
                this.forwardLinks = this.createLinks(true);
            }
            if (!this.forwardLinksValid) {
                this.computeLinks(this.forwardLinks, true);
                this.forwardLinksValid = true;
            }
            return this.forwardLinks;
        }

        private int getMaxIndex() {
            if (this.maxIndex == Integer.MIN_VALUE) {
                this.maxIndex = Math.max(0, this.calculateMaxIndex());
            }
            return this.maxIndex;
        }

        private int getMeasure(int n, int n2) {
            this.setParentConstraints(n, n2);
            return this.size(this.getLocations());
        }

        private boolean hasWeights() {
            if (!this.hasWeightsValid) {
                this.hasWeights = this.computeHasWeights();
                this.hasWeightsValid = true;
            }
            return this.hasWeights;
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt) {
            this.include(list, interval, mutableInt, true);
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt, boolean bl) {
            if (interval.size() == 0) {
                return;
            }
            if (bl) {
                Iterator<Arc> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().span.equals(interval)) continue;
                    return;
                }
            }
            list.add(new Arc(interval, mutableInt));
        }

        private void init(int[] nArray) {
            Arrays.fill(nArray, 0);
        }

        private void logError(String string2, Arc[] object, boolean[] object2) {
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            for (int i = 0; i < ((Arc[])object).length; ++i) {
                Arc arc = object[i];
                if (object2[i]) {
                    arrayList.add(arc);
                }
                if (arc.valid) continue;
                arrayList2.add(arc);
            }
            object2 = GridLayout.this.mPrinter;
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" constraints: ");
            ((StringBuilder)object).append(this.arcsToString(arrayList));
            ((StringBuilder)object).append(" are inconsistent; permanently removing: ");
            ((StringBuilder)object).append(this.arcsToString(arrayList2));
            ((StringBuilder)object).append(". ");
            object2.println(((StringBuilder)object).toString());
        }

        private boolean relax(int[] nArray, Arc arc) {
            if (!arc.valid) {
                return false;
            }
            Interval interval = arc.span;
            int n = interval.min;
            int n2 = interval.max;
            int n3 = arc.value.value;
            if ((n3 = nArray[n] + n3) > nArray[n2]) {
                nArray[n2] = n3;
                return true;
            }
            return false;
        }

        private void setParentConstraints(int n, int n2) {
            this.parentMin.value = n;
            this.parentMax.value = -n2;
            this.locationsValid = false;
        }

        private void shareOutDelta(int n, float f) {
            Object object = this.deltas;
            int n2 = 0;
            Arrays.fill((int[])object, 0);
            int n3 = GridLayout.this.getChildCount();
            float f2 = f;
            int n4 = n;
            for (n = n2; n < n3; ++n) {
                object = GridLayout.this.getChildAt(n);
                if (object.getVisibility() == 8) {
                    n2 = n4;
                    f = f2;
                } else {
                    object = (Object)GridLayout.this.getLayoutParams((View)object);
                    object = this.horizontal ? (Object)((LayoutParams)((Object)object)).columnSpec : (Object)((LayoutParams)((Object)object)).rowSpec;
                    float f3 = ((Spec)object).weight;
                    n2 = n4;
                    f = f2;
                    if (f3 != 0.0f) {
                        this.deltas[n] = n2 = Math.round((float)n4 * f3 / f2);
                        n2 = n4 - n2;
                        f = f2 - f3;
                    }
                }
                n4 = n2;
                f2 = f;
            }
        }

        private int size(int[] nArray) {
            return nArray[this.getCount()];
        }

        private boolean solve(int[] nArray) {
            return this.solve(this.getArcs(), nArray);
        }

        private boolean solve(Arc[] arcArray, int[] nArray) {
            return this.solve(arcArray, nArray, true);
        }

        private boolean solve(Arc[] arcArray, int[] nArray, boolean bl) {
            String string2 = this.horizontal ? "horizontal" : "vertical";
            int n = this.getCount() + 1;
            boolean[] blArray = null;
            block0: for (int i = 0; i < arcArray.length; ++i) {
                int n2;
                int n3;
                int n4;
                this.init(nArray);
                for (n4 = 0; n4 < n; ++n4) {
                    int n5 = arcArray.length;
                    n3 = 0;
                    for (n2 = 0; n2 < n5; ++n2) {
                        n3 |= this.relax(nArray, arcArray[n2]);
                    }
                    if (n3 != 0) continue;
                    if (blArray != null) {
                        this.logError(string2, arcArray, blArray);
                    }
                    return true;
                }
                if (!bl) {
                    return false;
                }
                boolean[] blArray2 = new boolean[arcArray.length];
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = arcArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        blArray2[n2] = blArray2[n2] | this.relax(nArray, arcArray[n2]);
                    }
                }
                if (i == 0) {
                    blArray = blArray2;
                }
                for (n4 = 0; n4 < arcArray.length; ++n4) {
                    if (!blArray2[n4]) continue;
                    Arc arc = arcArray[n4];
                    if (arc.span.min < arc.span.max) continue;
                    arc.valid = false;
                    continue block0;
                }
            }
            return true;
        }

        private void solveAndDistributeSpace(int[] nArray) {
            Arrays.fill(this.getDeltas(), 0);
            this.solve(nArray);
            int n = this.parentMin.value;
            int n2 = GridLayout.this.getChildCount();
            boolean bl = true;
            n = n * n2 + 1;
            if (n < 2) {
                return;
            }
            float f = this.calculateTotalWeight();
            n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                int n4 = (int)(((long)n3 + (long)n) / 2L);
                this.invalidateValues();
                this.shareOutDelta(n4, f);
                bl = this.solve(this.getArcs(), nArray, false);
                if (bl) {
                    n3 = n4 + 1;
                    n2 = n4;
                    continue;
                }
                n = n4;
            }
            if (n2 > 0 && !bl) {
                this.invalidateValues();
                this.shareOutDelta(n2, f);
                this.solve(nArray);
            }
        }

        private Arc[] topologicalSort(List<Arc> list) {
            return this.topologicalSort(list.toArray(new Arc[list.size()]));
        }

        private Arc[] topologicalSort(final Arc[] arcArray) {
            return new Object(){
                static final /* synthetic */ boolean $assertionsDisabled = false;
                Arc[][] arcsByVertex;
                int cursor;
                Arc[] result;
                int[] visited;
                {
                    Arc[] arcArray2 = new Arc[arcArray3.length];
                    this.result = arcArray2;
                    this.cursor = arcArray2.length - 1;
                    this.arcsByVertex = Axis.this.groupArcsByFirstVertex(arcArray3);
                    this.visited = new int[Axis.this.getCount() + 1];
                }

                Arc[] sort() {
                    int n = this.arcsByVertex.length;
                    for (int i = 0; i < n; ++i) {
                        this.walk(i);
                    }
                    return this.result;
                }

                void walk(int n) {
                    Object object = this.visited;
                    if (object[n] == 0) {
                        object[n] = 1;
                        Arc[] arcArray3 = this.arcsByVertex[n];
                        int n2 = arcArray3.length;
                        for (int i = 0; i < n2; ++i) {
                            object = arcArray3[i];
                            this.walk(object.span.max);
                            Arc[] arcArray2 = this.result;
                            int n3 = this.cursor;
                            this.cursor = n3 - 1;
                            arcArray2[n3] = object;
                        }
                        this.visited[n] = 2;
                    }
                }
            }.sort();
        }

        public Arc[] getArcs() {
            if (this.arcs == null) {
                this.arcs = this.createArcs();
            }
            if (!this.arcsValid) {
                this.computeArcs();
                this.arcsValid = true;
            }
            return this.arcs;
        }

        public int getCount() {
            return Math.max(this.definedCount, this.getMaxIndex());
        }

        public int[] getDeltas() {
            if (this.deltas == null) {
                this.deltas = new int[GridLayout.this.getChildCount()];
            }
            return this.deltas;
        }

        public PackedMap<Spec, Bounds> getGroupBounds() {
            if (this.groupBounds == null) {
                this.groupBounds = this.createGroupBounds();
            }
            if (!this.groupBoundsValid) {
                this.computeGroupBounds();
                this.groupBoundsValid = true;
            }
            return this.groupBounds;
        }

        public int[] getLeadingMargins() {
            if (this.leadingMargins == null) {
                this.leadingMargins = new int[this.getCount() + 1];
            }
            if (!this.leadingMarginsValid) {
                this.computeMargins(true);
                this.leadingMarginsValid = true;
            }
            return this.leadingMargins;
        }

        public int[] getLocations() {
            if (this.locations == null) {
                this.locations = new int[this.getCount() + 1];
            }
            if (!this.locationsValid) {
                this.computeLocations(this.locations);
                this.locationsValid = true;
            }
            return this.locations;
        }

        public int getMeasure(int n) {
            int n2 = View.MeasureSpec.getMode((int)n);
            n = View.MeasureSpec.getSize((int)n);
            if (n2 != Integer.MIN_VALUE) {
                if (n2 != 0) {
                    if (n2 != 0x40000000) {
                        return 0;
                    }
                    return this.getMeasure(n, n);
                }
                return this.getMeasure(0, 100000);
            }
            return this.getMeasure(0, n);
        }

        public int[] getTrailingMargins() {
            if (this.trailingMargins == null) {
                this.trailingMargins = new int[this.getCount() + 1];
            }
            if (!this.trailingMarginsValid) {
                this.computeMargins(false);
                this.trailingMarginsValid = true;
            }
            return this.trailingMargins;
        }

        Arc[][] groupArcsByFirstVertex(Arc[] arcArray) {
            int n;
            int n2 = this.getCount() + 1;
            Arc[][] arcArray2 = new Arc[n2][];
            int[] nArray = new int[n2];
            int n3 = arcArray.length;
            int n4 = 0;
            for (n = 0; n < n3; ++n) {
                int n5 = arcArray[n].span.min;
                nArray[n5] = nArray[n5] + 1;
            }
            for (n = 0; n < n2; ++n) {
                arcArray2[n] = new Arc[nArray[n]];
            }
            Arrays.fill(nArray, 0);
            n2 = arcArray.length;
            for (n = n4; n < n2; ++n) {
                Arc arc = arcArray[n];
                n3 = arc.span.min;
                Arc[] arcArray3 = arcArray2[n3];
                n4 = nArray[n3];
                nArray[n3] = n4 + 1;
                arcArray3[n4] = arc;
            }
            return arcArray2;
        }

        public void invalidateStructure() {
            this.maxIndex = Integer.MIN_VALUE;
            this.groupBounds = null;
            this.forwardLinks = null;
            this.backwardLinks = null;
            this.leadingMargins = null;
            this.trailingMargins = null;
            this.arcs = null;
            this.locations = null;
            this.deltas = null;
            this.hasWeightsValid = false;
            this.invalidateValues();
        }

        public void invalidateValues() {
            this.groupBoundsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.leadingMarginsValid = false;
            this.trailingMarginsValid = false;
            this.arcsValid = false;
            this.locationsValid = false;
        }

        public boolean isOrderPreserved() {
            return this.orderPreserved;
        }

        public void layout(int n) {
            this.setParentConstraints(n, n);
            this.getLocations();
        }

        public void setCount(int n) {
            if (n != Integer.MIN_VALUE && n < this.getMaxIndex()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.horizontal ? "column" : "row";
                stringBuilder.append(string2);
                stringBuilder.append("Count must be greater than or equal to the maximum of all grid indices ");
                stringBuilder.append("(and spans) defined in the LayoutParams of each child");
                GridLayout.handleInvalidParams(stringBuilder.toString());
            }
            this.definedCount = n;
        }

        public void setOrderPreserved(boolean bl) {
            this.orderPreserved = bl;
            this.invalidateStructure();
        }
    }

    static class Bounds {
        public int after;
        public int before;
        public int flexibility;

        Bounds() {
            this.reset();
        }

        protected int getOffset(GridLayout gridLayout, View view, Alignment alignment, int n, boolean bl) {
            return this.before - alignment.getAlignmentValue(view, n, ViewGroupCompat.getLayoutMode(gridLayout));
        }

        protected void include(int n, int n2) {
            this.before = Math.max(this.before, n);
            this.after = Math.max(this.after, n2);
        }

        protected final void include(GridLayout gridLayout, View view, Spec spec, Axis axis, int n) {
            this.flexibility &= spec.getFlexibility();
            int n2 = spec.getAbsoluteAlignment(axis.horizontal).getAlignmentValue(view, n, ViewGroupCompat.getLayoutMode(gridLayout));
            this.include(n2, n - n2);
        }

        protected void reset() {
            this.before = Integer.MIN_VALUE;
            this.after = Integer.MIN_VALUE;
            this.flexibility = 2;
        }

        protected int size(boolean bl) {
            if (!bl && GridLayout.canStretch(this.flexibility)) {
                return 100000;
            }
            return this.before + this.after;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Bounds{before=");
            stringBuilder.append(this.before);
            stringBuilder.append(", after=");
            stringBuilder.append(this.after);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    static final class Interval {
        public final int max;
        public final int min;

        public Interval(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (Interval)object;
                if (this.max != ((Interval)object).max) {
                    return false;
                }
                return this.min == ((Interval)object).min;
            }
            return false;
        }

        public int hashCode() {
            return this.min * 31 + this.max;
        }

        Interval inverse() {
            return new Interval(this.max, this.min);
        }

        int size() {
            return this.max - this.min;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            stringBuilder.append(this.min);
            stringBuilder.append(", ");
            stringBuilder.append(this.max);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int BOTTOM_MARGIN;
        private static final int COLUMN;
        private static final int COLUMN_SPAN;
        private static final int COLUMN_WEIGHT;
        private static final int DEFAULT_COLUMN = Integer.MIN_VALUE;
        private static final int DEFAULT_HEIGHT = -2;
        private static final int DEFAULT_MARGIN = Integer.MIN_VALUE;
        private static final int DEFAULT_ROW = Integer.MIN_VALUE;
        private static final Interval DEFAULT_SPAN;
        private static final int DEFAULT_SPAN_SIZE;
        private static final int DEFAULT_WIDTH = -2;
        private static final int GRAVITY;
        private static final int LEFT_MARGIN;
        private static final int MARGIN;
        private static final int RIGHT_MARGIN;
        private static final int ROW;
        private static final int ROW_SPAN;
        private static final int ROW_WEIGHT;
        private static final int TOP_MARGIN;
        public Spec columnSpec;
        public Spec rowSpec = Spec.UNDEFINED;

        static {
            Interval interval;
            DEFAULT_SPAN = interval = new Interval(Integer.MIN_VALUE, -2147483647);
            DEFAULT_SPAN_SIZE = interval.size();
            MARGIN = R.styleable.GridLayout_Layout_android_layout_margin;
            LEFT_MARGIN = R.styleable.GridLayout_Layout_android_layout_marginLeft;
            TOP_MARGIN = R.styleable.GridLayout_Layout_android_layout_marginTop;
            RIGHT_MARGIN = R.styleable.GridLayout_Layout_android_layout_marginRight;
            BOTTOM_MARGIN = R.styleable.GridLayout_Layout_android_layout_marginBottom;
            COLUMN = R.styleable.GridLayout_Layout_layout_column;
            COLUMN_SPAN = R.styleable.GridLayout_Layout_layout_columnSpan;
            COLUMN_WEIGHT = R.styleable.GridLayout_Layout_layout_columnWeight;
            ROW = R.styleable.GridLayout_Layout_layout_row;
            ROW_SPAN = R.styleable.GridLayout_Layout_layout_rowSpan;
            ROW_WEIGHT = R.styleable.GridLayout_Layout_layout_rowWeight;
            GRAVITY = R.styleable.GridLayout_Layout_layout_gravity;
        }

        public LayoutParams() {
            this(Spec.UNDEFINED, Spec.UNDEFINED);
        }

        private LayoutParams(int n, int n2, int n3, int n4, int n5, int n6, Spec spec, Spec spec2) {
            super(n, n2);
            this.columnSpec = Spec.UNDEFINED;
            this.setMargins(n3, n4, n5, n6);
            this.rowSpec = spec;
            this.columnSpec = spec2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.columnSpec = Spec.UNDEFINED;
            this.reInitSuper(context, attributeSet);
            this.init(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.columnSpec = Spec.UNDEFINED;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.columnSpec = Spec.UNDEFINED;
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.columnSpec = Spec.UNDEFINED;
            this.rowSpec = layoutParams.rowSpec;
            this.columnSpec = layoutParams.columnSpec;
        }

        public LayoutParams(Spec spec, Spec spec2) {
            this(-2, -2, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, spec, spec2);
        }

        private void init(Context context, AttributeSet attributeSet) {
            attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout_Layout);
            try {
                int n = attributeSet.getInt(GRAVITY, 0);
                int n2 = attributeSet.getInt(COLUMN, Integer.MIN_VALUE);
                int n3 = COLUMN_SPAN;
                int n4 = DEFAULT_SPAN_SIZE;
                n3 = attributeSet.getInt(n3, n4);
                float f = attributeSet.getFloat(COLUMN_WEIGHT, 0.0f);
                this.columnSpec = GridLayout.spec(n2, n3, GridLayout.getAlignment(n, true), f);
                n2 = attributeSet.getInt(ROW, Integer.MIN_VALUE);
                n4 = attributeSet.getInt(ROW_SPAN, n4);
                f = attributeSet.getFloat(ROW_WEIGHT, 0.0f);
                this.rowSpec = GridLayout.spec(n2, n4, GridLayout.getAlignment(n, false), f);
                return;
            }
            finally {
                attributeSet.recycle();
            }
        }

        private void reInitSuper(Context context, AttributeSet attributeSet) {
            context = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout_Layout);
            try {
                int n = context.getDimensionPixelSize(MARGIN, Integer.MIN_VALUE);
                this.leftMargin = context.getDimensionPixelSize(LEFT_MARGIN, n);
                this.topMargin = context.getDimensionPixelSize(TOP_MARGIN, n);
                this.rightMargin = context.getDimensionPixelSize(RIGHT_MARGIN, n);
                this.bottomMargin = context.getDimensionPixelSize(BOTTOM_MARGIN, n);
                return;
            }
            finally {
                context.recycle();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && ((Object)((Object)this)).getClass() == object.getClass()) {
                object = (LayoutParams)((Object)object);
                if (!this.columnSpec.equals(((LayoutParams)((Object)object)).columnSpec)) {
                    return false;
                }
                return this.rowSpec.equals(((LayoutParams)((Object)object)).rowSpec);
            }
            return false;
        }

        public int hashCode() {
            return this.rowSpec.hashCode() * 31 + this.columnSpec.hashCode();
        }

        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = typedArray.getLayoutDimension(n, -2);
            this.height = typedArray.getLayoutDimension(n2, -2);
        }

        final void setColumnSpecSpan(Interval interval) {
            this.columnSpec = this.columnSpec.copyWriteSpan(interval);
        }

        public void setGravity(int n) {
            this.rowSpec = this.rowSpec.copyWriteAlignment(GridLayout.getAlignment(n, false));
            this.columnSpec = this.columnSpec.copyWriteAlignment(GridLayout.getAlignment(n, true));
        }

        final void setRowSpecSpan(Interval interval) {
            this.rowSpec = this.rowSpec.copyWriteSpan(interval);
        }
    }

    static final class MutableInt {
        public int value;

        public MutableInt() {
            this.reset();
        }

        public MutableInt(int n) {
            this.value = n;
        }

        public void reset() {
            this.value = Integer.MIN_VALUE;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    static final class PackedMap<K, V> {
        public final int[] index;
        public final K[] keys;
        public final V[] values;

        PackedMap(K[] KArray, V[] VArray) {
            int[] nArray = PackedMap.createIndex(KArray);
            this.index = nArray;
            this.keys = PackedMap.compact(KArray, nArray);
            this.values = PackedMap.compact(VArray, nArray);
        }

        private static <K> K[] compact(K[] KArray, int[] nArray) {
            int n = KArray.length;
            Object[] objectArray = (Object[])Array.newInstance(KArray.getClass().getComponentType(), GridLayout.max2(nArray, -1) + 1);
            for (int i = 0; i < n; ++i) {
                objectArray[nArray[i]] = KArray[i];
            }
            return objectArray;
        }

        private static <K> int[] createIndex(K[] KArray) {
            int n = KArray.length;
            int[] nArray = new int[n];
            HashMap<K, Integer> hashMap = new HashMap<K, Integer>();
            for (int i = 0; i < n; ++i) {
                Integer n2;
                K k = KArray[i];
                Integer n3 = n2 = (Integer)hashMap.get(k);
                if (n2 == null) {
                    n3 = hashMap.size();
                    hashMap.put(k, n3);
                }
                nArray[i] = n3;
            }
            return nArray;
        }

        public V getValue(int n) {
            return this.values[this.index[n]];
        }
    }

    public static class Spec {
        static final float DEFAULT_WEIGHT = 0.0f;
        static final Spec UNDEFINED = GridLayout.spec(Integer.MIN_VALUE);
        final Alignment alignment;
        final Interval span;
        final boolean startDefined;
        final float weight;

        Spec(boolean bl, int n, int n2, Alignment alignment, float f) {
            this(bl, new Interval(n, n2 + n), alignment, f);
        }

        private Spec(boolean bl, Interval interval, Alignment alignment, float f) {
            this.startDefined = bl;
            this.span = interval;
            this.alignment = alignment;
            this.weight = f;
        }

        final Spec copyWriteAlignment(Alignment alignment) {
            return new Spec(this.startDefined, this.span, alignment, this.weight);
        }

        final Spec copyWriteSpan(Interval interval) {
            return new Spec(this.startDefined, interval, this.alignment, this.weight);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (Spec)object;
                if (!this.alignment.equals(((Spec)object).alignment)) {
                    return false;
                }
                return this.span.equals(((Spec)object).span);
            }
            return false;
        }

        public Alignment getAbsoluteAlignment(boolean bl) {
            if (this.alignment != UNDEFINED_ALIGNMENT) {
                return this.alignment;
            }
            if (this.weight == 0.0f) {
                Alignment alignment = bl ? START : BASELINE;
                return alignment;
            }
            return FILL;
        }

        final int getFlexibility() {
            int n = this.alignment == UNDEFINED_ALIGNMENT && this.weight == 0.0f ? 0 : 2;
            return n;
        }

        public int hashCode() {
            return this.span.hashCode() * 31 + this.alignment.hashCode();
        }
    }
}

