/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Arrays;

public class GridLayoutManager
extends LinearLayoutManager {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_SPAN_COUNT = -1;
    private static final String TAG = "GridLayoutManager";
    int[] mCachedBorders;
    final Rect mDecorInsets;
    boolean mPendingSpanCountChange = false;
    final SparseIntArray mPreLayoutSpanIndexCache;
    final SparseIntArray mPreLayoutSpanSizeCache = new SparseIntArray();
    View[] mSet;
    int mSpanCount = -1;
    SpanSizeLookup mSpanSizeLookup;
    private boolean mUsingSpansToEstimateScrollBarDimensions;

    public GridLayoutManager(Context context, int n) {
        super(context);
        this.mPreLayoutSpanIndexCache = new SparseIntArray();
        this.mSpanSizeLookup = new DefaultSpanSizeLookup();
        this.mDecorInsets = new Rect();
        this.setSpanCount(n);
    }

    public GridLayoutManager(Context context, int n, int n2, boolean bl) {
        super(context, n2, bl);
        this.mPreLayoutSpanIndexCache = new SparseIntArray();
        this.mSpanSizeLookup = new DefaultSpanSizeLookup();
        this.mDecorInsets = new Rect();
        this.setSpanCount(n);
    }

    public GridLayoutManager(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mPreLayoutSpanIndexCache = new SparseIntArray();
        this.mSpanSizeLookup = new DefaultSpanSizeLookup();
        this.mDecorInsets = new Rect();
        this.setSpanCount(GridLayoutManager.getProperties((Context)context, (AttributeSet)attributeSet, (int)n, (int)n2).spanCount);
    }

    private void assignSpans(RecyclerView.Recycler recycler, RecyclerView.State state, int n, boolean bl) {
        int n2;
        int n3 = 0;
        int n4 = -1;
        if (bl) {
            int n5 = 0;
            n2 = 1;
            n4 = n;
            n = n5;
        } else {
            --n;
            n2 = -1;
        }
        while (n != n4) {
            View view = this.mSet[n];
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.mSpanSize = this.getSpanSize(recycler, state, this.getPosition(view));
            layoutParams.mSpanIndex = n3;
            n3 += layoutParams.mSpanSize;
            n += n2;
        }
    }

    private void cachePreLayoutSpanMapping() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
            int n2 = layoutParams.getViewLayoutPosition();
            this.mPreLayoutSpanSizeCache.put(n2, layoutParams.getSpanSize());
            this.mPreLayoutSpanIndexCache.put(n2, layoutParams.getSpanIndex());
        }
    }

    private void calculateItemBorders(int n) {
        this.mCachedBorders = GridLayoutManager.calculateItemBorders(this.mCachedBorders, this.mSpanCount, n);
    }

    static int[] calculateItemBorders(int[] nArray, int n, int n2) {
        int[] nArray2;
        int n3;
        block7: {
            block6: {
                n3 = 1;
                if (nArray == null || nArray.length != n + 1) break block6;
                nArray2 = nArray;
                if (nArray[nArray.length - 1] == n2) break block7;
            }
            nArray2 = new int[n + 1];
        }
        int n4 = 0;
        nArray2[0] = 0;
        int n5 = n2 / n;
        int n6 = n2 % n;
        int n7 = 0;
        n2 = n4;
        while (n3 <= n) {
            if ((n2 += n6) > 0 && n - n2 < n6) {
                n4 = n5 + 1;
                n2 -= n;
            } else {
                n4 = n5;
            }
            nArray2[n3] = n7 += n4;
            ++n3;
        }
        return nArray2;
    }

    private void clearPreLayoutSpanMappingCache() {
        this.mPreLayoutSpanSizeCache.clear();
        this.mPreLayoutSpanIndexCache.clear();
    }

    private int computeScrollOffsetWithSpanInfo(RecyclerView.State state) {
        if (this.getChildCount() != 0 && state.getItemCount() != 0) {
            this.ensureLayoutState();
            boolean bl = this.isSmoothScrollbarEnabled();
            View view = this.findFirstVisibleChildClosestToStart(bl ^ true, true);
            View view2 = this.findFirstVisibleChildClosestToEnd(bl ^ true, true);
            if (view != null && view2 != null) {
                int n = this.mSpanSizeLookup.getCachedSpanGroupIndex(this.getPosition(view), this.mSpanCount);
                int n2 = this.mSpanSizeLookup.getCachedSpanGroupIndex(this.getPosition(view2), this.mSpanCount);
                int n3 = Math.min(n, n2);
                n = Math.max(n, n2);
                n2 = this.mSpanSizeLookup.getCachedSpanGroupIndex(state.getItemCount() - 1, this.mSpanCount);
                n3 = this.mShouldReverseLayout ? Math.max(0, n2 + 1 - n - 1) : Math.max(0, n3);
                if (!bl) {
                    return n3;
                }
                n = Math.abs(this.mOrientationHelper.getDecoratedEnd(view2) - this.mOrientationHelper.getDecoratedStart(view));
                n2 = this.mSpanSizeLookup.getCachedSpanGroupIndex(this.getPosition(view), this.mSpanCount);
                int n4 = this.mSpanSizeLookup.getCachedSpanGroupIndex(this.getPosition(view2), this.mSpanCount);
                float f = (float)n / (float)(n4 - n2 + 1);
                return Math.round((float)n3 * f + (float)(this.mOrientationHelper.getStartAfterPadding() - this.mOrientationHelper.getDecoratedStart(view)));
            }
        }
        return 0;
    }

    private int computeScrollRangeWithSpanInfo(RecyclerView.State state) {
        if (this.getChildCount() != 0 && state.getItemCount() != 0) {
            this.ensureLayoutState();
            View view = this.findFirstVisibleChildClosestToStart(this.isSmoothScrollbarEnabled() ^ true, true);
            View view2 = this.findFirstVisibleChildClosestToEnd(this.isSmoothScrollbarEnabled() ^ true, true);
            if (view != null && view2 != null) {
                if (!this.isSmoothScrollbarEnabled()) {
                    return this.mSpanSizeLookup.getCachedSpanGroupIndex(state.getItemCount() - 1, this.mSpanCount) + 1;
                }
                int n = this.mOrientationHelper.getDecoratedEnd(view2);
                int n2 = this.mOrientationHelper.getDecoratedStart(view);
                int n3 = this.mSpanSizeLookup.getCachedSpanGroupIndex(this.getPosition(view), this.mSpanCount);
                int n4 = this.mSpanSizeLookup.getCachedSpanGroupIndex(this.getPosition(view2), this.mSpanCount);
                int n5 = this.mSpanSizeLookup.getCachedSpanGroupIndex(state.getItemCount() - 1, this.mSpanCount);
                return (int)((float)(n - n2) / (float)(n4 - n3 + 1) * (float)(n5 + 1));
            }
        }
        return 0;
    }

    private void ensureAnchorIsInCorrectSpan(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.AnchorInfo anchorInfo, int n) {
        n = n == 1 ? 1 : 0;
        int n2 = this.getSpanIndex(recycler, state, anchorInfo.mPosition);
        if (n != 0) {
            while (n2 > 0 && anchorInfo.mPosition > 0) {
                --anchorInfo.mPosition;
                n2 = this.getSpanIndex(recycler, state, anchorInfo.mPosition);
            }
        } else {
            int n3;
            int n4;
            int n5 = state.getItemCount();
            n = anchorInfo.mPosition;
            while (n < n5 - 1 && (n4 = this.getSpanIndex(recycler, state, n3 = n + 1)) > n2) {
                n = n3;
                n2 = n4;
            }
            anchorInfo.mPosition = n;
        }
    }

    private void ensureViewSet() {
        View[] viewArray = this.mSet;
        if (viewArray == null || viewArray.length != this.mSpanCount) {
            this.mSet = new View[this.mSpanCount];
        }
    }

    private int getSpanGroupIndex(RecyclerView.Recycler object, RecyclerView.State state, int n) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanGroupIndex(n, this.mSpanCount);
        }
        int n2 = ((RecyclerView.Recycler)object).convertPreLayoutPositionToPostLayout(n);
        if (n2 == -1) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot find span size for pre layout position. ");
            ((StringBuilder)object).append(n);
            Log.w((String)TAG, (String)((StringBuilder)object).toString());
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanGroupIndex(n2, this.mSpanCount);
    }

    private int getSpanIndex(RecyclerView.Recycler object, RecyclerView.State state, int n) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanIndex(n, this.mSpanCount);
        }
        int n2 = this.mPreLayoutSpanIndexCache.get(n, -1);
        if (n2 != -1) {
            return n2;
        }
        n2 = ((RecyclerView.Recycler)object).convertPreLayoutPositionToPostLayout(n);
        if (n2 == -1) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:");
            ((StringBuilder)object).append(n);
            Log.w((String)TAG, (String)((StringBuilder)object).toString());
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanIndex(n2, this.mSpanCount);
    }

    private int getSpanSize(RecyclerView.Recycler object, RecyclerView.State state, int n) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanSize(n);
        }
        int n2 = this.mPreLayoutSpanSizeCache.get(n, -1);
        if (n2 != -1) {
            return n2;
        }
        n2 = ((RecyclerView.Recycler)object).convertPreLayoutPositionToPostLayout(n);
        if (n2 == -1) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:");
            ((StringBuilder)object).append(n);
            Log.w((String)TAG, (String)((StringBuilder)object).toString());
            return 1;
        }
        return this.mSpanSizeLookup.getSpanSize(n2);
    }

    private void guessMeasurement(float f, int n) {
        this.calculateItemBorders(Math.max(Math.round(f * (float)this.mSpanCount), n));
    }

    private void measureChild(View view, int n, boolean bl) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        Rect rect = layoutParams.mDecorInsets;
        int n2 = rect.top + rect.bottom + layoutParams.topMargin + layoutParams.bottomMargin;
        int n3 = rect.left + rect.right + layoutParams.leftMargin + layoutParams.rightMargin;
        int n4 = this.getSpaceForSpanRange(layoutParams.mSpanIndex, layoutParams.mSpanSize);
        if (this.mOrientation == 1) {
            n3 = GridLayoutManager.getChildMeasureSpec(n4, n, n3, layoutParams.width, false);
            n = GridLayoutManager.getChildMeasureSpec(this.mOrientationHelper.getTotalSpace(), this.getHeightMode(), n2, layoutParams.height, true);
        } else {
            n = GridLayoutManager.getChildMeasureSpec(n4, n, n2, layoutParams.height, false);
            n3 = GridLayoutManager.getChildMeasureSpec(this.mOrientationHelper.getTotalSpace(), this.getWidthMode(), n3, layoutParams.width, true);
        }
        this.measureChildWithDecorationsAndMargin(view, n3, n, bl);
    }

    private void measureChildWithDecorationsAndMargin(View view, int n, int n2, boolean bl) {
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (bl = bl ? this.shouldReMeasureChild(view, n, n2, layoutParams) : this.shouldMeasureChild(view, n, n2, layoutParams)) {
            view.measure(n, n2);
        }
    }

    private void updateMeasurements() {
        int n;
        int n2;
        if (this.getOrientation() == 1) {
            n2 = this.getWidth() - this.getPaddingRight();
            n = this.getPaddingLeft();
        } else {
            n2 = this.getHeight() - this.getPaddingBottom();
            n = this.getPaddingTop();
        }
        this.calculateItemBorders(n2 - n);
    }

    @Override
    public boolean checkLayoutParams(RecyclerView.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    @Override
    void collectPrefetchPositionsForLayoutState(RecyclerView.State state, LinearLayoutManager.LayoutState layoutState, RecyclerView.LayoutManager.LayoutPrefetchRegistry layoutPrefetchRegistry) {
        int n = this.mSpanCount;
        for (int i = 0; i < this.mSpanCount && layoutState.hasMore(state) && n > 0; ++i) {
            int n2 = layoutState.mCurrentPosition;
            layoutPrefetchRegistry.addPosition(n2, Math.max(0, layoutState.mScrollingOffset));
            n -= this.mSpanSizeLookup.getSpanSize(n2);
            layoutState.mCurrentPosition += layoutState.mItemDirection;
        }
    }

    @Override
    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        if (this.mUsingSpansToEstimateScrollBarDimensions) {
            return this.computeScrollOffsetWithSpanInfo(state);
        }
        return super.computeHorizontalScrollOffset(state);
    }

    @Override
    public int computeHorizontalScrollRange(RecyclerView.State state) {
        if (this.mUsingSpansToEstimateScrollBarDimensions) {
            return this.computeScrollRangeWithSpanInfo(state);
        }
        return super.computeHorizontalScrollRange(state);
    }

    @Override
    public int computeVerticalScrollOffset(RecyclerView.State state) {
        if (this.mUsingSpansToEstimateScrollBarDimensions) {
            return this.computeScrollOffsetWithSpanInfo(state);
        }
        return super.computeVerticalScrollOffset(state);
    }

    @Override
    public int computeVerticalScrollRange(RecyclerView.State state) {
        if (this.mUsingSpansToEstimateScrollBarDimensions) {
            return this.computeScrollRangeWithSpanInfo(state);
        }
        return super.computeVerticalScrollRange(state);
    }

    @Override
    View findReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state, int n, int n2, int n3) {
        this.ensureLayoutState();
        int n4 = this.mOrientationHelper.getStartAfterPadding();
        int n5 = this.mOrientationHelper.getEndAfterPadding();
        int n6 = n2 > n ? 1 : -1;
        View view = null;
        View view2 = null;
        while (n != n2) {
            View view3 = this.getChildAt(n);
            int n7 = this.getPosition(view3);
            View view4 = view;
            View view5 = view2;
            if (n7 >= 0) {
                view4 = view;
                view5 = view2;
                if (n7 < n3) {
                    if (this.getSpanIndex(recycler, state, n7) != 0) {
                        view4 = view;
                        view5 = view2;
                    } else if (((RecyclerView.LayoutParams)view3.getLayoutParams()).isItemRemoved()) {
                        view4 = view;
                        view5 = view2;
                        if (view2 == null) {
                            view5 = view3;
                            view4 = view;
                        }
                    } else {
                        if (this.mOrientationHelper.getDecoratedStart(view3) < n5 && this.mOrientationHelper.getDecoratedEnd(view3) >= n4) {
                            return view3;
                        }
                        view4 = view;
                        view5 = view2;
                        if (view == null) {
                            view4 = view3;
                            view5 = view2;
                        }
                    }
                }
            }
            n += n6;
            view = view4;
            view2 = view5;
        }
        if (view == null) {
            view = view2;
        }
        return view;
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -1);
        }
        return new LayoutParams(-1, -2);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(Context context, AttributeSet attributeSet) {
        return new LayoutParams(context, attributeSet);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    @Override
    public int getColumnCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1) + 1;
    }

    @Override
    public int getRowCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1) + 1;
    }

    int getSpaceForSpanRange(int n, int n2) {
        if (this.mOrientation == 1 && this.isLayoutRTL()) {
            int[] nArray = this.mCachedBorders;
            int n3 = this.mSpanCount;
            return nArray[n3 - n] - nArray[n3 - n - n2];
        }
        int[] nArray = this.mCachedBorders;
        return nArray[n2 + n] - nArray[n];
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    public SpanSizeLookup getSpanSizeLookup() {
        return this.mSpanSizeLookup;
    }

    public boolean isUsingSpansToEstimateScrollbarDimensions() {
        return this.mUsingSpansToEstimateScrollBarDimensions;
    }

    @Override
    void layoutChunk(RecyclerView.Recycler object, RecyclerView.State object2, LinearLayoutManager.LayoutState layoutState, LinearLayoutManager.LayoutChunkResult layoutChunkResult) {
        int n;
        View view;
        int n2;
        int n3;
        int n4;
        int n5 = this.mOrientationHelper.getModeInOther();
        int n6 = n5 != 0x40000000 ? 1 : 0;
        int n7 = this.getChildCount() > 0 ? this.mCachedBorders[this.mSpanCount] : 0;
        if (n6 != 0) {
            this.updateMeasurements();
        }
        boolean bl = layoutState.mItemDirection == 1;
        int n8 = this.mSpanCount;
        if (!bl) {
            n8 = this.getSpanIndex((RecyclerView.Recycler)object, (RecyclerView.State)object2, layoutState.mCurrentPosition) + this.getSpanSize((RecyclerView.Recycler)object, (RecyclerView.State)object2, layoutState.mCurrentPosition);
        }
        for (n4 = 0; n4 < this.mSpanCount && layoutState.hasMore((RecyclerView.State)object2) && n8 > 0; ++n4) {
            n3 = layoutState.mCurrentPosition;
            n2 = this.getSpanSize((RecyclerView.Recycler)object, (RecyclerView.State)object2, n3);
            if (n2 <= this.mSpanCount) {
                if ((n8 -= n2) < 0 || (view = layoutState.next((RecyclerView.Recycler)object)) == null) break;
                this.mSet[n4] = view;
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Item at position ");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append(" requires ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(" spans but GridLayoutManager has only ");
            ((StringBuilder)object).append(this.mSpanCount);
            ((StringBuilder)object).append(" spans.");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (n4 == 0) {
            layoutChunkResult.mFinished = true;
            return;
        }
        float f = 0.0f;
        this.assignSpans((RecyclerView.Recycler)object, (RecyclerView.State)object2, n4, bl);
        n8 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            object = this.mSet[n2];
            if (layoutState.mScrapList == null) {
                if (bl) {
                    this.addView((View)object);
                } else {
                    this.addView((View)object, 0);
                }
            } else if (bl) {
                this.addDisappearingView((View)object);
            } else {
                this.addDisappearingView((View)object, 0);
            }
            this.calculateItemDecorationsForChild((View)object, this.mDecorInsets);
            this.measureChild((View)object, n5, false);
            n = this.mOrientationHelper.getDecoratedMeasurement((View)object);
            n3 = n8;
            if (n > n8) {
                n3 = n;
            }
            object2 = (LayoutParams)object.getLayoutParams();
            float f2 = (float)this.mOrientationHelper.getDecoratedMeasurementInOther((View)object) * 1.0f / (float)((LayoutParams)((Object)object2)).mSpanSize;
            float f3 = f;
            if (f2 > f) {
                f3 = f2;
            }
            n8 = n3;
            f = f3;
        }
        n2 = n8;
        if (n6 != 0) {
            this.guessMeasurement(f, n7);
            n6 = 0;
            n8 = 0;
            while (true) {
                n2 = n8;
                if (n6 >= n4) break;
                object = this.mSet[n6];
                this.measureChild((View)object, 0x40000000, true);
                n7 = this.mOrientationHelper.getDecoratedMeasurement((View)object);
                n2 = n8;
                if (n7 > n8) {
                    n2 = n7;
                }
                ++n6;
                n8 = n2;
            }
        }
        for (n8 = 0; n8 < n4; ++n8) {
            object2 = this.mSet[n8];
            if (this.mOrientationHelper.getDecoratedMeasurement((View)object2) == n2) continue;
            object = (LayoutParams)object2.getLayoutParams();
            view = ((LayoutParams)((Object)object)).mDecorInsets;
            n7 = view.top + view.bottom + ((LayoutParams)((Object)object)).topMargin + ((LayoutParams)((Object)object)).bottomMargin;
            n6 = view.left + view.right + ((LayoutParams)((Object)object)).leftMargin + ((LayoutParams)((Object)object)).rightMargin;
            n3 = this.getSpaceForSpanRange(((LayoutParams)((Object)object)).mSpanIndex, ((LayoutParams)((Object)object)).mSpanSize);
            if (this.mOrientation == 1) {
                n6 = GridLayoutManager.getChildMeasureSpec(n3, 0x40000000, n6, ((LayoutParams)((Object)object)).width, false);
                n7 = View.MeasureSpec.makeMeasureSpec((int)(n2 - n7), (int)0x40000000);
            } else {
                n6 = View.MeasureSpec.makeMeasureSpec((int)(n2 - n6), (int)0x40000000);
                n7 = GridLayoutManager.getChildMeasureSpec(n3, 0x40000000, n7, ((LayoutParams)((Object)object)).height, false);
            }
            this.measureChildWithDecorationsAndMargin((View)object2, n6, n7, true);
        }
        n = 0;
        layoutChunkResult.mConsumed = n2;
        if (this.mOrientation == 1) {
            if (layoutState.mLayoutDirection == -1) {
                n8 = layoutState.mOffset;
                n2 = n8 - n2;
            } else {
                n8 = n6 = layoutState.mOffset;
                n6 = n2 + n6;
                n2 = n8;
                n8 = n6;
            }
            n7 = 0;
            n6 = 0;
        } else if (layoutState.mLayoutDirection == -1) {
            n7 = layoutState.mOffset;
            n6 = n7 - n2;
            n2 = 0;
            n8 = 0;
        } else {
            n6 = layoutState.mOffset;
            n7 = n2 + n6;
            n8 = 0;
            n2 = 0;
        }
        while (n < n4) {
            block31: {
                block30: {
                    block28: {
                        block29: {
                            object = this.mSet[n];
                            object2 = (LayoutParams)object.getLayoutParams();
                            if (this.mOrientation != 1) break block28;
                            if (!this.isLayoutRTL()) break block29;
                            n7 = this.getPaddingLeft() + this.mCachedBorders[this.mSpanCount - ((LayoutParams)((Object)object2)).mSpanIndex];
                            n6 = n7 - this.mOrientationHelper.getDecoratedMeasurementInOther((View)object);
                            n3 = n2;
                            n2 = n8;
                            break block30;
                        }
                        n3 = this.getPaddingLeft() + this.mCachedBorders[((LayoutParams)((Object)object2)).mSpanIndex];
                        n5 = this.mOrientationHelper.getDecoratedMeasurementInOther((View)object);
                        n7 = n8;
                        n8 = n3;
                        n6 = n2;
                        n3 = n5 + n3;
                        n2 = n7;
                        n7 = n3;
                        break block31;
                    }
                    n8 = this.getPaddingTop() + this.mCachedBorders[((LayoutParams)((Object)object2)).mSpanIndex];
                    n2 = this.mOrientationHelper.getDecoratedMeasurementInOther((View)object);
                    n3 = n8;
                    n2 += n8;
                }
                n8 = n6;
                n6 = n3;
            }
            this.layoutDecoratedWithMargins((View)object, n8, n6, n7, n2);
            if (((RecyclerView.LayoutParams)((Object)object2)).isItemRemoved() || ((RecyclerView.LayoutParams)((Object)object2)).isItemChanged()) {
                layoutChunkResult.mIgnoreConsumed = true;
            }
            layoutChunkResult.mFocusable |= object.hasFocusable();
            ++n;
            n3 = n8;
            n8 = n2;
            n2 = n6;
            n6 = n3;
        }
        Arrays.fill(this.mSet, null);
    }

    @Override
    void onAnchorReady(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.AnchorInfo anchorInfo, int n) {
        super.onAnchorReady(recycler, state, anchorInfo, n);
        this.updateMeasurements();
        if (state.getItemCount() > 0 && !state.isPreLayout()) {
            this.ensureAnchorIsInCorrectSpan(recycler, state, anchorInfo, n);
        }
        this.ensureViewSet();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public View onFocusSearchFailed(View var1_1, int var2_2, RecyclerView.Recycler var3_3, RecyclerView.State var4_4) {
        var5_5 = this.findContainingItemView(var1_1 /* !! */ );
        var6_6 /* !! */  = null;
        if (var5_5 == null) {
            return null;
        }
        var7_7 = (LayoutParams)var5_5.getLayoutParams();
        var8_8 = var7_7.mSpanIndex;
        var9_9 = var7_7.mSpanIndex + var7_7.mSpanSize;
        if (super.onFocusSearchFailed(var1_1 /* !! */ , var2_2, var3_3, var4_4) == null) {
            return null;
        }
        var10_10 = this.convertFocusDirectionToLayoutDirection(var2_2) == 1;
        if ((var2_2 = var10_10 != this.mShouldReverseLayout ? 1 : 0) != 0) {
            var2_2 = this.getChildCount() - 1;
            var11_11 = -1;
            var12_12 = -1;
        } else {
            var11_11 = this.getChildCount();
            var2_2 = 0;
            var12_12 = 1;
        }
        var13_13 = this.mOrientation == 1 && this.isLayoutRTL() != false ? 1 : 0;
        var14_14 = this.getSpanGroupIndex(var3_3, var4_4, var2_2);
        var15_15 = var2_2;
        var16_16 = 0;
        var17_17 = -1;
        var18_18 = -1;
        var2_2 = 0;
        var1_1 /* !! */  = null;
        var19_19 = var11_11;
        var11_11 = var16_16;
        while (var15_15 != var19_19) {
            block19: {
                block17: {
                    block20: {
                        block18: {
                            var16_16 = this.getSpanGroupIndex(var3_3, var4_4, var15_15);
                            var7_7 = this.getChildAt(var15_15);
                            if (var7_7 == var5_5) break;
                            if (!var7_7.hasFocusable() || var16_16 == var14_14) break block18;
                            if (var6_6 /* !! */  != null) {
                                break;
                            }
                            break block19;
                        }
                        var20_20 = (LayoutParams)var7_7.getLayoutParams();
                        var21_21 = var20_20.mSpanIndex;
                        var22_22 = var20_20.mSpanIndex + var20_20.mSpanSize;
                        if (var7_7.hasFocusable() && var21_21 == var8_8 && var22_22 == var9_9) {
                            return var7_7;
                        }
                        if (var7_7.hasFocusable() && var6_6 /* !! */  == null || !var7_7.hasFocusable() && var1_1 /* !! */  == null) lbl-1000:
                        // 3 sources

                        {
                            while (true) {
                                var16_16 = 1;
                                break block17;
                                break;
                            }
                        }
                        var16_16 = Math.max(var21_21, var8_8);
                        var23_23 = Math.min(var22_22, var9_9) - var16_16;
                        if (!var7_7.hasFocusable()) break block20;
                        if (var23_23 <= var11_11 && (var23_23 != var11_11 || var13_13 != (var16_16 = var21_21 > var17_17 ? 1 : 0))) ** GOTO lbl66
                        ** GOTO lbl-1000
                    }
                    if (var6_6 /* !! */  != null) ** GOTO lbl66
                    var24_24 = 1;
                    var16_16 = 1;
                    if (!this.isViewPartiallyVisible((View)var7_7, false, true)) ** GOTO lbl66
                    var25_25 = var2_2;
                    if (var23_23 > var25_25) {
                        var16_16 = var24_24;
                    } else {
                        if (var23_23 == var25_25) {
                            if (var21_21 <= var18_18) {
                                var16_16 = 0;
                            }
                            if (var13_13 != var16_16) ** break;
                            ** continue;
                        }
lbl66:
                        // 6 sources

                        var16_16 = 0;
                    }
                }
                if (var16_16 != 0) {
                    if (var7_7.hasFocusable()) {
                        var17_17 = var20_20.mSpanIndex;
                        var11_11 = Math.min(var22_22, var9_9) - Math.max(var21_21, var8_8);
                        var6_6 /* !! */  = var7_7;
                    } else {
                        var18_18 = var20_20.mSpanIndex;
                        var2_2 = Math.min(var22_22, var9_9) - Math.max(var21_21, var8_8);
                        var1_1 /* !! */  = var7_7;
                    }
                }
            }
            var15_15 += var12_12;
        }
        if (var6_6 /* !! */  == null) {
            var6_6 /* !! */  = var1_1 /* !! */ ;
        }
        return var6_6 /* !! */ ;
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.Recycler recycler, RecyclerView.State state, View object, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        ViewGroup.LayoutParams layoutParams = object.getLayoutParams();
        if (!(layoutParams instanceof LayoutParams)) {
            super.onInitializeAccessibilityNodeInfoForItem((View)object, accessibilityNodeInfoCompat);
            return;
        }
        object = (LayoutParams)layoutParams;
        int n = this.getSpanGroupIndex(recycler, state, ((RecyclerView.LayoutParams)((Object)object)).getViewLayoutPosition());
        if (this.mOrientation == 0) {
            accessibilityNodeInfoCompat.setCollectionItemInfo(AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain(((LayoutParams)((Object)object)).getSpanIndex(), ((LayoutParams)((Object)object)).getSpanSize(), n, 1, false, false));
        } else {
            accessibilityNodeInfoCompat.setCollectionItemInfo(AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain(n, 1, ((LayoutParams)((Object)object)).getSpanIndex(), ((LayoutParams)((Object)object)).getSpanSize(), false, false));
        }
    }

    @Override
    public void onItemsAdded(RecyclerView recyclerView, int n, int n2) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.mSpanSizeLookup.invalidateSpanGroupIndexCache();
    }

    @Override
    public void onItemsChanged(RecyclerView recyclerView) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.mSpanSizeLookup.invalidateSpanGroupIndexCache();
    }

    @Override
    public void onItemsMoved(RecyclerView recyclerView, int n, int n2, int n3) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.mSpanSizeLookup.invalidateSpanGroupIndexCache();
    }

    @Override
    public void onItemsRemoved(RecyclerView recyclerView, int n, int n2) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.mSpanSizeLookup.invalidateSpanGroupIndexCache();
    }

    @Override
    public void onItemsUpdated(RecyclerView recyclerView, int n, int n2, Object object) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.mSpanSizeLookup.invalidateSpanGroupIndexCache();
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.isPreLayout()) {
            this.cachePreLayoutSpanMapping();
        }
        super.onLayoutChildren(recycler, state);
        this.clearPreLayoutSpanMappingCache();
    }

    @Override
    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSpanCountChange = false;
    }

    @Override
    public int scrollHorizontallyBy(int n, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.updateMeasurements();
        this.ensureViewSet();
        return super.scrollHorizontallyBy(n, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int n, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.updateMeasurements();
        this.ensureViewSet();
        return super.scrollVerticallyBy(n, recycler, state);
    }

    @Override
    public void setMeasuredDimension(Rect object, int n, int n2) {
        if (this.mCachedBorders == null) {
            super.setMeasuredDimension((Rect)object, n, n2);
        }
        int n3 = this.getPaddingLeft() + this.getPaddingRight();
        int n4 = this.getPaddingTop() + this.getPaddingBottom();
        if (this.mOrientation == 1) {
            n2 = GridLayoutManager.chooseSize(n2, object.height() + n4, this.getMinimumHeight());
            object = this.mCachedBorders;
            n4 = GridLayoutManager.chooseSize(n, (int)(object[((Rect)object).length - 1] + n3), this.getMinimumWidth());
            n = n2;
            n2 = n4;
        } else {
            n = GridLayoutManager.chooseSize(n, object.width() + n3, this.getMinimumWidth());
            object = this.mCachedBorders;
            n4 = GridLayoutManager.chooseSize(n2, (int)(object[((Rect)object).length - 1] + n4), this.getMinimumHeight());
            n2 = n;
            n = n4;
        }
        this.setMeasuredDimension(n2, n);
    }

    public void setSpanCount(int n) {
        if (n == this.mSpanCount) {
            return;
        }
        this.mPendingSpanCountChange = true;
        if (n >= 1) {
            this.mSpanCount = n;
            this.mSpanSizeLookup.invalidateSpanIndexCache();
            this.requestLayout();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Span count should be at least 1. Provided ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    @Override
    public void setStackFromEnd(boolean bl) {
        if (!bl) {
            super.setStackFromEnd(false);
            return;
        }
        throw new UnsupportedOperationException("GridLayoutManager does not support stack from end. Consider using reverse layout");
    }

    public void setUsingSpansToEstimateScrollbarDimensions(boolean bl) {
        this.mUsingSpansToEstimateScrollBarDimensions = bl;
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        boolean bl = this.mPendingSavedState == null && !this.mPendingSpanCountChange;
        return bl;
    }

    public static final class DefaultSpanSizeLookup
    extends SpanSizeLookup {
        @Override
        public int getSpanIndex(int n, int n2) {
            return n % n2;
        }

        @Override
        public int getSpanSize(int n) {
            return 1;
        }
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public static final int INVALID_SPAN_ID = -1;
        int mSpanIndex = -1;
        int mSpanSize = 0;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(RecyclerView.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public int getSpanIndex() {
            return this.mSpanIndex;
        }

        public int getSpanSize() {
            return this.mSpanSize;
        }
    }

    public static abstract class SpanSizeLookup {
        private boolean mCacheSpanGroupIndices = false;
        private boolean mCacheSpanIndices = false;
        final SparseIntArray mSpanGroupIndexCache;
        final SparseIntArray mSpanIndexCache = new SparseIntArray();

        public SpanSizeLookup() {
            this.mSpanGroupIndexCache = new SparseIntArray();
        }

        static int findFirstKeyLessThan(SparseIntArray sparseIntArray, int n) {
            int n2 = sparseIntArray.size() - 1;
            int n3 = 0;
            while (n3 <= n2) {
                int n4 = n3 + n2 >>> 1;
                if (sparseIntArray.keyAt(n4) < n) {
                    n3 = n4 + 1;
                    continue;
                }
                n2 = n4 - 1;
            }
            n = n3 - 1;
            if (n >= 0 && n < sparseIntArray.size()) {
                return sparseIntArray.keyAt(n);
            }
            return -1;
        }

        int getCachedSpanGroupIndex(int n, int n2) {
            if (!this.mCacheSpanGroupIndices) {
                return this.getSpanGroupIndex(n, n2);
            }
            int n3 = this.mSpanGroupIndexCache.get(n, -1);
            if (n3 != -1) {
                return n3;
            }
            n2 = this.getSpanGroupIndex(n, n2);
            this.mSpanGroupIndexCache.put(n, n2);
            return n2;
        }

        int getCachedSpanIndex(int n, int n2) {
            if (!this.mCacheSpanIndices) {
                return this.getSpanIndex(n, n2);
            }
            int n3 = this.mSpanIndexCache.get(n, -1);
            if (n3 != -1) {
                return n3;
            }
            n2 = this.getSpanIndex(n, n2);
            this.mSpanIndexCache.put(n, n2);
            return n2;
        }

        public int getSpanGroupIndex(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block6: {
                block7: {
                    block5: {
                        if (!this.mCacheSpanGroupIndices || (n8 = SpanSizeLookup.findFirstKeyLessThan(this.mSpanGroupIndexCache, n)) == -1) break block5;
                        n7 = this.mSpanGroupIndexCache.get(n8);
                        n6 = n8 + 1;
                        n5 = this.getCachedSpanIndex(n8, n2) + this.getSpanSize(n8);
                        n4 = n7;
                        n8 = n6;
                        n3 = n5;
                        if (n5 != n2) break block6;
                        n4 = n7 + 1;
                        n8 = n6;
                        break block7;
                    }
                    n4 = 0;
                    n8 = 0;
                }
                n3 = 0;
            }
            int n9 = this.getSpanSize(n);
            n7 = n3;
            n3 = n4;
            for (n6 = n8; n6 < n; ++n6) {
                n5 = this.getSpanSize(n6);
                if ((n7 += n5) == n2) {
                    n4 = n3 + 1;
                    n8 = 0;
                } else {
                    n4 = n3;
                    n8 = n7;
                    if (n7 > n2) {
                        n4 = n3 + 1;
                        n8 = n5;
                    }
                }
                n3 = n4;
                n7 = n8;
            }
            n = n3;
            if (n7 + n9 > n2) {
                n = n3 + 1;
            }
            return n;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        public int getSpanIndex(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6 = this.getSpanSize(n);
            if (n6 == n2) {
                return 0;
            }
            if (this.mCacheSpanIndices && (n5 = SpanSizeLookup.findFirstKeyLessThan(this.mSpanIndexCache, n)) >= 0) {
                n4 = this.mSpanIndexCache.get(n5) + this.getSpanSize(n5);
                n3 = n5 + 1;
            } else {
                n3 = 0;
                n4 = 0;
            }
            while (n3 < n) {
                int n7 = this.getSpanSize(n3);
                int n8 = n4 + n7;
                if (n8 == n2) {
                    n4 = 0;
                    n5 = n3;
                } else {
                    n5 = n3;
                    n4 = n8;
                    if (n8 > n2) {
                        n4 = n7;
                        n5 = n3;
                    }
                }
                n3 = n5 + 1;
            }
            if (n6 + n4 <= n2) {
                return n4;
            }
            return 0;
        }

        public abstract int getSpanSize(int var1);

        public void invalidateSpanGroupIndexCache() {
            this.mSpanGroupIndexCache.clear();
        }

        public void invalidateSpanIndexCache() {
            this.mSpanIndexCache.clear();
        }

        public boolean isSpanGroupIndexCacheEnabled() {
            return this.mCacheSpanGroupIndices;
        }

        public boolean isSpanIndexCacheEnabled() {
            return this.mCacheSpanIndices;
        }

        public void setSpanGroupIndexCacheEnabled(boolean bl) {
            if (!bl) {
                this.mSpanGroupIndexCache.clear();
            }
            this.mCacheSpanGroupIndices = bl;
        }

        public void setSpanIndexCacheEnabled(boolean bl) {
            if (!bl) {
                this.mSpanGroupIndexCache.clear();
            }
            this.mCacheSpanIndices = bl;
        }
    }
}

