/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.graphics.PointF;
import android.view.View;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;

public class LinearSnapHelper
extends SnapHelper {
    private static final float INVALID_DISTANCE = 1.0f;
    private OrientationHelper mHorizontalHelper;
    private OrientationHelper mVerticalHelper;

    private float computeDistancePerChild(RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper) {
        int n;
        int n2 = layoutManager.getChildCount();
        if (n2 == 0) {
            return 1.0f;
        }
        View view = null;
        View view2 = null;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            int n5;
            View view3;
            View view4 = layoutManager.getChildAt(i);
            int n6 = layoutManager.getPosition(view4);
            if (n6 == -1) {
                view3 = view;
                n5 = n4;
            } else {
                n = n3;
                if (n6 < n3) {
                    view = view4;
                    n = n6;
                }
                view3 = view;
                n3 = n;
                n5 = n4;
                if (n6 > n4) {
                    view2 = view4;
                    n5 = n6;
                    n3 = n;
                    view3 = view;
                }
            }
            view = view3;
            n4 = n5;
        }
        if (view != null && view2 != null) {
            n = Math.min(orientationHelper.getDecoratedStart(view), orientationHelper.getDecoratedStart(view2));
            n = Math.max(orientationHelper.getDecoratedEnd(view), orientationHelper.getDecoratedEnd(view2)) - n;
            if (n == 0) {
                return 1.0f;
            }
            return (float)n * 1.0f / (float)(n4 - n3 + 1);
        }
        return 1.0f;
    }

    private int distanceToCenter(RecyclerView.LayoutManager layoutManager, View view, OrientationHelper orientationHelper) {
        return orientationHelper.getDecoratedStart(view) + orientationHelper.getDecoratedMeasurement(view) / 2 - (orientationHelper.getStartAfterPadding() + orientationHelper.getTotalSpace() / 2);
    }

    private int estimateNextPositionDiffForFling(RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper, int n, int n2) {
        int[] nArray = this.calculateScrollDistance(n, n2);
        float f = this.computeDistancePerChild(layoutManager, orientationHelper);
        if (f <= 0.0f) {
            return 0;
        }
        n = Math.abs(nArray[0]) > Math.abs(nArray[1]) ? nArray[0] : nArray[1];
        return Math.round((float)n / f);
    }

    private View findCenterView(RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper) {
        int n = layoutManager.getChildCount();
        View view = null;
        if (n == 0) {
            return null;
        }
        int n2 = orientationHelper.getStartAfterPadding();
        int n3 = orientationHelper.getTotalSpace() / 2;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            View view2 = layoutManager.getChildAt(i);
            int n5 = Math.abs(orientationHelper.getDecoratedStart(view2) + orientationHelper.getDecoratedMeasurement(view2) / 2 - (n2 + n3));
            int n6 = n4;
            if (n5 < n4) {
                view = view2;
                n6 = n5;
            }
            n4 = n6;
        }
        return view;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        OrientationHelper orientationHelper = this.mHorizontalHelper;
        if (orientationHelper == null || orientationHelper.mLayoutManager != layoutManager) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper(layoutManager);
        }
        return this.mHorizontalHelper;
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        OrientationHelper orientationHelper = this.mVerticalHelper;
        if (orientationHelper == null || orientationHelper.mLayoutManager != layoutManager) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper(layoutManager);
        }
        return this.mVerticalHelper;
    }

    @Override
    public int[] calculateDistanceToFinalSnap(RecyclerView.LayoutManager layoutManager, View view) {
        int[] nArray = new int[]{layoutManager.canScrollHorizontally() ? this.distanceToCenter(layoutManager, view, this.getHorizontalHelper(layoutManager)) : 0, layoutManager.canScrollVertically() ? this.distanceToCenter(layoutManager, view, this.getVerticalHelper(layoutManager)) : 0};
        return nArray;
    }

    @Override
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager.canScrollVertically()) {
            return this.findCenterView(layoutManager, this.getVerticalHelper(layoutManager));
        }
        if (layoutManager.canScrollHorizontally()) {
            return this.findCenterView(layoutManager, this.getHorizontalHelper(layoutManager));
        }
        return null;
    }

    @Override
    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int n, int n2) {
        block14: {
            int n3;
            if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider)) {
                return -1;
            }
            int n4 = layoutManager.getItemCount();
            if (n4 == 0) {
                return -1;
            }
            Object object = this.findSnapView(layoutManager);
            if (object == null) {
                return -1;
            }
            int n5 = layoutManager.getPosition((View)object);
            if (n5 == -1) {
                return -1;
            }
            object = (RecyclerView.SmoothScroller.ScrollVectorProvider)((Object)layoutManager);
            int n6 = n4 - 1;
            if ((object = object.computeScrollVectorForPosition(n6)) == null) {
                return -1;
            }
            boolean bl = layoutManager.canScrollHorizontally();
            int n7 = 0;
            if (bl) {
                n = n3 = this.estimateNextPositionDiffForFling(layoutManager, this.getHorizontalHelper(layoutManager), n, 0);
                if (((PointF)object).x < 0.0f) {
                    n = -n3;
                }
            } else {
                n = 0;
            }
            if (layoutManager.canScrollVertically()) {
                n2 = n3 = this.estimateNextPositionDiffForFling(layoutManager, this.getVerticalHelper(layoutManager), 0, n2);
                if (((PointF)object).y < 0.0f) {
                    n2 = -n3;
                }
            } else {
                n2 = 0;
            }
            if (layoutManager.canScrollVertically()) {
                n = n2;
            }
            if (n == 0) {
                return -1;
            }
            if ((n = n5 + n) < 0) {
                n = n7;
            }
            if (n < n4) break block14;
            n = n6;
        }
        return n;
    }
}

