/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;

public abstract class SnapHelper
extends RecyclerView.OnFlingListener {
    static final float MILLISECONDS_PER_INCH = 100.0f;
    private Scroller mGravityScroller;
    RecyclerView mRecyclerView;
    private final RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){
        boolean mScrolled = false;

        @Override
        public void onScrollStateChanged(RecyclerView recyclerView, int n) {
            super.onScrollStateChanged(recyclerView, n);
            if (n == 0 && this.mScrolled) {
                this.mScrolled = false;
                SnapHelper.this.snapToTargetExistingView();
            }
        }

        @Override
        public void onScrolled(RecyclerView recyclerView, int n, int n2) {
            if (n != 0 || n2 != 0) {
                this.mScrolled = true;
            }
        }
    };

    private void destroyCallbacks() {
        this.mRecyclerView.removeOnScrollListener(this.mScrollListener);
        this.mRecyclerView.setOnFlingListener(null);
    }

    private void setupCallbacks() throws IllegalStateException {
        if (this.mRecyclerView.getOnFlingListener() == null) {
            this.mRecyclerView.addOnScrollListener(this.mScrollListener);
            this.mRecyclerView.setOnFlingListener(this);
            return;
        }
        throw new IllegalStateException("An instance of OnFlingListener already set.");
    }

    private boolean snapFromFling(RecyclerView.LayoutManager layoutManager, int n, int n2) {
        if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider)) {
            return false;
        }
        RecyclerView.SmoothScroller smoothScroller2 = this.createScroller(layoutManager);
        if (smoothScroller2 == null) {
            return false;
        }
        if ((n = this.findTargetSnapPosition(layoutManager, n, n2)) == -1) {
            return false;
        }
        smoothScroller2.setTargetPosition(n);
        layoutManager.startSmoothScroll(smoothScroller2);
        return true;
    }

    public void attachToRecyclerView(RecyclerView recyclerView) throws IllegalStateException {
        RecyclerView recyclerView2 = this.mRecyclerView;
        if (recyclerView2 == recyclerView) {
            return;
        }
        if (recyclerView2 != null) {
            this.destroyCallbacks();
        }
        this.mRecyclerView = recyclerView;
        if (recyclerView != null) {
            this.setupCallbacks();
            this.mGravityScroller = new Scroller(this.mRecyclerView.getContext(), (Interpolator)new DecelerateInterpolator());
            this.snapToTargetExistingView();
        }
    }

    public abstract int[] calculateDistanceToFinalSnap(RecyclerView.LayoutManager var1, View var2);

    public int[] calculateScrollDistance(int n, int n2) {
        this.mGravityScroller.fling(0, 0, n, n2, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        return new int[]{this.mGravityScroller.getFinalX(), this.mGravityScroller.getFinalY()};
    }

    protected RecyclerView.SmoothScroller createScroller(RecyclerView.LayoutManager layoutManager) {
        return this.createSnapScroller(layoutManager);
    }

    @Deprecated
    protected LinearSmoothScroller createSnapScroller(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof RecyclerView.SmoothScroller.ScrollVectorProvider)) {
            return null;
        }
        return new LinearSmoothScroller(this.mRecyclerView.getContext()){

            @Override
            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return 100.0f / (float)displayMetrics.densityDpi;
            }

            @Override
            protected void onTargetFound(View object, RecyclerView.State object2, RecyclerView.SmoothScroller.Action action) {
                if (SnapHelper.this.mRecyclerView == null) {
                    return;
                }
                object2 = SnapHelper.this;
                object = ((SnapHelper)object2).calculateDistanceToFinalSnap(((SnapHelper)object2).mRecyclerView.getLayoutManager(), (View)object);
                View view = object[0];
                View view2 = object[1];
                int n = this.calculateTimeForDeceleration(Math.max(Math.abs((int)view), Math.abs((int)view2)));
                if (n > 0) {
                    action.update((int)view, (int)view2, n, (Interpolator)this.mDecelerateInterpolator);
                }
            }
        };
    }

    public abstract View findSnapView(RecyclerView.LayoutManager var1);

    public abstract int findTargetSnapPosition(RecyclerView.LayoutManager var1, int var2, int var3);

    @Override
    public boolean onFling(int n, int n2) {
        boolean bl;
        block7: {
            boolean bl2;
            RecyclerView.LayoutManager layoutManager;
            block6: {
                layoutManager = this.mRecyclerView.getLayoutManager();
                bl2 = false;
                if (layoutManager == null) {
                    return false;
                }
                if (this.mRecyclerView.getAdapter() == null) {
                    return false;
                }
                int n3 = this.mRecyclerView.getMinFlingVelocity();
                if (Math.abs(n2) > n3) break block6;
                bl = bl2;
                if (Math.abs(n) <= n3) break block7;
            }
            bl = bl2;
            if (this.snapFromFling(layoutManager, n, n2)) {
                bl = true;
            }
        }
        return bl;
    }

    void snapToTargetExistingView() {
        Object object = this.mRecyclerView;
        if (object == null) {
            return;
        }
        if ((object = ((RecyclerView)object).getLayoutManager()) == null) {
            return;
        }
        View view = this.findSnapView((RecyclerView.LayoutManager)object);
        if (view == null) {
            return;
        }
        if ((object = (Object)this.calculateDistanceToFinalSnap((RecyclerView.LayoutManager)object, view))[0] != false || object[1] != false) {
            this.mRecyclerView.smoothScrollBy((int)object[0], (int)object[1]);
        }
    }
}

