/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.arch.core.util.Function;
import androidx.room.util.SneakyThrow;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

final class AutoCloser {
    final long mAutoCloseTimeoutInMs;
    final Runnable mAutoCloser;
    SupportSQLiteDatabase mDelegateDatabase;
    private SupportSQLiteOpenHelper mDelegateOpenHelper = null;
    private final Runnable mExecuteAutoCloser;
    final Executor mExecutor;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    long mLastDecrementRefCountTimeStamp;
    final Object mLock = new Object();
    private boolean mManuallyClosed = false;
    Runnable mOnAutoCloseCallback = null;
    int mRefCount = 0;

    AutoCloser(long l, TimeUnit timeUnit, Executor executor) {
        this.mLastDecrementRefCountTimeStamp = SystemClock.uptimeMillis();
        this.mExecuteAutoCloser = new Runnable(){

            @Override
            public void run() {
                AutoCloser.this.mExecutor.execute(AutoCloser.this.mAutoCloser);
            }
        };
        this.mAutoCloser = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = AutoCloser.this.mLock;
                synchronized (object) {
                    boolean bl;
                    if (SystemClock.uptimeMillis() - AutoCloser.this.mLastDecrementRefCountTimeStamp < AutoCloser.this.mAutoCloseTimeoutInMs) {
                        return;
                    }
                    if (AutoCloser.this.mRefCount != 0) {
                        return;
                    }
                    if (AutoCloser.this.mOnAutoCloseCallback == null) {
                        IllegalStateException illegalStateException = new IllegalStateException("mOnAutoCloseCallback is null but it should have been set before use. Please file a bug against Room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568");
                        throw illegalStateException;
                    }
                    AutoCloser.this.mOnAutoCloseCallback.run();
                    if (AutoCloser.this.mDelegateDatabase != null && (bl = AutoCloser.this.mDelegateDatabase.isOpen())) {
                        try {
                            AutoCloser.this.mDelegateDatabase.close();
                        }
                        catch (IOException iOException) {
                            SneakyThrow.reThrow(iOException);
                        }
                        AutoCloser.this.mDelegateDatabase = null;
                    }
                    return;
                }
            }
        };
        this.mAutoCloseTimeoutInMs = timeUnit.toMillis(l);
        this.mExecutor = executor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDatabaseIfOpen() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.mManuallyClosed = true;
            SupportSQLiteDatabase supportSQLiteDatabase = this.mDelegateDatabase;
            if (supportSQLiteDatabase != null) {
                supportSQLiteDatabase.close();
            }
            this.mDelegateDatabase = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decrementCountAndScheduleClose() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mRefCount;
            if (n <= 0) {
                IllegalStateException illegalStateException = new IllegalStateException("ref count is 0 or lower but we're supposed to decrement");
                throw illegalStateException;
            }
            this.mRefCount = --n;
            if (n == 0) {
                if (this.mDelegateDatabase == null) {
                    return;
                }
                this.mHandler.postDelayed(this.mExecuteAutoCloser, this.mAutoCloseTimeoutInMs);
            }
            return;
        }
    }

    public <V> V executeRefCountingFunction(Function<SupportSQLiteDatabase, V> function) {
        try {
            function = function.apply(this.incrementCountAndEnsureDbIsOpen());
            return (V)function;
        }
        finally {
            this.decrementCountAndScheduleClose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportSQLiteDatabase getDelegateDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDelegateDatabase;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRefCountForTest() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRefCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SupportSQLiteDatabase incrementCountAndEnsureDbIsOpen() {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeCallbacks(this.mExecuteAutoCloser);
            ++this.mRefCount;
            if (this.mManuallyClosed) {
                IllegalStateException illegalStateException = new IllegalStateException("Attempting to open already closed database.");
                throw illegalStateException;
            }
            Object object2 = this.mDelegateDatabase;
            if (object2 != null && object2.isOpen()) {
                return this.mDelegateDatabase;
            }
            object2 = this.mDelegateOpenHelper;
            if (object2 != null) {
                this.mDelegateDatabase = object2 = object2.getWritableDatabase();
                return object2;
            }
            object2 = new IllegalStateException("AutoCloser has not been initialized. Please file a bug against Room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568");
            throw object2;
        }
    }

    public void init(SupportSQLiteOpenHelper supportSQLiteOpenHelper) {
        if (this.mDelegateOpenHelper != null) {
            Log.e((String)"ROOM", (String)"AutoCloser initialized multiple times. Please file a bug against room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568");
            return;
        }
        this.mDelegateOpenHelper = supportSQLiteOpenHelper;
    }

    public boolean isActive() {
        return this.mManuallyClosed ^ true;
    }

    public void setAutoCloseCallback(Runnable runnable) {
        this.mOnAutoCloseCallback = runnable;
    }
}

