/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import android.content.Intent;
import androidx.room.MultiInstanceInvalidationService;
import androidx.room.RoomDatabase;
import androidx.room.migration.AutoMigrationSpec;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class DatabaseConfiguration {
    public final boolean allowDestructiveMigrationOnDowngrade;
    public final boolean allowMainThreadQueries;
    public final List<AutoMigrationSpec> autoMigrationSpecs;
    public final List<RoomDatabase.Callback> callbacks;
    public final Context context;
    public final String copyFromAssetPath;
    public final File copyFromFile;
    public final Callable<InputStream> copyFromInputStream;
    public final RoomDatabase.JournalMode journalMode;
    private final Set<Integer> mMigrationNotRequiredFrom;
    public final RoomDatabase.MigrationContainer migrationContainer;
    public final boolean multiInstanceInvalidation;
    public final Intent multiInstanceInvalidationServiceIntent;
    public final String name;
    public final RoomDatabase.PrepackagedDatabaseCallback prepackagedDatabaseCallback;
    public final Executor queryExecutor;
    public final boolean requireMigration;
    public final SupportSQLiteOpenHelper.Factory sqliteOpenHelperFactory;
    public final Executor transactionExecutor;
    public final List<Object> typeConverters;

    public DatabaseConfiguration(Context object, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, Intent intent, boolean bl2, boolean bl3, Set<Integer> set, String string3, File file, Callable<InputStream> callable, RoomDatabase.PrepackagedDatabaseCallback prepackagedDatabaseCallback, List<Object> list2, List<AutoMigrationSpec> list3) {
        this.sqliteOpenHelperFactory = factory;
        this.context = object;
        this.name = string2;
        this.migrationContainer = migrationContainer;
        this.callbacks = list;
        this.allowMainThreadQueries = bl;
        this.journalMode = journalMode;
        this.queryExecutor = executor;
        this.transactionExecutor = executor2;
        this.multiInstanceInvalidationServiceIntent = intent;
        bl = intent != null;
        this.multiInstanceInvalidation = bl;
        this.requireMigration = bl2;
        this.allowDestructiveMigrationOnDowngrade = bl3;
        this.mMigrationNotRequiredFrom = set;
        this.copyFromAssetPath = string3;
        this.copyFromFile = file;
        this.copyFromInputStream = callable;
        this.prepackagedDatabaseCallback = prepackagedDatabaseCallback;
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this.typeConverters = list2;
        object = list3 == null ? Collections.emptyList() : list3;
        this.autoMigrationSpecs = object;
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, boolean bl2, boolean bl3, boolean bl4, Set<Integer> set) {
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor2, bl2, bl3, bl4, set, null, null, null, null, null, null);
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, boolean bl2, boolean bl3, boolean bl4, Set<Integer> set, String string3, File file) {
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor2, bl2, bl3, bl4, set, string3, file, null, null, null, null);
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, boolean bl2, boolean bl3, boolean bl4, Set<Integer> set, String string3, File file, Callable<InputStream> callable) {
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor2, bl2, bl3, bl4, set, string3, file, callable, null, null, null);
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, boolean bl2, boolean bl3, boolean bl4, Set<Integer> set, String string3, File file, Callable<InputStream> callable, RoomDatabase.PrepackagedDatabaseCallback prepackagedDatabaseCallback) {
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor2, bl2, bl3, bl4, set, string3, file, callable, prepackagedDatabaseCallback, null, null);
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, boolean bl2, boolean bl3, boolean bl4, Set<Integer> set, String string3, File file, Callable<InputStream> callable, RoomDatabase.PrepackagedDatabaseCallback prepackagedDatabaseCallback, List<Object> list2) {
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor2, bl2, bl3, bl4, set, string3, file, callable, prepackagedDatabaseCallback, list2, null);
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, Executor executor2, boolean bl2, boolean bl3, boolean bl4, Set<Integer> set, String string3, File file, Callable<InputStream> callable, RoomDatabase.PrepackagedDatabaseCallback prepackagedDatabaseCallback, List<Object> list2, List<AutoMigrationSpec> list3) {
        Intent intent = bl2 ? new Intent(context, MultiInstanceInvalidationService.class) : null;
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor2, intent, bl3, bl4, set, string3, file, callable, prepackagedDatabaseCallback, list2, list3);
    }

    @Deprecated
    public DatabaseConfiguration(Context context, String string2, SupportSQLiteOpenHelper.Factory factory, RoomDatabase.MigrationContainer migrationContainer, List<RoomDatabase.Callback> list, boolean bl, RoomDatabase.JournalMode journalMode, Executor executor, boolean bl2, Set<Integer> set) {
        this(context, string2, factory, migrationContainer, list, bl, journalMode, executor, executor, false, bl2, false, set, null, null, null, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMigrationRequired(int n, int n2) {
        boolean bl = true;
        if ((n2 = n > n2 ? 1 : 0) != 0 && this.allowDestructiveMigrationOnDowngrade) {
            return false;
        }
        if (!this.requireMigration) return false;
        Set<Integer> set = this.mMigrationNotRequiredFrom;
        boolean bl2 = bl;
        if (set == null) return bl2;
        if (set.contains(n)) return false;
        return bl;
    }

    @Deprecated
    public boolean isMigrationRequiredFrom(int n) {
        return this.isMigrationRequired(n, n + 1);
    }
}

