/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class EntityInsertionAdapter<T>
extends SharedSQLiteStatement {
    public EntityInsertionAdapter(RoomDatabase roomDatabase) {
        super(roomDatabase);
    }

    protected abstract void bind(SupportSQLiteStatement var1, T var2);

    public final void insert(Iterable<? extends T> object) {
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            object = object.iterator();
            while (object.hasNext()) {
                this.bind(supportSQLiteStatement, object.next());
                supportSQLiteStatement.executeInsert();
            }
            return;
        }
        finally {
            this.release(supportSQLiteStatement);
        }
    }

    public final void insert(T t) {
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            this.bind(supportSQLiteStatement, t);
            supportSQLiteStatement.executeInsert();
            return;
        }
        finally {
            this.release(supportSQLiteStatement);
        }
    }

    public final void insert(T[] TArray) {
        int n;
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            n = TArray.length;
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            this.bind(supportSQLiteStatement, TArray[i]);
            supportSQLiteStatement.executeInsert();
            continue;
        }
        this.release(supportSQLiteStatement);
        return;
    }

    public final long insertAndReturnId(T t) {
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            this.bind(supportSQLiteStatement, t);
            long l = supportSQLiteStatement.executeInsert();
            return l;
        }
        finally {
            this.release(supportSQLiteStatement);
        }
    }

    public final long[] insertAndReturnIdsArray(Collection<? extends T> object) {
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        long[] lArray = new long[object.size()];
        int n = 0;
        try {
            object = object.iterator();
            while (object.hasNext()) {
                this.bind(supportSQLiteStatement, object.next());
                lArray[n] = supportSQLiteStatement.executeInsert();
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        this.release(supportSQLiteStatement);
        return lArray;
    }

    public final long[] insertAndReturnIdsArray(T[] TArray) {
        int n;
        int n2;
        long[] lArray;
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            lArray = new long[TArray.length];
            n2 = TArray.length;
            n = 0;
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            this.bind(supportSQLiteStatement, TArray[i]);
            lArray[n] = supportSQLiteStatement.executeInsert();
            ++n;
            continue;
        }
        this.release(supportSQLiteStatement);
        return lArray;
    }

    public final Long[] insertAndReturnIdsArrayBox(Collection<? extends T> object) {
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        Long[] longArray = new Long[object.size()];
        int n = 0;
        try {
            object = object.iterator();
            while (object.hasNext()) {
                this.bind(supportSQLiteStatement, object.next());
                longArray[n] = supportSQLiteStatement.executeInsert();
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        this.release(supportSQLiteStatement);
        return longArray;
    }

    public final Long[] insertAndReturnIdsArrayBox(T[] TArray) {
        int n;
        int n2;
        Long[] longArray;
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            longArray = new Long[TArray.length];
            n2 = TArray.length;
            n = 0;
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            this.bind(supportSQLiteStatement, TArray[i]);
            longArray[n] = supportSQLiteStatement.executeInsert();
            ++n;
            continue;
        }
        this.release(supportSQLiteStatement);
        return longArray;
    }

    public final List<Long> insertAndReturnIdsList(Collection<? extends T> object) {
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        ArrayList<Long> arrayList = new ArrayList<Long>(object.size());
        int n = 0;
        try {
            object = object.iterator();
            while (object.hasNext()) {
                this.bind(supportSQLiteStatement, object.next());
                arrayList.add(n, supportSQLiteStatement.executeInsert());
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        this.release(supportSQLiteStatement);
        return arrayList;
    }

    public final List<Long> insertAndReturnIdsList(T[] TArray) {
        int n;
        int n2;
        ArrayList<Long> arrayList;
        SupportSQLiteStatement supportSQLiteStatement = this.acquire();
        try {
            arrayList = new ArrayList<Long>(TArray.length);
            n2 = TArray.length;
            n = 0;
        }
        catch (Throwable throwable) {
            this.release(supportSQLiteStatement);
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            this.bind(supportSQLiteStatement, TArray[i]);
            arrayList.add(n, supportSQLiteStatement.executeInsert());
            ++n;
            continue;
        }
        this.release(supportSQLiteStatement);
        return arrayList;
    }
}

