/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Log;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.LiveData;
import androidx.room.AutoCloser;
import androidx.room.InvalidationLiveDataContainer;
import androidx.room.InvalidationTracker$$ExternalSyntheticLambda0;
import androidx.room.MultiInstanceInvalidationClient;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public class InvalidationTracker {
    private static final String CREATE_TRACKING_TABLE_SQL = "CREATE TEMP TABLE room_table_modification_log(table_id INTEGER PRIMARY KEY, invalidated INTEGER NOT NULL DEFAULT 0)";
    private static final String INVALIDATED_COLUMN_NAME = "invalidated";
    static final String RESET_UPDATED_TABLES_SQL = "UPDATE room_table_modification_log SET invalidated = 0 WHERE invalidated = 1 ";
    static final String SELECT_UPDATED_TABLES_SQL = "SELECT * FROM room_table_modification_log WHERE invalidated = 1;";
    private static final String TABLE_ID_COLUMN_NAME = "table_id";
    private static final String[] TRIGGERS = new String[]{"UPDATE", "DELETE", "INSERT"};
    private static final String UPDATE_TABLE_NAME = "room_table_modification_log";
    AutoCloser mAutoCloser = null;
    volatile SupportSQLiteStatement mCleanupStatement;
    final RoomDatabase mDatabase;
    private volatile boolean mInitialized = false;
    private final InvalidationLiveDataContainer mInvalidationLiveDataContainer;
    private MultiInstanceInvalidationClient mMultiInstanceInvalidationClient;
    private final ObservedTableTracker mObservedTableTracker;
    final SafeIterableMap<Observer, ObserverWrapper> mObserverMap;
    AtomicBoolean mPendingRefresh = new AtomicBoolean(false);
    Runnable mRefreshRunnable;
    private final Object mSyncTriggersLock;
    final HashMap<String, Integer> mTableIdLookup;
    final String[] mTableNames;
    private Map<String, Set<String>> mViewTables;

    public InvalidationTracker(RoomDatabase object, Map<String, String> object2, Map<String, Set<String>> object32, String ... object4) {
        String string2;
        this.mObserverMap = new SafeIterableMap();
        this.mSyncTriggersLock = new Object();
        this.mRefreshRunnable = new Runnable(){

            private Set<Integer> checkUpdatedTable() {
                Cursor cursor;
                HashSet<Integer> hashSet;
                block4: {
                    hashSet = new HashSet<Integer>();
                    cursor = InvalidationTracker.this.mDatabase.query(new SimpleSQLiteQuery(InvalidationTracker.SELECT_UPDATED_TABLES_SQL));
                    while (cursor.moveToNext()) {
                        hashSet.add(cursor.getInt(0));
                    }
                    if (hashSet.isEmpty()) break block4;
                    InvalidationTracker.this.mCleanupStatement.executeUpdateDelete();
                }
                return hashSet;
                finally {
                    cursor.close();
                }
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Throwable throwable322;
                Lock lock;
                block26: {
                    Set<Integer> set;
                    Set<Integer> set2;
                    Set<Integer> set3;
                    block28: {
                        block29: {
                            Set<Integer> set4;
                            Set<Integer> set5;
                            block25: {
                                boolean bl;
                                block24: {
                                    block23: {
                                        lock = InvalidationTracker.this.mDatabase.getCloseLock();
                                        lock.lock();
                                        set3 = null;
                                        set5 = null;
                                        set4 = null;
                                        set2 = set3;
                                        set = set5;
                                        bl = InvalidationTracker.this.ensureInitialization();
                                        if (bl) break block23;
                                        lock.unlock();
                                        if (InvalidationTracker.this.mAutoCloser != null) {
                                            InvalidationTracker.this.mAutoCloser.decrementCountAndScheduleClose();
                                        }
                                        return;
                                    }
                                    set2 = set3;
                                    set = set5;
                                    bl = InvalidationTracker.this.mPendingRefresh.compareAndSet(true, false);
                                    if (bl) break block24;
                                    lock.unlock();
                                    if (InvalidationTracker.this.mAutoCloser != null) {
                                        InvalidationTracker.this.mAutoCloser.decrementCountAndScheduleClose();
                                    }
                                    return;
                                }
                                set2 = set3;
                                set = set5;
                                bl = InvalidationTracker.this.mDatabase.inTransaction();
                                if (!bl) break block25;
                                lock.unlock();
                                if (InvalidationTracker.this.mAutoCloser != null) {
                                    InvalidationTracker.this.mAutoCloser.decrementCountAndScheduleClose();
                                }
                                return;
                            }
                            set2 = set3;
                            set = set5;
                            SupportSQLiteDatabase supportSQLiteDatabase = InvalidationTracker.this.mDatabase.getOpenHelper().getWritableDatabase();
                            set2 = set3;
                            set = set5;
                            supportSQLiteDatabase.beginTransactionNonExclusive();
                            set4 = set3 = this.checkUpdatedTable();
                            supportSQLiteDatabase.setTransactionSuccessful();
                            set2 = set3;
                            set = set3;
                            supportSQLiteDatabase.endTransaction();
                            lock.unlock();
                            set2 = set3;
                            if (InvalidationTracker.this.mAutoCloser == null) break block28;
                            break block29;
                            catch (Throwable throwable2) {
                                block27: {
                                    set2 = set4;
                                    set = set4;
                                    try {
                                        supportSQLiteDatabase.endTransaction();
                                        set2 = set4;
                                        set = set4;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable322) {
                                        break block26;
                                    }
                                    catch (SQLiteException sQLiteException) {
                                        set = set2;
                                        break block27;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        // empty catch block
                                    }
                                }
                                Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", set3);
                            }
                            lock.unlock();
                            set2 = set;
                            if (InvalidationTracker.this.mAutoCloser == null) break block28;
                            set3 = set;
                        }
                        InvalidationTracker.this.mAutoCloser.decrementCountAndScheduleClose();
                        set2 = set3;
                    }
                    if (set2 != null && !set2.isEmpty()) {
                        set3 = InvalidationTracker.this.mObserverMap;
                        synchronized (set3) {
                            set = InvalidationTracker.this.mObserverMap.iterator();
                            while (set.hasNext()) {
                                ((ObserverWrapper)((Map.Entry)set.next()).getValue()).notifyByTableInvalidStatus(set2);
                            }
                        }
                    }
                    return;
                }
                lock.unlock();
                if (InvalidationTracker.this.mAutoCloser != null) {
                    InvalidationTracker.this.mAutoCloser.decrementCountAndScheduleClose();
                }
                throw throwable322;
            }
        };
        this.mDatabase = object;
        this.mObservedTableTracker = new ObservedTableTracker(((void)string2).length);
        this.mTableIdLookup = new HashMap();
        this.mViewTables = object32;
        this.mInvalidationLiveDataContainer = new InvalidationLiveDataContainer((RoomDatabase)object);
        int n = ((void)string2).length;
        this.mTableNames = new String[n];
        for (int i = 0; i < n; ++i) {
            object = string2[i].toLowerCase(Locale.US);
            this.mTableIdLookup.put((String)object, i);
            String string3 = (String)object2.get(string2[i]);
            this.mTableNames[i] = string3 != null ? string3.toLowerCase(Locale.US) : object;
        }
        for (Map.Entry entry : object2.entrySet()) {
            object2 = ((String)entry.getValue()).toLowerCase(Locale.US);
            if (!this.mTableIdLookup.containsKey(object2)) continue;
            string2 = ((String)entry.getKey()).toLowerCase(Locale.US);
            HashMap<String, Integer> hashMap = this.mTableIdLookup;
            hashMap.put(string2, hashMap.get(object2));
        }
    }

    public InvalidationTracker(RoomDatabase roomDatabase, String ... stringArray) {
        this(roomDatabase, new HashMap<String, String>(), Collections.emptyMap(), stringArray);
    }

    private static void appendTriggerName(StringBuilder stringBuilder, String string2, String string3) {
        stringBuilder.append("`");
        stringBuilder.append("room_table_modification_trigger_");
        stringBuilder.append(string2);
        stringBuilder.append("_");
        stringBuilder.append(string3);
        stringBuilder.append("`");
    }

    private static void beginTransactionInternal(SupportSQLiteDatabase supportSQLiteDatabase) {
        if (Build.VERSION.SDK_INT >= 16 && supportSQLiteDatabase.isWriteAheadLoggingEnabled()) {
            supportSQLiteDatabase.beginTransactionNonExclusive();
        } else {
            supportSQLiteDatabase.beginTransaction();
        }
    }

    private String[] resolveViews(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            String string3 = string2.toLowerCase(Locale.US);
            if (this.mViewTables.containsKey(string3)) {
                hashSet.addAll((Collection)this.mViewTables.get(string3));
                continue;
            }
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private void startTrackingTable(SupportSQLiteDatabase supportSQLiteDatabase, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT OR IGNORE INTO room_table_modification_log VALUES(");
        stringBuilder.append(n);
        stringBuilder.append(", 0)");
        supportSQLiteDatabase.execSQL(stringBuilder.toString());
        String string2 = this.mTableNames[n];
        stringBuilder = new StringBuilder();
        for (String string3 : TRIGGERS) {
            stringBuilder.setLength(0);
            stringBuilder.append("CREATE TEMP TRIGGER IF NOT EXISTS ");
            InvalidationTracker.appendTriggerName(stringBuilder, string2, string3);
            stringBuilder.append(" AFTER ");
            stringBuilder.append(string3);
            stringBuilder.append(" ON `");
            stringBuilder.append(string2);
            stringBuilder.append("` BEGIN UPDATE ");
            stringBuilder.append(UPDATE_TABLE_NAME);
            stringBuilder.append(" SET ");
            stringBuilder.append(INVALIDATED_COLUMN_NAME);
            stringBuilder.append(" = 1");
            stringBuilder.append(" WHERE ");
            stringBuilder.append(TABLE_ID_COLUMN_NAME);
            stringBuilder.append(" = ");
            stringBuilder.append(n);
            stringBuilder.append(" AND ");
            stringBuilder.append(INVALIDATED_COLUMN_NAME);
            stringBuilder.append(" = 0");
            stringBuilder.append("; END");
            supportSQLiteDatabase.execSQL(stringBuilder.toString());
        }
    }

    private void stopTrackingTable(SupportSQLiteDatabase supportSQLiteDatabase, int n) {
        String string2 = this.mTableNames[n];
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : TRIGGERS) {
            stringBuilder.setLength(0);
            stringBuilder.append("DROP TRIGGER IF EXISTS ");
            InvalidationTracker.appendTriggerName(stringBuilder, string2, string3);
            supportSQLiteDatabase.execSQL(stringBuilder.toString());
        }
    }

    private String[] validateAndResolveTableNames(String[] object) {
        Object object2 = this.resolveViews((String[])object);
        int n = ((String[])object2).length;
        for (int i = 0; i < n; ++i) {
            object = object2[i];
            if (this.mTableIdLookup.containsKey(((String)object).toLowerCase(Locale.US))) {
                continue;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("There is no table with name ");
            ((StringBuilder)object2).append((String)object);
            throw new IllegalArgumentException(((StringBuilder)object2).toString());
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addObserver(Observer object) {
        Object object2 = this.resolveViews(((Observer)object).mTables);
        int[] nArray = new int[((String[])object2).length];
        int n = ((String[])object2).length;
        int n2 = 0;
        while (true) {
            Object object3;
            if (n2 >= n) {
                object3 = new ObserverWrapper((Observer)object, nArray, (String[])object2);
                object2 = this.mObserverMap;
                // MONITORENTER : object2
                object = this.mObserverMap.putIfAbsent((Observer)object, (ObserverWrapper)object3);
                // MONITOREXIT : object2
                if (object != null) return;
                if (!this.mObservedTableTracker.onAdded(nArray)) return;
                this.syncTriggers();
                return;
            }
            object3 = this.mTableIdLookup.get(object2[n2].toLowerCase(Locale.US));
            if (object3 == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("There is no table with name ");
                ((StringBuilder)object).append(object2[n2]);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            nArray[n2] = (Integer)object3;
            ++n2;
        }
    }

    public void addWeakObserver(Observer observer) {
        this.addObserver(new WeakObserver(this, observer));
    }

    @Deprecated
    public <T> LiveData<T> createLiveData(String[] stringArray, Callable<T> callable) {
        return this.createLiveData(stringArray, false, callable);
    }

    public <T> LiveData<T> createLiveData(String[] stringArray, boolean bl, Callable<T> callable) {
        return this.mInvalidationLiveDataContainer.create(this.validateAndResolveTableNames(stringArray), bl, callable);
    }

    boolean ensureInitialization() {
        if (!this.mDatabase.isOpen()) {
            return false;
        }
        if (!this.mInitialized) {
            this.mDatabase.getOpenHelper().getWritableDatabase();
        }
        if (!this.mInitialized) {
            Log.e((String)"ROOM", (String)"database is not initialized even though it is open");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void internalInit(SupportSQLiteDatabase supportSQLiteDatabase) {
        synchronized (this) {
            if (this.mInitialized) {
                Log.e((String)"ROOM", (String)"Invalidation tracker is initialized twice :/.");
                return;
            }
            supportSQLiteDatabase.execSQL("PRAGMA temp_store = MEMORY;");
            supportSQLiteDatabase.execSQL("PRAGMA recursive_triggers='ON';");
            supportSQLiteDatabase.execSQL(CREATE_TRACKING_TABLE_SQL);
            this.syncTriggers(supportSQLiteDatabase);
            this.mCleanupStatement = supportSQLiteDatabase.compileStatement(RESET_UPDATED_TABLES_SQL);
            this.mInitialized = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyObserversByTableNames(String ... stringArray) {
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        synchronized (safeIterableMap) {
            Iterator<Map.Entry<Observer, ObserverWrapper>> iterator = this.mObserverMap.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Observer, ObserverWrapper> entry = iterator.next();
                if (entry.getKey().isRemote()) continue;
                entry.getValue().notifyByTableNames(stringArray);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onAutoCloseCallback() {
        synchronized (this) {
            this.mInitialized = false;
            this.mObservedTableTracker.resetTriggerState();
            return;
        }
    }

    public void refreshVersionsAsync() {
        if (this.mPendingRefresh.compareAndSet(false, true)) {
            AutoCloser autoCloser = this.mAutoCloser;
            if (autoCloser != null) {
                autoCloser.incrementCountAndEnsureDbIsOpen();
            }
            this.mDatabase.getQueryExecutor().execute(this.mRefreshRunnable);
        }
    }

    public void refreshVersionsSync() {
        AutoCloser autoCloser = this.mAutoCloser;
        if (autoCloser != null) {
            autoCloser.incrementCountAndEnsureDbIsOpen();
        }
        this.syncTriggers();
        this.mRefreshRunnable.run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeObserver(Observer object) {
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        // MONITORENTER : safeIterableMap
        object = this.mObserverMap.remove((Observer)object);
        // MONITOREXIT : safeIterableMap
        if (object == null) return;
        if (!this.mObservedTableTracker.onRemoved(((ObserverWrapper)object).mTableIds)) return;
        this.syncTriggers();
    }

    void setAutoCloser(AutoCloser autoCloser) {
        this.mAutoCloser = autoCloser;
        autoCloser.setAutoCloseCallback(new InvalidationTracker$$ExternalSyntheticLambda0(this));
    }

    void startMultiInstanceInvalidation(Context context, String string2, Intent intent) {
        this.mMultiInstanceInvalidationClient = new MultiInstanceInvalidationClient(context, string2, intent, this, this.mDatabase.getQueryExecutor());
    }

    void stopMultiInstanceInvalidation() {
        MultiInstanceInvalidationClient multiInstanceInvalidationClient = this.mMultiInstanceInvalidationClient;
        if (multiInstanceInvalidationClient != null) {
            multiInstanceInvalidationClient.stop();
            this.mMultiInstanceInvalidationClient = null;
        }
    }

    void syncTriggers() {
        if (!this.mDatabase.isOpen()) {
            return;
        }
        this.syncTriggers(this.mDatabase.getOpenHelper().getWritableDatabase());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void syncTriggers(SupportSQLiteDatabase var1_1) {
        block20: {
            if (var1_1.inTransaction()) {
                return;
            }
            var2_6 = this.mDatabase.getCloseLock();
            var2_6.lock();
            {
                catch (SQLiteException var1_3) {
                    break block20;
                }
                catch (IllegalStateException var1_4) {
                    // empty catch block
                    break block20;
                }
                try {
                    var3_7 = this.mSyncTriggersLock;
                    synchronized (var3_7) {
                        var4_8 = this.mObservedTableTracker.getTablesToSync();
                        if (var4_8 != null) ** break block21
                    }
                }
                catch (Throwable var1_2) {}
                {
                    var2_6.unlock();
                    return;
                }
                {
                    var5_10 = var4_8.length;
                    InvalidationTracker.beginTransactionInternal(var1_1);
                    for (var6_11 = 0; var6_11 < var5_10; ++var6_11) {
                        var7_12 = var4_8[var6_11];
                        if (var7_12 == 1) ** GOTO lbl29
                        if (var7_12 != 2) continue;
                        this.stopTrackingTable(var1_1, var6_11);
                        continue;
lbl29:
                        // 1 sources

                        this.startTrackingTable(var1_1, var6_11);
                        continue;
                    }
                    ** try [egrp 6[TRYBLOCK] [10 : 118->124)] { 
lbl34:
                    // 1 sources

                    var1_1.setTransactionSuccessful();
                }
                {
                    var2_6.unlock();
                    return;
                }
lbl-1000:
                // 1 sources

                {
                    finally {
                        var1_1.endTransaction();
                    }
                }
                {
                    var2_6.unlock();
                    throw var1_2;
                }
            }
        }
        Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)var1_5);
    }

    static class ObservedTableTracker {
        static final int ADD = 1;
        static final int NO_OP = 0;
        static final int REMOVE = 2;
        boolean mNeedsSync;
        final long[] mTableObservers;
        final int[] mTriggerStateChanges;
        final boolean[] mTriggerStates;

        ObservedTableTracker(int n) {
            long[] lArray = new long[n];
            this.mTableObservers = lArray;
            boolean[] blArray = new boolean[n];
            this.mTriggerStates = blArray;
            this.mTriggerStateChanges = new int[n];
            Arrays.fill(lArray, 0L);
            Arrays.fill(blArray, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int[] getTablesToSync() {
            synchronized (this) {
                if (!this.mNeedsSync) {
                    return null;
                }
                int n = this.mTableObservers.length;
                int n2 = 0;
                while (true) {
                    boolean[] blArray;
                    if (n2 >= n) {
                        this.mNeedsSync = false;
                        return (int[])this.mTriggerStateChanges.clone();
                    }
                    long l = this.mTableObservers[n2];
                    int n3 = 1;
                    boolean bl = l > 0L;
                    if (bl != (blArray = this.mTriggerStates)[n2]) {
                        int[] nArray = this.mTriggerStateChanges;
                        if (!bl) {
                            n3 = 2;
                        }
                        nArray[n2] = n3;
                    } else {
                        this.mTriggerStateChanges[n2] = 0;
                    }
                    blArray[n2] = bl;
                    ++n2;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean onAdded(int ... nArray) {
            synchronized (this) {
                int n = nArray.length;
                int n2 = 0;
                boolean bl = false;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    long[] lArray = this.mTableObservers;
                    long l = lArray[n3];
                    lArray[n3] = 1L + l;
                    if (l == 0L) {
                        this.mNeedsSync = true;
                        bl = true;
                    }
                    ++n2;
                }
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean onRemoved(int ... nArray) {
            synchronized (this) {
                int n = nArray.length;
                int n2 = 0;
                boolean bl = false;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    long[] lArray = this.mTableObservers;
                    long l = lArray[n3];
                    lArray[n3] = l - 1L;
                    if (l == 1L) {
                        this.mNeedsSync = true;
                        bl = true;
                    }
                    ++n2;
                }
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void resetTriggerState() {
            synchronized (this) {
                Arrays.fill(this.mTriggerStates, false);
                this.mNeedsSync = true;
                return;
            }
        }
    }

    public static abstract class Observer {
        final String[] mTables;

        protected Observer(String string2, String ... stringArray) {
            String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length + 1);
            this.mTables = stringArray2;
            stringArray2[stringArray.length] = string2;
        }

        public Observer(String[] stringArray) {
            this.mTables = Arrays.copyOf(stringArray, stringArray.length);
        }

        boolean isRemote() {
            return false;
        }

        public abstract void onInvalidated(Set<String> var1);
    }

    static class ObserverWrapper {
        final Observer mObserver;
        private final Set<String> mSingleTableSet;
        final int[] mTableIds;
        private final String[] mTableNames;

        ObserverWrapper(Observer object, int[] nArray, String[] stringArray) {
            this.mObserver = object;
            this.mTableIds = nArray;
            this.mTableNames = stringArray;
            if (nArray.length == 1) {
                object = new HashSet();
                ((HashSet)object).add(stringArray[0]);
                this.mSingleTableSet = Collections.unmodifiableSet(object);
            } else {
                this.mSingleTableSet = null;
            }
        }

        void notifyByTableInvalidStatus(Set<Integer> set) {
            int n = this.mTableIds.length;
            Set<String> set2 = null;
            for (int i = 0; i < n; ++i) {
                Set<String> set3 = set2;
                if (set.contains(this.mTableIds[i])) {
                    if (n == 1) {
                        set3 = this.mSingleTableSet;
                    } else {
                        set3 = set2;
                        if (set2 == null) {
                            set3 = new HashSet<String>(n);
                        }
                        set3.add(this.mTableNames[i]);
                    }
                }
                set2 = set3;
            }
            if (set2 != null) {
                this.mObserver.onInvalidated(set2);
            }
        }

        /*
         * WARNING - void declaration
         */
        void notifyByTableNames(String[] stringArray) {
            void var5_11;
            block7: {
                int n = this.mTableNames.length;
                Object stringArray2 = null;
                if (n == 1) {
                    int n2 = stringArray.length;
                    n = 0;
                    while (true) {
                        Object object = stringArray2;
                        if (n >= n2) break block7;
                        if (stringArray[n].equalsIgnoreCase(this.mTableNames[0])) {
                            Set<String> set = this.mSingleTableSet;
                            break block7;
                        }
                        ++n;
                    }
                }
                HashSet<String> hashSet = new HashSet<String>();
                block1: for (String string2 : stringArray) {
                    for (String string3 : this.mTableNames) {
                        if (!string3.equalsIgnoreCase(string2)) continue;
                        hashSet.add(string3);
                        continue block1;
                    }
                }
                Object var5_9 = stringArray2;
                if (hashSet.size() > 0) {
                    HashSet<String> hashSet2 = hashSet;
                }
            }
            if (var5_11 != null) {
                this.mObserver.onInvalidated((Set<String>)var5_11);
            }
        }
    }

    static class WeakObserver
    extends Observer {
        final WeakReference<Observer> mDelegateRef;
        final InvalidationTracker mTracker;

        WeakObserver(InvalidationTracker invalidationTracker, Observer observer) {
            super(observer.mTables);
            this.mTracker = invalidationTracker;
            this.mDelegateRef = new WeakReference<Observer>(observer);
        }

        @Override
        public void onInvalidated(Set<String> set) {
            Observer observer = (Observer)this.mDelegateRef.get();
            if (observer == null) {
                this.mTracker.removeObserver(this);
            } else {
                observer.onInvalidated(set);
            }
        }
    }
}

