/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.room.IMultiInstanceInvalidationCallback;
import androidx.room.IMultiInstanceInvalidationService;
import androidx.room.InvalidationTracker;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class MultiInstanceInvalidationClient {
    final Context mAppContext;
    final IMultiInstanceInvalidationCallback mCallback = new IMultiInstanceInvalidationCallback.Stub(){

        @Override
        public void onInvalidation(final String[] stringArray) {
            MultiInstanceInvalidationClient.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MultiInstanceInvalidationClient.this.mInvalidationTracker.notifyObserversByTableNames(stringArray);
                }
            });
        }
    };
    int mClientId;
    final Executor mExecutor;
    final InvalidationTracker mInvalidationTracker;
    final String mName;
    final InvalidationTracker.Observer mObserver;
    final Runnable mRemoveObserverRunnable;
    IMultiInstanceInvalidationService mService;
    final ServiceConnection mServiceConnection;
    final Runnable mSetUpRunnable;
    final AtomicBoolean mStopped = new AtomicBoolean(false);

    MultiInstanceInvalidationClient(Context context, String string2, Intent intent, InvalidationTracker invalidationTracker, Executor executor) {
        ServiceConnection serviceConnection;
        this.mServiceConnection = serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                MultiInstanceInvalidationClient.this.mService = IMultiInstanceInvalidationService.Stub.asInterface(iBinder);
                MultiInstanceInvalidationClient.this.mExecutor.execute(MultiInstanceInvalidationClient.this.mSetUpRunnable);
            }

            public void onServiceDisconnected(ComponentName componentName) {
                MultiInstanceInvalidationClient.this.mExecutor.execute(MultiInstanceInvalidationClient.this.mRemoveObserverRunnable);
                MultiInstanceInvalidationClient.this.mService = null;
            }
        };
        this.mSetUpRunnable = new Runnable(){

            @Override
            public void run() {
                block3: {
                    IMultiInstanceInvalidationService iMultiInstanceInvalidationService = MultiInstanceInvalidationClient.this.mService;
                    if (iMultiInstanceInvalidationService == null) break block3;
                    try {
                        MultiInstanceInvalidationClient multiInstanceInvalidationClient = MultiInstanceInvalidationClient.this;
                        multiInstanceInvalidationClient.mClientId = iMultiInstanceInvalidationService.registerCallback(multiInstanceInvalidationClient.mCallback, MultiInstanceInvalidationClient.this.mName);
                        MultiInstanceInvalidationClient.this.mInvalidationTracker.addObserver(MultiInstanceInvalidationClient.this.mObserver);
                    }
                    catch (RemoteException remoteException) {
                        Log.w((String)"ROOM", (String)"Cannot register multi-instance invalidation callback", (Throwable)remoteException);
                    }
                }
            }
        };
        this.mRemoveObserverRunnable = new Runnable(){

            @Override
            public void run() {
                MultiInstanceInvalidationClient.this.mInvalidationTracker.removeObserver(MultiInstanceInvalidationClient.this.mObserver);
            }
        };
        this.mAppContext = context = context.getApplicationContext();
        this.mName = string2;
        this.mInvalidationTracker = invalidationTracker;
        this.mExecutor = executor;
        this.mObserver = new InvalidationTracker.Observer(invalidationTracker.mTableIdLookup.keySet().toArray(new String[0])){

            @Override
            boolean isRemote() {
                return true;
            }

            @Override
            public void onInvalidated(Set<String> set) {
                block4: {
                    if (MultiInstanceInvalidationClient.this.mStopped.get()) {
                        return;
                    }
                    IMultiInstanceInvalidationService iMultiInstanceInvalidationService = MultiInstanceInvalidationClient.this.mService;
                    if (iMultiInstanceInvalidationService == null) break block4;
                    try {
                        iMultiInstanceInvalidationService.broadcastInvalidation(MultiInstanceInvalidationClient.this.mClientId, set.toArray(new String[0]));
                    }
                    catch (RemoteException remoteException) {
                        Log.w((String)"ROOM", (String)"Cannot broadcast invalidation", (Throwable)remoteException);
                    }
                }
            }
        };
        context.bindService(intent, serviceConnection, 1);
    }

    void stop() {
        if (this.mStopped.compareAndSet(false, true)) {
            block4: {
                this.mInvalidationTracker.removeObserver(this.mObserver);
                IMultiInstanceInvalidationService iMultiInstanceInvalidationService = this.mService;
                if (iMultiInstanceInvalidationService == null) break block4;
                try {
                    iMultiInstanceInvalidationService.unregisterCallback(this.mCallback, this.mClientId);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"ROOM", (String)"Cannot unregister multi-instance invalidation callback", (Throwable)remoteException);
                }
            }
            this.mAppContext.unbindService(this.mServiceConnection);
        }
    }
}

