/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;
import androidx.room.IMultiInstanceInvalidationCallback;
import androidx.room.IMultiInstanceInvalidationService;
import java.util.HashMap;

public class MultiInstanceInvalidationService
extends Service {
    private final IMultiInstanceInvalidationService.Stub mBinder;
    final RemoteCallbackList<IMultiInstanceInvalidationCallback> mCallbackList;
    final HashMap<Integer, String> mClientNames = new HashMap();
    int mMaxClientId = 0;

    public MultiInstanceInvalidationService() {
        this.mCallbackList = new RemoteCallbackList<IMultiInstanceInvalidationCallback>(){

            public void onCallbackDied(IMultiInstanceInvalidationCallback iMultiInstanceInvalidationCallback, Object object) {
                MultiInstanceInvalidationService.this.mClientNames.remove((int)((Integer)object));
            }
        };
        this.mBinder = new IMultiInstanceInvalidationService.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void broadcastInvalidation(int n, String[] stringArray) {
                RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = MultiInstanceInvalidationService.this.mCallbackList;
                synchronized (remoteCallbackList) {
                    String string2 = MultiInstanceInvalidationService.this.mClientNames.get(n);
                    if (string2 == null) {
                        Log.w((String)"ROOM", (String)"Remote invalidation client ID not registered");
                        return;
                    }
                    int n2 = MultiInstanceInvalidationService.this.mCallbackList.beginBroadcast();
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            MultiInstanceInvalidationService.this.mCallbackList.finishBroadcast();
                            return;
                        }
                        try {
                            boolean bl;
                            int n4 = (Integer)MultiInstanceInvalidationService.this.mCallbackList.getBroadcastCookie(n3);
                            String string3 = MultiInstanceInvalidationService.this.mClientNames.get(n4);
                            if (n != n4 && (bl = string2.equals(string3))) {
                                try {
                                    ((IMultiInstanceInvalidationCallback)MultiInstanceInvalidationService.this.mCallbackList.getBroadcastItem(n3)).onInvalidation(stringArray);
                                }
                                catch (RemoteException remoteException) {
                                    Log.w((String)"ROOM", (String)"Error invoking a remote callback", (Throwable)remoteException);
                                }
                            }
                            ++n3;
                        }
                        catch (Throwable throwable) {
                            MultiInstanceInvalidationService.this.mCallbackList.finishBroadcast();
                            throw throwable;
                        }
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int registerCallback(IMultiInstanceInvalidationCallback object, String string2) {
                if (string2 == null) {
                    return 0;
                }
                RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = MultiInstanceInvalidationService.this.mCallbackList;
                synchronized (remoteCallbackList) {
                    int n;
                    MultiInstanceInvalidationService multiInstanceInvalidationService = MultiInstanceInvalidationService.this;
                    multiInstanceInvalidationService.mMaxClientId = n = multiInstanceInvalidationService.mMaxClientId + 1;
                    if (MultiInstanceInvalidationService.this.mCallbackList.register((IInterface)object, (Object)n)) {
                        MultiInstanceInvalidationService.this.mClientNames.put(n, string2);
                        return n;
                    }
                    object = MultiInstanceInvalidationService.this;
                    --((MultiInstanceInvalidationService)((Object)object)).mMaxClientId;
                    return 0;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterCallback(IMultiInstanceInvalidationCallback iMultiInstanceInvalidationCallback, int n) {
                RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = MultiInstanceInvalidationService.this.mCallbackList;
                synchronized (remoteCallbackList) {
                    MultiInstanceInvalidationService.this.mCallbackList.unregister((IInterface)iMultiInstanceInvalidationCallback);
                    MultiInstanceInvalidationService.this.mClientNames.remove(n);
                    return;
                }
            }
        };
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }
}

