/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.sqlite.db.SupportSQLiteProgram;
import java.util.ArrayList;
import java.util.List;

final class QueryInterceptorProgram
implements SupportSQLiteProgram {
    private List<Object> mBindArgsCache = new ArrayList<Object>();

    QueryInterceptorProgram() {
    }

    private void saveArgsToCache(int n, Object object) {
        int n2 = n - 1;
        if (n2 >= this.mBindArgsCache.size()) {
            for (n = this.mBindArgsCache.size(); n <= n2; ++n) {
                this.mBindArgsCache.add(null);
            }
        }
        this.mBindArgsCache.set(n2, object);
    }

    @Override
    public void bindBlob(int n, byte[] byArray) {
        this.saveArgsToCache(n, byArray);
    }

    @Override
    public void bindDouble(int n, double d) {
        this.saveArgsToCache(n, d);
    }

    @Override
    public void bindLong(int n, long l) {
        this.saveArgsToCache(n, l);
    }

    @Override
    public void bindNull(int n) {
        this.saveArgsToCache(n, null);
    }

    @Override
    public void bindString(int n, String string2) {
        this.saveArgsToCache(n, string2);
    }

    @Override
    public void clearBindings() {
        this.mBindArgsCache.clear();
    }

    @Override
    public void close() {
    }

    List<Object> getBindArgs() {
        return this.mBindArgsCache;
    }
}

