/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Looper;
import android.util.Log;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.room.AutoCloser;
import androidx.room.AutoClosingRoomOpenHelper;
import androidx.room.AutoClosingRoomOpenHelperFactory;
import androidx.room.DatabaseConfiguration;
import androidx.room.DelegatingOpenHelper;
import androidx.room.InvalidationTracker;
import androidx.room.MultiInstanceInvalidationService;
import androidx.room.QueryInterceptorOpenHelperFactory;
import androidx.room.Room;
import androidx.room.RoomDatabase$$ExternalSyntheticLambda0;
import androidx.room.RoomDatabase$$ExternalSyntheticLambda1;
import androidx.room.SQLiteCopyOpenHelper;
import androidx.room.SQLiteCopyOpenHelperFactory;
import androidx.room.TransactionExecutor;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class RoomDatabase {
    private static final String DB_IMPL_SUFFIX = "_Impl";
    public static final int MAX_BIND_PARAMETER_CNT = 999;
    private boolean mAllowMainThreadQueries;
    private AutoCloser mAutoCloser;
    protected Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> mAutoMigrationSpecs;
    private final Map<String, Object> mBackingFieldMap;
    @Deprecated
    protected List<Callback> mCallbacks;
    private final ReentrantReadWriteLock mCloseLock = new ReentrantReadWriteLock();
    @Deprecated
    protected volatile SupportSQLiteDatabase mDatabase;
    private final InvalidationTracker mInvalidationTracker;
    private SupportSQLiteOpenHelper mOpenHelper;
    private Executor mQueryExecutor;
    private final ThreadLocal<Integer> mSuspendingTransactionId = new ThreadLocal();
    private Executor mTransactionExecutor;
    private final Map<Class<?>, Object> mTypeConverters;
    boolean mWriteAheadLoggingEnabled;

    public RoomDatabase() {
        this.mBackingFieldMap = Collections.synchronizedMap(new HashMap());
        this.mInvalidationTracker = this.createInvalidationTracker();
        this.mTypeConverters = new HashMap();
        this.mAutoMigrationSpecs = new HashMap<Class<? extends AutoMigrationSpec>, AutoMigrationSpec>();
    }

    private void internalBeginTransaction() {
        this.assertNotMainThread();
        SupportSQLiteDatabase supportSQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        this.mInvalidationTracker.syncTriggers(supportSQLiteDatabase);
        if (Build.VERSION.SDK_INT >= 16 && supportSQLiteDatabase.isWriteAheadLoggingEnabled()) {
            supportSQLiteDatabase.beginTransactionNonExclusive();
        } else {
            supportSQLiteDatabase.beginTransaction();
        }
    }

    private void internalEndTransaction() {
        this.mOpenHelper.getWritableDatabase().endTransaction();
        if (!this.inTransaction()) {
            this.mInvalidationTracker.refreshVersionsAsync();
        }
    }

    private static boolean isMainThread() {
        boolean bl = Looper.getMainLooper().getThread() == Thread.currentThread();
        return bl;
    }

    private <T> T unwrapOpenHelper(Class<T> clazz, SupportSQLiteOpenHelper supportSQLiteOpenHelper) {
        if (clazz.isInstance(supportSQLiteOpenHelper)) {
            return (T)supportSQLiteOpenHelper;
        }
        if (supportSQLiteOpenHelper instanceof DelegatingOpenHelper) {
            return this.unwrapOpenHelper(clazz, ((DelegatingOpenHelper)((Object)supportSQLiteOpenHelper)).getDelegate());
        }
        return null;
    }

    public void assertNotMainThread() {
        if (this.mAllowMainThreadQueries) {
            return;
        }
        if (!RoomDatabase.isMainThread()) {
            return;
        }
        throw new IllegalStateException("Cannot access database on the main thread since it may potentially lock the UI for a long period of time.");
    }

    public void assertNotSuspendingTransaction() {
        if (!this.inTransaction() && this.mSuspendingTransactionId.get() != null) {
            throw new IllegalStateException("Cannot access database on a different coroutine context inherited from a suspending transaction.");
        }
    }

    @Deprecated
    public void beginTransaction() {
        this.assertNotMainThread();
        AutoCloser autoCloser = this.mAutoCloser;
        if (autoCloser == null) {
            this.internalBeginTransaction();
        } else {
            autoCloser.executeRefCountingFunction(new RoomDatabase$$ExternalSyntheticLambda0(this));
        }
    }

    public abstract void clearAllTables();

    public void close() {
        if (this.isOpen()) {
            ReentrantReadWriteLock.WriteLock writeLock = this.mCloseLock.writeLock();
            writeLock.lock();
            try {
                this.mInvalidationTracker.stopMultiInstanceInvalidation();
                this.mOpenHelper.close();
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    public SupportSQLiteStatement compileStatement(String string2) {
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        return this.mOpenHelper.getWritableDatabase().compileStatement(string2);
    }

    protected abstract InvalidationTracker createInvalidationTracker();

    protected abstract SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration var1);

    @Deprecated
    public void endTransaction() {
        AutoCloser autoCloser = this.mAutoCloser;
        if (autoCloser == null) {
            this.internalEndTransaction();
        } else {
            autoCloser.executeRefCountingFunction(new RoomDatabase$$ExternalSyntheticLambda1(this));
        }
    }

    public List<Migration> getAutoMigrations(Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> map) {
        return Collections.emptyList();
    }

    Map<String, Object> getBackingFieldMap() {
        return this.mBackingFieldMap;
    }

    Lock getCloseLock() {
        return this.mCloseLock.readLock();
    }

    public InvalidationTracker getInvalidationTracker() {
        return this.mInvalidationTracker;
    }

    public SupportSQLiteOpenHelper getOpenHelper() {
        return this.mOpenHelper;
    }

    public Executor getQueryExecutor() {
        return this.mQueryExecutor;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        return Collections.emptySet();
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        return Collections.emptyMap();
    }

    ThreadLocal<Integer> getSuspendingTransactionId() {
        return this.mSuspendingTransactionId;
    }

    public Executor getTransactionExecutor() {
        return this.mTransactionExecutor;
    }

    public <T> T getTypeConverter(Class<T> clazz) {
        return (T)this.mTypeConverters.get(clazz);
    }

    public boolean inTransaction() {
        return this.mOpenHelper.getWritableDatabase().inTransaction();
    }

    public void init(DatabaseConfiguration object) {
        boolean bl;
        int n;
        boolean bl2;
        Object object2;
        Object object3;
        block17: {
            this.mOpenHelper = this.createOpenHelper((DatabaseConfiguration)object);
            object3 = this.getRequiredAutoMigrationSpecs();
            object2 = new BitSet();
            Iterator<Object> iterator = object3.iterator();
            while (true) {
                int n2;
                bl2 = iterator.hasNext();
                int n3 = -1;
                if (!bl2) break block17;
                object3 = iterator.next();
                n = ((DatabaseConfiguration)object).autoMigrationSpecs.size() - 1;
                while (true) {
                    n2 = n3;
                    if (n < 0) break;
                    if (((Class)object3).isAssignableFrom(((DatabaseConfiguration)object).autoMigrationSpecs.get(n).getClass())) {
                        ((BitSet)object2).set(n);
                        n2 = n;
                        break;
                    }
                    --n;
                }
                if (n2 < 0) break;
                this.mAutoMigrationSpecs.put((Class<? extends AutoMigrationSpec>)object3, ((DatabaseConfiguration)object).autoMigrationSpecs.get(n2));
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("A required auto migration spec (");
            ((StringBuilder)object).append(((Class)object3).getCanonicalName());
            ((StringBuilder)object).append(") is missing in the database configuration.");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        for (n = ((DatabaseConfiguration)object).autoMigrationSpecs.size() - 1; n >= 0; --n) {
            if (((BitSet)object2).get(n)) {
                continue;
            }
            throw new IllegalArgumentException("Unexpected auto migration specs found. Annotate AutoMigrationSpec implementation with @ProvidedAutoMigrationSpec annotation or remove this spec from the builder.");
        }
        object3 = this.getAutoMigrations(this.mAutoMigrationSpecs).iterator();
        while (true) {
            boolean bl3 = object3.hasNext();
            bl2 = false;
            bl = false;
            if (!bl3) break;
            object2 = object3.next();
            if (((DatabaseConfiguration)object).migrationContainer.getMigrations().containsKey(((Migration)object2).startVersion)) continue;
            ((DatabaseConfiguration)object).migrationContainer.addMigrations(new Migration[]{object2});
        }
        object3 = this.unwrapOpenHelper(SQLiteCopyOpenHelper.class, this.mOpenHelper);
        if (object3 != null) {
            ((SQLiteCopyOpenHelper)object3).setDatabaseConfiguration((DatabaseConfiguration)object);
        }
        if ((object3 = this.unwrapOpenHelper(AutoClosingRoomOpenHelper.class, this.mOpenHelper)) != null) {
            this.mAutoCloser = object3 = ((AutoClosingRoomOpenHelper)object3).getAutoCloser();
            this.mInvalidationTracker.setAutoCloser((AutoCloser)object3);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            bl2 = bl;
            if (((DatabaseConfiguration)object).journalMode == JournalMode.WRITE_AHEAD_LOGGING) {
                bl2 = true;
            }
            this.mOpenHelper.setWriteAheadLoggingEnabled(bl2);
        }
        this.mCallbacks = ((DatabaseConfiguration)object).callbacks;
        this.mQueryExecutor = ((DatabaseConfiguration)object).queryExecutor;
        this.mTransactionExecutor = new TransactionExecutor(((DatabaseConfiguration)object).transactionExecutor);
        this.mAllowMainThreadQueries = ((DatabaseConfiguration)object).allowMainThreadQueries;
        this.mWriteAheadLoggingEnabled = bl2;
        if (((DatabaseConfiguration)object).multiInstanceInvalidationServiceIntent != null) {
            this.mInvalidationTracker.startMultiInstanceInvalidation(((DatabaseConfiguration)object).context, ((DatabaseConfiguration)object).name, ((DatabaseConfiguration)object).multiInstanceInvalidationServiceIntent);
        }
        object2 = this.getRequiredTypeConverters();
        object3 = new BitSet();
        for (Map.Entry entry : object2.entrySet()) {
            object2 = (Class)entry.getKey();
            for (Class clazz : (List)entry.getValue()) {
                block18: {
                    for (n = ((DatabaseConfiguration)object).typeConverters.size() - 1; n >= 0; --n) {
                        if (!clazz.isAssignableFrom(((DatabaseConfiguration)object).typeConverters.get(n).getClass())) continue;
                        ((BitSet)object3).set(n);
                        break block18;
                    }
                    n = -1;
                }
                if (n >= 0) {
                    this.mTypeConverters.put(clazz, ((DatabaseConfiguration)object).typeConverters.get(n));
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("A required type converter (");
                ((StringBuilder)object).append(clazz);
                ((StringBuilder)object).append(") for ");
                ((StringBuilder)object).append(((Class)object2).getCanonicalName());
                ((StringBuilder)object).append(" is missing in the database configuration.");
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
        }
        for (n = ((DatabaseConfiguration)object).typeConverters.size() - 1; n >= 0; --n) {
            if (((BitSet)object3).get(n)) {
                continue;
            }
            object3 = ((DatabaseConfiguration)object).typeConverters.get(n);
            object = new StringBuilder();
            ((StringBuilder)object).append("Unexpected type converter ");
            ((StringBuilder)object).append(object3);
            ((StringBuilder)object).append(". Annotate TypeConverter class with @ProvidedTypeConverter annotation or remove this converter from the builder.");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }

    protected void internalInitInvalidationTracker(SupportSQLiteDatabase supportSQLiteDatabase) {
        this.mInvalidationTracker.internalInit(supportSQLiteDatabase);
    }

    public boolean isOpen() {
        Object object = this.mAutoCloser;
        if (object != null) {
            return ((AutoCloser)object).isActive();
        }
        object = this.mDatabase;
        boolean bl = object != null && object.isOpen();
        return bl;
    }

    public /* synthetic */ Object lambda$beginTransaction$0$androidx-room-RoomDatabase(SupportSQLiteDatabase supportSQLiteDatabase) {
        this.internalBeginTransaction();
        return null;
    }

    public /* synthetic */ Object lambda$endTransaction$1$androidx-room-RoomDatabase(SupportSQLiteDatabase supportSQLiteDatabase) {
        this.internalEndTransaction();
        return null;
    }

    public Cursor query(SupportSQLiteQuery supportSQLiteQuery) {
        return this.query(supportSQLiteQuery, null);
    }

    public Cursor query(SupportSQLiteQuery supportSQLiteQuery, CancellationSignal cancellationSignal) {
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        if (cancellationSignal != null && Build.VERSION.SDK_INT >= 16) {
            return this.mOpenHelper.getWritableDatabase().query(supportSQLiteQuery, cancellationSignal);
        }
        return this.mOpenHelper.getWritableDatabase().query(supportSQLiteQuery);
    }

    public Cursor query(String string2, Object[] objectArray) {
        return this.mOpenHelper.getWritableDatabase().query(new SimpleSQLiteQuery(string2, objectArray));
    }

    /*
     * Exception decompiling
     */
    public <V> V runInTransaction(Callable<V> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 26->30)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runInTransaction(Runnable runnable) {
        this.beginTransaction();
        try {
            runnable.run();
            this.setTransactionSuccessful();
            return;
        }
        finally {
            this.endTransaction();
        }
    }

    @Deprecated
    public void setTransactionSuccessful() {
        this.mOpenHelper.getWritableDatabase().setTransactionSuccessful();
    }

    public static class Builder<T extends RoomDatabase> {
        private boolean mAllowDestructiveMigrationOnDowngrade;
        private boolean mAllowMainThreadQueries;
        private TimeUnit mAutoCloseTimeUnit;
        private long mAutoCloseTimeout = -1L;
        private List<AutoMigrationSpec> mAutoMigrationSpecs;
        private ArrayList<Callback> mCallbacks;
        private final Context mContext;
        private String mCopyFromAssetPath;
        private File mCopyFromFile;
        private Callable<InputStream> mCopyFromInputStream;
        private final Class<T> mDatabaseClass;
        private SupportSQLiteOpenHelper.Factory mFactory;
        private JournalMode mJournalMode;
        private final MigrationContainer mMigrationContainer;
        private Set<Integer> mMigrationStartAndEndVersions;
        private Set<Integer> mMigrationsNotRequiredFrom;
        private Intent mMultiInstanceInvalidationIntent;
        private final String mName;
        private PrepackagedDatabaseCallback mPrepackagedDatabaseCallback;
        private QueryCallback mQueryCallback;
        private Executor mQueryCallbackExecutor;
        private Executor mQueryExecutor;
        private boolean mRequireMigration;
        private Executor mTransactionExecutor;
        private List<Object> mTypeConverters;

        Builder(Context context, Class<T> clazz, String string2) {
            this.mContext = context;
            this.mDatabaseClass = clazz;
            this.mName = string2;
            this.mJournalMode = JournalMode.AUTOMATIC;
            this.mRequireMigration = true;
            this.mMigrationContainer = new MigrationContainer();
        }

        public Builder<T> addAutoMigrationSpec(AutoMigrationSpec autoMigrationSpec) {
            if (this.mAutoMigrationSpecs == null) {
                this.mAutoMigrationSpecs = new ArrayList<AutoMigrationSpec>();
            }
            this.mAutoMigrationSpecs.add(autoMigrationSpec);
            return this;
        }

        public Builder<T> addCallback(Callback callback) {
            if (this.mCallbacks == null) {
                this.mCallbacks = new ArrayList();
            }
            this.mCallbacks.add(callback);
            return this;
        }

        public Builder<T> addMigrations(Migration ... migrationArray) {
            if (this.mMigrationStartAndEndVersions == null) {
                this.mMigrationStartAndEndVersions = new HashSet<Integer>();
            }
            int n = migrationArray.length;
            for (int i = 0; i < n; ++i) {
                Migration migration = migrationArray[i];
                this.mMigrationStartAndEndVersions.add(migration.startVersion);
                this.mMigrationStartAndEndVersions.add(migration.endVersion);
            }
            this.mMigrationContainer.addMigrations(migrationArray);
            return this;
        }

        public Builder<T> addTypeConverter(Object object) {
            if (this.mTypeConverters == null) {
                this.mTypeConverters = new ArrayList<Object>();
            }
            this.mTypeConverters.add(object);
            return this;
        }

        public Builder<T> allowMainThreadQueries() {
            this.mAllowMainThreadQueries = true;
            return this;
        }

        public T build() {
            block15: {
                block16: {
                    block19: {
                        block20: {
                            Callable<InputStream> callable;
                            Object object;
                            block18: {
                                String string2;
                                block17: {
                                    if (this.mContext == null) break block15;
                                    if (this.mDatabaseClass == null) break block16;
                                    object = this.mQueryExecutor;
                                    if (object == null && this.mTransactionExecutor == null) {
                                        object = ArchTaskExecutor.getIOThreadExecutor();
                                        this.mTransactionExecutor = object;
                                        this.mQueryExecutor = object;
                                    } else if (object != null && this.mTransactionExecutor == null) {
                                        this.mTransactionExecutor = object;
                                    } else if (object == null && (object = this.mTransactionExecutor) != null) {
                                        this.mQueryExecutor = object;
                                    }
                                    object = this.mMigrationStartAndEndVersions;
                                    if (object != null && this.mMigrationsNotRequiredFrom != null) {
                                        callable = object.iterator();
                                        while (callable.hasNext()) {
                                            object = (Integer)callable.next();
                                            if (!this.mMigrationsNotRequiredFrom.contains(object)) continue;
                                            callable = new StringBuilder();
                                            ((StringBuilder)((Object)callable)).append("Inconsistency detected. A Migration was supplied to addMigration(Migration... migrations) that has a start or end version equal to a start version supplied to fallbackToDestructiveMigrationFrom(int... startVersions). Start version: ");
                                            ((StringBuilder)((Object)callable)).append(object);
                                            throw new IllegalArgumentException(((StringBuilder)((Object)callable)).toString());
                                        }
                                    }
                                    callable = object = this.mFactory;
                                    if (object == null) {
                                        callable = new FrameworkSQLiteOpenHelperFactory();
                                    }
                                    long l = this.mAutoCloseTimeout;
                                    object = callable;
                                    if (l > 0L) {
                                        if (this.mName != null) {
                                            object = new AutoClosingRoomOpenHelperFactory((SupportSQLiteOpenHelper.Factory)((Object)callable), new AutoCloser(l, this.mAutoCloseTimeUnit, this.mTransactionExecutor));
                                        } else {
                                            throw new IllegalArgumentException("Cannot create auto-closing database for an in-memory database.");
                                        }
                                    }
                                    if ((string2 = this.mCopyFromAssetPath) != null || this.mCopyFromFile != null) break block17;
                                    callable = object;
                                    if (this.mCopyFromInputStream == null) break block18;
                                }
                                if (this.mName == null) break block19;
                                int n = 0;
                                int n2 = string2 == null ? 0 : 1;
                                File file = this.mCopyFromFile;
                                int n3 = file == null ? 0 : 1;
                                callable = this.mCopyFromInputStream;
                                if (callable != null) {
                                    n = 1;
                                }
                                if (n2 + n3 + n != 1) break block20;
                                callable = new SQLiteCopyOpenHelperFactory(string2, file, callable, (SupportSQLiteOpenHelper.Factory)object);
                            }
                            object = (object = this.mQueryCallback) != null ? new QueryInterceptorOpenHelperFactory((SupportSQLiteOpenHelper.Factory)((Object)callable), (QueryCallback)object, this.mQueryCallbackExecutor) : callable;
                            callable = this.mContext;
                            object = new DatabaseConfiguration((Context)callable, this.mName, (SupportSQLiteOpenHelper.Factory)object, this.mMigrationContainer, (List<Callback>)this.mCallbacks, this.mAllowMainThreadQueries, this.mJournalMode.resolve((Context)callable), this.mQueryExecutor, this.mTransactionExecutor, this.mMultiInstanceInvalidationIntent, this.mRequireMigration, this.mAllowDestructiveMigrationOnDowngrade, this.mMigrationsNotRequiredFrom, this.mCopyFromAssetPath, this.mCopyFromFile, this.mCopyFromInputStream, this.mPrepackagedDatabaseCallback, this.mTypeConverters, this.mAutoMigrationSpecs);
                            callable = (RoomDatabase)Room.getGeneratedImplementation(this.mDatabaseClass, RoomDatabase.DB_IMPL_SUFFIX);
                            ((RoomDatabase)((Object)callable)).init((DatabaseConfiguration)object);
                            return (T)callable;
                        }
                        throw new IllegalArgumentException("More than one of createFromAsset(), createFromInputStream(), and createFromFile() were called on this Builder, but the database can only be created using one of the three configurations.");
                    }
                    throw new IllegalArgumentException("Cannot create from asset or file for an in-memory database.");
                }
                throw new IllegalArgumentException("Must provide an abstract class that extends RoomDatabase");
            }
            throw new IllegalArgumentException("Cannot provide null context for the database.");
        }

        public Builder<T> createFromAsset(String string2) {
            this.mCopyFromAssetPath = string2;
            return this;
        }

        public Builder<T> createFromAsset(String string2, PrepackagedDatabaseCallback prepackagedDatabaseCallback) {
            this.mPrepackagedDatabaseCallback = prepackagedDatabaseCallback;
            this.mCopyFromAssetPath = string2;
            return this;
        }

        public Builder<T> createFromFile(File file) {
            this.mCopyFromFile = file;
            return this;
        }

        public Builder<T> createFromFile(File file, PrepackagedDatabaseCallback prepackagedDatabaseCallback) {
            this.mPrepackagedDatabaseCallback = prepackagedDatabaseCallback;
            this.mCopyFromFile = file;
            return this;
        }

        public Builder<T> createFromInputStream(Callable<InputStream> callable) {
            this.mCopyFromInputStream = callable;
            return this;
        }

        public Builder<T> createFromInputStream(Callable<InputStream> callable, PrepackagedDatabaseCallback prepackagedDatabaseCallback) {
            this.mPrepackagedDatabaseCallback = prepackagedDatabaseCallback;
            this.mCopyFromInputStream = callable;
            return this;
        }

        public Builder<T> enableMultiInstanceInvalidation() {
            Intent intent = this.mName != null ? new Intent(this.mContext, MultiInstanceInvalidationService.class) : null;
            this.mMultiInstanceInvalidationIntent = intent;
            return this;
        }

        public Builder<T> fallbackToDestructiveMigration() {
            this.mRequireMigration = false;
            this.mAllowDestructiveMigrationOnDowngrade = true;
            return this;
        }

        public Builder<T> fallbackToDestructiveMigrationFrom(int ... nArray) {
            if (this.mMigrationsNotRequiredFrom == null) {
                this.mMigrationsNotRequiredFrom = new HashSet<Integer>(nArray.length);
            }
            for (int n : nArray) {
                this.mMigrationsNotRequiredFrom.add(n);
            }
            return this;
        }

        public Builder<T> fallbackToDestructiveMigrationOnDowngrade() {
            this.mRequireMigration = true;
            this.mAllowDestructiveMigrationOnDowngrade = true;
            return this;
        }

        public Builder<T> openHelperFactory(SupportSQLiteOpenHelper.Factory factory) {
            this.mFactory = factory;
            return this;
        }

        public Builder<T> setAutoCloseTimeout(long l, TimeUnit timeUnit) {
            if (l >= 0L) {
                this.mAutoCloseTimeout = l;
                this.mAutoCloseTimeUnit = timeUnit;
                return this;
            }
            throw new IllegalArgumentException("autoCloseTimeout must be >= 0");
        }

        public Builder<T> setJournalMode(JournalMode journalMode) {
            this.mJournalMode = journalMode;
            return this;
        }

        public Builder<T> setMultiInstanceInvalidationServiceIntent(Intent intent) {
            if (this.mName == null) {
                intent = null;
            }
            this.mMultiInstanceInvalidationIntent = intent;
            return this;
        }

        public Builder<T> setQueryCallback(QueryCallback queryCallback, Executor executor) {
            this.mQueryCallback = queryCallback;
            this.mQueryCallbackExecutor = executor;
            return this;
        }

        public Builder<T> setQueryExecutor(Executor executor) {
            this.mQueryExecutor = executor;
            return this;
        }

        public Builder<T> setTransactionExecutor(Executor executor) {
            this.mTransactionExecutor = executor;
            return this;
        }
    }

    public static abstract class Callback {
        public void onCreate(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        public void onDestructiveMigration(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
        }
    }

    public static final class JournalMode
    extends Enum<JournalMode> {
        private static final /* synthetic */ JournalMode[] $VALUES;
        public static final /* enum */ JournalMode AUTOMATIC;
        public static final /* enum */ JournalMode TRUNCATE;
        public static final /* enum */ JournalMode WRITE_AHEAD_LOGGING;

        static {
            JournalMode journalMode;
            JournalMode journalMode2;
            JournalMode journalMode3;
            AUTOMATIC = journalMode3 = new JournalMode();
            TRUNCATE = journalMode2 = new JournalMode();
            WRITE_AHEAD_LOGGING = journalMode = new JournalMode();
            $VALUES = new JournalMode[]{journalMode3, journalMode2, journalMode};
        }

        private static boolean isLowRamDevice(ActivityManager activityManager) {
            if (Build.VERSION.SDK_INT >= 19) {
                return SupportSQLiteCompat.Api19Impl.isLowRamDevice(activityManager);
            }
            return false;
        }

        public static JournalMode valueOf(String string2) {
            return Enum.valueOf(JournalMode.class, string2);
        }

        public static JournalMode[] values() {
            return (JournalMode[])$VALUES.clone();
        }

        JournalMode resolve(Context context) {
            if (this != AUTOMATIC) {
                return this;
            }
            if (Build.VERSION.SDK_INT >= 16 && (context = (ActivityManager)context.getSystemService("activity")) != null && !JournalMode.isLowRamDevice((ActivityManager)context)) {
                return WRITE_AHEAD_LOGGING;
            }
            return TRUNCATE;
        }
    }

    public static class MigrationContainer {
        private HashMap<Integer, TreeMap<Integer, Migration>> mMigrations = new HashMap();

        private void addMigration(Migration migration) {
            int n = migration.startVersion;
            int n2 = migration.endVersion;
            Object object = this.mMigrations.get(n);
            TreeMap<Integer, Migration> treeMap = object;
            if (object == null) {
                treeMap = new TreeMap();
                this.mMigrations.put(n, treeMap);
            }
            if ((object = treeMap.get(n2)) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Overriding migration ");
                stringBuilder.append(object);
                stringBuilder.append(" with ");
                stringBuilder.append(migration);
                Log.w((String)"ROOM", (String)stringBuilder.toString());
            }
            treeMap.put(n2, migration);
        }

        /*
         * Enabled aggressive block sorting
         */
        private List<Migration> findUpMigrationPath(List<Migration> list, boolean bl, int n, int n2) {
            boolean bl2;
            do {
                int n3;
                boolean bl3;
                if (bl) {
                    if (n >= n2) return list;
                } else if (n <= n2) return list;
                TreeMap<Integer, Migration> treeMap = this.mMigrations.get(n);
                if (treeMap == null) {
                    return null;
                }
                Set<Integer> set = bl ? treeMap.descendingKeySet() : treeMap.keySet();
                set = set.iterator();
                do {
                    boolean bl4 = set.hasNext();
                    bl3 = true;
                    boolean bl5 = false;
                    if (!bl4) return null;
                    n3 = (Integer)set.next();
                    if (bl) {
                        bl2 = bl5;
                        if (n3 > n2) continue;
                        bl2 = bl5;
                        if (n3 <= n) continue;
                    } else {
                        bl2 = bl5;
                        if (n3 < n2) continue;
                        bl2 = bl5;
                        if (n3 >= n) continue;
                    }
                    bl2 = true;
                } while (!bl2);
                list.add(treeMap.get(n3));
                n = n3;
                bl2 = bl3;
            } while (bl2);
            return null;
        }

        public void addMigrations(List<Migration> object) {
            object = object.iterator();
            while (object.hasNext()) {
                this.addMigration((Migration)object.next());
            }
        }

        public void addMigrations(Migration ... migrationArray) {
            int n = migrationArray.length;
            for (int i = 0; i < n; ++i) {
                this.addMigration(migrationArray[i]);
            }
        }

        public List<Migration> findMigrationPath(int n, int n2) {
            if (n == n2) {
                return Collections.emptyList();
            }
            boolean bl = n2 > n;
            return this.findUpMigrationPath(new ArrayList<Migration>(), bl, n, n2);
        }

        public Map<Integer, Map<Integer, Migration>> getMigrations() {
            return Collections.unmodifiableMap(this.mMigrations);
        }
    }

    public static abstract class PrepackagedDatabaseCallback {
        public void onOpenPrepackagedDatabase(SupportSQLiteDatabase supportSQLiteDatabase) {
        }
    }

    public static interface QueryCallback {
        public void onQuery(String var1, List<Object> var2);
    }
}

