/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.database.Cursor;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomMasterTable;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;

public class RoomOpenHelper
extends SupportSQLiteOpenHelper.Callback {
    private DatabaseConfiguration mConfiguration;
    private final Delegate mDelegate;
    private final String mIdentityHash;
    private final String mLegacyHash;

    public RoomOpenHelper(DatabaseConfiguration databaseConfiguration, Delegate delegate, String string2) {
        this(databaseConfiguration, delegate, "", string2);
    }

    public RoomOpenHelper(DatabaseConfiguration databaseConfiguration, Delegate delegate, String string2, String string3) {
        super(delegate.version);
        this.mConfiguration = databaseConfiguration;
        this.mDelegate = delegate;
        this.mIdentityHash = string2;
        this.mLegacyHash = string3;
    }

    private void checkIdentity(SupportSQLiteDatabase object) {
        ValidationResult validationResult;
        block12: {
            block11: {
                if (RoomOpenHelper.hasRoomMasterTable((SupportSQLiteDatabase)object)) {
                    Object var2_3 = null;
                    Cursor cursor = object.query(new SimpleSQLiteQuery("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1"));
                    object = var2_3;
                    try {
                        if (cursor.moveToFirst()) {
                            object = cursor.getString(0);
                        }
                        if (!this.mIdentityHash.equals(object) && !this.mLegacyHash.equals(object)) {
                            throw new IllegalStateException("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number.");
                        }
                        break block11;
                    }
                    finally {
                        cursor.close();
                    }
                }
                validationResult = this.mDelegate.onValidateSchema((SupportSQLiteDatabase)object);
                if (!validationResult.isValid) break block12;
                this.mDelegate.onPostMigrate((SupportSQLiteDatabase)object);
                this.updateIdentity((SupportSQLiteDatabase)object);
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Pre-packaged database has an invalid schema: ");
        ((StringBuilder)object).append(validationResult.expectedFoundMsg);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    private void createMasterTableIfNotExists(SupportSQLiteDatabase supportSQLiteDatabase) {
        supportSQLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    private static boolean hasEmptySchema(SupportSQLiteDatabase supportSQLiteDatabase) {
        boolean bl;
        block3: {
            boolean bl2;
            supportSQLiteDatabase = supportSQLiteDatabase.query("SELECT count(*) FROM sqlite_master WHERE name != 'android_metadata'");
            try {
                boolean bl3 = supportSQLiteDatabase.moveToFirst();
                bl = bl2 = false;
                if (!bl3) break block3;
            }
            catch (Throwable throwable) {
                supportSQLiteDatabase.close();
                throw throwable;
            }
            int n = supportSQLiteDatabase.getInt(0);
            bl = bl2;
            if (n != 0) break block3;
            bl = true;
        }
        supportSQLiteDatabase.close();
        return bl;
    }

    private static boolean hasRoomMasterTable(SupportSQLiteDatabase supportSQLiteDatabase) {
        boolean bl;
        Cursor cursor;
        block3: {
            boolean bl2;
            cursor = supportSQLiteDatabase.query("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name='room_master_table'");
            try {
                boolean bl3 = cursor.moveToFirst();
                bl = bl2 = false;
                if (!bl3) break block3;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            int n = cursor.getInt(0);
            bl = bl2;
            if (n == 0) break block3;
            bl = true;
        }
        cursor.close();
        return bl;
    }

    private void updateIdentity(SupportSQLiteDatabase supportSQLiteDatabase) {
        this.createMasterTableIfNotExists(supportSQLiteDatabase);
        supportSQLiteDatabase.execSQL(RoomMasterTable.createInsertQuery(this.mIdentityHash));
    }

    @Override
    public void onConfigure(SupportSQLiteDatabase supportSQLiteDatabase) {
        super.onConfigure(supportSQLiteDatabase);
    }

    @Override
    public void onCreate(SupportSQLiteDatabase object) {
        boolean bl = RoomOpenHelper.hasEmptySchema((SupportSQLiteDatabase)object);
        this.mDelegate.createAllTables((SupportSQLiteDatabase)object);
        if (!bl) {
            ValidationResult validationResult = this.mDelegate.onValidateSchema((SupportSQLiteDatabase)object);
            if (!validationResult.isValid) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Pre-packaged database has an invalid schema: ");
                ((StringBuilder)object).append(validationResult.expectedFoundMsg);
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
        }
        this.updateIdentity((SupportSQLiteDatabase)object);
        this.mDelegate.onCreate((SupportSQLiteDatabase)object);
    }

    @Override
    public void onDowngrade(SupportSQLiteDatabase supportSQLiteDatabase, int n, int n2) {
        this.onUpgrade(supportSQLiteDatabase, n, n2);
    }

    @Override
    public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
        super.onOpen(supportSQLiteDatabase);
        this.checkIdentity(supportSQLiteDatabase);
        this.mDelegate.onOpen(supportSQLiteDatabase);
        this.mConfiguration = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onUpgrade(SupportSQLiteDatabase object, int n, int n2) {
        Object object2 = this.mConfiguration;
        if (object2 != null && (object2 = ((DatabaseConfiguration)object2).migrationContainer.findMigrationPath(n, n2)) != null) {
            this.mDelegate.onPreMigrate((SupportSQLiteDatabase)object);
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ((Migration)object2.next()).migrate((SupportSQLiteDatabase)object);
            }
            object2 = this.mDelegate.onValidateSchema((SupportSQLiteDatabase)object);
            if (((ValidationResult)object2).isValid) {
                this.mDelegate.onPostMigrate((SupportSQLiteDatabase)object);
                this.updateIdentity((SupportSQLiteDatabase)object);
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Migration didn't properly handle: ");
            ((StringBuilder)object).append(((ValidationResult)object2).expectedFoundMsg);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        boolean bl = false;
        if (bl) return;
        object2 = this.mConfiguration;
        if (object2 == null || ((DatabaseConfiguration)object2).isMigrationRequired(n, n2)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("A migration from ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(" to ");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(" was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(Migration ...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* methods.");
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        this.mDelegate.dropAllTables((SupportSQLiteDatabase)object);
        this.mDelegate.createAllTables((SupportSQLiteDatabase)object);
    }

    public static abstract class Delegate {
        public final int version;

        public Delegate(int n) {
            this.version = n;
        }

        protected abstract void createAllTables(SupportSQLiteDatabase var1);

        protected abstract void dropAllTables(SupportSQLiteDatabase var1);

        protected abstract void onCreate(SupportSQLiteDatabase var1);

        protected abstract void onOpen(SupportSQLiteDatabase var1);

        protected void onPostMigrate(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        protected void onPreMigrate(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        protected ValidationResult onValidateSchema(SupportSQLiteDatabase supportSQLiteDatabase) {
            this.validateMigration(supportSQLiteDatabase);
            return new ValidationResult(true, null);
        }

        @Deprecated
        protected void validateMigration(SupportSQLiteDatabase supportSQLiteDatabase) {
            throw new UnsupportedOperationException("validateMigration is deprecated");
        }
    }

    public static class ValidationResult {
        public final String expectedFoundMsg;
        public final boolean isValid;

        public ValidationResult(boolean bl, String string2) {
            this.isValid = bl;
            this.expectedFoundMsg = string2;
        }
    }
}

