/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Arrays;
import java.util.TreeMap;

public class RoomSQLiteQuery
implements SupportSQLiteQuery,
SupportSQLiteProgram {
    private static final int BLOB = 5;
    static final int DESIRED_POOL_SIZE = 10;
    private static final int DOUBLE = 3;
    private static final int LONG = 2;
    private static final int NULL = 1;
    static final int POOL_LIMIT = 15;
    private static final int STRING = 4;
    static final TreeMap<Integer, RoomSQLiteQuery> sQueryPool = new TreeMap();
    int mArgCount;
    private final int[] mBindingTypes;
    final byte[][] mBlobBindings;
    final int mCapacity;
    final double[] mDoubleBindings;
    final long[] mLongBindings;
    private volatile String mQuery;
    final String[] mStringBindings;

    private RoomSQLiteQuery(int n) {
        this.mCapacity = n++;
        this.mBindingTypes = new int[n];
        this.mLongBindings = new long[n];
        this.mDoubleBindings = new double[n];
        this.mStringBindings = new String[n];
        this.mBlobBindings = new byte[n][];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RoomSQLiteQuery acquire(String string2, int n) {
        Object object = sQueryPool;
        synchronized (object) {
            Object object2 = ((TreeMap)object).ceilingEntry(n);
            if (object2 != null) {
                ((TreeMap)object).remove(object2.getKey());
                object2 = object2.getValue();
                ((RoomSQLiteQuery)object2).init(string2, n);
                return object2;
            }
        }
        object = new RoomSQLiteQuery(n);
        ((RoomSQLiteQuery)object).init(string2, n);
        return object;
    }

    public static RoomSQLiteQuery copyFrom(SupportSQLiteQuery supportSQLiteQuery) {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire(supportSQLiteQuery.getSql(), supportSQLiteQuery.getArgCount());
        supportSQLiteQuery.bindTo(new SupportSQLiteProgram(){

            @Override
            public void bindBlob(int n, byte[] byArray) {
                RoomSQLiteQuery.this.bindBlob(n, byArray);
            }

            @Override
            public void bindDouble(int n, double d) {
                RoomSQLiteQuery.this.bindDouble(n, d);
            }

            @Override
            public void bindLong(int n, long l) {
                RoomSQLiteQuery.this.bindLong(n, l);
            }

            @Override
            public void bindNull(int n) {
                RoomSQLiteQuery.this.bindNull(n);
            }

            @Override
            public void bindString(int n, String string2) {
                RoomSQLiteQuery.this.bindString(n, string2);
            }

            @Override
            public void clearBindings() {
                RoomSQLiteQuery.this.clearBindings();
            }

            @Override
            public void close() {
            }
        });
        return roomSQLiteQuery;
    }

    private static void prunePoolLocked() {
        TreeMap<Integer, RoomSQLiteQuery> treeMap = sQueryPool;
        if (treeMap.size() > 15) {
            int n = treeMap.size() - 10;
            treeMap = treeMap.descendingKeySet().iterator();
            while (n > 0) {
                treeMap.next();
                treeMap.remove();
                --n;
            }
        }
    }

    @Override
    public void bindBlob(int n, byte[] byArray) {
        this.mBindingTypes[n] = 5;
        this.mBlobBindings[n] = byArray;
    }

    @Override
    public void bindDouble(int n, double d) {
        this.mBindingTypes[n] = 3;
        this.mDoubleBindings[n] = d;
    }

    @Override
    public void bindLong(int n, long l) {
        this.mBindingTypes[n] = 2;
        this.mLongBindings[n] = l;
    }

    @Override
    public void bindNull(int n) {
        this.mBindingTypes[n] = 1;
    }

    @Override
    public void bindString(int n, String string2) {
        this.mBindingTypes[n] = 4;
        this.mStringBindings[n] = string2;
    }

    @Override
    public void bindTo(SupportSQLiteProgram supportSQLiteProgram) {
        for (int i = 1; i <= this.mArgCount; ++i) {
            int n = this.mBindingTypes[i];
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) continue;
                            supportSQLiteProgram.bindBlob(i, this.mBlobBindings[i]);
                            continue;
                        }
                        supportSQLiteProgram.bindString(i, this.mStringBindings[i]);
                        continue;
                    }
                    supportSQLiteProgram.bindDouble(i, this.mDoubleBindings[i]);
                    continue;
                }
                supportSQLiteProgram.bindLong(i, this.mLongBindings[i]);
                continue;
            }
            supportSQLiteProgram.bindNull(i);
        }
    }

    @Override
    public void clearBindings() {
        Arrays.fill(this.mBindingTypes, 1);
        Arrays.fill(this.mStringBindings, null);
        Arrays.fill((Object[])this.mBlobBindings, null);
        this.mQuery = null;
    }

    @Override
    public void close() {
    }

    public void copyArgumentsFrom(RoomSQLiteQuery roomSQLiteQuery) {
        int n = roomSQLiteQuery.getArgCount() + 1;
        System.arraycopy(roomSQLiteQuery.mBindingTypes, 0, this.mBindingTypes, 0, n);
        System.arraycopy(roomSQLiteQuery.mLongBindings, 0, this.mLongBindings, 0, n);
        System.arraycopy(roomSQLiteQuery.mStringBindings, 0, this.mStringBindings, 0, n);
        System.arraycopy(roomSQLiteQuery.mBlobBindings, 0, this.mBlobBindings, 0, n);
        System.arraycopy(roomSQLiteQuery.mDoubleBindings, 0, this.mDoubleBindings, 0, n);
    }

    @Override
    public int getArgCount() {
        return this.mArgCount;
    }

    @Override
    public String getSql() {
        return this.mQuery;
    }

    void init(String string2, int n) {
        this.mQuery = string2;
        this.mArgCount = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        TreeMap<Integer, RoomSQLiteQuery> treeMap = sQueryPool;
        synchronized (treeMap) {
            treeMap.put(this.mCapacity, this);
            RoomSQLiteQuery.prunePoolLocked();
            return;
        }
    }
}

