/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import androidx.room.InvalidationLiveDataContainer;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class RoomTrackingLiveData<T>
extends LiveData<T> {
    final Callable<T> mComputeFunction;
    final AtomicBoolean mComputing;
    private final InvalidationLiveDataContainer mContainer;
    final RoomDatabase mDatabase;
    final boolean mInTransaction;
    final AtomicBoolean mInvalid = new AtomicBoolean(true);
    final Runnable mInvalidationRunnable;
    final InvalidationTracker.Observer mObserver;
    final Runnable mRefreshRunnable;
    final AtomicBoolean mRegisteredObserver;

    RoomTrackingLiveData(RoomDatabase roomDatabase, InvalidationLiveDataContainer invalidationLiveDataContainer, boolean bl, Callable<T> callable, String[] stringArray) {
        this.mComputing = new AtomicBoolean(false);
        this.mRegisteredObserver = new AtomicBoolean(false);
        this.mRefreshRunnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                if (RoomTrackingLiveData.this.mRegisteredObserver.compareAndSet(false, true)) {
                    RoomTrackingLiveData.this.mDatabase.getInvalidationTracker().addWeakObserver(RoomTrackingLiveData.this.mObserver);
                }
                do {
                    if (!RoomTrackingLiveData.this.mComputing.compareAndSet(false, true)) return;
                    RuntimeException runtimeException = null;
                    boolean bl = false;
                    try {
                        boolean bl2;
                        while (bl2 = RoomTrackingLiveData.this.mInvalid.compareAndSet(true, false)) {
                            try {
                                runtimeException = RoomTrackingLiveData.this.mComputeFunction.call();
                                bl = true;
                            }
                            catch (Exception exception) {
                                runtimeException = new RuntimeException("Exception while computing database live data.", exception);
                                throw runtimeException;
                            }
                        }
                        if (bl) {
                            RoomTrackingLiveData.this.postValue(runtimeException);
                        }
                    }
                    finally {
                        RoomTrackingLiveData.this.mComputing.set(false);
                    }
                    if (!bl) return;
                } while (RoomTrackingLiveData.this.mInvalid.get());
            }
        };
        this.mInvalidationRunnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = RoomTrackingLiveData.this.hasActiveObservers();
                if (RoomTrackingLiveData.this.mInvalid.compareAndSet(false, true) && bl) {
                    RoomTrackingLiveData.this.getQueryExecutor().execute(RoomTrackingLiveData.this.mRefreshRunnable);
                }
            }
        };
        this.mDatabase = roomDatabase;
        this.mInTransaction = bl;
        this.mComputeFunction = callable;
        this.mContainer = invalidationLiveDataContainer;
        this.mObserver = new InvalidationTracker.Observer(stringArray){

            @Override
            public void onInvalidated(Set<String> set) {
                ArchTaskExecutor.getInstance().executeOnMainThread(RoomTrackingLiveData.this.mInvalidationRunnable);
            }
        };
    }

    Executor getQueryExecutor() {
        if (this.mInTransaction) {
            return this.mDatabase.getTransactionExecutor();
        }
        return this.mDatabase.getQueryExecutor();
    }

    @Override
    protected void onActive() {
        super.onActive();
        this.mContainer.onActive(this);
        this.getQueryExecutor().execute(this.mRefreshRunnable);
    }

    @Override
    protected void onInactive() {
        super.onInactive();
        this.mContainer.onInactive(this);
    }
}

