/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.DelegatingOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.FileUtil;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;

class SQLiteCopyOpenHelper
implements SupportSQLiteOpenHelper,
DelegatingOpenHelper {
    private final Context mContext;
    private final String mCopyFromAssetPath;
    private final File mCopyFromFile;
    private final Callable<InputStream> mCopyFromInputStream;
    private DatabaseConfiguration mDatabaseConfiguration;
    private final int mDatabaseVersion;
    private final SupportSQLiteOpenHelper mDelegate;
    private boolean mVerified;

    SQLiteCopyOpenHelper(Context context, String string2, File file, Callable<InputStream> callable, int n, SupportSQLiteOpenHelper supportSQLiteOpenHelper) {
        this.mContext = context;
        this.mCopyFromAssetPath = string2;
        this.mCopyFromFile = file;
        this.mCopyFromInputStream = callable;
        this.mDatabaseVersion = n;
        this.mDelegate = supportSQLiteOpenHelper;
    }

    private void copyDatabaseFile(File file, boolean bl) throws IOException {
        block10: {
            Callable<InputStream> callable;
            block8: {
                block9: {
                    block7: {
                        if (this.mCopyFromAssetPath == null) break block7;
                        callable = Channels.newChannel(this.mContext.getAssets().open(this.mCopyFromAssetPath));
                        break block8;
                    }
                    if (this.mCopyFromFile == null) break block9;
                    callable = new FileInputStream(this.mCopyFromFile).getChannel();
                    break block8;
                }
                callable = this.mCopyFromInputStream;
                if (callable == null) break block10;
                try {
                    callable = (InputStream)callable.call();
                }
                catch (Exception exception) {
                    throw new IOException("inputStreamCallable exception on call", exception);
                }
                callable = Channels.newChannel((InputStream)((Object)callable));
            }
            File file2 = File.createTempFile("room-copy-helper", ".tmp", this.mContext.getCacheDir());
            file2.deleteOnExit();
            FileUtil.copy((ReadableByteChannel)((Object)callable), new FileOutputStream(file2).getChannel());
            callable = file.getParentFile();
            if (callable != null && !((File)((Object)callable)).exists() && !((File)((Object)callable)).mkdirs()) {
                callable = new StringBuilder();
                ((StringBuilder)((Object)callable)).append("Failed to create directories for ");
                ((StringBuilder)((Object)callable)).append(file.getAbsolutePath());
                throw new IOException(((StringBuilder)((Object)callable)).toString());
            }
            this.dispatchOnOpenPrepackagedDatabase(file2, bl);
            if (file2.renameTo(file)) {
                return;
            }
            callable = new StringBuilder();
            ((StringBuilder)((Object)callable)).append("Failed to move intermediate file (");
            ((StringBuilder)((Object)callable)).append(file2.getAbsolutePath());
            ((StringBuilder)((Object)callable)).append(") to destination (");
            ((StringBuilder)((Object)callable)).append(file.getAbsolutePath());
            ((StringBuilder)((Object)callable)).append(").");
            throw new IOException(((StringBuilder)((Object)callable)).toString());
        }
        throw new IllegalStateException("copyFromAssetPath, copyFromFile and copyFromInputStream are all null!");
    }

    private SupportSQLiteOpenHelper createFrameworkOpenHelper(File file) {
        try {
            int n = DBUtil.readVersion(file);
            return new FrameworkSQLiteOpenHelperFactory().create(SupportSQLiteOpenHelper.Configuration.builder(this.mContext).name(file.getAbsolutePath()).callback(new SupportSQLiteOpenHelper.Callback(Math.max(n, 1)){

                @Override
                public void onCreate(SupportSQLiteDatabase supportSQLiteDatabase) {
                }

                @Override
                public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
                    if (this.version < 1) {
                        supportSQLiteDatabase.setVersion(this.version);
                    }
                }

                @Override
                public void onUpgrade(SupportSQLiteDatabase supportSQLiteDatabase, int n, int n2) {
                }
            }).build());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Malformed database file, unable to read version.", iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void dispatchOnOpenPrepackagedDatabase(File var1_1, boolean var2_3) {
        block3: {
            var3_4 = this.mDatabaseConfiguration;
            if (var3_4 == null || var3_4.prepackagedDatabaseCallback == null) break block3;
            var3_4 = this.createFrameworkOpenHelper((File)var1_1);
            if (!var2_3) ** GOTO lbl8
            try {
                block4: {
                    var1_1 = var3_4.getWritableDatabase();
                    break block4;
lbl8:
                    // 1 sources

                    var1_1 = var3_4.getReadableDatabase();
                }
                this.mDatabaseConfiguration.prepackagedDatabaseCallback.onOpenPrepackagedDatabase((SupportSQLiteDatabase)var1_1);
                return;
            }
            finally {
                var3_4.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void verifyDatabaseFile(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        synchronized (this) {
            this.mDelegate.close();
            this.mVerified = false;
            return;
        }
    }

    @Override
    public String getDatabaseName() {
        return this.mDelegate.getDatabaseName();
    }

    @Override
    public SupportSQLiteOpenHelper getDelegate() {
        return this.mDelegate;
    }

    @Override
    public SupportSQLiteDatabase getReadableDatabase() {
        synchronized (this) {
            if (!this.mVerified) {
                this.verifyDatabaseFile(false);
                this.mVerified = true;
            }
            SupportSQLiteDatabase supportSQLiteDatabase = this.mDelegate.getReadableDatabase();
            return supportSQLiteDatabase;
        }
    }

    @Override
    public SupportSQLiteDatabase getWritableDatabase() {
        synchronized (this) {
            if (!this.mVerified) {
                this.verifyDatabaseFile(true);
                this.mVerified = true;
            }
            SupportSQLiteDatabase supportSQLiteDatabase = this.mDelegate.getWritableDatabase();
            return supportSQLiteDatabase;
        }
    }

    void setDatabaseConfiguration(DatabaseConfiguration databaseConfiguration) {
        this.mDatabaseConfiguration = databaseConfiguration;
    }

    @Override
    public void setWriteAheadLoggingEnabled(boolean bl) {
        this.mDelegate.setWriteAheadLoggingEnabled(bl);
    }
}

