/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import java.util.ArrayDeque;
import java.util.concurrent.Executor;

class TransactionExecutor
implements Executor {
    private Runnable mActive;
    private final Executor mExecutor;
    private final ArrayDeque<Runnable> mTasks = new ArrayDeque();

    TransactionExecutor(Executor executor) {
        this.mExecutor = executor;
    }

    @Override
    public void execute(final Runnable runnable) {
        synchronized (this) {
            ArrayDeque<Runnable> arrayDeque = this.mTasks;
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                        return;
                    }
                    finally {
                        TransactionExecutor.this.scheduleNext();
                    }
                }
            };
            arrayDeque.offer(runnable2);
            if (this.mActive == null) {
                this.scheduleNext();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scheduleNext() {
        synchronized (this) {
            Runnable runnable;
            this.mActive = runnable = this.mTasks.poll();
            if (runnable != null) {
                this.mExecutor.execute(runnable);
            }
            return;
        }
    }
}

