/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging;

import android.database.Cursor;
import androidx.paging.PositionalDataSource;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class LimitOffsetDataSource<T>
extends PositionalDataSource<T> {
    private final String mCountQuery;
    private final RoomDatabase mDb;
    private final boolean mInTransaction;
    private final String mLimitOffsetQuery;
    private final InvalidationTracker.Observer mObserver;
    private final AtomicBoolean mRegisteredObserver = new AtomicBoolean(false);
    private final RoomSQLiteQuery mSourceQuery;

    protected LimitOffsetDataSource(RoomDatabase object, RoomSQLiteQuery roomSQLiteQuery, boolean bl, boolean bl2, String ... stringArray) {
        this.mDb = object;
        this.mSourceQuery = roomSQLiteQuery;
        this.mInTransaction = bl;
        object = new StringBuilder();
        ((StringBuilder)object).append("SELECT COUNT(*) FROM ( ");
        ((StringBuilder)object).append(roomSQLiteQuery.getSql());
        ((StringBuilder)object).append(" )");
        this.mCountQuery = ((StringBuilder)object).toString();
        object = new StringBuilder();
        ((StringBuilder)object).append("SELECT * FROM ( ");
        ((StringBuilder)object).append(roomSQLiteQuery.getSql());
        ((StringBuilder)object).append(" ) LIMIT ? OFFSET ?");
        this.mLimitOffsetQuery = ((StringBuilder)object).toString();
        this.mObserver = new InvalidationTracker.Observer(stringArray){

            @Override
            public void onInvalidated(Set<String> set) {
                LimitOffsetDataSource.this.invalidate();
            }
        };
        if (bl2) {
            this.registerObserverIfNecessary();
        }
    }

    protected LimitOffsetDataSource(RoomDatabase roomDatabase, RoomSQLiteQuery roomSQLiteQuery, boolean bl, String ... stringArray) {
        this(roomDatabase, roomSQLiteQuery, bl, true, stringArray);
    }

    protected LimitOffsetDataSource(RoomDatabase roomDatabase, SupportSQLiteQuery supportSQLiteQuery, boolean bl, boolean bl2, String ... stringArray) {
        this(roomDatabase, RoomSQLiteQuery.copyFrom(supportSQLiteQuery), bl, bl2, stringArray);
    }

    protected LimitOffsetDataSource(RoomDatabase roomDatabase, SupportSQLiteQuery supportSQLiteQuery, boolean bl, String ... stringArray) {
        this(roomDatabase, RoomSQLiteQuery.copyFrom(supportSQLiteQuery), bl, stringArray);
    }

    private RoomSQLiteQuery getSQLiteQuery(int n, int n2) {
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire(this.mLimitOffsetQuery, this.mSourceQuery.getArgCount() + 2);
        roomSQLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        roomSQLiteQuery.bindLong(roomSQLiteQuery.getArgCount() - 1, n2);
        roomSQLiteQuery.bindLong(roomSQLiteQuery.getArgCount(), n);
        return roomSQLiteQuery;
    }

    private void registerObserverIfNecessary() {
        if (this.mRegisteredObserver.compareAndSet(false, true)) {
            this.mDb.getInvalidationTracker().addWeakObserver(this.mObserver);
        }
    }

    protected abstract List<T> convertRows(Cursor var1);

    public int countItems() {
        this.registerObserverIfNecessary();
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire(this.mCountQuery, this.mSourceQuery.getArgCount());
        roomSQLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        Cursor cursor = this.mDb.query(roomSQLiteQuery);
        try {
            if (cursor.moveToFirst()) {
                int n = cursor.getInt(0);
                return n;
            }
            return 0;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    public boolean isInvalid() {
        this.registerObserverIfNecessary();
        this.mDb.getInvalidationTracker().refreshVersionsSync();
        return super.isInvalid();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadInitial(PositionalDataSource.LoadInitialParams object, PositionalDataSource.LoadInitialCallback<T> loadInitialCallback) {
        void var2_5;
        RoomSQLiteQuery roomSQLiteQuery;
        block9: {
            int n;
            int n2;
            Cursor cursor;
            block10: {
                Cursor cursor2;
                List list;
                block8: {
                    this.registerObserverIfNecessary();
                    list = Collections.emptyList();
                    this.mDb.beginTransaction();
                    cursor2 = null;
                    cursor = null;
                    Object var6_9 = null;
                    try {
                        n2 = this.countItems();
                        if (n2 == 0) break block8;
                        n = LimitOffsetDataSource.computeInitialLoadPosition((PositionalDataSource.LoadInitialParams)object, (int)n2);
                        roomSQLiteQuery = this.getSQLiteQuery(n, LimitOffsetDataSource.computeInitialLoadSize((PositionalDataSource.LoadInitialParams)object, (int)n, (int)n2));
                        object = var6_9;
                    }
                    catch (Throwable throwable) {
                        roomSQLiteQuery = null;
                        object = cursor;
                        break block9;
                    }
                    try {
                        cursor = this.mDb.query(roomSQLiteQuery);
                        object = cursor;
                        list = this.convertRows(cursor);
                        object = cursor;
                        this.mDb.setTransactionSuccessful();
                        object = list;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        break block9;
                    }
                }
                n = 0;
                roomSQLiteQuery = null;
                cursor = cursor2;
                object = list;
            }
            if (cursor != null) {
                cursor.close();
            }
            this.mDb.endTransaction();
            if (roomSQLiteQuery != null) {
                roomSQLiteQuery.release();
            }
            loadInitialCallback.onResult((List)object, n, n2);
            return;
        }
        if (object != null) {
            object.close();
        }
        this.mDb.endTransaction();
        if (roomSQLiteQuery != null) {
            roomSQLiteQuery.release();
        }
        throw var2_5;
    }

    public List<T> loadRange(int n, int n2) {
        RoomSQLiteQuery roomSQLiteQuery = this.getSQLiteQuery(n, n2);
        if (this.mInTransaction) {
            List<T> list;
            block9: {
                Cursor cursor;
                this.mDb.beginTransaction();
                Cursor cursor2 = null;
                try {
                    cursor2 = cursor = this.mDb.query(roomSQLiteQuery);
                }
                catch (Throwable throwable) {
                    if (cursor2 != null) {
                        cursor2.close();
                    }
                    this.mDb.endTransaction();
                    roomSQLiteQuery.release();
                    throw throwable;
                }
                list = this.convertRows(cursor);
                cursor2 = cursor;
                this.mDb.setTransactionSuccessful();
                if (cursor == null) break block9;
                cursor.close();
            }
            this.mDb.endTransaction();
            roomSQLiteQuery.release();
            return list;
        }
        Cursor cursor = this.mDb.query(roomSQLiteQuery);
        try {
            List<T> list = this.convertRows(cursor);
            return list;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    public void loadRange(PositionalDataSource.LoadRangeParams loadRangeParams, PositionalDataSource.LoadRangeCallback<T> loadRangeCallback) {
        loadRangeCallback.onResult(this.loadRange(loadRangeParams.startPosition, loadRangeParams.loadSize));
    }
}

