/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import android.database.MatrixCursor;
import android.os.Build;
import android.util.Log;
import java.util.Arrays;

public class CursorUtil {
    private CursorUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Cursor copyAndClose(Cursor cursor) {
        try {
            MatrixCursor matrixCursor = new MatrixCursor(cursor.getColumnNames(), cursor.getCount());
            while (cursor.moveToNext()) {
                Object object = new Object[cursor.getColumnCount()];
                for (int i = 0; i < cursor.getColumnCount(); ++i) {
                    int n = cursor.getType(i);
                    if (n != 0) {
                        if (n != 1) {
                            if (n != 2) {
                                if (n != 3) {
                                    if (n != 4) {
                                        object = new IllegalStateException();
                                        throw object;
                                    }
                                    object[i] = cursor.getBlob(i);
                                    continue;
                                }
                                object[i] = cursor.getString(i);
                                continue;
                            }
                            object[i] = cursor.getDouble(i);
                            continue;
                        }
                        object[i] = cursor.getLong(i);
                        continue;
                    }
                    object[i] = null;
                }
                matrixCursor.addRow(object);
            }
            return matrixCursor;
        }
        finally {
            cursor.close();
        }
    }

    private static int findColumnIndexBySuffix(Cursor cursor, String string2) {
        if (Build.VERSION.SDK_INT > 25) {
            return -1;
        }
        if (string2.length() == 0) {
            return -1;
        }
        return CursorUtil.findColumnIndexBySuffix(cursor.getColumnNames(), string2);
    }

    static int findColumnIndexBySuffix(String[] stringArray, String string2) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append(".");
        charSequence.append(string2);
        charSequence = charSequence.toString();
        CharSequence charSequence2 = new StringBuilder();
        ((StringBuilder)charSequence2).append(".");
        ((StringBuilder)charSequence2).append(string2);
        ((StringBuilder)charSequence2).append("`");
        String string3 = ((StringBuilder)charSequence2).toString();
        for (int i = 0; i < stringArray.length; ++i) {
            charSequence2 = stringArray[i];
            if (((String)charSequence2).length() < string2.length() + 2) continue;
            if (((String)charSequence2).endsWith((String)charSequence)) {
                return i;
            }
            if (((String)charSequence2).charAt(0) != '`' || !((String)charSequence2).endsWith(string3)) continue;
            return i;
        }
        return -1;
    }

    public static int getColumnIndex(Cursor cursor, String string2) {
        int n = cursor.getColumnIndex(string2);
        if (n >= 0) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("`");
        stringBuilder.append(string2);
        stringBuilder.append("`");
        n = cursor.getColumnIndex(stringBuilder.toString());
        if (n >= 0) {
            return n;
        }
        return CursorUtil.findColumnIndexBySuffix(cursor, string2);
    }

    public static int getColumnIndexOrThrow(Cursor object, String string2) {
        int n = CursorUtil.getColumnIndex(object, string2);
        if (n >= 0) {
            return n;
        }
        try {
            object = Arrays.toString(object.getColumnNames());
        }
        catch (Exception exception) {
            Log.d((String)"RoomCursorUtil", (String)"Cannot collect column names for debug purposes", (Throwable)exception);
            object = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("column '");
        stringBuilder.append(string2);
        stringBuilder.append("' does not exist. Available columns: ");
        stringBuilder.append((String)object);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

