/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.os.Build;
import android.os.CancellationSignal;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DBUtil {
    private DBUtil() {
    }

    public static CancellationSignal createCancellationSignal() {
        if (Build.VERSION.SDK_INT >= 16) {
            return SupportSQLiteCompat.Api16Impl.createCancellationSignal();
        }
        return null;
    }

    public static void dropFtsSyncTriggers(SupportSQLiteDatabase supportSQLiteDatabase) {
        Serializable serializable = new ArrayList<String>();
        Object object = supportSQLiteDatabase.query("SELECT name FROM sqlite_master WHERE type = 'trigger'");
        while (object.moveToNext()) {
            serializable.add(object.getString(0));
        }
        object = serializable.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (!string2.startsWith("room_fts_content_sync_")) continue;
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("DROP TRIGGER IF EXISTS ");
            ((StringBuilder)serializable).append(string2);
            supportSQLiteDatabase.execSQL(((StringBuilder)serializable).toString());
        }
        return;
        finally {
            object.close();
        }
    }

    public static void foreignKeyCheck(SupportSQLiteDatabase supportSQLiteDatabase, String string2) {
        Serializable serializable;
        block3: {
            serializable = new StringBuilder();
            serializable.append("PRAGMA foreign_key_check(`");
            serializable.append(string2);
            serializable.append("`)");
            supportSQLiteDatabase = supportSQLiteDatabase.query(serializable.toString());
            try {
                int n = supportSQLiteDatabase.getCount();
                if (n > 0) break block3;
            }
            catch (Throwable throwable) {
                supportSQLiteDatabase.close();
                throw throwable;
            }
            supportSQLiteDatabase.close();
            return;
        }
        string2 = DBUtil.processForeignKeyCheckFailure((Cursor)supportSQLiteDatabase);
        serializable = new IllegalStateException(string2);
        throw serializable;
    }

    /*
     * WARNING - void declaration
     */
    private static String processForeignKeyCheckFailure(Cursor object) {
        void var3_4;
        int n = object.getCount();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object22 = null;
        while (object.moveToNext()) {
            Object object2 = var3_4;
            if (var3_4 == null) {
                object2 = object.getString(0);
            }
            String string2 = object.getString(3);
            String string3 = object2;
            if (hashMap.containsKey(string2)) continue;
            hashMap.put(string2, object.getString(2));
            String string4 = object2;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Foreign key violation(s) detected in '");
        ((StringBuilder)object).append((String)var3_4);
        ((StringBuilder)object).append("'.\n");
        ((StringBuilder)object).append("Number of different violations discovered: ");
        ((StringBuilder)object).append(hashMap.keySet().size());
        ((StringBuilder)object).append("\n");
        ((StringBuilder)object).append("Number of rows in violation: ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append("\n");
        ((StringBuilder)object).append("Violation(s) detected in the following constraint(s):\n");
        for (Map.Entry entry : hashMap.entrySet()) {
            ((StringBuilder)object).append("\tParent Table = ");
            ((StringBuilder)object).append((String)entry.getValue());
            ((StringBuilder)object).append(", Foreign Key Constraint Index = ");
            ((StringBuilder)object).append((String)entry.getKey());
            ((StringBuilder)object).append("\n");
        }
        return ((StringBuilder)object).toString();
    }

    @Deprecated
    public static Cursor query(RoomDatabase roomDatabase, SupportSQLiteQuery supportSQLiteQuery, boolean bl) {
        return DBUtil.query(roomDatabase, supportSQLiteQuery, bl, null);
    }

    public static Cursor query(RoomDatabase object, SupportSQLiteQuery supportSQLiteQuery, boolean bl, CancellationSignal cancellationSignal) {
        block2: {
            block3: {
                supportSQLiteQuery = ((RoomDatabase)object).query(supportSQLiteQuery, cancellationSignal);
                object = supportSQLiteQuery;
                if (!bl) break block2;
                object = supportSQLiteQuery;
                if (!(supportSQLiteQuery instanceof AbstractWindowedCursor)) break block2;
                cancellationSignal = (AbstractWindowedCursor)supportSQLiteQuery;
                int n = cancellationSignal.getCount();
                int n2 = cancellationSignal.hasWindow() ? cancellationSignal.getWindow().getNumRows() : n;
                if (Build.VERSION.SDK_INT < 23) break block3;
                object = supportSQLiteQuery;
                if (n2 >= n) break block2;
            }
            object = CursorUtil.copyAndClose((Cursor)cancellationSignal);
        }
        return object;
    }

    public static int readVersion(File object) throws IOException {
        Object object2;
        Object object3;
        block14: {
            int n;
            block15: {
                ByteBuffer byteBuffer;
                object2 = object3 = null;
                try {
                    byteBuffer = ByteBuffer.allocate(4);
                    object2 = object3;
                    object2 = object3;
                }
                catch (Throwable throwable) {
                    if (object2 != null) {
                        ((AbstractInterruptibleChannel)object2).close();
                    }
                    throw throwable;
                }
                FileInputStream fileInputStream = new FileInputStream((File)object);
                object2 = object3;
                object2 = object = fileInputStream.getChannel();
                ((FileChannel)object).tryLock(60L, 4L, true);
                object2 = object;
                ((FileChannel)object).position(60L);
                object2 = object;
                if (((FileChannel)object).read(byteBuffer) != 4) break block14;
                object2 = object;
                byteBuffer.rewind();
                object2 = object;
                n = byteBuffer.getInt();
                if (object == null) break block15;
                ((AbstractInterruptibleChannel)object).close();
            }
            return n;
        }
        object2 = object;
        object2 = object;
        object3 = new IOException("Bad database header, unable to read 4 bytes at offset 60");
        object2 = object;
        throw object3;
    }
}

