/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import android.os.Build;
import androidx.room.Index;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class TableInfo {
    public static final int CREATED_FROM_DATABASE = 2;
    public static final int CREATED_FROM_ENTITY = 1;
    public static final int CREATED_FROM_UNKNOWN = 0;
    public final Map<String, Column> columns;
    public final Set<ForeignKey> foreignKeys;
    public final Set<Index> indices;
    public final String name;

    public TableInfo(String string2, Map<String, Column> map, Set<ForeignKey> set) {
        this(string2, map, set, Collections.emptySet());
    }

    public TableInfo(String object, Map<String, Column> map, Set<ForeignKey> set, Set<Index> set2) {
        this.name = object;
        this.columns = Collections.unmodifiableMap(map);
        this.foreignKeys = Collections.unmodifiableSet(set);
        object = set2 == null ? null : Collections.unmodifiableSet(set2);
        this.indices = object;
    }

    public static TableInfo read(SupportSQLiteDatabase supportSQLiteDatabase, String string2) {
        return new TableInfo(string2, TableInfo.readColumns(supportSQLiteDatabase, string2), TableInfo.readForeignKeys(supportSQLiteDatabase, string2), TableInfo.readIndices(supportSQLiteDatabase, string2));
    }

    private static Map<String, Column> readColumns(SupportSQLiteDatabase supportSQLiteDatabase, String object) {
        block4: {
            boolean bl;
            String string2;
            String string3;
            int n;
            int n2;
            CharSequence charSequence = new StringBuilder();
            charSequence.append("PRAGMA table_info(`");
            charSequence.append((String)object);
            charSequence.append("`)");
            supportSQLiteDatabase = supportSQLiteDatabase.query(charSequence.toString());
            object = new HashMap();
            try {
                if (supportSQLiteDatabase.getColumnCount() <= 0) break block4;
                int n3 = supportSQLiteDatabase.getColumnIndex("name");
                int n4 = supportSQLiteDatabase.getColumnIndex("type");
                int n5 = supportSQLiteDatabase.getColumnIndex("notnull");
                n2 = supportSQLiteDatabase.getColumnIndex("pk");
                n = supportSQLiteDatabase.getColumnIndex("dflt_value");
                while (supportSQLiteDatabase.moveToNext()) {
                    string3 = supportSQLiteDatabase.getString(n3);
                    string2 = supportSQLiteDatabase.getString(n4);
                    bl = supportSQLiteDatabase.getInt(n5) != 0;
                }
            }
            catch (Throwable throwable) {
                supportSQLiteDatabase.close();
                throw throwable;
            }
            {
                int n6 = supportSQLiteDatabase.getInt(n2);
                charSequence = supportSQLiteDatabase.getString(n);
                Column column = new Column(string3, string2, bl, n6, (String)charSequence, 2);
                object.put(string3, column);
                continue;
            }
        }
        supportSQLiteDatabase.close();
        return object;
    }

    private static List<ForeignKeyWithSequence> readForeignKeyFieldMappings(Cursor cursor) {
        int n = cursor.getColumnIndex("id");
        int n2 = cursor.getColumnIndex("seq");
        int n3 = cursor.getColumnIndex("from");
        int n4 = cursor.getColumnIndex("to");
        int n5 = cursor.getCount();
        ArrayList<ForeignKeyWithSequence> arrayList = new ArrayList<ForeignKeyWithSequence>();
        for (int i = 0; i < n5; ++i) {
            cursor.moveToPosition(i);
            arrayList.add(new ForeignKeyWithSequence(cursor.getInt(n), cursor.getInt(n2), cursor.getString(n3), cursor.getString(n4)));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static Set<ForeignKey> readForeignKeys(SupportSQLiteDatabase supportSQLiteDatabase, String object) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        HashSet<ForeignKey> hashSet = new HashSet<ForeignKey>();
        Serializable serializable = new StringBuilder();
        ((StringBuilder)serializable).append("PRAGMA foreign_key_list(`");
        ((StringBuilder)serializable).append((String)object);
        ((StringBuilder)serializable).append("`)");
        supportSQLiteDatabase = supportSQLiteDatabase.query(((StringBuilder)serializable).toString());
        try {
            n6 = supportSQLiteDatabase.getColumnIndex("id");
            n5 = supportSQLiteDatabase.getColumnIndex("seq");
            n4 = supportSQLiteDatabase.getColumnIndex("table");
            n3 = supportSQLiteDatabase.getColumnIndex("on_delete");
            n2 = supportSQLiteDatabase.getColumnIndex("on_update");
            object = TableInfo.readForeignKeyFieldMappings((Cursor)supportSQLiteDatabase);
            n = supportSQLiteDatabase.getCount();
        }
        catch (Throwable throwable) {
            supportSQLiteDatabase.close();
            throw throwable;
        }
        for (int i = 0; i < n; ++i) {
            supportSQLiteDatabase.moveToPosition(i);
            if (supportSQLiteDatabase.getInt(n5) != 0) continue;
            int n7 = supportSQLiteDatabase.getInt(n6);
            serializable = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                ForeignKeyWithSequence foreignKeyWithSequence = (ForeignKeyWithSequence)object2.next();
                if (foreignKeyWithSequence.mId != n7) continue;
                serializable.add(foreignKeyWithSequence.mFrom);
                arrayList.add(foreignKeyWithSequence.mTo);
            }
            object2 = new ForeignKey(supportSQLiteDatabase.getString(n4), supportSQLiteDatabase.getString(n3), supportSQLiteDatabase.getString(n2), (List<String>)((Object)serializable), arrayList);
            hashSet.add((ForeignKey)object2);
            continue;
        }
        supportSQLiteDatabase.close();
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Index readIndex(SupportSQLiteDatabase object, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PRAGMA index_xinfo(`");
        stringBuilder.append(string2);
        stringBuilder.append("`)");
        stringBuilder = object.query(stringBuilder.toString());
        try {
            int n = stringBuilder.getColumnIndex("seqno");
            int n2 = stringBuilder.getColumnIndex("cid");
            int n3 = stringBuilder.getColumnIndex("name");
            int n4 = stringBuilder.getColumnIndex("desc");
            if (n == -1) return null;
            if (n2 == -1) return null;
            if (n3 == -1) return null;
            if (n4 == -1) {
                return null;
            }
            Cloneable cloneable = new TreeMap();
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            while (stringBuilder.moveToNext()) {
                if (stringBuilder.getInt(n2) < 0) continue;
                int n5 = stringBuilder.getInt(n);
                String string3 = stringBuilder.getString(n3);
                object = stringBuilder.getInt(n4) > 0 ? "DESC" : "ASC";
                ((TreeMap)cloneable).put(n5, string3);
                treeMap.put(n5, object);
            }
            object = new ArrayList(((TreeMap)cloneable).size());
            object.addAll(((TreeMap)cloneable).values());
            cloneable = new ArrayList(treeMap.size());
            cloneable.addAll(treeMap.values());
            object = new Index(string2, bl, (List<String>)object, (List<String>)((Object)cloneable));
            return object;
        }
        finally {
            stringBuilder.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Index> readIndices(SupportSQLiteDatabase supportSQLiteDatabase, String string2) {
        Serializable serializable = new StringBuilder();
        ((StringBuilder)serializable).append("PRAGMA index_list(`");
        ((StringBuilder)serializable).append(string2);
        ((StringBuilder)serializable).append("`)");
        string2 = supportSQLiteDatabase.query(((StringBuilder)serializable).toString());
        try {
            int n = string2.getColumnIndex("name");
            int n2 = string2.getColumnIndex("origin");
            int n3 = string2.getColumnIndex("unique");
            if (n != -1 && n2 != -1 && n3 != -1) {
                serializable = new HashSet();
            } else {
                string2.close();
                return null;
            }
            while (string2.moveToNext()) {
                if (!"c".equals(string2.getString(n2))) continue;
                Object object = string2.getString(n);
                int n4 = string2.getInt(n3);
                boolean bl = true;
                if (n4 != 1) {
                    bl = false;
                }
                object = TableInfo.readIndex(supportSQLiteDatabase, (String)object, bl);
                if (object == null) {
                    return null;
                }
                ((HashSet)serializable).add(object);
            }
            return serializable;
        }
        finally {
            string2.close();
        }
    }

    public boolean equals(Object set) {
        if (this == set) {
            return true;
        }
        if (!(set instanceof TableInfo)) {
            return false;
        }
        set = (TableInfo)((Object)set);
        Set<Index> set2 = this.name;
        if (set2 != null ? !((String)((Object)set2)).equals(((TableInfo)((Object)set)).name) : ((TableInfo)((Object)set)).name != null) {
            return false;
        }
        set2 = this.columns;
        if (set2 != null ? !set2.equals(((TableInfo)((Object)set)).columns) : ((TableInfo)((Object)set)).columns != null) {
            return false;
        }
        set2 = this.foreignKeys;
        if (set2 != null ? !set2.equals(((TableInfo)((Object)set)).foreignKeys) : ((TableInfo)((Object)set)).foreignKeys != null) {
            return false;
        }
        set2 = this.indices;
        if (set2 != null && (set = ((TableInfo)((Object)set)).indices) != null) {
            return set2.equals(set);
        }
        return true;
    }

    public int hashCode() {
        Set<ForeignKey> set = this.name;
        int n = 0;
        int n2 = set != null ? ((String)((Object)set)).hashCode() : 0;
        set = this.columns;
        int n3 = set != null ? set.hashCode() : 0;
        set = this.foreignKeys;
        if (set != null) {
            n = set.hashCode();
        }
        return (n2 * 31 + n3) * 31 + n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TableInfo{name='");
        stringBuilder.append(this.name);
        stringBuilder.append('\'');
        stringBuilder.append(", columns=");
        stringBuilder.append(this.columns);
        stringBuilder.append(", foreignKeys=");
        stringBuilder.append(this.foreignKeys);
        stringBuilder.append(", indices=");
        stringBuilder.append(this.indices);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static final class Column {
        public final int affinity;
        public final String defaultValue;
        private final int mCreatedFrom;
        public final String name;
        public final boolean notNull;
        public final int primaryKeyPosition;
        public final String type;

        @Deprecated
        public Column(String string2, String string3, boolean bl, int n) {
            this(string2, string3, bl, n, null, 0);
        }

        public Column(String string2, String string3, boolean bl, int n, String string4, int n2) {
            this.name = string2;
            this.type = string3;
            this.notNull = bl;
            this.primaryKeyPosition = n;
            this.affinity = Column.findAffinity(string3);
            this.defaultValue = string4;
            this.mCreatedFrom = n2;
        }

        private static boolean containsSurroundingParenthesis(String string2) {
            int n = string2.length();
            boolean bl = false;
            if (n == 0) {
                return false;
            }
            int n2 = 0;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (i == 0 && c != '(') {
                    return false;
                }
                if (c == '(') {
                    n = n2 + 1;
                } else {
                    n = n2--;
                    if (c == ')') {
                        n = n2;
                        if (n2 == 0) {
                            n = n2;
                            if (i != string2.length() - 1) {
                                return false;
                            }
                        }
                    }
                }
                n2 = n;
            }
            if (n2 == 0) {
                bl = true;
            }
            return bl;
        }

        public static boolean defaultValueEquals(String string2, String string3) {
            if (string3 == null) {
                return false;
            }
            if (string2.equals(string3)) {
                return true;
            }
            if (Column.containsSurroundingParenthesis(string2)) {
                return string2.substring(1, string2.length() - 1).trim().equals(string3);
            }
            return false;
        }

        private static int findAffinity(String string2) {
            if (string2 == null) {
                return 5;
            }
            if ((string2 = string2.toUpperCase(Locale.US)).contains("INT")) {
                return 3;
            }
            if (!(string2.contains("CHAR") || string2.contains("CLOB") || string2.contains("TEXT"))) {
                if (string2.contains("BLOB")) {
                    return 5;
                }
                if (!(string2.contains("REAL") || string2.contains("FLOA") || string2.contains("DOUB"))) {
                    return 1;
                }
                return 4;
            }
            return 2;
        }

        public boolean equals(Object object) {
            String string2;
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (!(object instanceof Column)) {
                return false;
            }
            object = (Column)object;
            if (Build.VERSION.SDK_INT >= 20 ? this.primaryKeyPosition != ((Column)object).primaryKeyPosition : this.isPrimaryKey() != ((Column)object).isPrimaryKey()) {
                return false;
            }
            if (!this.name.equals(((Column)object).name)) {
                return false;
            }
            if (this.notNull != ((Column)object).notNull) {
                return false;
            }
            if (this.mCreatedFrom == 1 && ((Column)object).mCreatedFrom == 2 && (string2 = this.defaultValue) != null && !Column.defaultValueEquals(string2, ((Column)object).defaultValue)) {
                return false;
            }
            if (this.mCreatedFrom == 2 && ((Column)object).mCreatedFrom == 1 && (string2 = ((Column)object).defaultValue) != null && !Column.defaultValueEquals(string2, this.defaultValue)) {
                return false;
            }
            int n = this.mCreatedFrom;
            if (n != 0 && n == ((Column)object).mCreatedFrom && ((string2 = this.defaultValue) != null ? !Column.defaultValueEquals(string2, ((Column)object).defaultValue) : ((Column)object).defaultValue != null)) {
                return false;
            }
            if (this.affinity != ((Column)object).affinity) {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            int n = this.name.hashCode();
            int n2 = this.affinity;
            int n3 = this.notNull ? 1231 : 1237;
            return ((n * 31 + n2) * 31 + n3) * 31 + this.primaryKeyPosition;
        }

        public boolean isPrimaryKey() {
            boolean bl = this.primaryKeyPosition > 0;
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Column{name='");
            stringBuilder.append(this.name);
            stringBuilder.append('\'');
            stringBuilder.append(", type='");
            stringBuilder.append(this.type);
            stringBuilder.append('\'');
            stringBuilder.append(", affinity='");
            stringBuilder.append(this.affinity);
            stringBuilder.append('\'');
            stringBuilder.append(", notNull=");
            stringBuilder.append(this.notNull);
            stringBuilder.append(", primaryKeyPosition=");
            stringBuilder.append(this.primaryKeyPosition);
            stringBuilder.append(", defaultValue='");
            stringBuilder.append(this.defaultValue);
            stringBuilder.append('\'');
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static final class ForeignKey {
        public final List<String> columnNames;
        public final String onDelete;
        public final String onUpdate;
        public final List<String> referenceColumnNames;
        public final String referenceTable;

        public ForeignKey(String string2, String string3, String string4, List<String> list, List<String> list2) {
            this.referenceTable = string2;
            this.onDelete = string3;
            this.onUpdate = string4;
            this.columnNames = Collections.unmodifiableList(list);
            this.referenceColumnNames = Collections.unmodifiableList(list2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ForeignKey)) {
                return false;
            }
            object = (ForeignKey)object;
            if (!this.referenceTable.equals(((ForeignKey)object).referenceTable)) {
                return false;
            }
            if (!this.onDelete.equals(((ForeignKey)object).onDelete)) {
                return false;
            }
            if (!this.onUpdate.equals(((ForeignKey)object).onUpdate)) {
                return false;
            }
            if (!this.columnNames.equals(((ForeignKey)object).columnNames)) {
                return false;
            }
            return this.referenceColumnNames.equals(((ForeignKey)object).referenceColumnNames);
        }

        public int hashCode() {
            return (((this.referenceTable.hashCode() * 31 + this.onDelete.hashCode()) * 31 + this.onUpdate.hashCode()) * 31 + this.columnNames.hashCode()) * 31 + this.referenceColumnNames.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ForeignKey{referenceTable='");
            stringBuilder.append(this.referenceTable);
            stringBuilder.append('\'');
            stringBuilder.append(", onDelete='");
            stringBuilder.append(this.onDelete);
            stringBuilder.append('\'');
            stringBuilder.append(", onUpdate='");
            stringBuilder.append(this.onUpdate);
            stringBuilder.append('\'');
            stringBuilder.append(", columnNames=");
            stringBuilder.append(this.columnNames);
            stringBuilder.append(", referenceColumnNames=");
            stringBuilder.append(this.referenceColumnNames);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    static class ForeignKeyWithSequence
    implements Comparable<ForeignKeyWithSequence> {
        final String mFrom;
        final int mId;
        final int mSequence;
        final String mTo;

        ForeignKeyWithSequence(int n, int n2, String string2, String string3) {
            this.mId = n;
            this.mSequence = n2;
            this.mFrom = string2;
            this.mTo = string3;
        }

        @Override
        public int compareTo(ForeignKeyWithSequence foreignKeyWithSequence) {
            int n;
            int n2 = n = this.mId - foreignKeyWithSequence.mId;
            if (n == 0) {
                n2 = this.mSequence - foreignKeyWithSequence.mSequence;
            }
            return n2;
        }
    }

    public static final class Index {
        public static final String DEFAULT_PREFIX = "index_";
        public final List<String> columns;
        public final String name;
        public final List<String> orders;
        public final boolean unique;

        public Index(String string2, boolean bl, List<String> list) {
            this(string2, bl, list, null);
        }

        public Index(String list, boolean bl, List<String> list2, List<String> list3) {
            block3: {
                block2: {
                    this.name = list;
                    this.unique = bl;
                    this.columns = list2;
                    if (list3 == null) break block2;
                    list = list3;
                    if (list3.size() != 0) break block3;
                }
                list = Collections.nCopies(list2.size(), Index.Order.ASC.name());
            }
            this.orders = list;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Index)) {
                return false;
            }
            object = (Index)object;
            if (this.unique != ((Index)object).unique) {
                return false;
            }
            if (!this.columns.equals(((Index)object).columns)) {
                return false;
            }
            if (!this.orders.equals(((Index)object).orders)) {
                return false;
            }
            if (this.name.startsWith(DEFAULT_PREFIX)) {
                return ((Index)object).name.startsWith(DEFAULT_PREFIX);
            }
            return this.name.equals(((Index)object).name);
        }

        public int hashCode() {
            int n = this.name.startsWith(DEFAULT_PREFIX) ? -1184239155 : this.name.hashCode();
            return ((n * 31 + this.unique) * 31 + this.columns.hashCode()) * 31 + this.orders.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Index{name='");
            stringBuilder.append(this.name);
            stringBuilder.append('\'');
            stringBuilder.append(", unique=");
            stringBuilder.append(this.unique);
            stringBuilder.append(", columns=");
            stringBuilder.append(this.columns);
            stringBuilder.append(", orders=");
            stringBuilder.append(this.orders);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }
}

