/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate;

import android.os.Bundle;
import androidx.lifecycle.GenericLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

final class Recreator
implements GenericLifecycleObserver {
    static final String CLASSES_KEY = "classes_to_restore";
    static final String COMPONENT_KEY = "androidx.savedstate.Restarter";
    private final SavedStateRegistryOwner mOwner;

    Recreator(SavedStateRegistryOwner savedStateRegistryOwner) {
        this.mOwner = savedStateRegistryOwner;
    }

    private void reflectiveNew(String string2) {
        Constructor<SavedStateRegistry.AutoRecreated> constructor;
        Object object;
        try {
            object = Class.forName(string2, false, Recreator.class.getClassLoader()).asSubclass(SavedStateRegistry.AutoRecreated.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Class ");
            stringBuilder.append(string2);
            stringBuilder.append(" wasn't found");
            throw new RuntimeException(stringBuilder.toString(), classNotFoundException);
        }
        try {
            constructor = ((Class)object).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Class");
            stringBuilder.append(((Class)object).getSimpleName());
            stringBuilder.append(" must have default constructor in order to be automatically recreated");
            throw new IllegalStateException(stringBuilder.toString(), noSuchMethodException);
        }
        try {
            object = constructor.newInstance(new Object[0]);
            object.onRecreated(this.mOwner);
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to instantiate ");
            ((StringBuilder)object).append(string2);
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    @Override
    public void onStateChanged(LifecycleOwner iterator, Lifecycle.Event event) {
        if (event == Lifecycle.Event.ON_CREATE) {
            iterator.getLifecycle().removeObserver(this);
            iterator = this.mOwner.getSavedStateRegistry().consumeRestoredStateForKey(COMPONENT_KEY);
            if (iterator == null) {
                return;
            }
            if ((iterator = iterator.getStringArrayList(CLASSES_KEY)) != null) {
                iterator = ((ArrayList)((Object)iterator)).iterator();
                while (iterator.hasNext()) {
                    this.reflectiveNew((String)iterator.next());
                }
                return;
            }
            throw new IllegalStateException("Bundle with restored state for the component \"androidx.savedstate.Restarter\" must contain list of strings by the key \"classes_to_restore\"");
        }
        throw new AssertionError((Object)"Next event must be ON_CREATE");
    }

    static final class SavedStateProvider
    implements SavedStateRegistry.SavedStateProvider {
        final Set<String> mClasses = new HashSet<String>();

        SavedStateProvider(SavedStateRegistry savedStateRegistry) {
            savedStateRegistry.registerSavedStateProvider(Recreator.COMPONENT_KEY, this);
        }

        void add(String string2) {
            this.mClasses.add(string2);
        }

        @Override
        public Bundle saveState() {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList(Recreator.CLASSES_KEY, new ArrayList<String>(this.mClasses));
            return bundle;
        }
    }
}

