/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public interface SupportSQLiteOpenHelper
extends Closeable {
    @Override
    public void close();

    public String getDatabaseName();

    public SupportSQLiteDatabase getReadableDatabase();

    public SupportSQLiteDatabase getWritableDatabase();

    public void setWriteAheadLoggingEnabled(boolean var1);

    public static abstract class Callback {
        private static final String TAG = "SupportSQLite";
        public final int version;

        public Callback(int n) {
            this.version = n;
        }

        private void deleteDatabaseFile(String string2) {
            if (!string2.equalsIgnoreCase(":memory:") && string2.trim().length() != 0) {
                Comparable<StringBuilder> comparable;
                block7: {
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("deleting the database file: ");
                    ((StringBuilder)comparable).append(string2);
                    Log.w((String)TAG, (String)((StringBuilder)comparable).toString());
                    if (Build.VERSION.SDK_INT < 16) break block7;
                    comparable = new Comparable<StringBuilder>(string2);
                    SupportSQLiteCompat.Api16Impl.deleteDatabase((File)comparable);
                }
                try {
                    comparable = new Comparable<StringBuilder>(string2);
                    if (!((File)comparable).delete()) {
                        comparable = new Comparable<StringBuilder>();
                        ((StringBuilder)comparable).append("Could not delete the database file ");
                        ((StringBuilder)comparable).append(string2);
                        Log.e((String)TAG, (String)((StringBuilder)comparable).toString());
                    }
                }
                catch (Exception exception) {
                    try {
                        Log.e((String)TAG, (String)"error while deleting corrupted database file", (Throwable)exception);
                    }
                    catch (Exception exception2) {
                        Log.w((String)TAG, (String)"delete failed: ", (Throwable)exception2);
                    }
                }
            }
        }

        public void onConfigure(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onCorruption(SupportSQLiteDatabase iterator) {
            StringBuilder stringBuilder;
            Object object;
            block13: {
                object = new StringBuilder();
                ((StringBuilder)object).append("Corruption reported by sqlite on database: ");
                ((StringBuilder)object).append(iterator.getPath());
                Log.e((String)TAG, (String)((StringBuilder)object).toString());
                if (!iterator.isOpen()) {
                    this.deleteDatabaseFile(iterator.getPath());
                    return;
                }
                object = null;
                stringBuilder = null;
                try {
                    try {
                        List<Pair<String, String>> list = iterator.getAttachedDbs();
                        object = list;
                    }
                    catch (SQLiteException sQLiteException) {}
                    break block13;
                }
                catch (Throwable throwable) {}
                if (stringBuilder != null) {
                    iterator = stringBuilder.iterator();
                    while (iterator.hasNext()) {
                        this.deleteDatabaseFile((String)((Pair)iterator.next()).second);
                    }
                    throw throwable;
                } else {
                    this.deleteDatabaseFile(iterator.getPath());
                }
                throw throwable;
            }
            stringBuilder = object;
            try {
                iterator.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    this.deleteDatabaseFile((String)((Pair)iterator.next()).second);
                }
                return;
            } else {
                this.deleteDatabaseFile(iterator.getPath());
            }
        }

        public abstract void onCreate(SupportSQLiteDatabase var1);

        public void onDowngrade(SupportSQLiteDatabase object, int n, int n2) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Can't downgrade database from version ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(" to ");
            ((StringBuilder)object).append(n2);
            throw new SQLiteException(((StringBuilder)object).toString());
        }

        public void onOpen(SupportSQLiteDatabase supportSQLiteDatabase) {
        }

        public abstract void onUpgrade(SupportSQLiteDatabase var1, int var2, int var3);
    }

    public static class Configuration {
        public final Callback callback;
        public final Context context;
        public final String name;
        public final boolean useNoBackupDirectory;

        Configuration(Context context, String string2, Callback callback) {
            this(context, string2, callback, false);
        }

        Configuration(Context context, String string2, Callback callback, boolean bl) {
            this.context = context;
            this.name = string2;
            this.callback = callback;
            this.useNoBackupDirectory = bl;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            Callback mCallback;
            Context mContext;
            String mName;
            boolean mUseNoBackupDirectory;

            Builder(Context context) {
                this.mContext = context;
            }

            public Configuration build() {
                if (this.mCallback != null) {
                    if (this.mContext != null) {
                        if (this.mUseNoBackupDirectory && TextUtils.isEmpty((CharSequence)this.mName)) {
                            throw new IllegalArgumentException("Must set a non-null database name to a configuration that uses the no backup directory.");
                        }
                        return new Configuration(this.mContext, this.mName, this.mCallback, this.mUseNoBackupDirectory);
                    }
                    throw new IllegalArgumentException("Must set a non-null context to create the configuration.");
                }
                throw new IllegalArgumentException("Must set a callback to create the configuration.");
            }

            public Builder callback(Callback callback) {
                this.mCallback = callback;
                return this;
            }

            public Builder name(String string2) {
                this.mName = string2;
                return this;
            }

            public Builder noBackupDirectory(boolean bl) {
                this.mUseNoBackupDirectory = bl;
                return this;
            }
        }
    }

    public static interface Factory {
        public SupportSQLiteOpenHelper create(Configuration var1);
    }
}

