/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db;

import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.regex.Pattern;

public final class SupportSQLiteQueryBuilder {
    private static final Pattern sLimitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    private Object[] mBindArgs;
    private String[] mColumns = null;
    private boolean mDistinct = false;
    private String mGroupBy = null;
    private String mHaving = null;
    private String mLimit = null;
    private String mOrderBy = null;
    private String mSelection;
    private final String mTable;

    private SupportSQLiteQueryBuilder(String string2) {
        this.mTable = string2;
    }

    private static void appendClause(StringBuilder stringBuilder, String string2, String string3) {
        if (!SupportSQLiteQueryBuilder.isEmpty(string3)) {
            stringBuilder.append(string2);
            stringBuilder.append(string3);
        }
    }

    private static void appendColumns(StringBuilder stringBuilder, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(' ');
    }

    public static SupportSQLiteQueryBuilder builder(String string2) {
        return new SupportSQLiteQueryBuilder(string2);
    }

    private static boolean isEmpty(String string2) {
        boolean bl = string2 == null || string2.length() == 0;
        return bl;
    }

    public SupportSQLiteQueryBuilder columns(String[] stringArray) {
        this.mColumns = stringArray;
        return this;
    }

    public SupportSQLiteQuery create() {
        String[] stringArray;
        if (SupportSQLiteQueryBuilder.isEmpty(this.mGroupBy) && !SupportSQLiteQueryBuilder.isEmpty(this.mHaving)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("SELECT ");
        if (this.mDistinct) {
            stringBuilder.append("DISTINCT ");
        }
        if ((stringArray = this.mColumns) != null && stringArray.length != 0) {
            SupportSQLiteQueryBuilder.appendColumns(stringBuilder, stringArray);
        } else {
            stringBuilder.append(" * ");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.mTable);
        SupportSQLiteQueryBuilder.appendClause(stringBuilder, " WHERE ", this.mSelection);
        SupportSQLiteQueryBuilder.appendClause(stringBuilder, " GROUP BY ", this.mGroupBy);
        SupportSQLiteQueryBuilder.appendClause(stringBuilder, " HAVING ", this.mHaving);
        SupportSQLiteQueryBuilder.appendClause(stringBuilder, " ORDER BY ", this.mOrderBy);
        SupportSQLiteQueryBuilder.appendClause(stringBuilder, " LIMIT ", this.mLimit);
        return new SimpleSQLiteQuery(stringBuilder.toString(), this.mBindArgs);
    }

    public SupportSQLiteQueryBuilder distinct() {
        this.mDistinct = true;
        return this;
    }

    public SupportSQLiteQueryBuilder groupBy(String string2) {
        this.mGroupBy = string2;
        return this;
    }

    public SupportSQLiteQueryBuilder having(String string2) {
        this.mHaving = string2;
        return this;
    }

    public SupportSQLiteQueryBuilder limit(String string2) {
        if (!SupportSQLiteQueryBuilder.isEmpty(string2) && !sLimitPattern.matcher(string2).matches()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid LIMIT clauses:");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.mLimit = string2;
        return this;
    }

    public SupportSQLiteQueryBuilder orderBy(String string2) {
        this.mOrderBy = string2;
        return this;
    }

    public SupportSQLiteQueryBuilder selection(String string2, Object[] objectArray) {
        this.mSelection = string2;
        this.mBindArgs = objectArray;
        return this;
    }
}

