/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db.framework;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.Build;
import android.os.CancellationSignal;
import android.text.TextUtils;
import android.util.Pair;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.sqlite.db.framework.FrameworkSQLiteProgram;
import androidx.sqlite.db.framework.FrameworkSQLiteStatement;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

class FrameworkSQLiteDatabase
implements SupportSQLiteDatabase {
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final SQLiteDatabase mDelegate;

    FrameworkSQLiteDatabase(SQLiteDatabase sQLiteDatabase) {
        this.mDelegate = sQLiteDatabase;
    }

    @Override
    public void beginTransaction() {
        this.mDelegate.beginTransaction();
    }

    @Override
    public void beginTransactionNonExclusive() {
        this.mDelegate.beginTransactionNonExclusive();
    }

    @Override
    public void beginTransactionWithListener(SQLiteTransactionListener sQLiteTransactionListener) {
        this.mDelegate.beginTransactionWithListener(sQLiteTransactionListener);
    }

    @Override
    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener sQLiteTransactionListener) {
        this.mDelegate.beginTransactionWithListenerNonExclusive(sQLiteTransactionListener);
    }

    @Override
    public void close() throws IOException {
        this.mDelegate.close();
    }

    @Override
    public SupportSQLiteStatement compileStatement(String string2) {
        return new FrameworkSQLiteStatement(this.mDelegate.compileStatement(string2));
    }

    @Override
    public int delete(String object, String string2, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append((String)object);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            object = "";
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append(" WHERE ");
            ((StringBuilder)object).append(string2);
            object = ((StringBuilder)object).toString();
        }
        stringBuilder.append((String)object);
        object = this.compileStatement(stringBuilder.toString());
        SimpleSQLiteQuery.bind((SupportSQLiteProgram)object, objectArray);
        return object.executeUpdateDelete();
    }

    @Override
    public void disableWriteAheadLogging() {
        SupportSQLiteCompat.Api16Impl.disableWriteAheadLogging(this.mDelegate);
    }

    @Override
    public boolean enableWriteAheadLogging() {
        return this.mDelegate.enableWriteAheadLogging();
    }

    @Override
    public void endTransaction() {
        this.mDelegate.endTransaction();
    }

    @Override
    public void execPerConnectionSQL(String charSequence, Object[] objectArray) {
        if (Build.VERSION.SDK_INT >= 30) {
            this.mDelegate.execPerConnectionSQL((String)charSequence, objectArray);
            return;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("execPerConnectionSQL is not supported on a SDK version lower than 30, current version is: ");
        ((StringBuilder)charSequence).append(Build.VERSION.SDK_INT);
        throw new UnsupportedOperationException(((StringBuilder)charSequence).toString());
    }

    @Override
    public void execSQL(String string2) throws SQLException {
        this.mDelegate.execSQL(string2);
    }

    @Override
    public void execSQL(String string2, Object[] objectArray) throws SQLException {
        this.mDelegate.execSQL(string2, objectArray);
    }

    @Override
    public List<Pair<String, String>> getAttachedDbs() {
        return this.mDelegate.getAttachedDbs();
    }

    @Override
    public long getMaximumSize() {
        return this.mDelegate.getMaximumSize();
    }

    @Override
    public long getPageSize() {
        return this.mDelegate.getPageSize();
    }

    @Override
    public String getPath() {
        return this.mDelegate.getPath();
    }

    @Override
    public int getVersion() {
        return this.mDelegate.getVersion();
    }

    @Override
    public boolean inTransaction() {
        return this.mDelegate.inTransaction();
    }

    @Override
    public long insert(String string2, int n, ContentValues contentValues) throws SQLException {
        return this.mDelegate.insertWithOnConflict(string2, null, contentValues, n);
    }

    @Override
    public boolean isDatabaseIntegrityOk() {
        return this.mDelegate.isDatabaseIntegrityOk();
    }

    @Override
    public boolean isDbLockedByCurrentThread() {
        return this.mDelegate.isDbLockedByCurrentThread();
    }

    boolean isDelegate(SQLiteDatabase sQLiteDatabase) {
        boolean bl = this.mDelegate == sQLiteDatabase;
        return bl;
    }

    @Override
    public boolean isExecPerConnectionSQLSupported() {
        boolean bl = Build.VERSION.SDK_INT >= 30;
        return bl;
    }

    @Override
    public boolean isOpen() {
        return this.mDelegate.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.mDelegate.isReadOnly();
    }

    @Override
    public boolean isWriteAheadLoggingEnabled() {
        return SupportSQLiteCompat.Api16Impl.isWriteAheadLoggingEnabled(this.mDelegate);
    }

    @Override
    public boolean needUpgrade(int n) {
        return this.mDelegate.needUpgrade(n);
    }

    @Override
    public Cursor query(final SupportSQLiteQuery supportSQLiteQuery) {
        return this.mDelegate.rawQueryWithFactory(new SQLiteDatabase.CursorFactory(){

            public Cursor newCursor(SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
                supportSQLiteQuery.bindTo(new FrameworkSQLiteProgram((SQLiteProgram)sQLiteQuery));
                return new SQLiteCursor(sQLiteCursorDriver, string2, sQLiteQuery);
            }
        }, supportSQLiteQuery.getSql(), EMPTY_STRING_ARRAY, null);
    }

    @Override
    public Cursor query(final SupportSQLiteQuery supportSQLiteQuery, CancellationSignal cancellationSignal) {
        return SupportSQLiteCompat.Api16Impl.rawQueryWithFactory(this.mDelegate, supportSQLiteQuery.getSql(), EMPTY_STRING_ARRAY, null, cancellationSignal, new SQLiteDatabase.CursorFactory(){

            public Cursor newCursor(SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
                supportSQLiteQuery.bindTo(new FrameworkSQLiteProgram((SQLiteProgram)sQLiteQuery));
                return new SQLiteCursor(sQLiteCursorDriver, string2, sQLiteQuery);
            }
        });
    }

    @Override
    public Cursor query(String string2) {
        return this.query(new SimpleSQLiteQuery(string2));
    }

    @Override
    public Cursor query(String string2, Object[] objectArray) {
        return this.query(new SimpleSQLiteQuery(string2, objectArray));
    }

    @Override
    public void setForeignKeyConstraintsEnabled(boolean bl) {
        SupportSQLiteCompat.Api16Impl.setForeignKeyConstraintsEnabled(this.mDelegate, bl);
    }

    @Override
    public void setLocale(Locale locale) {
        this.mDelegate.setLocale(locale);
    }

    @Override
    public void setMaxSqlCacheSize(int n) {
        this.mDelegate.setMaxSqlCacheSize(n);
    }

    @Override
    public long setMaximumSize(long l) {
        return this.mDelegate.setMaximumSize(l);
    }

    @Override
    public void setPageSize(long l) {
        this.mDelegate.setPageSize(l);
    }

    @Override
    public void setTransactionSuccessful() {
        this.mDelegate.setTransactionSuccessful();
    }

    @Override
    public void setVersion(int n) {
        this.mDelegate.setVersion(n);
    }

    @Override
    public int update(String object, int n, ContentValues contentValues, String string2, Object[] objectArray) {
        if (contentValues != null && contentValues.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("UPDATE ");
            stringBuilder.append(CONFLICT_VALUES[n]);
            stringBuilder.append((String)object);
            stringBuilder.append(" SET ");
            n = contentValues.size();
            int n2 = objectArray == null ? n : objectArray.length + n;
            Object[] objectArray2 = new Object[n2];
            int n3 = 0;
            for (String string3 : contentValues.keySet()) {
                object = n3 > 0 ? "," : "";
                stringBuilder.append((String)object);
                stringBuilder.append(string3);
                objectArray2[n3] = contentValues.get(string3);
                stringBuilder.append("=?");
                ++n3;
            }
            if (objectArray != null) {
                for (n3 = n; n3 < n2; ++n3) {
                    objectArray2[n3] = objectArray[n3 - n];
                }
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                stringBuilder.append(" WHERE ");
                stringBuilder.append(string2);
            }
            object = this.compileStatement(stringBuilder.toString());
            SimpleSQLiteQuery.bind((SupportSQLiteProgram)object, objectArray2);
            return object.executeUpdateDelete();
        }
        throw new IllegalArgumentException("Empty values");
    }

    @Override
    public boolean yieldIfContendedSafely() {
        return this.mDelegate.yieldIfContendedSafely();
    }

    @Override
    public boolean yieldIfContendedSafely(long l) {
        return this.mDelegate.yieldIfContendedSafely(l);
    }
}

