/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db.framework;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteDatabase;
import java.io.File;

class FrameworkSQLiteOpenHelper
implements SupportSQLiteOpenHelper {
    private final SupportSQLiteOpenHelper.Callback mCallback;
    private final Context mContext;
    private OpenHelper mDelegate;
    private final Object mLock;
    private final String mName;
    private final boolean mUseNoBackupDirectory;
    private boolean mWriteAheadLoggingEnabled;

    FrameworkSQLiteOpenHelper(Context context, String string2, SupportSQLiteOpenHelper.Callback callback) {
        this(context, string2, callback, false);
    }

    FrameworkSQLiteOpenHelper(Context context, String string2, SupportSQLiteOpenHelper.Callback callback, boolean bl) {
        this.mContext = context;
        this.mName = string2;
        this.mCallback = callback;
        this.mUseNoBackupDirectory = bl;
        this.mLock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OpenHelper getDelegate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDelegate != null) return this.mDelegate;
            FrameworkSQLiteDatabase[] frameworkSQLiteDatabaseArray = new FrameworkSQLiteDatabase[1];
            if (Build.VERSION.SDK_INT >= 23 && this.mName != null && this.mUseNoBackupDirectory) {
                OpenHelper openHelper;
                File file = new File(SupportSQLiteCompat.Api21Impl.getNoBackupFilesDir(this.mContext), this.mName);
                this.mDelegate = openHelper = new OpenHelper(this.mContext, file.getAbsolutePath(), frameworkSQLiteDatabaseArray, this.mCallback);
            } else {
                OpenHelper openHelper;
                this.mDelegate = openHelper = new OpenHelper(this.mContext, this.mName, frameworkSQLiteDatabaseArray, this.mCallback);
            }
            if (Build.VERSION.SDK_INT < 16) return this.mDelegate;
            SupportSQLiteCompat.Api16Impl.setWriteAheadLoggingEnabled(this.mDelegate, this.mWriteAheadLoggingEnabled);
            return this.mDelegate;
        }
    }

    @Override
    public void close() {
        this.getDelegate().close();
    }

    @Override
    public String getDatabaseName() {
        return this.mName;
    }

    @Override
    public SupportSQLiteDatabase getReadableDatabase() {
        return this.getDelegate().getReadableSupportDatabase();
    }

    @Override
    public SupportSQLiteDatabase getWritableDatabase() {
        return this.getDelegate().getWritableSupportDatabase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setWriteAheadLoggingEnabled(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            OpenHelper openHelper = this.mDelegate;
            if (openHelper != null) {
                SupportSQLiteCompat.Api16Impl.setWriteAheadLoggingEnabled(openHelper, bl);
            }
            this.mWriteAheadLoggingEnabled = bl;
            return;
        }
    }

    static class OpenHelper
    extends SQLiteOpenHelper {
        final SupportSQLiteOpenHelper.Callback mCallback;
        final FrameworkSQLiteDatabase[] mDbRef;
        private boolean mMigrated;

        OpenHelper(Context context, String string2, final FrameworkSQLiteDatabase[] frameworkSQLiteDatabaseArray, final SupportSQLiteOpenHelper.Callback callback) {
            super(context, string2, null, callback.version, new DatabaseErrorHandler(){

                public void onCorruption(SQLiteDatabase sQLiteDatabase) {
                    callback.onCorruption(OpenHelper.getWrappedDb(frameworkSQLiteDatabaseArray, sQLiteDatabase));
                }
            });
            this.mCallback = callback;
            this.mDbRef = frameworkSQLiteDatabaseArray;
        }

        static FrameworkSQLiteDatabase getWrappedDb(FrameworkSQLiteDatabase[] frameworkSQLiteDatabaseArray, SQLiteDatabase sQLiteDatabase) {
            FrameworkSQLiteDatabase frameworkSQLiteDatabase = frameworkSQLiteDatabaseArray[0];
            if (frameworkSQLiteDatabase == null || !frameworkSQLiteDatabase.isDelegate(sQLiteDatabase)) {
                frameworkSQLiteDatabaseArray[0] = new FrameworkSQLiteDatabase(sQLiteDatabase);
            }
            return frameworkSQLiteDatabaseArray[0];
        }

        public void close() {
            synchronized (this) {
                super.close();
                this.mDbRef[0] = null;
                return;
            }
        }

        SupportSQLiteDatabase getReadableSupportDatabase() {
            synchronized (this) {
                Object object;
                block4: {
                    this.mMigrated = false;
                    object = super.getReadableDatabase();
                    if (!this.mMigrated) break block4;
                    this.close();
                    object = this.getReadableSupportDatabase();
                    return object;
                }
                object = this.getWrappedDb((SQLiteDatabase)object);
                return object;
            }
        }

        FrameworkSQLiteDatabase getWrappedDb(SQLiteDatabase sQLiteDatabase) {
            return OpenHelper.getWrappedDb(this.mDbRef, sQLiteDatabase);
        }

        SupportSQLiteDatabase getWritableSupportDatabase() {
            synchronized (this) {
                Object object;
                block4: {
                    this.mMigrated = false;
                    object = super.getWritableDatabase();
                    if (!this.mMigrated) break block4;
                    this.close();
                    object = this.getWritableSupportDatabase();
                    return object;
                }
                object = this.getWrappedDb((SQLiteDatabase)object);
                return object;
            }
        }

        public void onConfigure(SQLiteDatabase sQLiteDatabase) {
            this.mCallback.onConfigure(this.getWrappedDb(sQLiteDatabase));
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            this.mCallback.onCreate(this.getWrappedDb(sQLiteDatabase));
        }

        public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            this.mMigrated = true;
            this.mCallback.onDowngrade(this.getWrappedDb(sQLiteDatabase), n, n2);
        }

        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (!this.mMigrated) {
                this.mCallback.onOpen(this.getWrappedDb(sQLiteDatabase));
            }
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            this.mMigrated = true;
            this.mCallback.onUpgrade(this.getWrappedDb(sQLiteDatabase), n, n2);
        }
    }
}

