/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.graphics.Canvas;
import android.os.Build;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class CanvasUtils {
    private static Method sInorderBarrierMethod;
    private static boolean sOrderMethodsFetched;
    private static Method sReorderBarrierMethod;

    private CanvasUtils() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void enableZ(Canvas canvas, boolean bl) {
        Method method;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            if (bl) {
                canvas.enableZ();
                return;
            }
            canvas.disableZ();
            return;
        }
        if (Build.VERSION.SDK_INT == 28) throw new IllegalStateException("This method doesn't work on Pie!");
        if (!sOrderMethodsFetched) {
            try {
                sReorderBarrierMethod = method = Canvas.class.getDeclaredMethod("insertReorderBarrier", new Class[0]);
                method.setAccessible(true);
                sInorderBarrierMethod = method = Canvas.class.getDeclaredMethod("insertInorderBarrier", new Class[0]);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            sOrderMethodsFetched = true;
        }
        if (bl) {
            try {
                method = sReorderBarrierMethod;
                if (method != null) {
                    method.invoke((Object)canvas, new Object[0]);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
        if (bl) return;
        method = sInorderBarrierMethod;
        if (method == null) return;
        method.invoke((Object)canvas, new Object[0]);
        return;
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }
}

