/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.util.Property;

class PathProperty<T>
extends Property<T, Float> {
    private float mCurrentFraction;
    private final float mPathLength;
    private final PathMeasure mPathMeasure;
    private final PointF mPointF;
    private final float[] mPosition = new float[2];
    private final Property<T, PointF> mProperty;

    PathProperty(Property<T, PointF> pathMeasure, Path path) {
        super(Float.class, pathMeasure.getName());
        this.mPointF = new PointF();
        this.mProperty = pathMeasure;
        this.mPathMeasure = pathMeasure = new PathMeasure(path, false);
        this.mPathLength = pathMeasure.getLength();
    }

    public Float get(T t) {
        return Float.valueOf(this.mCurrentFraction);
    }

    public void set(T t, Float f) {
        this.mCurrentFraction = f.floatValue();
        this.mPathMeasure.getPosTan(this.mPathLength * f.floatValue(), this.mPosition, null);
        this.mPointF.x = this.mPosition[0];
        this.mPointF.y = this.mPosition[1];
        this.mProperty.set(t, (Object)this.mPointF);
    }
}

